/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.sql.jdbc;

import com.sap.jdo.sql.catalog.Column;
import com.sap.jdo.sql.catalog.Table;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class JDBCHelper {
    private static final String __BIGINT = "BIGINT";
    private static final String __BINARY = "BINARY";
    private static final String __BIT = "BIT";
    private static final String __BLOB = "BLOB";
    private static final String __CHAR = "CHAR";
    private static final String __CLOB = "CLOB";
    private static final String __DATE = "DATE";
    private static final String __DECIMAL = "DECIMAL";
    private static final String __DOUBLE = "DOUBLE";
    private static final String __FLOAT = "FLOAT";
    private static final String __INTEGER = "INTEGER";
    private static final String __LONGVARBINARY = "LONGVARBINARY";
    private static final String __LONGVARCHAR = "LONGVARCHAR";
    private static final String __NUMERIC = "NUMERIC";
    private static final String __REAL = "REAL";
    private static final String __SMALLINT = "SMALLINT";
    private static final String __TIME = "TIME";
    private static final String __TIMESTAMP = "TIMESTAMP";
    private static final String __VARBINARY = "VARBINARY";
    private static final String __VARCHAR = "VARCHAR";
    private static final String __TINYINT = "TINYINT";
    private static final String __NULL = "NULL";
    private static final String __OTHER = "OTHER";
    private static final String __REF = "REF";
    private static final String __STRUCT = "STRUCT";
    private static final String __DISTINCT = "DISTINCT";
    private static final String __ARRAY = "ARRAY";
    private static final String __JAVA_OBJECT = "JAVA_OBJECT";
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$util$Locale;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class class$java$io$Serializable;

    public static final int parseJdbcType(String typeName) throws InvalidJdbcType {
        if (__BIGINT.equals(typeName)) {
            return -5;
        }
        if (__BINARY.equals(typeName)) {
            return -2;
        }
        if (__BIT.equals(typeName)) {
            return -7;
        }
        if (__BLOB.equals(typeName)) {
            return 2004;
        }
        if (__CHAR.equals(typeName)) {
            return 1;
        }
        if (__CLOB.equals(typeName)) {
            return 2005;
        }
        if (__DATE.equals(typeName)) {
            return 91;
        }
        if (__DECIMAL.equals(typeName)) {
            return 3;
        }
        if (__DOUBLE.equals(typeName)) {
            return 8;
        }
        if (__FLOAT.equals(typeName)) {
            return 6;
        }
        if (__INTEGER.equals(typeName)) {
            return 4;
        }
        if (__LONGVARBINARY.equals(typeName)) {
            return -4;
        }
        if (__LONGVARCHAR.equals(typeName)) {
            return -1;
        }
        if (__NUMERIC.equals(typeName)) {
            return 2;
        }
        if (__REAL.equals(typeName)) {
            return 7;
        }
        if (__SMALLINT.equals(typeName)) {
            return 5;
        }
        if (__TIME.equals(typeName)) {
            return 92;
        }
        if (__TIMESTAMP.equals(typeName)) {
            return 93;
        }
        if (__VARBINARY.equals(typeName)) {
            return -3;
        }
        if (__VARCHAR.equals(typeName)) {
            return 12;
        }
        if (__TINYINT.equals(typeName)) {
            return -6;
        }
        if (__NULL.equals(typeName)) {
            return 0;
        }
        if (__OTHER.equals(typeName)) {
            return 1111;
        }
        if (__REF.equals(typeName)) {
            return 2006;
        }
        if (__STRUCT.equals(typeName)) {
            return 2002;
        }
        if (__DISTINCT.equals(typeName)) {
            return 2001;
        }
        if (__ARRAY.equals(typeName)) {
            return 2003;
        }
        if (__JAVA_OBJECT.equals(typeName)) {
            return 2000;
        }
        throw new InvalidJdbcType("JDBC type " + typeName + " unknown");
    }

    public static final String getJdbcTypeName(int jdbcType) throws InvalidJdbcType {
        switch (jdbcType) {
            case 2003: {
                return __ARRAY;
            }
            case -5: {
                return __BIGINT;
            }
            case -2: {
                return __BINARY;
            }
            case -7: {
                return __BIT;
            }
            case 2004: {
                return __BLOB;
            }
            case 1: {
                return __CHAR;
            }
            case 2005: {
                return __CLOB;
            }
            case 91: {
                return __DATE;
            }
            case 3: {
                return __DECIMAL;
            }
            case 2001: {
                return __DISTINCT;
            }
            case 8: {
                return __DOUBLE;
            }
            case 6: {
                return __FLOAT;
            }
            case 4: {
                return __INTEGER;
            }
            case 2000: {
                return __JAVA_OBJECT;
            }
            case -4: {
                return __LONGVARBINARY;
            }
            case -1: {
                return __LONGVARCHAR;
            }
            case 0: {
                return __NULL;
            }
            case 2: {
                return __NUMERIC;
            }
            case 1111: {
                return __OTHER;
            }
            case 7: {
                return __REAL;
            }
            case 2006: {
                return __REF;
            }
            case 5: {
                return __SMALLINT;
            }
            case 2002: {
                return __STRUCT;
            }
            case 92: {
                return __TIME;
            }
            case 93: {
                return __TIMESTAMP;
            }
            case -6: {
                return __TINYINT;
            }
            case -3: {
                return __VARBINARY;
            }
            case 12: {
                return __VARCHAR;
            }
        }
        throw new InvalidJdbcType("JDBC type " + jdbcType + " unknown");
    }

    public static final boolean isSupportedJdbcType(int jdbcType) throws InvalidJdbcType {
        switch (jdbcType) {
            case -7: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 91: 
            case 92: 
            case 93: 
            case 2004: 
            case 2005: {
                return true;
            }
            case -6: 
            case 0: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2006: {
                return false;
            }
        }
        throw new InvalidJdbcType("JDBC type " + jdbcType + " unknown");
    }

    public static final boolean isJdbcTypeCompatible(Class clazz, int jdbcType) {
        if (clazz == Boolean.TYPE || clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = JDBCHelper.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return jdbcType == -7 || jdbcType == 5 || jdbcType == 4 || jdbcType == -5 || jdbcType == 3 || jdbcType == 2;
        }
        if (clazz == Byte.TYPE || clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = JDBCHelper.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return jdbcType == 5 || jdbcType == 3 || jdbcType == 2;
        }
        if (clazz == Short.TYPE || clazz == (class$java$lang$Short == null ? (class$java$lang$Short = JDBCHelper.class$("java.lang.Short")) : class$java$lang$Short)) {
            return jdbcType == 5 || jdbcType == 3 || jdbcType == 2;
        }
        if (clazz == Integer.TYPE || clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = JDBCHelper.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return jdbcType == 4 || jdbcType == 3 || jdbcType == 2;
        }
        if (clazz == Long.TYPE || clazz == (class$java$lang$Long == null ? (class$java$lang$Long = JDBCHelper.class$("java.lang.Long")) : class$java$lang$Long)) {
            return jdbcType == -5 || jdbcType == 3 || jdbcType == 2;
        }
        if (clazz == Float.TYPE || clazz == (class$java$lang$Float == null ? (class$java$lang$Float = JDBCHelper.class$("java.lang.Float")) : class$java$lang$Float)) {
            return jdbcType == 7 || jdbcType == 6 || jdbcType == 8 || jdbcType == 4 || jdbcType == -5 || jdbcType == 3 || jdbcType == 2;
        }
        if (clazz == Double.TYPE || clazz == (class$java$lang$Double == null ? (class$java$lang$Double = JDBCHelper.class$("java.lang.Double")) : class$java$lang$Double)) {
            return jdbcType == 8 || jdbcType == 4 || jdbcType == -5 || jdbcType == 3 || jdbcType == 2;
        }
        if (clazz == Character.TYPE || clazz == (class$java$lang$Character == null ? (class$java$lang$Character = JDBCHelper.class$("java.lang.Character")) : class$java$lang$Character)) {
            return jdbcType == 1 || jdbcType == 4 || jdbcType == 3 || jdbcType == 2;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = JDBCHelper.class$("java.lang.String")) : class$java$lang$String)) {
            return jdbcType == 1 || jdbcType == 12 || jdbcType == -1 || jdbcType == 2005;
        }
        if (clazz == (class$java$util$Date == null ? (class$java$util$Date = JDBCHelper.class$("java.util.Date")) : class$java$util$Date)) {
            return jdbcType == 93 || jdbcType == -5;
        }
        if (clazz == (class$java$sql$Date == null ? (class$java$sql$Date = JDBCHelper.class$("java.sql.Date")) : class$java$sql$Date)) {
            return jdbcType == 91;
        }
        if (clazz == (class$java$sql$Time == null ? (class$java$sql$Time = JDBCHelper.class$("java.sql.Time")) : class$java$sql$Time)) {
            return jdbcType == 92;
        }
        if (clazz == (class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = JDBCHelper.class$("java.sql.Timestamp")) : class$java$sql$Timestamp)) {
            return jdbcType == 93;
        }
        if (clazz == (class$java$util$Locale == null ? (class$java$util$Locale = JDBCHelper.class$("java.util.Locale")) : class$java$util$Locale)) {
            return jdbcType == 1 || jdbcType == 12 || jdbcType == -1;
        }
        if (clazz == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = JDBCHelper.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
            return jdbcType == 3 || jdbcType == 2;
        }
        if (clazz == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JDBCHelper.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            return jdbcType == 3 || jdbcType == 2;
        }
        if (clazz == (class$java$sql$Blob == null ? (class$java$sql$Blob = JDBCHelper.class$("java.sql.Blob")) : class$java$sql$Blob)) {
            return jdbcType == 2004;
        }
        if (clazz == (class$java$io$Serializable == null ? (class$java$io$Serializable = JDBCHelper.class$("java.io.Serializable")) : class$java$io$Serializable)) {
            return jdbcType == 2004;
        }
        throw new IllegalArgumentException("Can not determine JDBC-Type for class " + clazz);
    }

    public static int promoteType(int jdbcType, Class fieldType) {
        if (!(jdbcType != 5 && jdbcType != 4 && jdbcType != -5 || fieldType != (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JDBCHelper.class$("java.math.BigDecimal")) : class$java$math$BigDecimal) && fieldType != (class$java$math$BigInteger == null ? (class$java$math$BigInteger = JDBCHelper.class$("java.math.BigInteger")) : class$java$math$BigInteger))) {
            return 3;
        }
        if (jdbcType == 5 && (fieldType == (class$java$lang$Integer == null ? (class$java$lang$Integer = JDBCHelper.class$("java.lang.Integer")) : class$java$lang$Integer) || fieldType == (class$java$lang$Long == null ? (class$java$lang$Long = JDBCHelper.class$("java.lang.Long")) : class$java$lang$Long))) {
            return 4;
        }
        if (jdbcType == 4 && fieldType == (class$java$lang$Long == null ? (class$java$lang$Long = JDBCHelper.class$("java.lang.Long")) : class$java$lang$Long)) {
            return -5;
        }
        return jdbcType;
    }

    public static int getDefaultJdbcTypeForClass(Class clazz, boolean storeCharacterAsNumber, boolean storeAllNumbersAsDecimals, boolean storeFloatAsDouble, boolean storeDateAsLong) throws IllegalArgumentException {
        if (clazz == Boolean.TYPE || clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = JDBCHelper.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return 5;
        }
        if (clazz == Byte.TYPE || clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = JDBCHelper.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return storeAllNumbersAsDecimals ? 3 : 5;
        }
        if (clazz == Short.TYPE || clazz == (class$java$lang$Short == null ? (class$java$lang$Short = JDBCHelper.class$("java.lang.Short")) : class$java$lang$Short)) {
            return storeAllNumbersAsDecimals ? 3 : 5;
        }
        if (clazz == Integer.TYPE || clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = JDBCHelper.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return storeAllNumbersAsDecimals ? 3 : 4;
        }
        if (clazz == Long.TYPE || clazz == (class$java$lang$Long == null ? (class$java$lang$Long = JDBCHelper.class$("java.lang.Long")) : class$java$lang$Long)) {
            return storeAllNumbersAsDecimals ? 3 : -5;
        }
        if (clazz == Float.TYPE || clazz == (class$java$lang$Float == null ? (class$java$lang$Float = JDBCHelper.class$("java.lang.Float")) : class$java$lang$Float)) {
            return storeFloatAsDouble ? 8 : 7;
        }
        if (clazz == Double.TYPE || clazz == (class$java$lang$Double == null ? (class$java$lang$Double = JDBCHelper.class$("java.lang.Double")) : class$java$lang$Double)) {
            return 8;
        }
        if (clazz == Character.TYPE || clazz == (class$java$lang$Character == null ? (class$java$lang$Character = JDBCHelper.class$("java.lang.Character")) : class$java$lang$Character)) {
            if (!storeCharacterAsNumber) {
                return 1;
            }
            return storeAllNumbersAsDecimals ? 3 : 4;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = JDBCHelper.class$("java.lang.String")) : class$java$lang$String)) {
            return 12;
        }
        if (clazz == (class$java$util$Date == null ? (class$java$util$Date = JDBCHelper.class$("java.util.Date")) : class$java$util$Date)) {
            if (storeDateAsLong) {
                return -5;
            }
            return 93;
        }
        if (clazz == (class$java$sql$Date == null ? (class$java$sql$Date = JDBCHelper.class$("java.sql.Date")) : class$java$sql$Date)) {
            return 91;
        }
        if (clazz == (class$java$sql$Time == null ? (class$java$sql$Time = JDBCHelper.class$("java.sql.Time")) : class$java$sql$Time)) {
            return 92;
        }
        if (clazz == (class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = JDBCHelper.class$("java.sql.Timestamp")) : class$java$sql$Timestamp)) {
            return 93;
        }
        if (clazz == (class$java$util$Locale == null ? (class$java$util$Locale = JDBCHelper.class$("java.util.Locale")) : class$java$util$Locale)) {
            return 12;
        }
        if (clazz == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = JDBCHelper.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
            return 3;
        }
        if (clazz == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JDBCHelper.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            return 3;
        }
        if (clazz == (class$java$sql$Blob == null ? (class$java$sql$Blob = JDBCHelper.class$("java.sql.Blob")) : class$java$sql$Blob)) {
            return 2004;
        }
        if (clazz == (class$java$io$Serializable == null ? (class$java$io$Serializable = JDBCHelper.class$("java.io.Serializable")) : class$java$io$Serializable)) {
            return 2004;
        }
        throw new IllegalArgumentException("Can not determine JDBC-Type for class " + clazz);
    }

    public static long getDefaultSizeForClass(Class clazz, boolean storeCharacterAsNumber, boolean storeAllNumbersAsDecimals) {
        if (!(storeCharacterAsNumber || clazz != Character.TYPE && clazz != (class$java$lang$Character == null ? (class$java$lang$Character = JDBCHelper.class$("java.lang.Character")) : class$java$lang$Character))) {
            return 1L;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = JDBCHelper.class$("java.lang.String")) : class$java$lang$String)) {
            return 50L;
        }
        if (clazz == (class$java$util$Locale == null ? (class$java$util$Locale = JDBCHelper.class$("java.util.Locale")) : class$java$util$Locale)) {
            return 20L;
        }
        if (clazz == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = JDBCHelper.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
            return 28L;
        }
        if (clazz == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JDBCHelper.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            return 28L;
        }
        if (storeAllNumbersAsDecimals && (clazz == Byte.TYPE || clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = JDBCHelper.class$("java.lang.Byte")) : class$java$lang$Byte) || clazz == Short.TYPE || clazz == (class$java$lang$Short == null ? (class$java$lang$Short = JDBCHelper.class$("java.lang.Short")) : class$java$lang$Short) || clazz == Integer.TYPE || clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = JDBCHelper.class$("java.lang.Integer")) : class$java$lang$Integer) || clazz == Long.TYPE || clazz == (class$java$lang$Long == null ? (class$java$lang$Long = JDBCHelper.class$("java.lang.Long")) : class$java$lang$Long))) {
            return 28L;
        }
        if (storeCharacterAsNumber && storeAllNumbersAsDecimals && (clazz == Character.TYPE || clazz == (class$java$lang$Character == null ? (class$java$lang$Character = JDBCHelper.class$("java.lang.Character")) : class$java$lang$Character))) {
            return 28L;
        }
        return 0L;
    }

    public static int getDefaultDecimalsForClass(Class clazz, boolean storeCharacterAsNumber, boolean storeAllNumbersAsDecimals) {
        if (clazz == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JDBCHelper.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            return 10;
        }
        if (storeAllNumbersAsDecimals && (clazz == Byte.TYPE || clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = JDBCHelper.class$("java.lang.Byte")) : class$java$lang$Byte) || clazz == Short.TYPE || clazz == (class$java$lang$Short == null ? (class$java$lang$Short = JDBCHelper.class$("java.lang.Short")) : class$java$lang$Short) || clazz == Integer.TYPE || clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = JDBCHelper.class$("java.lang.Integer")) : class$java$lang$Integer) || clazz == Long.TYPE || clazz == (class$java$lang$Long == null ? (class$java$lang$Long = JDBCHelper.class$("java.lang.Long")) : class$java$lang$Long))) {
            return 5;
        }
        if (storeCharacterAsNumber && storeAllNumbersAsDecimals && (clazz == Character.TYPE || clazz == (class$java$lang$Character == null ? (class$java$lang$Character = JDBCHelper.class$("java.lang.Character")) : class$java$lang$Character))) {
            return 5;
        }
        return 0;
    }

    public static void appendTable(StringBuffer jdbcString, Table table) {
        jdbcString.append(JDBCHelper.getTableName(table));
    }

    public static String getTableName(Table table) {
        return '\"' + table.getName() + '\"';
    }

    public static void appendColumn(StringBuffer jdbcString, Column column) {
        jdbcString.append(JDBCHelper.getColumnName(column));
    }

    public static String getColumnName(Column column) {
        return '\"' + column.getName() + '\"';
    }

    public static void appendLiteral(StringBuffer jdbcString, String literal) {
        jdbcString.append("'" + literal + "'");
    }

    public static BigDecimal trimBigDecimal(BigDecimal value) {
        String str = value.toString();
        int trailingZeros = 0;
        int i = str.length() - 1;
        while (i >= 0) {
            if (str.charAt(i) == '0') {
                ++trailingZeros;
            } else {
                if (str.charAt(i) != '.') break;
                --trailingZeros;
                break;
            }
            --i;
        }
        if (trailingZeros > 0 && value.scale() > 0 && value.scale() - trailingZeros >= 0) {
            return value.setScale(value.scale() - trailingZeros);
        }
        return value;
    }

    public static int[] filterFields(int[] fields, Set filter) {
        int[] result = new int[fields.length - filter.size()];
        int j = 0;
        int i = 0;
        while (i < fields.length) {
            if (!filter.contains(new Integer(fields[i]))) {
                result[j++] = fields[i];
            }
            ++i;
        }
        return result;
    }

    public static StringBuffer filterStatementString(String statementString, Map replace) {
        StringBuffer s = new StringBuffer(statementString.length());
        int parameterIndex = 0;
        int pos = statementString.indexOf("= ?", 0);
        int lastPos = 0;
        while (pos != -1) {
            s.append(statementString.substring(lastPos, pos));
            String replaceString = (String)replace.get(new Integer(++parameterIndex));
            if (replaceString != null) {
                s.append(replaceString);
            } else {
                s.append("= ?");
            }
            lastPos = pos + "= ?".length();
            pos = statementString.indexOf("= ?", lastPos);
        }
        s.append(statementString.substring(lastPos));
        return s;
    }

    public static StringBuffer filterStatementString(String _statementString, Set replace) {
        HashMap nullStrings = new HashMap(replace.size());
        Iterator it = replace.iterator();
        while (it.hasNext()) {
            nullStrings.put(it.next(), " IS NULL ");
        }
        return JDBCHelper.filterStatementString(_statementString, nullStrings);
    }

    public static int[] filterStatementStringParameterMap(String statementString, Set replace) {
        int parameters = JDBCHelper.getParametersCount(statementString);
        int[] map = new int[parameters];
        int newParameterIndex = 0;
        int i = 0;
        while (i < parameters) {
            map[i] = replace.contains(new Integer(i + 1)) ? -1 : newParameterIndex++;
            ++i;
        }
        return map;
    }

    private static int getParametersCount(String statementString) {
        int parameters = 0;
        int pos = statementString.indexOf("= ?", 0);
        while (pos != -1) {
            ++parameters;
            pos = statementString.indexOf("= ?", pos + "= ?".length());
        }
        return parameters;
    }

    public static String getEscapedSQLString(String s, char escapeChar) {
        if (escapeChar == '\u0000') {
            return s;
        }
        char[] result = new char[s.length() + s.length() + 10];
        int pos = 0;
        int i = 0;
        while (i < s.length()) {
            char next = s.charAt(i);
            if (next == '%' || next == '_' || next == escapeChar) {
                result[pos++] = escapeChar;
            }
            result[pos++] = next;
            ++i;
        }
        return new String(result, 0, pos);
    }

    public static String getQuotedAndEscapedSQLString(String s, char escapeChar) {
        char[] result = new char[s.length() + s.length() + 10];
        int pos = 0;
        result[pos++] = 39;
        int i = 0;
        while (i < s.length()) {
            char next = s.charAt(i);
            if (next == '\'') {
                result[pos++] = 39;
            }
            if (escapeChar != '\u0000' && (next == '%' || next == '_' || next == escapeChar)) {
                result[pos++] = escapeChar;
            }
            result[pos++] = next;
            ++i;
        }
        result[pos++] = 39;
        return new String(result, 0, pos);
    }

    public static final boolean isSupported(int jdbcType) {
        return JDBCHelper.isFullySupported(jdbcType) || jdbcType == 1 || jdbcType == -3 || jdbcType == 6 || jdbcType == 2 || jdbcType == -7;
    }

    public static final boolean isFullySupported(int jdbcType) {
        return jdbcType == 12 || jdbcType == -2 || jdbcType == -1 || jdbcType == -4 || jdbcType == 5 || jdbcType == 4 || jdbcType == -5 || jdbcType == 7 || jdbcType == 8 || jdbcType == 3 || jdbcType == 91 || jdbcType == 92 || jdbcType == 93 || jdbcType == 2005 || jdbcType == 2004;
    }

    public static final boolean isLargeObject(int jdbcType) {
        return 2004 == jdbcType || 2005 == jdbcType || -1 == jdbcType || -4 == jdbcType;
    }

    public static final boolean isComparable(int jdbcType) {
        return JDBCHelper.isSupported(jdbcType) && !JDBCHelper.isLargeObject(jdbcType);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class InvalidJdbcType
    extends Exception {
        public InvalidJdbcType(String message) {
            super(message);
        }
    }
}

