/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.sql.catalog.virtual;

import com.sap.jdo.sql.catalog.Column;
import com.sap.jdo.sql.catalog.ColumnIterator;
import com.sap.jdo.sql.catalog.Table;
import com.sap.jdo.sql.catalog.virtual.VirtualCatalogReader;
import com.sap.jdo.sql.catalog.virtual.VirtualColumn;
import java.util.HashMap;
import java.util.Iterator;

public class VirtualTable
implements Table {
    private VirtualCatalogReader _catalogReader = null;
    private HashMap _columns = new HashMap();
    private String _name = null;
    private String _schemaName = null;

    public VirtualTable(VirtualCatalogReader catalogReader, String tableName) {
        this._catalogReader = catalogReader;
        this._name = tableName;
    }

    public VirtualTable(VirtualCatalogReader catalogReader, String schemaName, String tableName) {
        this(catalogReader, tableName);
        this._schemaName = schemaName;
    }

    public String getName() {
        return this._name;
    }

    public String getSchemaName() {
        return this._schemaName;
    }

    public synchronized int getColumnCnt() {
        return this._columns.size();
    }

    public int getPrimaryKeyCnt() {
        throw new UnsupportedOperationException();
    }

    public synchronized Column getColumn(String columnName) {
        Column column = (Column)this._columns.get(columnName);
        if (column == null) {
            column = new VirtualColumn(this._catalogReader, this, columnName);
            this._columns.put(columnName, column);
        }
        return column;
    }

    public ColumnIterator getColumns() {
        return new VirtualColumnIterator(this._columns.values().iterator());
    }

    public String toString() {
        return this.getName();
    }

    public class VirtualColumnIterator
    implements ColumnIterator {
        Iterator _it;

        public VirtualColumnIterator(Iterator it) {
            this._it = it;
        }

        public Column next() {
            return (Column)this._it.next();
        }

        public boolean hasNext() {
            return this._it.hasNext();
        }
    }
}

