/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.sql.catalog.virtual;

import com.sap.jdo.sql.catalog.ForeignKey;
import com.sap.jdo.sql.catalog.JDOCatalogReader;
import com.sap.jdo.sql.catalog.Table;
import com.sap.jdo.sql.catalog.impl.AbstractCatalogReader;
import com.sap.jdo.sql.catalog.virtual.VirtualForeignKey;
import com.sap.jdo.sql.catalog.virtual.VirtualTable;
import java.util.HashMap;
import java.util.Iterator;

public class VirtualCatalogReader
extends AbstractCatalogReader {
    private HashMap _tables = new HashMap();
    private HashMap _schemaTables = new HashMap();

    public synchronized Table getTable(String tableName) {
        Table table = (Table)this._tables.get(tableName);
        if (table == null) {
            table = new VirtualTable(this, tableName);
            this._tables.put(tableName, table);
        }
        return table;
    }

    public synchronized Table getTable(String schemaName, String tableName) {
        Table table;
        HashMap<String, Table> tables = (HashMap<String, Table>)this._schemaTables.get(schemaName);
        if (tables == null) {
            tables = new HashMap<String, Table>();
            table = new VirtualTable(this, schemaName, tableName);
            tables.put(tableName, table);
            this._schemaTables.put(schemaName, tables);
        } else {
            table = (Table)tables.get(tableName);
            if (table == null) {
                table = new VirtualTable(this, schemaName, tableName);
                tables.put(tableName, table);
            }
        }
        return table;
    }

    public synchronized String[] getTables() {
        return this.getTables(this._tables);
    }

    public synchronized String[] getTables(String schemaName) {
        HashMap tables = (HashMap)this._schemaTables.get(schemaName);
        return this.getTables(tables);
    }

    private synchronized String[] getTables(HashMap tables) {
        String[] result = null;
        if (tables != null) {
            result = new String[tables.keySet().size()];
            Iterator i = tables.keySet().iterator();
            int j = 0;
            while (j < result.length) {
                result[j] = (String)i.next();
                ++j;
            }
        }
        return result;
    }

    protected ForeignKey createConcreteForeignKey(JDOCatalogReader catalogReader, String foreignKeyName) {
        return new VirtualForeignKey(catalogReader, foreignKeyName);
    }

    protected ForeignKey createConcreteForeignKey(JDOCatalogReader catalogReader, String schemaName, String foreignKeyName) {
        return new VirtualForeignKey(catalogReader, schemaName, foreignKeyName);
    }
}

