/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.sql.catalog.impl;

import com.sap.jdo.sql.catalog.Column;
import com.sap.jdo.sql.catalog.ForeignKey;
import com.sap.jdo.sql.catalog.JDOCatalogReader;
import com.sap.jdo.sql.catalog.Table;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOUserException;

public abstract class AbstractForeignKey
implements ForeignKey {
    protected JDOCatalogReader _catalogReader = null;
    protected String _name = null;
    protected String _schemaName = null;
    protected Table _foreignKeyTable = null;
    protected Table _primaryKeyTable = null;
    protected List _foreignKeyColumns = new ArrayList();
    protected List _primaryKeyColumns = new ArrayList();
    protected static final Column[] initialColumnArray = new Column[0];

    public AbstractForeignKey(JDOCatalogReader catalogReader, String foreignKeyName) {
        this._catalogReader = catalogReader;
        this._name = foreignKeyName;
    }

    public AbstractForeignKey(JDOCatalogReader catalogReader, String schemaName, String foreignKeyName) {
        this(catalogReader, foreignKeyName);
        this._schemaName = schemaName;
    }

    public synchronized void setTableNames(String foreignKeyTableName, String primaryKeyTableName) {
        if (this._foreignKeyTable != null && !foreignKeyTableName.equals(this._foreignKeyTable.getName())) {
            throw new JDOUserException("inconsistent mapping metadata for foreign key " + this.getName() + " - different foreign key tables in multiple foreign key definitions");
        }
        if (this._primaryKeyTable != null && !primaryKeyTableName.equals(this._primaryKeyTable.getName())) {
            throw new JDOUserException("inconsistent mapping metadata for foreign key " + this.getName() + " - different primary key tables in multiple foreign key definitions");
        }
        try {
            this._foreignKeyTable = this._catalogReader.getTable(foreignKeyTableName);
            if (this._foreignKeyTable == null) {
                throw new JDOUserException("inconsistent mapping metadata for foreign key " + this.getName() + " - foreign key table " + foreignKeyTableName + " not found");
            }
            this._primaryKeyTable = this._catalogReader.getTable(primaryKeyTableName);
            if (this._primaryKeyTable == null) {
                throw new JDOUserException("inconsistent mapping metadata for foreign key " + this.getName() + " - primary key table " + primaryKeyTableName + " not found");
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException("catalog error");
        }
    }

    public synchronized void setColumnPair(String foreignKeyColumnName, String primaryKeyColumnName) {
        Column foreignKeyColumn = this._foreignKeyTable.getColumn(foreignKeyColumnName);
        if (foreignKeyColumn == null) {
            throw new JDOUserException("inconsistent mapping metadata for foreign key " + this.getName() + " - column " + foreignKeyColumnName + " in table " + this._foreignKeyTable.getName() + " not found");
        }
        Column primaryKeyColumn = this._primaryKeyTable.getColumn(primaryKeyColumnName);
        if (primaryKeyColumn == null) {
            throw new JDOUserException("inconsistent mapping metadata for foreign key " + this.getName() + " - column " + primaryKeyColumnName + " in table " + this._primaryKeyTable.getName() + " not found");
        }
        this.setColumnPair(foreignKeyColumn, primaryKeyColumn);
    }

    public synchronized void setColumnPair(Column foreignKeyColumn, Column primaryKeyColumn) {
        if (this._foreignKeyColumns.indexOf(foreignKeyColumn) != this._primaryKeyColumns.indexOf(primaryKeyColumn)) {
            throw new JDOUserException("inconsistent mapping metadata for foreign key " + this.getName() + " - different column pairs in multiple foreign key definitions");
        }
        if (!this._foreignKeyColumns.contains(foreignKeyColumn)) {
            this._foreignKeyColumns.add(foreignKeyColumn);
        }
        if (!this._primaryKeyColumns.contains(primaryKeyColumn)) {
            this._primaryKeyColumns.add(primaryKeyColumn);
        }
    }

    public String getName() {
        return this._name;
    }

    public String getSchemaName() {
        return this._schemaName;
    }

    public synchronized Table getForeignKeyTable() {
        return this._foreignKeyTable;
    }

    public synchronized Table getPrimaryKeyTable() {
        return this._primaryKeyTable;
    }

    public synchronized Column[] getForeignKeyColumns() {
        return this._foreignKeyColumns.toArray(initialColumnArray);
    }

    public synchronized Column[] getPrimaryKeyColumns() {
        return this._primaryKeyColumns.toArray(initialColumnArray);
    }

    public synchronized Column getFKColumnForPKColumn(Column pkColumn) {
        int i = this._primaryKeyColumns.indexOf(pkColumn);
        return i >= 0 ? (Column)this._foreignKeyColumns.get(i) : null;
    }

    public synchronized Column getPKColumnForFKColumn(Column fkColumn) {
        int i = this._foreignKeyColumns.indexOf(fkColumn);
        return i >= 0 ? (Column)this._primaryKeyColumns.get(i) : null;
    }
}

