/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.util;

import com.sap.jdo.enhancer.util.Assertion;
import com.sap.jdo.enhancer.util.ResourceLocator;
import com.sap.jdo.enhancer.util.ResourceLocatorBase;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;

public class CombinedResourceLocator
extends ResourceLocatorBase
implements ResourceLocator {
    final List locators;

    public CombinedResourceLocator(PrintWriter out, boolean verbose, List locators) {
        super(out, verbose);
        Assertion.affirm(locators != null);
        this.locators = locators;
    }

    public InputStream getInputStreamForResource(String resourceName) {
        Assertion.affirm(resourceName != null);
        Iterator i = this.locators.iterator();
        while (i.hasNext()) {
            ResourceLocator locator = (ResourceLocator)i.next();
            Assertion.affirm(locator != null);
            InputStream stream = locator.getInputStreamForResource(resourceName);
            if (stream == null) continue;
            return stream;
        }
        return null;
    }
}

