/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.test;

import com.sap.jdo.enhancer.classfile.ClassFile;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Disassembler {
    public static final int OK = 0;
    public static final int USAGE_ERROR = -1;
    public static final int INTERNAL_ERROR = -3;
    public static final int AFFIRMATIVE = 1;
    public static final int NEGATIVE = 0;
    public static final int ERROR = -1;
    private static boolean debug = true;
    private static final PrintWriter out = new PrintWriter(System.out, true);
    private static final PrintWriter err = new PrintWriter(System.err, true);
    private boolean verbose;

    static final void affirm(boolean cond) {
        if (debug && !cond) {
            throw new RuntimeException("Assertion failed.");
        }
    }

    static final void affirm(Object obj) {
        if (debug && obj == null) {
            throw new RuntimeException("Assertion failed: obj = null");
        }
    }

    private static InputStream openFileInputStream(String fileName) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(fileName));
    }

    private static void closeInputStream(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException ex) {
                err.println("Exception caught: " + ex);
            }
        }
    }

    private int disassemble(PrintWriter out, String fileName) {
        Disassembler.affirm(fileName);
        DataInputStream dis = null;
        try {
            try {
                dis = new DataInputStream(Disassembler.openFileInputStream(fileName));
                boolean allowJDK12ClassFiles = true;
                ClassFile classFile = new ClassFile(dis, true);
                ByteArrayOutputStream b = new ByteArrayOutputStream();
                if (this.verbose) {
                    classFile.print(new PrintStream(b), 0);
                    out.println(b.toString());
                }
                out.println("Statistics:");
                classFile.summarize(new PrintStream(b), 4);
                out.println(b.toString());
            }
            catch (ClassFormatError ex) {
                out.println("    !!! ERROR: format error when parsing classfile: " + fileName);
                out.println("        error: " + err);
                int classFile = -1;
                Object var8_12 = null;
                Disassembler.closeInputStream(dis);
                return classFile;
            }
            catch (IOException ex) {
                out.println("    !!! ERROR: exception while reading classfile: " + fileName);
                out.println("        exception: " + ex);
                int n = -1;
                Object var8_13 = null;
                Disassembler.closeInputStream(dis);
                return n;
            }
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            Disassembler.closeInputStream(dis);
            throw throwable;
        }
        Disassembler.closeInputStream(dis);
        return 1;
    }

    private int disassemble(PrintWriter out, List classFileNames) {
        Disassembler.affirm(classFileNames);
        int res = 1;
        Iterator i = classFileNames.iterator();
        while (i.hasNext()) {
            String classFileName = (String)i.next();
            out.println("-------------------------------------------------------------------------------");
            out.println();
            StringWriter s = new StringWriter();
            if (this.disassemble(new PrintWriter(s), classFileName) < 0) {
                out.println();
                out.println("!!! ERROR: failed disassembling classfile: " + classFileName);
                out.println(s.toString());
                res = -1;
            }
            out.println("+++ disassembled classfile: " + classFileName);
            out.println();
            out.println(s.toString());
        }
        return res;
    }

    public int disassemble(PrintWriter out, boolean verbose, List classFileNames) {
        Disassembler.affirm(classFileNames);
        this.verbose = verbose;
        out.println();
        out.println("Disassembler: Prints out the byte-code of classfiles.");
        int res = this.disassemble(out, classFileNames);
        out.println();
        out.print("Disassembler: Summary:  ");
        if (res < 0) {
            out.println("ERROR with disassembling classfiles.");
        } else {
            out.println("SUCCESSFULLY disassembled all classfiles.");
        }
        return res;
    }

    private static void usage() {
        err.println();
        err.println("Usage: Disassembler <options> <classfiles>...");
        err.println();
        err.println("This class disassembles and prints out classfiles.");
        err.println();
        err.println("Options include:");
        err.println("    -h, --help               print usage");
        err.println("    -v, --verbose            enable verbose output");
        err.println();
        err.println("Return value:");
        err.println("= 0   no errors");
        err.println("< 0   errors found");
        err.println();
    }

    public static void main(String[] argv) {
        boolean verbose = false;
        ArrayList<String> classFileNames = new ArrayList<String>();
        int i = 0;
        while (i < argv.length) {
            String arg = argv[i];
            if (arg.equals("-h") || arg.equals("--help")) {
                Disassembler.usage();
                System.exit(0);
            }
            if (arg.equals("-v") || arg.equals("--verbose")) {
                verbose = true;
            } else if (arg.equals("-d") || arg.equals("--debug")) {
                debug = true;
            } else {
                if (arg.startsWith("-")) {
                    err.println();
                    err.println("Unrecognized option: " + arg);
                    Disassembler.usage();
                    System.exit(-1);
                }
                classFileNames.add(arg);
            }
            ++i;
        }
        if (classFileNames.size() == 0) {
            err.println();
            err.println("Incorrect number of classfiles arguments.");
            Disassembler.usage();
            System.exit(-1);
            return;
        }
        if (debug) {
            out.println("Disassembler: options:");
            out.println("    verbose = " + verbose);
            out.print("    classFileNames =");
            int i2 = 0;
            while (i2 < classFileNames.size()) {
                out.print(" " + classFileNames.get(i2));
                ++i2;
            }
            out.println();
        }
        try {
            Disassembler dis = new Disassembler();
            int res = dis.disassemble(out, verbose, classFileNames);
            System.exit(res);
        }
        catch (RuntimeException ex) {
            err.println("Internal error;");
            err.println("Exception caught:" + ex);
            ex.printStackTrace(err);
            System.exit(-3);
        }
    }
}

