/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.test;

import com.sap.jdo.enhancer.classfile.ClassFile;
import com.sap.jdo.enhancer.classfile.ClassMethod;
import com.sap.jdo.enhancer.classfile.Descriptor;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class AugmentationDiffTest {
    public static final int OK = 0;
    public static final int USAGE_ERROR = -1;
    public static final int INTERNAL_ERROR = -3;
    public static final int AFFIRMATIVE = 1;
    public static final int NEGATIVE = 0;
    public static final int ERROR = -1;
    private static boolean debug = false;
    private static final PrintWriter out = new PrintWriter(System.out, true);
    private static final PrintWriter err = new PrintWriter(System.err, true);
    private boolean verbose;
    private String[] classFileNames;
    private String[] classNames;
    private String[] userClassNames;
    private ClassFile[] classFiles;

    static final void affirm(boolean cond) {
        if (debug && !cond) {
            throw new RuntimeException("Assertion failed.");
        }
    }

    static final void affirm(Object obj) {
        if (debug && obj == null) {
            throw new RuntimeException("Assertion failed: obj = null");
        }
    }

    private static InputStream openFileInputStream(String fileName) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(fileName));
    }

    private static void closeInputStream(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException ex) {
                err.println("Exception caught: " + ex);
            }
        }
    }

    private int diffAugmentation(PrintWriter out) {
        AugmentationDiffTest.affirm(true);
        AugmentationDiffTest.affirm(this.classFiles.length == 2);
        AugmentationDiffTest.affirm(this.classNames.length == 2);
        int res = 0;
        Map[] classMethods = new Map[]{new HashMap(), new HashMap()};
        int i = 0;
        while (i < 2) {
            Enumeration e = this.classFiles[i].methods().elements();
            while (e.hasMoreElements()) {
                ClassMethod method = (ClassMethod)e.nextElement();
                String methodSig = method.signature().asString();
                String methodArgs = Descriptor.userMethodArgs(methodSig);
                String methodName = method.name().asString();
                if (!methodName.startsWith("jdo")) continue;
                ClassMethod obj = classMethods[i].put(methodName + methodArgs, method);
                AugmentationDiffTest.affirm(obj == null);
            }
            ++i;
        }
        HashSet keySet = new HashSet();
        keySet.addAll(classMethods[0].keySet());
        keySet.addAll(classMethods[1].keySet());
        Iterator i2 = keySet.iterator();
        while (i2.hasNext()) {
            ClassMethod method1;
            Object key = i2.next();
            ClassMethod method0 = (ClassMethod)classMethods[0].remove(key);
            AugmentationDiffTest.affirm(method0 != (method1 = (ClassMethod)classMethods[1].remove(key)));
            AugmentationDiffTest.affirm(method0 != null || method1 != null);
            if (method0 == null || method1 == null) {
                out.println("    !!! ERROR: missing method: " + key);
                out.println("        <<< method: " + method0);
                out.println("        >>> method: " + method1);
                res = -1;
                continue;
            }
            Stack<String> msg = new Stack<String>();
            if (method0.isEqual(msg, method1)) {
                if (!this.verbose) continue;
                out.println("    +++ equal augmentation: " + key);
                continue;
            }
            out.println("    !!! not equal augmentation: " + key);
            msg.push("method = " + method1);
            msg.push("method = " + method0);
            StringWriter s0 = new StringWriter();
            StringWriter s1 = new StringWriter();
            PrintWriter p0 = new PrintWriter(s0);
            PrintWriter p1 = new PrintWriter(s1);
            int j = 0;
            while (!msg.empty()) {
                p0.println("    <<< " + AugmentationDiffTest.pad(j) + msg.pop());
                p1.println("    >>> " + AugmentationDiffTest.pad(j) + msg.pop());
                j += 4;
            }
            out.println(s0.toString());
            out.println(s1.toString());
            if (!this.verbose) break;
            ByteArrayOutputStream b0 = new ByteArrayOutputStream();
            ByteArrayOutputStream b1 = new ByteArrayOutputStream();
            method0.print(new PrintStream(b0), 4);
            method1.print(new PrintStream(b1), 4);
            out.println(b0.toString());
            out.println(b1.toString());
            if (res != 0) break;
            res = 1;
            break;
        }
        return res;
    }

    private static String pad(int n) {
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < n) {
            s.append(' ');
            ++i;
        }
        return s.toString();
    }

    private int parseClass(PrintWriter out, int i) {
        AugmentationDiffTest.affirm(0 <= i && i <= 1);
        AugmentationDiffTest.affirm(this.classFileNames.length == 2);
        AugmentationDiffTest.affirm(this.classFiles.length == 2);
        AugmentationDiffTest.affirm(this.classNames.length == 2);
        AugmentationDiffTest.affirm(this.userClassNames.length == 2);
        String fileName = this.classFileNames[i];
        DataInputStream dis = null;
        try {
            try {
                dis = new DataInputStream(AugmentationDiffTest.openFileInputStream(fileName));
                boolean allowJDK12ClassFiles = true;
                this.classFiles[i] = new ClassFile(dis, true);
                this.classNames[i] = this.classFiles[i].className().asString();
                this.userClassNames[i] = this.classNames[i].replace('/', '.');
                out.println("    +++ parsed classfile");
            }
            catch (ClassFormatError ex) {
                out.println("    !!! ERROR: format error when parsing classfile: " + fileName);
                out.println("        error: " + err);
                int n = -1;
                Object var9_8 = null;
                AugmentationDiffTest.closeInputStream(dis);
                return n;
            }
            catch (IOException ex) {
                out.println("    !!! ERROR: exception while reading classfile: " + fileName);
                out.println("        exception: " + ex);
                int n = -1;
                Object var9_9 = null;
                AugmentationDiffTest.closeInputStream(dis);
                return n;
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            AugmentationDiffTest.closeInputStream(dis);
            throw throwable;
        }
        AugmentationDiffTest.closeInputStream(dis);
        return 1;
    }

    private int test(PrintWriter out, String[] classFileNames) {
        StringWriter s;
        AugmentationDiffTest.affirm(classFileNames.length == 2);
        this.classFileNames = classFileNames;
        if (this.verbose) {
            out.println("-------------------------------------------------------------------------------");
            out.println();
            out.println("Test classfiles for equal augmentation: ...");
        }
        this.classFiles = new ClassFile[2];
        this.classNames = new String[2];
        this.userClassNames = new String[2];
        int i = 0;
        while (i < 2) {
            s = new StringWriter();
            if (this.parseClass(new PrintWriter(s), i) <= 0) {
                out.println();
                out.println("!!! ERROR: failed parsing classfile: " + classFileNames[i]);
                out.println(s.toString());
                return -1;
            }
            if (this.verbose) {
                out.println();
                out.println("+++ parsed classfile: " + classFileNames[i]);
                out.println(s.toString());
            }
            ++i;
        }
        s = new StringWriter();
        if (!this.classNames[0].equals(this.classNames[1])) {
            out.println();
            out.println("!!! ERROR: different class names:");
            out.println("<<< class name = " + this.userClassNames[0]);
            out.println(">>> class name = " + this.userClassNames[1]);
            out.println(s.toString());
            return -1;
        }
        s = new StringWriter();
        int r = this.diffAugmentation(new PrintWriter(s));
        if (r < 0) {
            out.println();
            out.println("!!! ERROR: incorrect augmentation: " + this.userClassNames[0]);
            out.println(s.toString());
            return -1;
        }
        if (r == 0) {
            out.println();
            out.println("+++ equal augmentation:" + this.userClassNames[0]);
        } else {
            out.println();
            out.println("!!! not equal augmentation:" + this.userClassNames[0]);
        }
        if (this.verbose) {
            out.println(s.toString());
        }
        return r;
    }

    public int test(PrintWriter out, boolean verbose, List classFileNames) {
        AugmentationDiffTest.affirm(classFileNames.size() % 2 == 0);
        this.verbose = verbose;
        out.println();
        out.println("AugmentationDiffTest: Testing Classes for JDO Persistence-Capability Enhancement");
        int all = classFileNames.size() / 2;
        int nofFailed = 0;
        int i = 0;
        while (i < all) {
            String name1;
            String name0 = (String)classFileNames.get(i);
            String[] pair = new String[]{name0, name1 = (String)classFileNames.get(all + i)};
            if (this.test(out, pair) != 0) {
                ++nofFailed;
            }
            ++i;
        }
        int nofPassed = all - nofFailed;
        out.println();
        out.println("AugmentationDiffTest: Summary:  TESTED: " + all + "  PASSED: " + nofPassed + "  FAILED: " + nofFailed);
        return nofFailed;
    }

    private static void usage() {
        err.println();
        err.println("Usage: AugmentationDiffTest <options> <classfile1> ... <classfile2> ...");
        err.println();
        err.println("This class pairwise tests if two classes have structurally the same code");
        err.println("enhancement for persistence-capability (\"augmentation\").");
        err.println();
        err.println("Options include:");
        err.println("    -h, --help               print usage");
        err.println("    -v, --verbose            enable verbose output");
        err.println();
        err.println("Return value:");
        err.println("= 0   equally augmented classfiles");
        err.println("> 0   not equally augmented classfiles");
        err.println("< 0   severe errors preventing the test to complete");
        err.println();
    }

    public static void main(String[] argv) {
        boolean verbose = false;
        ArrayList<String> classFileNames = new ArrayList<String>();
        int i = 0;
        while (i < argv.length) {
            String arg = argv[i];
            if (arg.equals("-h") || arg.equals("--help")) {
                AugmentationDiffTest.usage();
                System.exit(0);
            }
            if (arg.equals("-v") || arg.equals("--verbose")) {
                verbose = true;
            } else if (arg.equals("-d") || arg.equals("--debug")) {
                debug = true;
            } else {
                if (arg.startsWith("-")) {
                    err.println();
                    err.println("Unrecognized option: " + arg);
                    AugmentationDiffTest.usage();
                    System.exit(-1);
                }
                classFileNames.add(arg);
            }
            ++i;
        }
        if (classFileNames.size() % 2 != 0) {
            err.println();
            err.println("Odd number of classfiles arguments.");
            AugmentationDiffTest.usage();
            System.exit(-1);
            return;
        }
        if (debug) {
            out.println("AugmentationDiffTest: options:");
            out.println("    verbose = " + verbose);
            out.print("    classFileNames =");
            int i2 = 0;
            while (i2 < classFileNames.size()) {
                out.print(" " + classFileNames.get(i2));
                ++i2;
            }
            out.println();
        }
        try {
            AugmentationDiffTest test = new AugmentationDiffTest();
            int res = test.test(out, verbose, classFileNames);
            System.exit(res);
        }
        catch (RuntimeException ex) {
            err.println("Internal error;");
            err.println("Exception caught:" + ex);
            ex.printStackTrace(err);
            System.exit(-3);
        }
    }
}

