/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.test;

import com.sap.jdo.enhancer.classfile.ClassFile;
import com.sap.jdo.enhancer.classfile.ClassMethod;
import com.sap.jdo.enhancer.classfile.CodeAttribute;
import com.sap.jdo.enhancer.classfile.ConstClass;
import com.sap.jdo.enhancer.classfile.ConstFieldRef;
import com.sap.jdo.enhancer.classfile.ConstMethodRef;
import com.sap.jdo.enhancer.classfile.ConstNameAndType;
import com.sap.jdo.enhancer.classfile.Descriptor;
import com.sap.jdo.enhancer.classfile.Insn;
import com.sap.jdo.enhancer.classfile.InsnConstOp;
import com.sap.jdo.enhancer.meta.EnhancerMetaData;
import com.sap.jdo.enhancer.meta.EnhancerMetaDataFatalError;
import com.sap.jdo.enhancer.meta.EnhancerMetaDataUserException;
import com.sap.jdo.enhancer.meta.model.EnhancerMetaDataJDOModelImpl;
import com.sap.jdo.enhancer.meta.prop.EnhancerMetaDataPropertyImpl;
import com.sap.jdo.enhancer.meta.util.EnhancerMetaDataBaseModel;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class AnnotationTest {
    public static final int OK = 0;
    public static final int USAGE_ERROR = -1;
    public static final int METADATA_ERROR = -2;
    public static final int INTERNAL_ERROR = -3;
    public static final int AFFIRMATIVE = 1;
    public static final int NEGATIVE = 0;
    public static final int ERROR = -1;
    private static boolean debug = false;
    private static final PrintWriter out = new PrintWriter(System.out, true);
    private static final PrintWriter err = new PrintWriter(System.err, true);
    final EnhancerMetaData meta;
    private boolean verbose;
    private List classFilesNames;
    private String className;
    private String userClassName;
    private ClassFile classFile;
    static /* synthetic */ Class class$com$sap$jdo$enhancer$test$AnnotationTest;

    static final void affirm(boolean cond) {
        if (debug && !cond) {
            throw new RuntimeException("Assertion failed.");
        }
    }

    static final void affirm(Object obj) {
        if (debug && obj == null) {
            throw new RuntimeException("Assertion failed: obj = null");
        }
    }

    private static InputStream openFileInputStream(String fileName) throws FileNotFoundException {
        InputStream is = (class$com$sap$jdo$enhancer$test$AnnotationTest == null ? (class$com$sap$jdo$enhancer$test$AnnotationTest = AnnotationTest.class$("com.sap.jdo.enhancer.test.AnnotationTest")) : class$com$sap$jdo$enhancer$test$AnnotationTest).getClassLoader().getResourceAsStream(fileName);
        if (is != null) {
            return is;
        }
        return new BufferedInputStream(new FileInputStream(fileName));
    }

    private static void closeInputStream(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException ex) {
                err.println("Exception caught: " + ex);
            }
        }
    }

    public AnnotationTest(EnhancerMetaData jdoMetaData) {
        this.meta = jdoMetaData;
    }

    private int checkGetPutField(PrintWriter out, Insn insn, boolean jdoMethod) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        int res;
        String fieldType;
        ConstNameAndType fieldNameAndType;
        String fieldName;
        InsnConstOp fieldInsn = (InsnConstOp)insn;
        ConstFieldRef fieldRef = (ConstFieldRef)fieldInsn.value();
        ConstClass declClass = fieldRef.className();
        String declClassName = declClass.asString();
        if (this.meta.isKnownNonManagedField(declClassName, fieldName = (fieldNameAndType = fieldRef.nameAndType()).name().asString(), fieldType = fieldNameAndType.signature().asString())) {
            res = 0;
        } else if (!jdoMethod) {
            out.println("        !!! ERROR: missing annotation of field access: " + declClassName + "." + fieldName);
            res = -1;
        } else {
            res = 0;
        }
        return res;
    }

    private int checkInvokeStatic(PrintWriter out, Insn insn, boolean jdoMethod) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        int res;
        String fieldType;
        InsnConstOp methodInsn = (InsnConstOp)insn;
        ConstMethodRef methodRef = (ConstMethodRef)methodInsn.value();
        ConstClass declClass = methodRef.className();
        String declClassName = declClass.asString();
        ConstNameAndType methodNameAndType = methodRef.nameAndType();
        String methodName = methodNameAndType.name().asString();
        String methodType = methodNameAndType.signature().asString();
        if (!(methodName.startsWith("jdoSet") || methodName.startsWith("jdoGet") && !methodName.equals("jdoGetManagedFieldCount"))) {
            return 0;
        }
        String fieldName = methodName.substring(6);
        if (methodName.startsWith("jdoGet")) {
            fieldType = Descriptor.extractResultSig(methodType);
        } else {
            String argSig = Descriptor.extractArgSig(methodType);
            int idx = Descriptor.nextSigElement(argSig, 0);
            fieldType = argSig.substring(idx);
        }
        AnnotationTest.affirm(fieldType != null);
        if (this.meta.isKnownNonManagedField(declClassName, fieldName, fieldType)) {
            out.println("        !!! ERROR: annotated access to non-managed field: " + declClassName + "." + fieldName);
            res = -1;
        } else if (jdoMethod) {
            out.println("        !!! ERROR: annotated field access in JDO method: " + declClassName + "." + fieldName);
            res = -1;
        } else {
            if (this.verbose) {
                out.println("        +++ annotated field access: " + declClassName + "." + fieldName);
            }
            res = 1;
        }
        return res;
    }

    private int hasAnnotation(PrintWriter out, ClassMethod method, String methodName) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        CodeAttribute codeAttr = method.codeAttribute();
        if (codeAttr == null) {
            return 0;
        }
        int res = 0;
        String methodNameWithoutArguments = methodName.substring(0, methodName.indexOf(40));
        boolean jdoMethod = methodNameWithoutArguments.startsWith("jdo") & (!methodNameWithoutArguments.equals("jdoPreStore") & !methodNameWithoutArguments.equals("jdoPreDelete")) | methodNameWithoutArguments.equals("readObject");
        Insn firstInsn = codeAttr.theCode();
        Insn insn = firstInsn.next();
        while (insn != null) {
            switch (insn.opcode()) {
                case 180: 
                case 181: {
                    int r = this.checkGetPutField(out, insn, jdoMethod);
                    if (r >= 0) break;
                    res = -1;
                    break;
                }
                case 184: {
                    int r = this.checkInvokeStatic(out, insn, jdoMethod);
                    if (r < 0) {
                        res = -1;
                        break;
                    }
                    if (r <= 0 || res != 0) break;
                    res = 1;
                    break;
                }
            }
            insn = insn.next();
        }
        return res;
    }

    private int testAnnotation(PrintWriter out) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        AnnotationTest.affirm(true);
        AnnotationTest.affirm(this.classFile);
        AnnotationTest.affirm(this.className);
        int res = 0;
        Enumeration e = this.classFile.methods().elements();
        while (e.hasMoreElements()) {
            ClassMethod method = (ClassMethod)e.nextElement();
            String methodSig = method.signature().asString();
            String methodArgs = Descriptor.userMethodArgs(methodSig);
            StringWriter s = new StringWriter();
            String methodName = method.name().asString() + methodArgs;
            int r = this.hasAnnotation(new PrintWriter(s), method, methodName);
            if (r < 0) {
                out.println("    !!! ERROR: incorrect annotation in: " + methodName);
                out.println(s.toString());
                res = -1;
                continue;
            }
            if (r == 0) {
                if (!this.verbose) continue;
                out.println("    --- not annotated: " + methodName);
                out.println(s.toString());
                continue;
            }
            AnnotationTest.affirm(r > 0);
            if (this.verbose) {
                out.println("    +++ has correct annotation: " + methodName);
                out.println(s.toString());
            }
            if (res != 0) continue;
            res = 1;
        }
        return res;
    }

    private int parseClass(PrintWriter out, String fileName) {
        DataInputStream dis = null;
        try {
            try {
                dis = new DataInputStream(AnnotationTest.openFileInputStream(fileName));
                boolean allowJDK12ClassFiles = true;
                this.classFile = new ClassFile(dis, true);
                this.className = this.classFile.className().asString();
                this.userClassName = this.className.replace('/', '.');
                out.println("    +++ parsed classfile");
            }
            catch (ClassFormatError ex) {
                out.println("    !!! ERROR: format error when parsing classfile: " + fileName);
                out.println("        error: " + err);
                int n = -1;
                Object var8_7 = null;
                AnnotationTest.closeInputStream(dis);
                return n;
            }
            catch (IOException ex) {
                out.println("    !!! ERROR: exception while reading classfile: " + fileName);
                out.println("        exception: " + ex);
                int n = -1;
                Object var8_8 = null;
                AnnotationTest.closeInputStream(dis);
                return n;
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            AnnotationTest.closeInputStream(dis);
            throw throwable;
        }
        AnnotationTest.closeInputStream(dis);
        AnnotationTest.affirm(this.classFile);
        return 1;
    }

    private int test(PrintWriter out, String classFile) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        int r;
        StringWriter s;
        AnnotationTest.affirm(classFile);
        if (this.verbose) {
            out.println("-------------------------------------------------------------------------------");
            out.println();
            out.println("Test classfile for correct annotation: " + classFile + " ...");
        }
        if (this.parseClass(new PrintWriter(s = new StringWriter()), classFile) <= 0) {
            out.println();
            out.println("!!! ERROR: failed parsing classfile: " + classFile);
            out.println(s.toString());
            return -1;
        }
        if (this.verbose) {
            out.println();
            out.println("+++ parsed classfile: " + classFile);
            out.println(s.toString());
        }
        if ((r = this.testAnnotation(new PrintWriter(s = new StringWriter()))) < 0) {
            out.println();
            out.println("!!! ERROR: incorrect annotation: " + this.userClassName);
            out.println(s.toString());
            return -1;
        }
        if (r == 0) {
            out.println();
            out.println("--- class not annotated: " + this.userClassName);
        } else {
            out.println();
            out.println("+++ class annotated: " + this.userClassName);
        }
        if (this.verbose) {
            out.println(s.toString());
        }
        return r;
    }

    public int test(PrintWriter out, boolean verbose, List classFilesNames) {
        AnnotationTest.affirm(classFilesNames);
        this.verbose = verbose;
        int all = classFilesNames.size();
        out.println();
        out.println("AnnotationTest: Testing Classes for JDO Persistence-Capability Enhancement");
        int nofFailed = 0;
        int i = 0;
        while (i < all) {
            if (this.test(out, (String)classFilesNames.get(i)) < 0) {
                ++nofFailed;
            }
            ++i;
        }
        int nofPassed = all - nofFailed;
        out.println();
        out.println("AnnotationTest: Summary:  TESTED: " + all + "  PASSED: " + nofPassed + "  FAILED: " + nofFailed);
        return nofFailed;
    }

    private static void usage() {
        err.println();
        err.println("Usage: AnnotationTest <options> <classfiles>...");
        err.println();
        err.println("This class tests if classes have been correctly enhanced");
        err.println("for persistence-awareness (\"annotated\").");
        err.println();
        err.println("Options include:");
        err.println("    -h, --help               print usage");
        err.println("    -v, --verbose            enable verbose output");
        err.println("        --properties <file>  use property file for JDO meta data");
        err.println();
        err.println("Return value:");
        err.println("= 0   no errors");
        err.println("> 0   number of classes failing the test");
        err.println("< 0   severe errors preventing the test to complete");
        err.println();
    }

    public static void main(String[] argv) {
        boolean verbose = false;
        String jdoModelFileName = null;
        String jdoPropertiesFileName = null;
        ArrayList<String> classFilesNames = new ArrayList<String>();
        int i = 0;
        while (i < argv.length) {
            String arg = argv[i];
            if (arg.equals("-h") || arg.equals("--help")) {
                AnnotationTest.usage();
                System.exit(0);
            }
            if (arg.equals("-v") || arg.equals("--verbose")) {
                verbose = true;
            } else if (arg.equals("--properties")) {
                if (argv.length - i < 2) {
                    String msg = "Missing argument to the -p/--properties option";
                    err.println("Missing argument to the -p/--properties option");
                    AnnotationTest.usage();
                    System.exit(-1);
                }
                jdoPropertiesFileName = argv[++i];
            } else if (arg.equals("-d") || arg.equals("--debug")) {
                debug = true;
            } else {
                if (arg.startsWith("-")) {
                    err.println();
                    err.println("Unrecognized option: " + arg);
                    AnnotationTest.usage();
                    System.exit(-1);
                }
                classFilesNames.add(arg);
            }
            ++i;
        }
        if (classFilesNames.isEmpty()) {
            err.println();
            err.println("Missing classfiles argument");
            AnnotationTest.usage();
            System.exit(-1);
            return;
        }
        if (jdoModelFileName == null && jdoPropertiesFileName == null) {
            err.println();
            err.println("No meta-data source specified");
            AnnotationTest.usage();
            System.exit(-1);
            return;
        }
        if (jdoModelFileName != null && jdoPropertiesFileName != null) {
            err.println();
            err.println("More than one meta-data source specified");
            AnnotationTest.usage();
            System.exit(-1);
            return;
        }
        if (debug) {
            out.println("AnnotationTest: options:");
            out.println("    verbose = " + verbose);
            out.println("    jdoModelFileName = " + jdoModelFileName);
            out.println("    jdoPropertiesFileName = " + jdoPropertiesFileName);
            out.print("    classFilesNames =");
            int i2 = 0;
            while (i2 < classFilesNames.size()) {
                out.print(" " + classFilesNames.get(i2));
                ++i2;
            }
            out.println();
        }
        EnhancerMetaDataBaseModel jdoMetaData = null;
        if (jdoPropertiesFileName != null) {
            try {
                jdoMetaData = new EnhancerMetaDataPropertyImpl(out, verbose, jdoPropertiesFileName);
            }
            catch (EnhancerMetaDataFatalError ex) {
                err.println("Cannot read meta-data properties file;");
                err.println("Exception caught:" + ex);
                System.exit(-2);
            }
            if (verbose) {
                out.println("AnnotationTest: using meta-data from properties file: " + jdoPropertiesFileName);
            }
        } else if (jdoModelFileName != null) {
            try {
                AnnotationTest.affirm(false);
                jdoMetaData = new EnhancerMetaDataJDOModelImpl(out, verbose, null, null, null);
            }
            catch (EnhancerMetaDataFatalError ex) {
                err.println("Cannot read JDO XML meta-data file");
                err.println("Exception caught:" + ex);
                System.exit(-2);
            }
            if (verbose) {
                out.println("AnnotationTest: using meta-data from JDO model file: " + jdoModelFileName);
            }
        }
        AnnotationTest.affirm(jdoMetaData != null);
        try {
            AnnotationTest test = new AnnotationTest(jdoMetaData);
            int res = test.test(out, verbose, classFilesNames);
            System.exit(res);
        }
        catch (EnhancerMetaDataUserException ex) {
            err.println("Problem with reading JDO meta-data;");
            err.println("Exception caught:" + ex);
            ex.printStackTrace(err);
            System.exit(-2);
        }
        catch (EnhancerMetaDataFatalError ex) {
            err.println("Problem with reading JDO meta-data;");
            err.println("Exception caught:" + ex);
            ex.printStackTrace(err);
            System.exit(-2);
        }
        catch (RuntimeException ex) {
            err.println("Internal error;");
            err.println("Exception caught:" + ex);
            ex.printStackTrace(err);
            System.exit(-3);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

