/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.meta.util;

import com.sap.jdo.enhancer.meta.EnhancerMetaData;
import com.sap.jdo.enhancer.meta.EnhancerMetaDataFatalError;
import com.sap.jdo.enhancer.meta.EnhancerMetaDataUserException;
import com.sap.jdo.enhancer.util.Assertion;
import com.sap.jdo.enhancer.util.Support;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public abstract class EnhancerMetaDataBaseModel
extends Support
implements EnhancerMetaData {
    protected boolean verbose = true;
    protected final PrintWriter out;
    protected static final HashSet unenhancableTypePrefixes = new HashSet();

    public EnhancerMetaDataBaseModel(PrintWriter out, boolean verbose) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        Assertion.affirm(out != null);
        this.out = out;
    }

    public void printWarning(String msg) {
        this.out.println(Support.getI18N("enhancer.metadata.warning", msg));
    }

    public void printMessage(String msg) {
        if (this.verbose) {
            this.out.println(Support.getI18N("enhancer.metadata.message", msg));
        }
    }

    public boolean isKnownUnenhancableClass(String classPath) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        Iterator i = unenhancableTypePrefixes.iterator();
        while (i.hasNext()) {
            String typePrefix = (String)i.next();
            if (!classPath.startsWith(typePrefix)) continue;
            return true;
        }
        return false;
    }

    public boolean isPersistenceCapableRootClass(String classPath) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        return this.isPersistenceCapableClass(classPath) && this.getPersistenceCapableSuperClass(classPath) == null;
    }

    public String getPersistenceCapableRootClass(String classPath) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        String pcRootClass;
        if (!this.isPersistenceCapableClass(classPath)) {
            return null;
        }
        String clazz = classPath;
        do {
            pcRootClass = clazz;
        } while ((clazz = this.getPersistenceCapableSuperClass(clazz)) != null);
        return pcRootClass;
    }

    public String getSuperKeyClass(String classPath) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        String superClass = this.getPersistenceCapableSuperClass(classPath);
        while (superClass != null) {
            String superKeyClass = this.getKeyClass(superClass);
            if (superKeyClass != null) {
                return superKeyClass;
            }
            superClass = this.getPersistenceCapableSuperClass(superClass);
        }
        return null;
    }

    public boolean isManagedField(String classPath, String fieldName) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        return this.isPersistentField(classPath, fieldName) || this.isTransactionalField(classPath, fieldName);
    }

    public int getFieldFlags(String classPath, String fieldName) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        if (!this.isManagedField(classPath, fieldName)) {
            Assertion.affirm(!this.isTransactionalField(classPath, fieldName));
            Assertion.affirm(!this.isPersistentField(classPath, fieldName));
            Assertion.affirm(!this.isKeyField(classPath, fieldName));
            Assertion.affirm(!this.isDefaultFetchGroupField(classPath, fieldName));
            return 0;
        }
        if (this.isTransactionalField(classPath, fieldName)) {
            Assertion.affirm(!this.isPersistentField(classPath, fieldName));
            Assertion.affirm(!this.isKeyField(classPath, fieldName));
            return 4;
        }
        Assertion.affirm(this.isPersistentField(classPath, fieldName));
        if (this.isKeyField(classPath, fieldName)) {
            return 8;
        }
        if (this.isDefaultFetchGroupField(classPath, fieldName)) {
            return 5;
        }
        return 10;
    }

    public String[] getKeyFields(String classPath) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        ArrayList<String> keys = new ArrayList<String>();
        String[] fieldNames = this.getManagedFields(classPath);
        int n = fieldNames.length;
        int i = 0;
        while (i < n) {
            if (this.isKeyField(classPath, fieldNames[i])) {
                keys.add(fieldNames[i]);
            }
            ++i;
        }
        return keys.toArray(new String[keys.size()]);
    }

    public int[] getFieldFlags(String classPath, String[] fieldNames) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        int n = fieldNames != null ? fieldNames.length : 0;
        int[] flags = new int[n];
        int i = 0;
        while (i < n) {
            flags[i] = this.getFieldFlags(classPath, fieldNames[i]);
            ++i;
        }
        return flags;
    }

    public int[] getFieldNumber(String classPath, String[] fieldNames) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        int n = fieldNames != null ? fieldNames.length : 0;
        int[] flags = new int[n];
        int i = 0;
        while (i < n) {
            flags[i] = this.getFieldNumber(classPath, fieldNames[i]);
            ++i;
        }
        return flags;
    }

    public abstract int getFieldNumber(String var1, String var2) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError;

    public abstract boolean isDefaultFetchGroupField(String var1, String var2) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError;

    public abstract boolean isKeyField(String var1, String var2) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError;

    public abstract boolean isPersistentField(String var1, String var2) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError;

    public abstract boolean isTransactionalField(String var1, String var2) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError;

    public abstract boolean isKnownNonManagedField(String var1, String var2, String var3) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError;

    public abstract void passTypeInformation(String var1, String var2, String var3) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError;

    public abstract void declareField(String var1, String var2, String var3) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError;

    public abstract String[] getManagedFields(String var1) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError;

    public abstract String getKeyClass(String var1) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError;

    public abstract String getPersistenceCapableSuperClass(String var1) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError;

    public abstract boolean isPersistenceCapableClass(String var1) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError;

    static {
        unenhancableTypePrefixes.add("java/");
        unenhancableTypePrefixes.add("javax/");
    }
}

