/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.meta.prop;

import com.sap.jdo.enhancer.meta.EnhancerMetaDataUserException;
import com.sap.jdo.enhancer.meta.prop.JDOClass;
import com.sap.jdo.enhancer.meta.prop.JDOField;
import com.sap.jdo.enhancer.meta.prop.NameHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

final class MetaDataProperties {
    static final char FIELD_DELIMITER = '#';
    static final String PROPERTY_DELIMITERS = " \t,;";
    static final char PROPERTY_ASSIGNER = ':';
    static final String PROPERTY_ACCESS_MODIFIER = "access";
    static final String PROPERTY_JDO_MODIFIER = "jdo";
    static final String PROPERTY_SUPER_CLASSNAME = "super";
    static final String PROPERTY_OID_CLASSNAME = "oid";
    static final String PROPERTY_TYPE = "type";
    static final String PROPERTY_ANNOTATION_TYPE = "annotation";
    static final String ACCESS_PRIVATE = "private";
    static final String ACCESS_PACKAGE_LOCAL = "package";
    static final String ACCESS_PROTECTED = "protected";
    static final String ACCESS_PUBLIC = "public";
    static final String JDO_TRANSIENT = "transient";
    static final String JDO_PERSISTENT = "persistent";
    static final String JDO_TRANSACTIONAL = "transactional";
    static final String ANNOTATION_TYPE_KEY = "key";
    static final String ANNOTATION_TYPE_DFG = "dfg";
    static final String ANNOTATION_TYPE_MEDIATED = "mediated";
    private Properties properties;
    private final Map cachedJDOClasses = new HashMap();
    private static final JDOClass NULL = new JDOClass(null);
    private final List tmpTokens = new ArrayList();

    public MetaDataProperties(Properties props) {
        this.properties = props;
    }

    public final JDOClass getJDOClass(String classname) throws EnhancerMetaDataUserException {
        JDOClass clazz = (JDOClass)this.cachedJDOClasses.get(classname = NameHelper.toCanonicalClassName(classname));
        if (clazz == NULL) {
            return null;
        }
        if (clazz != null) {
            return clazz;
        }
        String s = this.properties.getProperty(classname);
        if (s == null) {
            this.cachedJDOClasses.put(classname, NULL);
            return null;
        }
        clazz = this.parseJDOClass(classname, s);
        this.parseJDOFields(clazz);
        this.validateDependencies(clazz);
        this.cachedJDOClasses.put(clazz.getName(), clazz);
        return clazz;
    }

    public final JDOField getJDOField(String fieldname, String classname) throws EnhancerMetaDataUserException {
        JDOClass clazz = this.getJDOClass(classname);
        return clazz != null ? clazz.getField(fieldname) : null;
    }

    public final String[] getKnownClassNames() {
        HashSet<String> classnames = new HashSet<String>();
        Enumeration<?> names = this.properties.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (name.indexOf(35) >= 0) continue;
            classnames.add(NameHelper.fromCanonicalClassName(name));
        }
        return classnames.toArray(new String[classnames.size()]);
    }

    private final JDOClass parseJDOClass(String classname, String attributes) throws EnhancerMetaDataUserException {
        List props = this.parseProperties(attributes);
        int i = 0;
        while (i < props.size()) {
            Property prop = (Property)props.get(i);
            MetaDataProperties.validateClassProperty(prop, classname);
            ++i;
        }
        MetaDataProperties.checkForDuplicateProperties(props, classname);
        JDOClass clazz = new JDOClass(classname);
        int i2 = 0;
        while (i2 < props.size()) {
            Property prop = (Property)props.get(i2);
            if (prop.name.equals(PROPERTY_ACCESS_MODIFIER)) {
                clazz.setModifiers(MetaDataProperties.getModifiers(prop.value));
            } else if (prop.name.equals(PROPERTY_JDO_MODIFIER)) {
                clazz.setPersistent(prop.value.equals(JDO_PERSISTENT));
            } else if (prop.name.equals(PROPERTY_SUPER_CLASSNAME)) {
                clazz.setSuperClassName(prop.value);
            } else if (prop.name.equals(PROPERTY_OID_CLASSNAME)) {
                clazz.setOidClassName(prop.value);
            }
            ++i2;
        }
        return clazz;
    }

    private static void validateClassProperty(Property prop, String classname) throws EnhancerMetaDataUserException {
        String value = prop.value;
        if (prop.name == null) {
            if (value.equals(ACCESS_PUBLIC) || value.equals(ACCESS_PROTECTED) || value.equals(ACCESS_PACKAGE_LOCAL) || value.equals(ACCESS_PRIVATE)) {
                prop.name = PROPERTY_ACCESS_MODIFIER;
            } else if (value.equals(JDO_PERSISTENT) || value.equals(JDO_TRANSIENT)) {
                prop.name = PROPERTY_JDO_MODIFIER;
            }
        } else {
            String name = prop.name;
            MetaDataProperties.checkPropertyName(prop.name, new String[]{PROPERTY_ACCESS_MODIFIER, PROPERTY_JDO_MODIFIER, PROPERTY_SUPER_CLASSNAME, PROPERTY_OID_CLASSNAME}, classname);
            MetaDataProperties.checkPropertyValue(prop, new String[]{ACCESS_PUBLIC, ACCESS_PROTECTED, ACCESS_PACKAGE_LOCAL, ACCESS_PRIVATE}, PROPERTY_ACCESS_MODIFIER, classname);
            MetaDataProperties.checkPropertyValue(prop, new String[]{JDO_TRANSIENT, JDO_PERSISTENT}, PROPERTY_JDO_MODIFIER, classname);
        }
    }

    private final void parseJDOFields(JDOClass clazz) throws EnhancerMetaDataUserException {
        Enumeration<?> names = this.properties.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith(clazz.getName() + '#')) continue;
            String fieldname = name.substring(name.indexOf(35) + 1, name.length());
            MetaDataProperties.validateFieldName(fieldname, clazz.getName());
            clazz.addField(this.parseJDOField(this.properties.getProperty(name), fieldname, clazz));
        }
        clazz.sortFields();
    }

    private final JDOField parseJDOField(String attributes, String fieldname, JDOClass clazz) throws EnhancerMetaDataUserException {
        List props = this.parseProperties(attributes);
        int i = 0;
        while (i < props.size()) {
            Property prop = (Property)props.get(i);
            this.validateFieldProperty(prop, fieldname, clazz.getName());
            ++i;
        }
        MetaDataProperties.checkForDuplicateProperties(props, clazz.getName() + '#' + fieldname);
        JDOField field = new JDOField(fieldname);
        int i2 = 0;
        while (i2 < props.size()) {
            Property prop = (Property)props.get(i2);
            if (prop.name.equals(PROPERTY_ACCESS_MODIFIER)) {
                field.setModifiers(MetaDataProperties.getModifiers(prop.value));
            } else if (prop.name.equals(PROPERTY_JDO_MODIFIER)) {
                field.setJdoModifier(prop.value);
            } else if (prop.name.equals(PROPERTY_TYPE)) {
                field.setType(prop.value);
            } else if (prop.name.equals(PROPERTY_ANNOTATION_TYPE)) {
                field.setAnnotationType(prop.value);
            }
            ++i2;
        }
        return field;
    }

    private final void validateFieldProperty(Property prop, String fieldname, String classname) throws EnhancerMetaDataUserException {
        String value = prop.value;
        if (prop.name == null) {
            prop.name = value.equals(ACCESS_PUBLIC) || value.equals(ACCESS_PROTECTED) || value.equals(ACCESS_PACKAGE_LOCAL) || value.equals(ACCESS_PRIVATE) ? PROPERTY_ACCESS_MODIFIER : (value.equals(JDO_PERSISTENT) || value.equals(JDO_TRANSIENT) || value.equals(JDO_TRANSACTIONAL) ? PROPERTY_JDO_MODIFIER : (value.equals(ANNOTATION_TYPE_KEY) || value.equals(ANNOTATION_TYPE_DFG) || value.equals(ANNOTATION_TYPE_MEDIATED) ? PROPERTY_ANNOTATION_TYPE : PROPERTY_TYPE));
        } else {
            String entry = classname + '#' + fieldname;
            MetaDataProperties.checkPropertyName(prop.name, new String[]{PROPERTY_ACCESS_MODIFIER, PROPERTY_JDO_MODIFIER, PROPERTY_TYPE, PROPERTY_ANNOTATION_TYPE}, entry);
            MetaDataProperties.checkPropertyValue(prop, new String[]{ACCESS_PUBLIC, ACCESS_PROTECTED, ACCESS_PACKAGE_LOCAL, ACCESS_PRIVATE}, PROPERTY_ACCESS_MODIFIER, entry);
            MetaDataProperties.checkPropertyValue(prop, new String[]{JDO_PERSISTENT, JDO_TRANSIENT, JDO_TRANSACTIONAL}, PROPERTY_JDO_MODIFIER, entry);
            MetaDataProperties.checkPropertyValue(prop, new String[]{ANNOTATION_TYPE_KEY, ANNOTATION_TYPE_DFG, ANNOTATION_TYPE_MEDIATED}, PROPERTY_ANNOTATION_TYPE, entry);
        }
    }

    private final void validateDependencies(JDOClass clazz) throws EnhancerMetaDataUserException {
        List fields = clazz.getFields();
        Iterator i = fields.iterator();
        while (i.hasNext()) {
            JDOField field = (JDOField)i.next();
            if (field.isPersistent() && clazz.isTransient()) {
                String msg = MetaDataProperties.getMsg("Error Parsing meta data properties: A non-persistent class cannot have a persistent field(class ''{0}'' with field ''{1})''.", new String[]{clazz.getName(), field.getName()});
                throw new EnhancerMetaDataUserException(msg);
            }
            if (field.isTransactional() && clazz.isTransient()) {
                String msg = MetaDataProperties.getMsg("Error Parsing meta data properties: A non-persistent class cannot have a transactional field(class ''{0}'' with field ''{1})''.", new String[]{clazz.getName(), field.getName()});
                throw new EnhancerMetaDataUserException(msg);
            }
            if (!field.isKnownTransient() && !field.isManaged()) {
                String msg = MetaDataProperties.getMsg("Error Parsing meta data properties: No persistence modifier specified for field: ''{0}.{1}''.", new String[]{clazz.getName(), field.getName()});
                throw new EnhancerMetaDataUserException(msg);
            }
            if (!field.isAnnotated() && field.isManaged()) {
                String msg = MetaDataProperties.getMsg("Error Parsing meta data properties: No annotation type specified for field: ''{0}.{1}''.", new String[]{clazz.getName(), field.getName()});
                throw new EnhancerMetaDataUserException(msg);
            }
            if (field.isAnnotated() && !field.isManaged()) {
                String msg = MetaDataProperties.getMsg("Error Parsing meta data properties: A non-managed field(''{1}'' of class ''{0}'') can''t be a annotated.", new String[]{clazz.getName(), field.getName()});
                throw new EnhancerMetaDataUserException(msg);
            }
            if (!field.isAnnotated() || !clazz.isTransient()) continue;
            String msg = MetaDataProperties.getMsg("Error Parsing meta data properties: A non-persistent class cannot have an annotated field(''{1}'' of class ''{0}'') can''t have a fetch group.", new String[]{clazz.getName(), field.getName()});
            throw new EnhancerMetaDataUserException(msg);
        }
    }

    private static void validateFieldName(String fieldname, String classname) throws EnhancerMetaDataUserException {
        if (fieldname.length() == 0) {
            String msg = MetaDataProperties.getMsg("Error Parsing meta data properties: The class ''{0}'' may not have an empty fieldname.", new String[]{classname});
            throw new EnhancerMetaDataUserException(msg);
        }
        if (!Character.isJavaIdentifierStart(fieldname.charAt(0))) {
            String msg = MetaDataProperties.getMsg("Error Parsing meta data properties: The field name ''{1}'' of class ''{0}'' is not valid.", new String[]{classname, fieldname});
            throw new EnhancerMetaDataUserException(msg);
        }
        int i = fieldname.length() - 1;
        while (i >= 0) {
            char c = fieldname.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) {
                String msg = MetaDataProperties.getMsg("Error Parsing meta data properties: The field name ''{1}'' of class ''{0}'' is not valid.", new String[]{classname, fieldname});
                throw new EnhancerMetaDataUserException(msg);
            }
            --i;
        }
    }

    private static void checkForDuplicateProperties(List props, String entry) throws EnhancerMetaDataUserException {
        int i = 0;
        while (i < props.size()) {
            int j = i + 1;
            while (j < props.size()) {
                Property p1 = (Property)props.get(i);
                Property p2 = (Property)props.get(j);
                if (p1.name.equals(p2.name) && !p1.value.equals(p2.value)) {
                    String msg = MetaDataProperties.getMsg("Error Parsing meta data properties: The property ''{1}'' for the entry ''{0}'' entered twice with values: ''{2}'' and ''{3}''.", new String[]{entry, p1.name, p1.value, p2.value});
                    throw new EnhancerMetaDataUserException(msg);
                }
                ++j;
            }
            ++i;
        }
    }

    private static void checkPropertyName(String name, String[] validnames, String entry) throws EnhancerMetaDataUserException {
        int i = 0;
        while (i < validnames.length) {
            if (name.equals(validnames[i])) {
                return;
            }
            ++i;
        }
        String msg = MetaDataProperties.getMsg("Error Parsing meta data properties: Invalid property name for entry ''{0}'': ''{1}''.", new String[]{entry, name});
        throw new EnhancerMetaDataUserException(msg);
    }

    private static void checkPropertyValue(Property prop, String[] validvalues, String name, String entry) throws EnhancerMetaDataUserException {
        if (!prop.name.equals(name)) {
            return;
        }
        int i = 0;
        while (i < validvalues.length) {
            if (prop.value.equals(validvalues[i])) {
                return;
            }
            ++i;
        }
        String msg = MetaDataProperties.getMsg("Error Parsing meta data properties: Invalid value for property ''{1}'' of entry ''{0}'': ''{2}''.", new String[]{entry, name, prop.value});
        throw new EnhancerMetaDataUserException(msg);
    }

    static final String getMsg(String msg, String[] params) {
        return MessageFormat.format(msg, params);
    }

    final List parseProperties(String attributes) throws EnhancerMetaDataUserException {
        this.tmpTokens.clear();
        StringTokenizer t = new StringTokenizer(attributes, PROPERTY_DELIMITERS);
        while (t.hasMoreTokens()) {
            this.tmpTokens.add(this.parseProperty(t.nextToken()));
        }
        return this.tmpTokens;
    }

    private final Property parseProperty(String attribute) throws EnhancerMetaDataUserException {
        Property prop = new Property();
        int idx = attribute.indexOf(58);
        if (idx < 0) {
            prop.value = attribute;
        } else {
            prop.name = attribute.substring(0, idx);
            prop.value = attribute.substring(idx + 1, attribute.length());
            if (prop.name.length() == 0 || prop.value.length() == 0) {
                String msg = MetaDataProperties.getMsg("Error Parsing meta data properties: The property name and value may not be empty if a '':'' is specified: ''{0}''.", new String[]{attribute});
                throw new EnhancerMetaDataUserException(msg);
            }
        }
        return prop;
    }

    private static int getModifiers(String modifier) {
        if (modifier.equals(ACCESS_PUBLIC)) {
            return 1;
        }
        if (modifier.equals(ACCESS_PRIVATE)) {
            return 2;
        }
        if (modifier.equals(ACCESS_PROTECTED)) {
            return 4;
        }
        return 0;
    }

    public static void main(String[] argv) throws IOException {
        if (argv.length != 1) {
            System.err.println("Error: no property filename specified");
            return;
        }
        Properties p = new Properties();
        FileInputStream in = new FileInputStream(new File(argv[0]));
        p.load(in);
        ((InputStream)in).close();
        System.out.println("PROPERTIES: " + p);
        System.out.println("############");
        MetaDataProperties props = new MetaDataProperties(p);
        String[] classnames = props.getKnownClassNames();
        int i = 0;
        while (i < classnames.length) {
            String classname = classnames[i];
            System.out.println(classname + ": " + props.getJDOClass(classname));
            ++i;
        }
    }

    private static interface Msg {
        public static final String PREFIX = "Error Parsing meta data properties: ";
        public static final String ERR_EMPTY_FIELDNAME = "Error Parsing meta data properties: The class ''{0}'' may not have an empty fieldname.";
        public static final String ERR_INVALID_FIELDNAME = "Error Parsing meta data properties: The field name ''{1}'' of class ''{0}'' is not valid.";
        public static final String ERR_EMPTY_PROPERTY_NAME_OR_VALUE = "Error Parsing meta data properties: The property name and value may not be empty if a '':'' is specified: ''{0}''.";
        public static final String ERR_INVALID_PROPERTY_NAME = "Error Parsing meta data properties: Invalid property name for entry ''{0}'': ''{1}''.";
        public static final String ERR_INVALID_PROPERTY_VALUE = "Error Parsing meta data properties: Invalid value for property ''{1}'' of entry ''{0}'': ''{2}''.";
        public static final String ERR_DUPLICATE_PROPERTY_NAME = "Error Parsing meta data properties: The property ''{1}'' for the entry ''{0}'' entered twice with values: ''{2}'' and ''{3}''.";
        public static final String ERR_UNSPECIFIED_FIELD_PERSISTENCE_MODIFIER = "Error Parsing meta data properties: No persistence modifier specified for field: ''{0}.{1}''.";
        public static final String ERR_TRANSIENT_CLASS_WITH_PERSISTENT_FIELD = "Error Parsing meta data properties: A non-persistent class cannot have a persistent field(class ''{0}'' with field ''{1})''.";
        public static final String ERR_TRANSIENT_CLASS_WITH_TRANSACTIONAL_FIELD = "Error Parsing meta data properties: A non-persistent class cannot have a transactional field(class ''{0}'' with field ''{1})''.";
        public static final String ERR_UNSPECIFIED_FIELD_ANNOTATION_TYPE = "Error Parsing meta data properties: No annotation type specified for field: ''{0}.{1}''.";
        public static final String ERR_TRANSIENT_CLASS_WITH_ANNOTATED_FIELD = "Error Parsing meta data properties: A non-persistent class cannot have an annotated field(''{1}'' of class ''{0}'') can''t have a fetch group.";
        public static final String ERR_NON_MANAGED_ANNOTATED_FIELD = "Error Parsing meta data properties: A non-managed field(''{1}'' of class ''{0}'') can''t be a annotated.";
    }

    private static final class Property {
        String name = null;
        String value = null;

        private Property() {
        }

        public final String toString() {
            return '<' + this.name + ':' + this.value + '>';
        }
    }
}

