/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.meta.prop;

import com.sap.jdo.enhancer.meta.prop.NameHelper;
import java.lang.reflect.Modifier;

final class JDOField {
    private final String name;
    private String type = null;
    private int modifiers = 2;
    private String jdoModifier = null;
    private String annotationType = null;

    JDOField(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setType(String type) {
        this.type = NameHelper.fromCanonicalClassName(type);
    }

    public String getType() {
        return this.type;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setAnnotationType(String annotationType) {
        this.annotationType = annotationType;
    }

    public boolean isAnnotated() {
        return this.annotationType != null;
    }

    public boolean isKey() {
        return this.annotationType != null && this.annotationType.equals("key");
    }

    public boolean isInDefaultFetchGroup() {
        return this.annotationType != null && this.annotationType.equals("dfg");
    }

    public void setJdoModifier(String jdoModifier) {
        this.jdoModifier = jdoModifier;
    }

    public boolean isKnownTransient() {
        return this.jdoModifier != null && this.jdoModifier.equals("transient");
    }

    public boolean isPersistent() {
        return this.jdoModifier != null && this.jdoModifier.equals("persistent");
    }

    public boolean isTransactional() {
        return this.jdoModifier != null && this.jdoModifier.equals("transactional");
    }

    public boolean isManaged() {
        return this.isPersistent() || this.isTransactional();
    }

    public String toString() {
        return "<name:" + this.name + ',' + "type" + ':' + this.type + ',' + "access" + ':' + Modifier.toString(this.modifiers) + ',' + "jdo" + ':' + this.jdoModifier + ',' + "annotation" + ':' + this.annotationType + '>';
    }
}

