/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.meta.prop;

import com.sap.jdo.enhancer.meta.EnhancerMetaDataFatalError;
import com.sap.jdo.enhancer.meta.EnhancerMetaDataUserException;
import com.sap.jdo.enhancer.meta.ExtendedMetaData;
import com.sap.jdo.enhancer.meta.prop.JDOClass;
import com.sap.jdo.enhancer.meta.prop.JDOField;
import com.sap.jdo.enhancer.meta.prop.MetaDataProperties;
import com.sap.jdo.enhancer.meta.util.EnhancerMetaDataBaseModel;
import com.sap.jdo.enhancer.util.Assertion;
import com.sap.jdo.enhancer.util.Support;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Properties;

public class EnhancerMetaDataPropertyImpl
extends EnhancerMetaDataBaseModel
implements ExtendedMetaData {
    private final MetaDataProperties model;

    public EnhancerMetaDataPropertyImpl(PrintWriter out, boolean verbose, Properties properties) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        super(out, verbose);
        Assertion.affirm(properties != null);
        this.model = new MetaDataProperties(properties);
        this.initModel();
        Assertion.affirm(this.model != null);
        this.printMessage(Support.getI18N("enhancer.metadata.using_properties", "<unnamed>"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EnhancerMetaDataPropertyImpl(PrintWriter out, boolean verbose, String fileName) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        block7: {
            super(out, verbose);
            Assertion.affirm(fileName != null);
            FileInputStream stream = null;
            try {
                try {
                    stream = new FileInputStream(fileName);
                    Properties properties = new Properties();
                    properties.load(stream);
                    this.model = new MetaDataProperties(properties);
                    this.initModel();
                }
                catch (IOException ex) {
                    String msg = Support.getI18N("enhancer.metadata.io_error", ex.getMessage());
                    throw new EnhancerMetaDataFatalError(msg, ex);
                }
                Object var8_7 = null;
                if (stream == null) break block7;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (stream == null) throw throwable;
                try {
                    ((InputStream)stream).close();
                    throw throwable;
                }
                catch (IOException ex) {
                    String msg = Support.getI18N("enhancer.metadata.io_error", ex.getMessage());
                    throw new EnhancerMetaDataFatalError(msg, ex);
                }
            }
            try {}
            catch (IOException ex) {
                String msg = Support.getI18N("enhancer.metadata.io_error", ex.getMessage());
                throw new EnhancerMetaDataFatalError(msg, ex);
            }
            ((InputStream)stream).close();
        }
        Assertion.affirm(this.model != null);
        this.printMessage(Support.getI18N("enhancer.metadata.using_properties", fileName));
    }

    private void initModel() {
        String[] classNames = this.model.getKnownClassNames();
        Assertion.affirm(classNames != null);
        int i = classNames.length - 1;
        while (i >= 0) {
            JDOClass clazz = this.getJDOClass(classNames[i]);
            Assertion.affirm(clazz != null);
            --i;
        }
    }

    public void declareField(String classPath, String fieldName, String signature) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        Assertion.affirm(this.isPersistenceCapableClass(classPath));
    }

    public void passTypeInformation(String classPath, String fieldName, String signature) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        Assertion.affirm(this.isPersistenceCapableClass(classPath));
    }

    public boolean isPersistenceCapableClass(String classPath) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        JDOClass clazz = this.getJDOClass(classPath);
        return clazz != null ? clazz.isPersistent() : false;
    }

    public String getPersistenceCapableSuperClass(String classPath) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        String clazz = this.getSuperClass(classPath);
        while (clazz != null) {
            if (this.isPersistenceCapableClass(clazz)) {
                return clazz;
            }
            clazz = this.getSuperClass(clazz);
        }
        return null;
    }

    public final String getSuperClass(String classname) {
        JDOClass clazz = this.getJDOClass(classname);
        return clazz != null ? clazz.getSuperClassName() : null;
    }

    public String getKeyClass(String classPath) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        JDOClass clazz = this.getJDOClass(classPath);
        return clazz != null ? clazz.getOidClassName() : null;
    }

    public boolean isKnownNonManagedField(String classPath, String fieldName, String fieldSig) {
        JDOClass clazz = this.getJDOClass(classPath);
        if (clazz == null) {
            return true;
        }
        JDOField field = this.getJDOField(clazz, fieldName);
        return field != null ? field.isKnownTransient() : false;
    }

    public boolean isManagedField(String classPath, String fieldName) {
        JDOField field = this.getJDOField(classPath, fieldName);
        return field != null ? field.isPersistent() | field.isTransactional() : false;
    }

    public boolean isPersistentField(String classPath, String fieldName) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        JDOField field = this.getJDOField(classPath, fieldName);
        return field != null ? field.isPersistent() : false;
    }

    public boolean isTransactionalField(String classPath, String fieldName) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        JDOField field = this.getJDOField(classPath, fieldName);
        return field != null ? field.isTransactional() : false;
    }

    public boolean isKeyField(String classPath, String fieldName) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        JDOField field = this.getJDOField(classPath, fieldName);
        return field != null ? field.isKey() : false;
    }

    public boolean isDefaultFetchGroupField(String classPath, String fieldName) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        JDOField field = this.getJDOField(classPath, fieldName);
        return field != null ? field.isInDefaultFetchGroup() : false;
    }

    public int getFieldNumber(String classPath, String fieldName) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        JDOClass clazz = this.getJDOClass(classPath);
        return clazz != null ? clazz.getIndexOfField(fieldName) : -1;
    }

    public String[] getManagedFields(String classname) {
        JDOClass clazz = this.getJDOClass(classname);
        return clazz != null ? clazz.getManagedFieldNames() : new String[]{};
    }

    public final String[] getKnownClasses() {
        return this.model.getKnownClassNames();
    }

    public final String[] getKnownFields(String classname) {
        JDOClass clazz = this.getJDOClass(classname);
        return clazz != null ? clazz.getFieldNames() : new String[]{};
    }

    public final int getClassModifiers(String classname) {
        JDOClass clazz = this.getJDOClass(classname);
        return clazz != null ? clazz.getModifiers() : 0;
    }

    public final int getFieldModifiers(String classname, String fieldname) {
        JDOField field = this.getJDOField(classname, fieldname);
        return field != null ? field.getModifiers() : 0;
    }

    public final String getFieldType(String classname, String fieldname) {
        JDOField field = this.getJDOField(classname, fieldname);
        return field != null ? field.getType() : null;
    }

    public final String[] getFieldType(String classname, String[] fieldnames) {
        int n = fieldnames != null ? fieldnames.length : 0;
        String[] types = new String[n];
        int i = 0;
        while (i < n) {
            types[i] = this.getFieldType(classname, fieldnames[i]);
            ++i;
        }
        return types;
    }

    public final int[] getFieldModifiers(String classname, String[] fieldnames) throws EnhancerMetaDataUserException, EnhancerMetaDataFatalError {
        int n = fieldnames != null ? fieldnames.length : 0;
        int[] mods = new int[n];
        int i = 0;
        while (i < n) {
            mods[i] = this.getFieldModifiers(classname, fieldnames[i]);
            ++i;
        }
        return mods;
    }

    private final JDOClass getJDOClass(String classname) throws EnhancerMetaDataUserException {
        return this.model.getJDOClass(classname);
    }

    private final JDOField getJDOField(JDOClass clazz, String fieldname) {
        return clazz != null ? clazz.getField(fieldname) : null;
    }

    private final JDOField getJDOField(String classname, String fieldname) {
        JDOClass clazz = this.getJDOClass(classname);
        return this.getJDOField(clazz, fieldname);
    }

    public static void main(String[] argv) throws IOException {
        PrintWriter out = new PrintWriter(System.out, true);
        if (argv.length != 1) {
            System.err.println("No property file specified.");
            return;
        }
        Properties p = new Properties();
        FileInputStream in = new FileInputStream(new File(argv[0]));
        p.load(in);
        ((InputStream)in).close();
        out.println("PROPERTIES: " + p);
        out.println("############");
        MetaDataProperties props = new MetaDataProperties(p);
        EnhancerMetaDataPropertyImpl jdo = new EnhancerMetaDataPropertyImpl(out, true, p);
        String[] classes = jdo.getKnownClasses();
        int k = 0;
        while (k < classes.length) {
            String clazz = classes[k];
            out.println("CLAZZ: " + clazz);
            out.println("\tpersistent: " + jdo.isPersistenceCapableClass(clazz));
            out.println("\tpersistent root: " + jdo.isPersistenceCapableRootClass(clazz));
            out.println("\tpersistent root class: " + jdo.getPersistenceCapableRootClass(clazz));
            out.println("\tpersistent super class: " + jdo.getPersistenceCapableSuperClass(clazz));
            out.println("\tkey class: " + jdo.getKeyClass(clazz));
            String[] fields = jdo.getKnownFields(clazz);
            int j = 0;
            while (j < fields.length) {
                String field = fields[j];
                out.println("FIELD: " + field);
                out.println("\tpersistent field: " + jdo.isPersistentField(clazz, field));
                out.println("\tpk field: " + jdo.isKeyField(clazz, field));
                out.println("\tdfg field: " + jdo.isDefaultFetchGroupField(clazz, field));
                out.println("\tnumber: " + jdo.getFieldNumber(clazz, field));
                String[] names = jdo.getManagedFields(clazz);
                int n = fields != null ? names.length : 0;
                out.println("managed fields: number: " + n);
                int i = 0;
                while (i < n) {
                    String name = names[i];
                    out.println(i + ": " + name + " number: " + jdo.getFieldNumber(clazz, name) + " pk: " + jdo.isKeyField(clazz, name) + " dfg: " + jdo.isDefaultFetchGroupField(clazz, name));
                    ++i;
                }
                ++j;
            }
            ++k;
        }
    }
}

