/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.meta.model;

import com.sap.jdo.enhancer.meta.EnhancerMetaDataUserException;
import com.sap.jdo.enhancer.util.Assertion;
import com.sap.jdo.enhancer.util.ResourceLocator;
import com.sap.jdo.enhancer.util.Support;
import com.sap.jdo.model.jdo.JavaModel;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class EnhancerJavaModel
extends Support
implements JavaModel {
    private final PrintWriter out;
    private final boolean verbose;
    private final ResourceLocator locator;
    static final Map primitiveTypes = new HashMap();

    public EnhancerJavaModel(PrintWriter out, boolean verbose, ResourceLocator locator) {
        Assertion.affirm(out != null);
        this.out = out;
        this.verbose = verbose;
        this.locator = locator;
    }

    public InputStream getInputStreamForResource(String resourceName) {
        return this.locator.getInputStreamForResource(resourceName);
    }

    public boolean isInterface(Object type) {
        String msg = "EnhancerJavaModel.isInterface(Object): illegal to call this method at enhancement time";
        throw new EnhancerMetaDataUserException("EnhancerJavaModel.isInterface(Object): illegal to call this method at enhancement time");
    }

    public boolean isArray(Object type) {
        Assertion.affirm(type instanceof String, "illegal type argument = " + type);
        return ((String)type).charAt(0) == '[';
    }

    public Object getArrayComponentType(Object type) {
        Assertion.affirm(type instanceof String, "illegal type argument = " + type);
        String s = (String)type;
        if (s.charAt(0) != '[') {
            return null;
        }
        return s.substring(s.lastIndexOf(91) + 1);
    }

    private static boolean isValidResourceName(String name) {
        return EnhancerJavaModel.isValidName(name, '/');
    }

    private static boolean isValidTypeName(String name) {
        return EnhancerJavaModel.isValidName(name, '.');
    }

    private static boolean isValidName(String name, char separator) {
        int n = name.length();
        if (n == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < n) {
            char c = name.charAt(i);
            if (!Character.isJavaIdentifierPart(c) && c != separator) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getTypeName(Object type) {
        String name2;
        Assertion.affirm(type instanceof String, "illegal type argument = " + type);
        String sig = (String)type;
        int n = sig.length();
        Assertion.affirm(n > 0, "invalid field signature: \"\"");
        int i = 0;
        StringBuffer s = new StringBuffer();
        while (i < n && sig.charAt(i) == '[') {
            s.append("[]");
            ++i;
        }
        Assertion.affirm(i < n, "invalid field signature: " + sig);
        char c = sig.charAt(i);
        switch (c) {
            case 'Z': {
                name2 = "boolean";
                break;
            }
            case 'C': {
                name2 = "char";
                break;
            }
            case 'B': {
                name2 = "byte";
                break;
            }
            case 'S': {
                name2 = "short";
                break;
            }
            case 'I': {
                name2 = "int";
                break;
            }
            case 'F': {
                name2 = "float";
                break;
            }
            case 'J': {
                name2 = "long";
                break;
            }
            case 'D': {
                name2 = "double";
                break;
            }
            case 'L': {
                Assertion.affirm(sig.indexOf(59) == n - 1, "invalid field signature: " + sig);
                String name2 = sig.substring(i + 1, n - 1);
                Assertion.affirm(EnhancerJavaModel.isValidResourceName(name2), "invalid field signature: " + sig);
                return name2.replace('/', '.') + s;
            }
            default: {
                name2 = "";
                Assertion.affirm(false, "invalid field signature: " + sig);
            }
        }
        Assertion.affirm(i == n - 1, "invalid field signature: " + sig);
        return name2 + s;
    }

    public Object getTypeForName(String name) {
        Assertion.affirm(name != null);
        int n = name.length();
        Assertion.affirm(n > 0, "invalid field type: \"\"");
        int i = n - 1;
        StringBuffer s = new StringBuffer();
        while (i > 0 && name.charAt(i) == ']') {
            s.append('[');
            Assertion.affirm(--i >= 0 && name.charAt(i) == '[', "invalid field type: " + name);
            --i;
        }
        String body = s.length() > 0 ? name.substring(0, i + 1) : name;
        Assertion.affirm(EnhancerJavaModel.isValidTypeName(body), "invalid field type: " + name);
        Object type = primitiveTypes.get(body);
        if (type != null) {
            Assertion.affirm(!name.equals("void"), "invalid field type: " + name);
            return s.toString() + type;
        }
        return s.toString() + 'L' + body.replace('.', '/') + ";";
    }

    static {
        primitiveTypes.put("boolean", "Z");
        primitiveTypes.put("char", "C");
        primitiveTypes.put("byte", "B");
        primitiveTypes.put("short", "S");
        primitiveTypes.put("int", "I");
        primitiveTypes.put("long", "J");
        primitiveTypes.put("float", "F");
        primitiveTypes.put("double", "D");
        primitiveTypes.put("void", "V");
    }
}

