/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.generator;

import com.sap.jdo.enhancer.generator.NameHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

final class ImplHelper
extends NameHelper {
    static final String[] COMMENT_ENHANCER_ADDED = null;
    static final String[] COMMENT_NOT_ENHANCER_ADDED = null;
    static final String CLASSNAME_JDO_PERSISTENCE_CAPABLE = "javax.jdo.spi.PersistenceCapable";
    static final String CLASSNAME_JDO_PERSISTENCE_MANAGER = "javax.jdo.PersistenceManager";
    static final String CLASSNAME_JDO_IMPL_HELPER = "javax.jdo.spi.JDOImplHelper";
    static final String CLASSNAME_JDO_STATE_MANAGER = "javax.jdo.spi.StateManager";
    static final String CLASSNAME_JDO_PERMISSION = "javax.jdo.spi.JDOPermission";
    static final String CLASSNAME_JDO_USER_EXCEPTION = "javax.jdo.JDOUserException";
    static final String CLASSNAME_JDO_OBJECT_ID_FIELD_SUPPLIER = "javax.jdo.spi.PersistenceCapable.ObjectIdFieldSupplier";
    static final String CLASSNAME_JDO_OBJECT_ID_FIELD_CONSUMER = "javax.jdo.spi.PersistenceCapable.ObjectIdFieldConsumer";
    static final String FIELDNAME_JDO_FLAGS = "jdoFlags";
    static final String FIELDNAME_JDO_STATE_MANAGER = "jdoStateManager";
    static final String FIELDNAME_JDO_INHERITED_FIELD_COUNT = "jdoInheritedFieldCount";
    static final String FIELDNAME_JDO_FIELD_NAMES = "jdoFieldNames";
    static final String FIELDNAME_JDO_FIELD_TYPES = "jdoFieldTypes";
    static final String FIELDNAME_JDO_FIELD_FLAGS = "jdoFieldFlags";
    static final String FIELDNAME_JDO_PC_SUPERCLASS = "jdoPersistenceCapableSuperclass";
    static final String FIELDNAME_SERIAL_VERSION_UID = "serialVersionUID";
    static final String METHODNAME_WRITE_OBJECT = "writeObject";
    static final String METHODNAME_JDO_GET_MANAGED_FIELD_COUNT = "jdoGetManagedFieldCount";
    static final String METHODNAME_JDO_NEW_INSTANCE = "jdoNewInstance";
    static final String METHODNAME_JDO_NEW_OID_INSTANCE = "jdoNewObjectIdInstance";
    static final String METHODNAME_JDO_REPLACE_STATE_MANAGER = "jdoReplaceStateManager";
    static final String METHODNAME_JDO_REPLACE_FLAGS = "jdoReplaceFlags";
    static final String METHODNAME_JDO_REPLACE_FIELD = "jdoReplaceField";
    static final String METHODNAME_JDO_REPLACE_FIELDS = "jdoReplaceFields";
    static final String METHODNAME_JDO_PROVIDE_FIELD = "jdoProvideField";
    static final String METHODNAME_JDO_PROVIDE_FIELDS = "jdoProvideFields";
    static final String METHODNAME_JDO_COPY_FIELDS = "jdoCopyFields";
    static final String METHODNAME_JDO_COPY_FIELD = "jdoCopyField";
    static final String METHODNAME_JDO_PRE_SERIALIZE = "jdoPreSerialize";
    static final String METHODNAME_JDO_GET_PERSISTENCE_MANAGER = "jdoGetPersistenceManager";
    static final String METHODNAME_JDO_MAKE_DIRTY = "jdoMakeDirty";
    static final String METHODNAME_JDO_GET_OBJECT_ID = "jdoGetObjectId";
    static final String METHODNAME_JDO_GET_TRANSACTIONAL_OBJECT_ID = "jdoGetTransactionalObjectId";
    static final String METHODNAME_JDO_IS_PERSISTENT = "jdoIsPersistent";
    static final String METHODNAME_JDO_IS_TRANSACTIONAL = "jdoIsTransactional";
    static final String METHODNAME_JDO_IS_NEW = "jdoIsNew";
    static final String METHODNAME_JDO_IS_DIRTY = "jdoIsDirty";
    static final String METHODNAME_JDO_IS_DELETED = "jdoIsDeleted";
    static final String METHODNAME_JDO_COPY_KEY_FIELDS_TO_OID = "jdoCopyKeyFieldsToObjectId";
    static final String METHODNAME_JDO_COPY_KEY_FIELDS_FROM_OID = "jdoCopyKeyFieldsFromObjectId";
    private static final HashMap typeNameConversion = new HashMap();
    static /* synthetic */ Class class$java$lang$SecurityManager;

    ImplHelper() {
    }

    private static String getConvertedTypeName(String fieldtype) {
        String name = (String)typeNameConversion.get(fieldtype);
        return name != null ? name : "Object";
    }

    private static String getMethodNameGetField(String fieldtype) {
        return "get" + ImplHelper.getConvertedTypeName(fieldtype) + "Field";
    }

    private static String getMethodNameSetField(String fieldtype) {
        return "set" + ImplHelper.getConvertedTypeName(fieldtype) + "Field";
    }

    private static String getMethodNameReplacingField(String fieldtype) {
        return "replacing" + ImplHelper.getConvertedTypeName(fieldtype) + "Field";
    }

    private static String getMethodNameProvidedField(String fieldtype) {
        return "provided" + ImplHelper.getConvertedTypeName(fieldtype) + "Field";
    }

    private static String getMethodNameFetchField(String fieldtype) {
        return "fetch" + ImplHelper.getConvertedTypeName(fieldtype) + "Field";
    }

    private static String getMethodNameStoreField(String fieldtype) {
        return "store" + ImplHelper.getConvertedTypeName(fieldtype) + "Field";
    }

    static String createJDOFieldAccessorName(String classname, String fieldname) {
        return "jdoGet" + fieldname;
    }

    static String createJDOFieldMutatorName(String classname, String fieldname) {
        return "jdoSet" + fieldname;
    }

    static String getJDOInheritedFieldCountInitValue(String superclassname) {
        return superclassname == null ? "0" : NameHelper.normalizeClassName(superclassname) + '.' + METHODNAME_JDO_GET_MANAGED_FIELD_COUNT + "()";
    }

    static String getJDOFieldNamesInitValue(String[] fieldnames) {
        String value = "new String[]{ ";
        int n = fieldnames.length;
        int i = 0;
        while (i < n) {
            value = value + "\"" + fieldnames[i] + "\"";
            if (i < n - 1) {
                value = value + ", ";
            }
            ++i;
        }
        return value + " }";
    }

    static String getJDOFieldTypesInitValue(String[] fieldtypes) {
        String value = "new Class[]{ ";
        int n = fieldtypes.length;
        int i = 0;
        while (i < n) {
            value = value + NameHelper.normalizeClassName(fieldtypes[i]) + ".class";
            if (i < n - 1) {
                value = value + ", ";
            }
            ++i;
        }
        return value + " }";
    }

    static String getJDOFieldFlagsInitValue(int[] fieldflags) {
        String value = "new byte[]{ ";
        int n = fieldflags.length;
        int i = 0;
        while (i < n) {
            value = value + "0x" + Integer.toHexString(fieldflags[i]);
            if (i < n - 1) {
                value = value + ", ";
            }
            ++i;
        }
        return value + " }";
    }

    static String getJDOPCSuperclassInitValue(String superclass) {
        return superclass == null ? "null" : NameHelper.normalizeClassName(superclass) + ".class";
    }

    static String getSerialVersionUIDInitValue(long uid) {
        return uid + "L";
    }

    static List getJDOManagedFieldCountImpl(int fieldcount) {
        ArrayList<String> impl = new ArrayList<String>(3);
        impl.add("jdoInheritedFieldCount + " + fieldcount + ';');
        return impl;
    }

    static List getStaticInitializerImpl(String classname, String superPC, String[] managedFieldNames, String[] managedFieldTypes, int[] managedFieldFlags) {
        classname = NameHelper.normalizeClassName(classname);
        ArrayList<String> impl = new ArrayList<String>(20);
        impl.add("jdoInheritedFieldCount = " + ImplHelper.getJDOInheritedFieldCountInitValue(superPC) + ";");
        impl.add("jdoFieldNames = " + ImplHelper.getJDOFieldNamesInitValue(managedFieldNames) + ";");
        impl.add("jdoFieldTypes = " + ImplHelper.getJDOFieldTypesInitValue(managedFieldTypes) + ";");
        impl.add("jdoFieldFlags = " + ImplHelper.getJDOFieldFlagsInitValue(managedFieldFlags) + ";");
        impl.add("jdoPersistenceCapableSuperclass = " + ImplHelper.getJDOPCSuperclassInitValue(superPC) + ";");
        impl.add("javax.jdo.spi.JDOImplHelper.registerClass(");
        impl.add("    " + classname + ".class" + ", ");
        impl.add("    jdoFieldNames, ");
        impl.add("    jdoFieldTypes, ");
        impl.add("    jdoFieldFlags, ");
        impl.add("    jdoPersistenceCapableSuperclass, ");
        impl.add("    new " + classname + "()");
        impl.add(");");
        return impl;
    }

    static List getJDOGetManagedFieldCountImpl(int fieldcount) {
        ArrayList<String> impl = new ArrayList<String>(5);
        impl.add("return jdoInheritedFieldCount + " + fieldcount + ';');
        return impl;
    }

    static List getDefaultConstructorImpl() {
        ArrayList<String> impl = new ArrayList<String>(5);
        impl.add("super();");
        return impl;
    }

    static List getDummyConstructorImpl() {
        ArrayList<String> impl = new ArrayList<String>(5);
        impl.add("super();");
        return impl;
    }

    static List getOidStringArgConstructorImpl(String superoidclassname, String str) {
        ArrayList<String> impl = new ArrayList<String>(5);
        if (superoidclassname != null) {
            impl.add("super(" + str + ");");
        }
        impl.add("// not implemented yet");
        impl.add("throw new UnsupportedOperationException();");
        return impl;
    }

    static List getCloneImpl(String classname, String[] fieldnames) {
        classname = NameHelper.normalizeClassName(classname);
        ArrayList<String> impl = new ArrayList<String>(5);
        impl.add("// clone() method for enhancer testing purpose");
        impl.add("final " + classname + " pc = (" + classname + ")super.clone();");
        int i = 0;
        while (i < fieldnames.length) {
            String fname = fieldnames[i];
            impl.add("pc." + fname + " = " + "this." + fname + ";");
            ++i;
        }
        impl.add("return pc;");
        return impl;
    }

    static List getJDONewInstanceImpl(String classname, String statemanager) {
        ArrayList<String> impl = new ArrayList<String>(5);
        classname = NameHelper.getClassName(classname);
        impl.add("final " + classname + " pc = new " + classname + "();");
        impl.add("pc.jdoFlags = 1; // == LOAD_REQUIRED");
        impl.add("pc.jdoStateManager = " + statemanager + ';');
        impl.add("return pc;");
        return impl;
    }

    static List getJDONewInstanceKeyImpl(String classname, String statemanager, String oid) {
        ArrayList<String> impl = new ArrayList<String>(5);
        classname = NameHelper.getClassName(classname);
        impl.add("final " + classname + " pc = new " + classname + "();");
        impl.add("pc.jdoCopyKeyFieldsFromObjectId(" + oid + ");");
        impl.add("pc.jdoFlags = 1; // == LOAD_REQUIRED");
        impl.add("pc.jdoStateManager = " + statemanager + ';');
        impl.add("return pc;");
        return impl;
    }

    static List getJDONewOidInstanceImpl(String oidclassname) {
        ArrayList<String> impl = new ArrayList<String>(5);
        if (oidclassname == null) {
            impl.add("return null;");
        } else {
            impl.add("return new " + oidclassname + "();");
        }
        return impl;
    }

    static List getJDONewOidInstanceImpl(String oidclassname, String str) {
        ArrayList<String> impl = new ArrayList<String>(5);
        if (oidclassname == null) {
            impl.add("return null;");
        } else {
            impl.add("return new " + oidclassname + "(" + str + ");");
        }
        return impl;
    }

    static List getJDOCopyKeyFieldsToOid(String oidclassname, String superoidclassname, String oid, String[] fieldnames) {
        ArrayList<String> impl = new ArrayList<String>(5);
        if (oidclassname == null) {
            impl.add("return;");
        } else {
            impl.add("if (!(" + oid + " instanceof " + oidclassname + ")) {");
            impl.add("    throw new IllegalArgumentException(\"arg1\");");
            impl.add("}");
            String _oid = "_" + oid;
            impl.add("final " + oidclassname + " " + _oid + " = (" + oidclassname + ")" + oid + ";");
            if (superoidclassname != null) {
                impl.add("super.jdoCopyKeyFieldsToObjectId(" + _oid + ");");
            }
            int i = 0;
            while (i < fieldnames.length) {
                String fname = fieldnames[i];
                impl.add(_oid + "." + fname + " = " + "this." + fname + ";");
                ++i;
            }
        }
        return impl;
    }

    static List getJDOCopyKeyFieldsFromOid(String oidclassname, String superoidclassname, String oid, String[] fieldnames) {
        ArrayList<String> impl = new ArrayList<String>(5);
        if (oidclassname == null) {
            impl.add("return;");
        } else {
            impl.add("if (!(" + oid + " instanceof " + oidclassname + ")) {");
            impl.add("    throw new IllegalArgumentException(\"arg1\");");
            impl.add("}");
            String _oid = "_" + oid;
            impl.add("final " + oidclassname + " " + _oid + " = (" + oidclassname + ")" + oid + ";");
            if (superoidclassname != null) {
                impl.add("super.jdoCopyKeyFieldsFromObjectId(" + _oid + ");");
            }
            int i = 0;
            while (i < fieldnames.length) {
                String fname = fieldnames[i];
                impl.add("this." + fname + " = " + _oid + "." + fname + ";");
                ++i;
            }
        }
        return impl;
    }

    static List getJDOCopyKeyFieldsToOid(String oidclassname, String superoidclassname, String fm, String oid, String[] fieldnames, String[] fieldtypes, int[] fieldnumbers) {
        ArrayList<String> impl = new ArrayList<String>(5);
        if (oidclassname == null) {
            impl.add("return;");
        } else {
            impl.add("if (" + fm + " == null) {");
            impl.add("    throw new IllegalArgumentException(\"arg1\");");
            impl.add("}");
            impl.add("if (!(" + oid + " instanceof " + oidclassname + ")) {");
            impl.add("    throw new IllegalArgumentException(\"arg2\");");
            impl.add("}");
            String _oid = "_" + oid;
            impl.add("final " + oidclassname + " " + _oid + " = (" + oidclassname + ")" + oid + ";");
            if (superoidclassname != null) {
                impl.add("super.jdoCopyKeyFieldsToObjectId(" + fm + ", " + _oid + ");");
            }
            int i = 0;
            while (i < fieldnames.length) {
                impl.add(_oid + "." + fieldnames[i] + " = " + fm + "." + ImplHelper.getMethodNameFetchField(fieldtypes[i]) + "(" + fieldnumbers[i] + ");");
                ++i;
            }
        }
        return impl;
    }

    static List getJDOCopyKeyFieldsFromOid(String oidclassname, String superoidclassname, String fm, String oid, String[] fieldnames, String[] fieldtypes, int[] fieldnumbers) {
        ArrayList<String> impl = new ArrayList<String>(5);
        if (oidclassname == null) {
            impl.add("return;");
        } else {
            impl.add("if (" + fm + " == null) {");
            impl.add("    throw new IllegalArgumentException(\"arg1\");");
            impl.add("}");
            impl.add("if (!(" + oid + " instanceof " + oidclassname + ")) {");
            impl.add("    throw new IllegalArgumentException(\"arg2\");");
            impl.add("}");
            String _oid = "_" + oid;
            impl.add("final " + oidclassname + " " + _oid + " = (" + oidclassname + ")" + oid + ";");
            if (superoidclassname != null) {
                impl.add("super.jdoCopyKeyFieldsFromObjectId(" + fm + ", " + _oid + ");");
            }
            int i = 0;
            while (i < fieldnames.length) {
                impl.add(fm + "." + ImplHelper.getMethodNameStoreField(fieldtypes[i]) + "(" + fieldnumbers[i] + ", " + _oid + "." + fieldnames[i] + ");");
                ++i;
            }
        }
        return impl;
    }

    static List getJDOReplaceStateManagerImpl(String statemanager) {
        ArrayList<String> impl = new ArrayList<String>(15);
        impl.add("final javax.jdo.spi.StateManager s = this.jdoStateManager;");
        impl.add("if (s != null) {");
        impl.add("    this.jdoStateManager = s.replacingStateManager(this, " + statemanager + ");");
        impl.add("    return;");
        impl.add("}");
        impl.add((class$java$lang$SecurityManager == null ? (class$java$lang$SecurityManager = ImplHelper.class$("java.lang.SecurityManager")) : class$java$lang$SecurityManager).getName() + " sec = java.lang.System.getSecurityManager();");
        impl.add("if (sec != null) {");
        impl.add("    // throws exception if not authorized");
        impl.add("    sec.checkPermission(new javax.jdo.spi.JDOPermission(\"setStateManager\"));");
        impl.add("}");
        impl.add("this.jdoStateManager = " + statemanager + ';');
        impl.add("this.jdoFlags = LOAD_REQUIRED;");
        return impl;
    }

    static List getJDOReplaceFlagsImpl() {
        ArrayList<String> impl = new ArrayList<String>(5);
        impl.add("final javax.jdo.spi.StateManager sm = this.jdoStateManager;");
        impl.add("if (sm != null) {");
        impl.add("    this.jdoFlags = sm.replacingFlags(this);");
        impl.add("}");
        return impl;
    }

    static List getJDOFieldDirectReadImpl(String fieldname, String fieldtype, int fieldnumber, String instancename) {
        fieldtype = NameHelper.normalizeClassName(fieldtype);
        ArrayList<String> impl = new ArrayList<String>(20);
        impl.add("// augmentation: grant direct read access");
        impl.add("return " + instancename + '.' + fieldname + ';');
        return impl;
    }

    private static void addFieldMediateReadImpl(List impl, String fieldname, String fieldtype, int fieldnumber, String instancename) {
        impl.add("final javax.jdo.spi.StateManager sm = " + instancename + '.' + FIELDNAME_JDO_STATE_MANAGER + ";");
        impl.add("if (sm == null) {");
        impl.add("    return " + instancename + '.' + fieldname + ';');
        impl.add("}");
        impl.add("if (sm.isLoaded(" + instancename + ", " + instancename + '.' + FIELDNAME_JDO_INHERITED_FIELD_COUNT + " + " + fieldnumber + ")) {");
        impl.add("    return " + instancename + '.' + fieldname + ';');
        impl.add("}");
        impl.add("return (" + fieldtype + ")" + "sm." + ImplHelper.getMethodNameGetField(fieldtype) + "(" + instancename + ", " + instancename + '.' + FIELDNAME_JDO_INHERITED_FIELD_COUNT + " + " + fieldnumber + ", " + instancename + '.' + fieldname + ");");
    }

    static List getJDOFieldMediateReadImpl(String fieldname, String fieldtype, int fieldnumber, String instancename) {
        fieldtype = NameHelper.normalizeClassName(fieldtype);
        ArrayList<String> impl = new ArrayList<String>(20);
        impl.add("// augmentation: mediate read access");
        ImplHelper.addFieldMediateReadImpl(impl, fieldname, fieldtype, fieldnumber, instancename);
        return impl;
    }

    static List getJDOFieldCheckReadImpl(String fieldname, String fieldtype, int fieldnumber, String instancename) {
        fieldtype = NameHelper.normalizeClassName(fieldtype);
        ArrayList<String> impl = new ArrayList<String>(20);
        impl.add("// augmentation: check read access");
        impl.add("if (" + instancename + '.' + FIELDNAME_JDO_FLAGS + " <= 0) {");
        impl.add("    return " + instancename + '.' + fieldname + ';');
        impl.add("}");
        ImplHelper.addFieldMediateReadImpl(impl, fieldname, fieldtype, fieldnumber, instancename);
        return impl;
    }

    static List getJDOFieldDirectWriteImpl(String fieldname, String fieldtype, int fieldnumber, String instancename, String newvalue) {
        fieldtype = NameHelper.normalizeClassName(fieldtype);
        ArrayList<String> impl = new ArrayList<String>(20);
        impl.add("// augmentation: grant direct write access");
        impl.add(instancename + '.' + fieldname + " = " + newvalue + ';');
        return impl;
    }

    private static void addFieldMediateWriteImpl(List impl, String fieldname, String fieldtype, int fieldnumber, String instancename, String newvalue) {
        impl.add("final javax.jdo.spi.StateManager sm = " + instancename + '.' + FIELDNAME_JDO_STATE_MANAGER + ";");
        impl.add("if (sm == null) {");
        impl.add("    " + instancename + '.' + fieldname + " = " + newvalue + ';');
        impl.add("    return;");
        impl.add("}");
        impl.add("sm." + ImplHelper.getMethodNameSetField(fieldtype) + "(" + instancename + ", " + instancename + '.' + FIELDNAME_JDO_INHERITED_FIELD_COUNT + " + " + fieldnumber + ", " + instancename + '.' + fieldname + ", " + newvalue + ");");
    }

    static List getJDOFieldMediateWriteImpl(String fieldname, String fieldtype, int fieldnumber, String instancename, String newvalue) {
        fieldtype = NameHelper.normalizeClassName(fieldtype);
        ArrayList<String> impl = new ArrayList<String>(20);
        impl.add("// augmentation: mediate write access");
        ImplHelper.addFieldMediateWriteImpl(impl, fieldname, fieldtype, fieldnumber, instancename, newvalue);
        return impl;
    }

    static List getJDOFieldCheckWriteImpl(String fieldname, String fieldtype, int fieldnumber, String instancename, String newvalue) {
        fieldtype = NameHelper.normalizeClassName(fieldtype);
        ArrayList<String> impl = new ArrayList<String>(20);
        impl.add("// augmentation: check write access");
        impl.add("if (" + instancename + '.' + FIELDNAME_JDO_FLAGS + " == 0) {");
        impl.add("    " + instancename + '.' + fieldname + " = " + newvalue + ';');
        impl.add("    return;");
        impl.add("}");
        ImplHelper.addFieldMediateWriteImpl(impl, fieldname, fieldtype, fieldnumber, instancename, newvalue);
        return impl;
    }

    static List getJDOReplaceFieldImpl(String fieldnumber, boolean isRoot, String[] fieldnames, String[] fieldtypes) {
        ArrayList<String> impl = new ArrayList<String>(20);
        impl.add("final javax.jdo.spi.StateManager sm = this.jdoStateManager;");
        impl.add("switch (" + fieldnumber + " - " + FIELDNAME_JDO_INHERITED_FIELD_COUNT + ") {");
        int i = 0;
        while (i < fieldnames.length) {
            String fieldtype = NameHelper.normalizeClassName(fieldtypes[i]);
            impl.add("case " + i + ':');
            impl.add("    if (sm == null) {");
            impl.add("        throw new IllegalStateException(\"arg0.jdoStateManager\");");
            impl.add("    }");
            impl.add("    this." + fieldnames[i] + " = (" + fieldtype + ")sm." + ImplHelper.getMethodNameReplacingField(fieldtype) + "(this, " + fieldnumber + ");");
            impl.add("    return;");
            ++i;
        }
        impl.add("default:");
        if (isRoot) {
            impl.add("    throw new IllegalArgumentException(\"arg1\");");
        } else {
            impl.add("    super.jdoReplaceField(" + fieldnumber + ");");
        }
        impl.add("}");
        return impl;
    }

    static List getJDOProvideFieldImpl(String fieldnumber, boolean isRoot, String[] fieldnames, String[] fieldtypes) {
        ArrayList<String> impl = new ArrayList<String>(20);
        impl.add("final javax.jdo.spi.StateManager sm = this.jdoStateManager;");
        impl.add("switch (" + fieldnumber + " - " + FIELDNAME_JDO_INHERITED_FIELD_COUNT + ") {");
        int i = 0;
        while (i < fieldnames.length) {
            String fieldtype = NameHelper.normalizeClassName(fieldtypes[i]);
            impl.add("case " + i + ':');
            impl.add("    if (sm == null) {");
            impl.add("        throw new IllegalStateException(\"arg0.jdoStateManager\");");
            impl.add("    }");
            impl.add("    sm." + ImplHelper.getMethodNameProvidedField(fieldtype) + "(this, " + fieldnumber + ", " + "this." + fieldnames[i] + ");");
            impl.add("    return;");
            ++i;
        }
        impl.add("default:");
        if (isRoot) {
            impl.add("    throw new IllegalArgumentException(\"arg1\");");
        } else {
            impl.add("    super.jdoProvideField(" + fieldnumber + ");");
        }
        impl.add("}");
        return impl;
    }

    static List getJDOCopyFieldsImpl(String classname, String copy, String fieldnumbers) {
        classname = NameHelper.normalizeClassName(classname);
        ArrayList<String> impl = new ArrayList<String>(50);
        impl.add("if (this.jdoStateManager == null) {");
        impl.add("    throw new IllegalStateException(\"arg0.jdoStateManager\");");
        impl.add("}");
        impl.add("if (!(" + copy + " instanceof " + classname + ")) {");
        impl.add("    throw new IllegalArgumentException(\"arg1\");");
        impl.add("}");
        impl.add("if (" + fieldnumbers + " == null) {");
        impl.add("    throw new IllegalArgumentException(\"arg2\");");
        impl.add("}");
        impl.add("final " + classname + " other = (" + classname + ")" + copy + ';');
        impl.add("if (other.jdoStateManager != this.jdoStateManager) {");
        impl.add("    throw new IllegalArgumentException(\"arg1.jdoStateManager\");");
        impl.add("}");
        impl.add("final int n = " + fieldnumbers + ".length;");
        impl.add("for (int i = 0; i < n; i++) {");
        impl.add("    this.jdoCopyField(other, " + fieldnumbers + "[i]);");
        impl.add("}");
        return impl;
    }

    static List getJDOCopyFieldImpl(String classname, String copy, String fieldnumber, String[] fieldnames, boolean isRoot) {
        classname = NameHelper.normalizeClassName(classname);
        ArrayList<String> impl = new ArrayList<String>(50);
        impl.add("switch (" + fieldnumber + " - " + FIELDNAME_JDO_INHERITED_FIELD_COUNT + ") {");
        int i = 0;
        while (i < fieldnames.length) {
            impl.add("case " + i + ':');
            impl.add("    if (" + copy + " == null) {");
            impl.add("        throw new IllegalArgumentException(\"arg1\");");
            impl.add("    }");
            impl.add("    this." + fieldnames[i] + " = " + copy + "." + fieldnames[i] + ';');
            impl.add("    return;");
            ++i;
        }
        impl.add("default:");
        if (isRoot) {
            impl.add("    throw new IllegalArgumentException(\"arg2\");");
        } else {
            impl.add("    super.jdoCopyField(" + copy + ", " + fieldnumber + ");");
        }
        impl.add("}");
        return impl;
    }

    static List getWriteObjectImpl(String out) {
        ArrayList<String> impl = new ArrayList<String>(5);
        impl.add("jdoPreSerialize();");
        impl.add(out + ".defaultWriteObject();");
        return impl;
    }

    static List getJDOStateManagerVoidDelegationImpl(String delegation) {
        ArrayList<String> impl = new ArrayList<String>(5);
        impl.add("final javax.jdo.spi.StateManager sm = this.jdoStateManager;");
        impl.add("if (sm != null) {");
        impl.add("    sm." + delegation + ';');
        impl.add("}");
        return impl;
    }

    static List getJDOStateManagerObjectDelegationImpl(String delegation) {
        ArrayList<String> impl = new ArrayList<String>(5);
        impl.add("final javax.jdo.spi.StateManager sm = this.jdoStateManager;");
        impl.add("if (sm != null) {");
        impl.add("    return sm." + delegation + ';');
        impl.add("}");
        impl.add("return null;");
        return impl;
    }

    static List getJDOStateManagerBooleanDelegationImpl(String delegation) {
        ArrayList<String> impl = new ArrayList<String>(5);
        impl.add("final javax.jdo.spi.StateManager sm = this.jdoStateManager;");
        impl.add("if (sm != null) {");
        impl.add("    return sm." + delegation + ';');
        impl.add("}");
        impl.add("return false;");
        return impl;
    }

    static List getJDOFieldIterationImpl(String fieldnumbers, String method) {
        ArrayList<String> impl = new ArrayList<String>(10);
        impl.add("if (" + fieldnumbers + " == null) {");
        impl.add("    throw new IllegalArgumentException(\"arg1\");");
        impl.add("}");
        impl.add("final int n = " + fieldnumbers + ".length;");
        impl.add("for (int i = 0; i < n; i++) {");
        impl.add("    this." + method + "(" + fieldnumbers + "[i]);");
        impl.add("}");
        return impl;
    }

    static List getOidHashCodeImpl(String[] pknames, String[] pktypes, boolean isRoot) {
        ArrayList<String> impl = new ArrayList<String>(3);
        if (isRoot) {
            impl.add("int hash = 0;");
        } else {
            impl.add("int hash = super.hashCode();");
        }
        int i = 0;
        while (i < pknames.length) {
            if (ImplHelper.isPrimitiveClass(pktypes[i])) {
                if (pktypes[i].equals("boolean")) {
                    impl.add("hash += (" + pknames[i] + " ? 1 : 0);");
                } else {
                    impl.add("hash += (int)" + pknames[i] + ';');
                }
            } else {
                impl.add("hash += (this." + pknames[i] + " != null ? this." + pknames[i] + ".hashCode() : 0);");
            }
            ++i;
        }
        impl.add("return hash;");
        return impl;
    }

    static List getOidEqualsImpl(String oidclassname, String[] pknames, String[] pktypes, String pk, boolean isRoot) {
        ArrayList<String> impl = new ArrayList<String>(3);
        if (isRoot) {
            impl.add("if (" + pk + " == null || !this.getClass().equals(" + pk + ".getClass())) {");
        } else {
            impl.add("if (!super.equals(" + pk + ")) {");
        }
        impl.add("    return false;");
        impl.add("}");
        oidclassname = NameHelper.getClassName(oidclassname);
        impl.add(oidclassname + " oid = (" + oidclassname + ")" + pk + ';');
        int i = 0;
        while (i < pknames.length) {
            if (ImplHelper.isPrimitiveClass(pktypes[i])) {
                impl.add("if (this." + pknames[i] + " != oid." + pknames[i] + ") return false;");
            } else {
                impl.add("if (this." + pknames[i] + " != oid." + pknames[i] + " && (this." + pknames[i] + " == null || " + "!this." + pknames[i] + ".equals(oid." + pknames[i] + "))) return false;");
            }
            ++i;
        }
        impl.add("return true;");
        return impl;
    }

    private static boolean isPrimitiveClass(String classname) {
        return classname.equals("int") || classname.equals("long") || classname.equals("short") || classname.equals("byte") || classname.equals("boolean") || classname.equals("char") || classname.equals("double") || classname.equals("float");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        typeNameConversion.put(Integer.TYPE.getName(), "Int");
        typeNameConversion.put(Long.TYPE.getName(), "Long");
        typeNameConversion.put(Byte.TYPE.getName(), "Byte");
        typeNameConversion.put(Character.TYPE.getName(), "Char");
        typeNameConversion.put(Boolean.TYPE.getName(), "Boolean");
        typeNameConversion.put(Short.TYPE.getName(), "Short");
        typeNameConversion.put(Float.TYPE.getName(), "Float");
        typeNameConversion.put(Double.TYPE.getName(), "Double");
        typeNameConversion.put("String", "String");
    }
}

