/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.generator;

import com.sap.jdo.enhancer.generator.NameHelper;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.util.List;

final class CodeWriter
extends NameHelper {
    private static final String lineSeparator = System.getProperty("line.separator");
    private static final String indent = "    ";
    private Writer writer = null;
    private int initialIndents = 0;
    static /* synthetic */ Class class$com$sap$jdo$enhancer$generator$Main;

    CodeWriter() {
    }

    public final void setWriter(Writer writer) {
        this.writer = writer;
    }

    public final void setInitialIndents(int indents) {
        this.initialIndents = indents;
    }

    public void writePackage(String packagename, String[] comments) throws IOException {
        this.writeComment(0, "Generated by " + (class$com$sap$jdo$enhancer$generator$Main == null ? (class$com$sap$jdo$enhancer$generator$Main = CodeWriter.class$("com.sap.jdo.enhancer.generator.Main")) : class$com$sap$jdo$enhancer$generator$Main));
        this.writeComments(0, comments);
        if (packagename != null && packagename.length() > 0) {
            this.writeln();
            this.writeln(0, "package " + NameHelper.normalizeClassName(packagename) + ';');
        }
        this.writeln();
    }

    public void writeImports(List imports, String[] comments) throws IOException {
        this.writeComments(0, comments);
        int n = imports != null ? imports.size() : 0;
        int i = 0;
        while (i < n) {
            String imp = (String)imports.get(i);
            if (imp != null && imp.length() > 0) {
                this.writeln(0, "import " + imp + ';');
            } else {
                this.writeln();
            }
            ++i;
        }
        this.writeln();
    }

    public void writeClassHeader(int modifiers, String classname, String superclass, String[] interfaces, String[] comments) throws IOException {
        int n;
        this.writeComments(0, comments);
        classname = NameHelper.getClassName(classname);
        superclass = NameHelper.normalizeClassName(superclass);
        String mod = Modifier.toString(modifiers);
        this.writeln(0, mod + (mod.length() > 0 ? " " : "") + "class " + classname);
        if (superclass != null) {
            this.writeln(1, "extends " + superclass);
        }
        int n2 = n = interfaces != null ? interfaces.length : 0;
        if (n > 0) {
            this.write(1, "implements ");
            int i = 0;
            while (i < n) {
                this.write(interfaces[i]);
                if (i < n - 1) {
                    this.write(0, ", ");
                }
                ++i;
            }
            this.writeln();
        }
        this.writeln(0, "{");
    }

    public void writeClassEnd() throws IOException {
        this.writeln(0, "}");
        this.writeln();
    }

    public void writeField(String name, int modifiers, String type, String init_value, String[] comments) throws IOException {
        this.writeComments(1, comments);
        type = NameHelper.normalizeClassName(type);
        String s = Modifier.toString(modifiers) + ' ' + type + ' ' + name;
        if (init_value != null) {
            s = s + " = " + init_value;
        }
        this.writeln(1, s + ';');
        this.writeln();
    }

    public void writeStaticInitializer(List impl, String[] comments) throws IOException {
        this.writeComments(1, comments);
        this.writeln(1, "static");
        this.writeln(1, "{");
        int n = impl != null ? impl.size() : 0;
        int i = 0;
        while (i < n) {
            this.writeln(2, (String)impl.get(i));
            ++i;
        }
        this.writeln(1, "}");
        this.writeln();
    }

    public void writeMethod(String name, int modifiers, String return_type, String[] param_names, String[] param_types, String[] exceptions, List impl, String[] comments) throws IOException {
        this.writeComments(1, comments);
        String sig = CodeWriter.createMethodSignature(name, modifiers, return_type, param_names, param_types, exceptions);
        if (sig.length() > 0) {
            this.writeln(1, sig);
        }
        this.writeln(1, "{");
        int n = impl != null ? impl.size() : 0;
        int i = 0;
        while (i < n) {
            this.writeln(2, (String)impl.get(i));
            ++i;
        }
        this.writeln(1, "}");
        this.writeln();
    }

    public void writeConstructor(String name, int modifiers, String[] param_names, String[] param_types, String[] exceptions, List impl, String[] comments) throws IOException {
        this.writeMethod(name, modifiers, null, param_names, param_types, exceptions, impl, comments);
    }

    private static String createMethodSignature(String name, int modifiers, String return_type, String[] param_names, String[] param_types, String[] exceptions) throws IOException {
        return_type = NameHelper.normalizeClassName(return_type);
        String s = "";
        if (modifiers != 0) {
            s = s + Modifier.toString(modifiers) + ' ';
        }
        s = s + (return_type != null ? return_type + " " : "") + name;
        s = s + "(";
        int n = param_names != null ? param_names.length : 0;
        int i = 0;
        while (i < n) {
            s = s + NameHelper.normalizeClassName(param_types[i]) + ' ' + param_names[i];
            if (i < n - 1) {
                s = s + ", ";
            }
            ++i;
        }
        s = s + ')';
        int n2 = n = exceptions != null ? exceptions.length : 0;
        if (n > 0) {
            s = s + " throws ";
            i = 0;
            while (i < n) {
                s = s + exceptions[i];
                if (i < n - 1) {
                    s = s + ", ";
                }
                ++i;
            }
        }
        return s;
    }

    public void writeComment(int indents, String comment) throws IOException {
        if (comment != null) {
            this.writeln(indents, "// " + comment);
        }
    }

    public void writeComments(int indents, String[] comments) throws IOException {
        int n = comments != null ? comments.length : 0;
        int i = 0;
        while (i < n) {
            String s = comments[i];
            this.writeln(indents, "// " + (s != null ? s : ""));
            ++i;
        }
    }

    private void _write(int indents, String s) throws IOException {
        int i = 0;
        while (i < indents) {
            this.writer.write(indent);
            ++i;
        }
        this.writer.write(s);
    }

    private void write(int indents, String s) throws IOException {
        this._write(indents + this.initialIndents, s);
    }

    private void write(String s) throws IOException {
        this._write(0, s);
    }

    private void writeln(int indents, String s) throws IOException {
        if (this.initialIndents > 0) {
            this._write(this.initialIndents, "");
        }
        this._write(indents, s + lineSeparator);
    }

    public void writeln() throws IOException {
        this.writeln(0, "");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

