/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.core;

import com.sap.jdo.enhancer.meta.EnhancerMetaData;
import com.sap.jdo.enhancer.util.Support;
import java.io.PrintWriter;

public final class Environment
extends Support {
    private PrintWriter out = new PrintWriter(System.out, true);
    private PrintWriter err = new PrintWriter(System.err, true);
    private boolean timingOption = false;
    private boolean dumpClassOption = false;
    private boolean noAugmentOption = false;
    private boolean noAnnotateOption = false;
    private boolean verboseOption = false;
    private boolean quietOption = false;
    private int errorsEncountered = 0;
    private EnhancerMetaData jdoMetaData;
    private String lastErrorMessage = null;

    public void error(String error) {
        ++this.errorsEncountered;
        this.lastErrorMessage = Support.getI18N("enhancer.enumerated_error", this.errorsEncountered, error);
        this.err.println(this.lastErrorMessage);
    }

    public void warning(String warn) {
        if (!this.quietOption) {
            this.out.println(Support.getI18N("enhancer.warning", warn));
        }
    }

    public void verbose(String msg) {
        if (this.verboseOption) {
            this.out.println(msg);
        }
    }

    public void message(String msg) {
        if (this.verboseOption) {
            this.out.println(Support.getI18N("enhancer.message", msg));
        }
    }

    public void messageNL(String msg) {
        if (this.verboseOption) {
            this.out.println();
            this.out.println(Support.getI18N("enhancer.message", msg));
        }
    }

    public int errorCount() {
        return this.errorsEncountered;
    }

    public final String getLastErrorMessage() {
        return this.lastErrorMessage;
    }

    public void setDoTimingStatistics(boolean opt) {
        this.timingOption = opt;
    }

    public boolean doTimingStatistics() {
        return this.timingOption;
    }

    public void setDumpClass(boolean opt) {
        this.dumpClassOption = opt;
    }

    public boolean dumpClass() {
        return this.dumpClassOption;
    }

    public void setNoAugment(boolean opt) {
        this.noAugmentOption = opt;
    }

    public boolean noAugment() {
        return this.noAugmentOption;
    }

    public void setNoAnnotate(boolean opt) {
        this.noAnnotateOption = opt;
    }

    public boolean noAnnotate() {
        return this.noAnnotateOption;
    }

    public EnhancerMetaData getEnhancerMetaData() {
        return this.jdoMetaData;
    }

    public void setEnhancerMetaData(EnhancerMetaData jdoMetaData) {
        this.jdoMetaData = jdoMetaData;
    }

    public void setOutputWriter(PrintWriter out) {
        this.out = out;
    }

    public PrintWriter getOutputWriter() {
        return this.out;
    }

    public void setErrorWriter(PrintWriter err) {
        this.err = err;
    }

    public PrintWriter getErrorWriter() {
        return this.err;
    }

    public void setVerbose(boolean beVerbose) {
        this.verboseOption = beVerbose;
    }

    public boolean isVerbose() {
        return this.verboseOption;
    }

    public void setQuiet(boolean beQuiet) {
        this.quietOption = beQuiet;
    }

    public boolean isQuiet() {
        return this.quietOption;
    }

    public void reset() {
        this.errorsEncountered = 0;
    }
}

