/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.core;

import com.sap.jdo.enhancer.classfile.AttributeVector;
import com.sap.jdo.enhancer.classfile.ClassFile;
import com.sap.jdo.enhancer.classfile.CodeAttribute;
import com.sap.jdo.enhancer.classfile.ConstClass;
import com.sap.jdo.enhancer.classfile.ConstFieldRef;
import com.sap.jdo.enhancer.classfile.ConstNameAndType;
import com.sap.jdo.enhancer.classfile.ConstUtf8;
import com.sap.jdo.enhancer.classfile.ConstantPool;
import com.sap.jdo.enhancer.classfile.Descriptor;
import com.sap.jdo.enhancer.classfile.ExceptionRange;
import com.sap.jdo.enhancer.classfile.ExceptionTable;
import com.sap.jdo.enhancer.classfile.ExceptionsAttribute;
import com.sap.jdo.enhancer.classfile.Insn;
import com.sap.jdo.enhancer.classfile.InsnIInc;
import com.sap.jdo.enhancer.classfile.InsnInterfaceInvoke;
import com.sap.jdo.enhancer.classfile.InsnLookupSwitch;
import com.sap.jdo.enhancer.classfile.InsnTableSwitch;
import com.sap.jdo.enhancer.classfile.InsnTarget;
import com.sap.jdo.enhancer.classfile.InsnUtils;
import com.sap.jdo.enhancer.classfile.VMConstants;
import com.sap.jdo.enhancer.core.Analyzer;
import com.sap.jdo.enhancer.core.Augmenter;
import com.sap.jdo.enhancer.core.EnhancerConstants;
import com.sap.jdo.enhancer.core.Environment;
import com.sap.jdo.enhancer.core.JAVA_ClassConstants;
import com.sap.jdo.enhancer.core.JDOConstants;
import com.sap.jdo.enhancer.core.JDONameHelper;
import com.sap.jdo.enhancer.core.JDO_ClassConstants;
import com.sap.jdo.enhancer.core.JDO_IH_MemberConstants;
import com.sap.jdo.enhancer.core.JDO_OIFC_MemberConstants;
import com.sap.jdo.enhancer.core.JDO_OIFS_MemberConstants;
import com.sap.jdo.enhancer.core.JDO_PC_MemberConstants;
import com.sap.jdo.enhancer.core.JDO_SM_MemberConstants;
import com.sap.jdo.enhancer.core.NameHelper;
import com.sap.jdo.enhancer.util.Assertion;
import com.sap.jdo.enhancer.util.InternalError;
import com.sap.jdo.enhancer.util.Support;

class Builder
extends Support
implements VMConstants,
JDOConstants,
EnhancerConstants {
    private final Augmenter augmenter;
    private final Analyzer analyzer;
    private final ClassFile classFile;
    private final String className;
    private final String userClassName;
    private final ConstantPool pool;
    private final Environment env;
    private ConstUtf8 codeAttributeUtf8;
    private ConstFieldRef jdoStateManagerFieldRef;
    private ConstFieldRef jdoFlagsFieldRef;
    private ConstFieldRef jdoFieldNamesFieldRef;
    private ConstFieldRef jdoFieldTypesFieldRef;
    private ConstFieldRef jdoFieldFlagsFieldRef;
    private ConstFieldRef jdoPersistenceCapableSuperclassFieldRef;
    private ConstFieldRef[] annotatedFieldRefs;
    private ConstFieldRef[] keyFieldRefs;
    private ConstFieldRef[] keyClassKeyFieldRefs;

    public Builder(Analyzer analyzer, Augmenter augmenter, Environment env) {
        Assertion.affirm(analyzer != null);
        Assertion.affirm(augmenter != null);
        Assertion.affirm(env != null);
        this.analyzer = analyzer;
        this.augmenter = augmenter;
        this.classFile = analyzer.getClassFile();
        this.className = this.classFile.classNameString();
        this.userClassName = this.classFile.userClassName();
        this.pool = this.classFile.pool();
        this.env = env;
        Assertion.affirm(this.classFile != null);
        Assertion.affirm(this.className != null);
        Assertion.affirm(this.userClassName != null);
        Assertion.affirm(this.pool != null);
    }

    private static int min(int i, int j) {
        return i < j ? i : j;
    }

    private static int max(int i, int j) {
        return i < j ? j : i;
    }

    private static int countMethodArgWords(String sig) {
        return Descriptor.countMethodArgWords(sig) + 1;
    }

    private ConstUtf8 getCodeAttributeUtf8() {
        if (this.codeAttributeUtf8 == null) {
            this.codeAttributeUtf8 = this.pool.addUtf8("Code");
        }
        return this.codeAttributeUtf8;
    }

    private ConstFieldRef getjdoStateManagerFieldRef() {
        String pcRootName = this.analyzer.getPCRootClassName();
        Assertion.affirm(pcRootName != null);
        if (this.jdoStateManagerFieldRef == null) {
            this.jdoStateManagerFieldRef = this.pool.addFieldRef(pcRootName, "jdoStateManager", JDO_PC_MemberConstants.JDO_PC_jdoStateManager_Sig);
        }
        return this.jdoStateManagerFieldRef;
    }

    private ConstFieldRef getjdoFlagsFieldRef() {
        String pcRootName = this.analyzer.getPCRootClassName();
        Assertion.affirm(pcRootName != null);
        if (this.jdoFlagsFieldRef == null) {
            this.jdoFlagsFieldRef = this.pool.addFieldRef(pcRootName, "jdoFlags", "B");
        }
        return this.jdoFlagsFieldRef;
    }

    private ConstFieldRef getjdoFieldNamesFieldRef() {
        if (this.jdoFieldNamesFieldRef == null) {
            this.jdoFieldNamesFieldRef = this.pool.addFieldRef(this.className, "jdoFieldNames", JDO_PC_MemberConstants.JDO_PC_jdoFieldNames_Sig);
        }
        return this.jdoFieldNamesFieldRef;
    }

    private ConstFieldRef getjdoFieldTypesFieldRef() {
        if (this.jdoFieldTypesFieldRef == null) {
            this.jdoFieldTypesFieldRef = this.pool.addFieldRef(this.className, "jdoFieldTypes", JDO_PC_MemberConstants.JDO_PC_jdoFieldTypes_Sig);
        }
        return this.jdoFieldTypesFieldRef;
    }

    private ConstFieldRef getjdoFieldFlagsFieldRef() {
        if (this.jdoFieldFlagsFieldRef == null) {
            this.jdoFieldFlagsFieldRef = this.pool.addFieldRef(this.className, "jdoFieldFlags", "[B");
        }
        return this.jdoFieldFlagsFieldRef;
    }

    private ConstFieldRef getjdoPersistenceCapableSuperclassFieldRef() {
        if (this.jdoPersistenceCapableSuperclassFieldRef == null) {
            this.jdoPersistenceCapableSuperclassFieldRef = this.pool.addFieldRef(this.className, "jdoPersistenceCapableSuperclass", JDO_PC_MemberConstants.JDO_PC_jdoPersistenceCapableSuperclass_Sig);
        }
        return this.jdoPersistenceCapableSuperclassFieldRef;
    }

    private ConstFieldRef[] getAnnotatedFieldRefs() {
        if (this.annotatedFieldRefs == null) {
            int annotatedFieldCount = this.analyzer.getAnnotatedFieldCount();
            String[] annotatedFieldNames = this.analyzer.getAnnotatedFieldNames();
            String[] annotatedFieldSigs = this.analyzer.getAnnotatedFieldSigs();
            Assertion.affirm(annotatedFieldNames.length == annotatedFieldCount);
            Assertion.affirm(annotatedFieldSigs.length == annotatedFieldCount);
            this.annotatedFieldRefs = new ConstFieldRef[annotatedFieldCount];
            int i = 0;
            while (i < annotatedFieldCount) {
                String name = annotatedFieldNames[i];
                String sig = annotatedFieldSigs[i];
                this.annotatedFieldRefs[i] = this.pool.addFieldRef(this.className, name, sig);
                Assertion.affirm(this.annotatedFieldRefs[i] != null);
                ++i;
            }
        }
        Assertion.affirm(this.annotatedFieldRefs != null);
        return this.annotatedFieldRefs;
    }

    private ConstFieldRef[] getKeyFieldRefs() {
        if (this.keyFieldRefs == null) {
            ConstFieldRef[] annotatedFieldRefs = this.getAnnotatedFieldRefs();
            int keyFieldCount = this.analyzer.getKeyFieldCount();
            int[] keyFieldIndexes = this.analyzer.getKeyFieldIndexes();
            Assertion.affirm(keyFieldIndexes.length == keyFieldCount);
            this.keyFieldRefs = new ConstFieldRef[keyFieldCount];
            int i = 0;
            while (i < keyFieldCount) {
                this.keyFieldRefs[i] = annotatedFieldRefs[keyFieldIndexes[i]];
                Assertion.affirm(this.keyFieldRefs[i] != null);
                ++i;
            }
        }
        Assertion.affirm(this.keyFieldRefs != null);
        return this.keyFieldRefs;
    }

    private ConstFieldRef[] getKeyClassKeyFieldRefs() {
        if (this.keyClassKeyFieldRefs == null) {
            String keyClassName = this.analyzer.getKeyClassName();
            Assertion.affirm(keyClassName != null);
            int keyFieldCount = this.analyzer.getKeyFieldCount();
            ConstFieldRef[] keyFieldRefs = this.getKeyFieldRefs();
            Assertion.affirm(keyFieldRefs.length == keyFieldCount);
            this.keyClassKeyFieldRefs = new ConstFieldRef[keyFieldCount];
            int i = 0;
            while (i < keyFieldCount) {
                ConstNameAndType nt = keyFieldRefs[i].nameAndType();
                String name = nt.name().asString();
                String sig = nt.signature().asString();
                this.keyClassKeyFieldRefs[i] = this.pool.addFieldRef(keyClassName, name, sig);
                Assertion.affirm(this.keyClassKeyFieldRefs[i] != null);
                ++i;
            }
        }
        Assertion.affirm(this.keyClassKeyFieldRefs != null);
        return this.keyClassKeyFieldRefs;
    }

    private Insn appendThrowJavaException(Insn insn, String exceptionName, String exceptionText) {
        Assertion.affirm(insn != null);
        Assertion.affirm(exceptionName != null);
        Assertion.affirm(exceptionText != null);
        String exceptionCtorName = NameHelper.constructorName();
        String exceptionCtorSig = NameHelper.constructorSig(JAVA_ClassConstants.JAVA_String_Sig);
        insn = insn.append(Insn.create(187, this.pool.addClass(exceptionName)));
        insn = insn.append(Insn.create(89));
        insn = insn.append(InsnUtils.stringConstant(exceptionText, this.pool));
        insn = insn.append(Insn.create(183, this.pool.addMethodRef(exceptionName, exceptionCtorName, exceptionCtorSig)));
        insn = insn.append(Insn.create(191));
        Assertion.affirm(insn != null);
        return insn;
    }

    private Insn appendCheckStateManager(Insn insn, int argStart, String exceptionName, String exceptionText) {
        Assertion.affirm(insn != null);
        Assertion.affirm(exceptionName != null);
        Assertion.affirm(exceptionText != null);
        InsnTarget body = new InsnTarget();
        insn = insn.append(InsnUtils.aLoad(argStart, this.pool));
        insn = insn.append(Insn.create(180, this.getjdoStateManagerFieldRef()));
        insn = insn.append(Insn.create(199, body));
        insn = this.appendThrowJavaException(insn, exceptionName, exceptionText);
        insn = insn.append(body);
        Assertion.affirm(insn != null);
        return insn;
    }

    private Insn appendCheckVarNonNull(Insn insn, int argStart, String exceptionName, String exceptionText) {
        Assertion.affirm(insn != null);
        Assertion.affirm(exceptionName != null);
        Assertion.affirm(exceptionText != null);
        InsnTarget body = new InsnTarget();
        insn = insn.append(InsnUtils.aLoad(argStart, this.pool));
        insn = insn.append(Insn.create(199, body));
        insn = this.appendThrowJavaException(insn, exceptionName, exceptionText);
        insn = insn.append(body);
        Assertion.affirm(insn != null);
        return insn;
    }

    private Insn appendCheckVarInstanceOf(Insn insn, int argStart, ConstClass constClass, String exceptionName, String exceptionText) {
        Assertion.affirm(insn != null);
        Assertion.affirm(constClass != null);
        Assertion.affirm(exceptionName != null);
        Assertion.affirm(exceptionText != null);
        InsnTarget body = new InsnTarget();
        insn = insn.append(InsnUtils.aLoad(argStart, this.pool));
        insn = insn.append(Insn.create(193, constClass));
        insn = insn.append(Insn.create(154, body));
        insn = this.appendThrowJavaException(insn, exceptionName, exceptionText);
        insn = insn.append(body);
        Assertion.affirm(insn != null);
        return insn;
    }

    public void addNullMethod(String methodName, String methodSig, int accessFlags) {
        InsnTarget begin;
        Assertion.affirm((accessFlags & 8) == 0);
        ExceptionsAttribute exceptAttr = null;
        Insn insn = begin = new InsnTarget();
        insn = insn.append(Insn.create(177));
        CodeAttribute codeAttr = new CodeAttribute(this.getCodeAttributeUtf8(), 0, Builder.countMethodArgWords(methodSig), begin, new ExceptionTable(), new AttributeVector());
        this.augmenter.addMethod(methodName, methodSig, accessFlags, codeAttr, exceptAttr);
    }

    public void addJDOReplaceStateManager() {
        String methodName = "jdoReplaceStateManager";
        String methodSig = JDO_PC_MemberConstants.JDO_PC_jdoReplaceStateManager_Sig;
        int accessFlags = 49;
        ExceptionsAttribute exceptAttr = null;
        InsnTarget begin = new InsnTarget();
        Insn insn = begin;
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(180, this.getjdoStateManagerFieldRef()));
        insn = insn.append(Insn.create(77));
        InsnTarget check = new InsnTarget();
        insn = insn.append(Insn.create(44));
        insn = insn.append(Insn.create(198, check));
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(44));
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(43));
        insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef(JDO_ClassConstants.JDO_StateManager_Path, "replacingStateManager", JDO_SM_MemberConstants.JDO_SM_replacingStateManager_Sig), Builder.countMethodArgWords(JDO_SM_MemberConstants.JDO_SM_replacingStateManager_Sig)));
        insn = insn.append(Insn.create(181, this.getjdoStateManagerFieldRef()));
        insn = insn.append(Insn.create(177));
        insn = insn.append(check);
        insn = insn.append(Insn.create(184, this.pool.addMethodRef(JAVA_ClassConstants.JAVA_System_Path, "getSecurityManager", JAVA_ClassConstants.JAVA_System_getSecurityManager_Sig)));
        insn = insn.append(Insn.create(78));
        InsnTarget assign = new InsnTarget();
        insn = insn.append(Insn.create(45));
        insn = insn.append(Insn.create(198, assign));
        insn = insn.append(Insn.create(45));
        insn = insn.append(Insn.create(187, this.pool.addClass(JDO_ClassConstants.JDO_JDOPermission_Path)));
        insn = insn.append(Insn.create(89));
        insn = insn.append(InsnUtils.stringConstant("setStateManager", this.pool));
        insn = insn.append(Insn.create(183, this.pool.addMethodRef(JDO_ClassConstants.JDO_JDOPermission_Path, JDO_ClassConstants.JDO_JDOPermission_JDOPermission_Name, JDO_ClassConstants.JDO_JDOPermission_JDOPermission_Sig)));
        insn = insn.append(Insn.create(182, this.pool.addMethodRef(JAVA_ClassConstants.JAVA_SecurityManager_Path, "checkPermission", JAVA_ClassConstants.JAVA_SecurityManager_checkPermission_Sig)));
        insn = insn.append(assign);
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(43));
        insn = insn.append(Insn.create(181, this.getjdoStateManagerFieldRef()));
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(4));
        insn = insn.append(Insn.create(181, this.getjdoFlagsFieldRef()));
        insn = insn.append(Insn.create(177));
        CodeAttribute codeAttr = new CodeAttribute(this.getCodeAttributeUtf8(), 4, 4, begin, new ExceptionTable(), new AttributeVector());
        this.augmenter.addMethod("jdoReplaceStateManager", methodSig, 49, codeAttr, exceptAttr);
    }

    public void addJDOReplaceFlags() {
        String methodName = "jdoReplaceFlags";
        String methodSig = "()V";
        int accessFlags = 17;
        ExceptionsAttribute exceptAttr = null;
        InsnTarget begin = new InsnTarget();
        Insn insn = begin;
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(180, this.getjdoStateManagerFieldRef()));
        insn = insn.append(Insn.create(76));
        InsnTarget end = new InsnTarget();
        insn = insn.append(Insn.create(43));
        insn = insn.append(Insn.create(198, end));
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(43));
        insn = insn.append(Insn.create(42));
        insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef(JDO_ClassConstants.JDO_StateManager_Path, "replacingFlags", JDO_SM_MemberConstants.JDO_SM_replacingFlags_Sig), Builder.countMethodArgWords(JDO_SM_MemberConstants.JDO_SM_replacingFlags_Sig)));
        insn = insn.append(Insn.create(181, this.getjdoFlagsFieldRef()));
        insn = insn.append(end);
        insn = insn.append(Insn.create(177));
        CodeAttribute codeAttr = new CodeAttribute(this.getCodeAttributeUtf8(), 3, 2, begin, new ExceptionTable(), new AttributeVector());
        this.augmenter.addMethod("jdoReplaceFlags", "()V", 17, codeAttr, exceptAttr);
    }

    public void addJDOMakeDirtyMethod() {
        String methodName = "jdoMakeDirty";
        String methodSig = JDO_PC_MemberConstants.JDO_PC_jdoMakeDirty_Sig;
        int accessFlags = 17;
        ExceptionsAttribute exceptAttr = null;
        InsnTarget begin = new InsnTarget();
        Insn insn = begin;
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(180, this.getjdoStateManagerFieldRef()));
        insn = insn.append(Insn.create(77));
        InsnTarget end = new InsnTarget();
        insn = insn.append(Insn.create(44));
        insn = insn.append(Insn.create(198, end));
        insn = insn.append(Insn.create(44));
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(43));
        insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef(JDO_ClassConstants.JDO_StateManager_Path, "makeDirty", JDO_SM_MemberConstants.JDO_SM_makeDirty_Sig), Builder.countMethodArgWords(JDO_SM_MemberConstants.JDO_SM_makeDirty_Sig)));
        insn = insn.append(end);
        insn = insn.append(Insn.create(177));
        CodeAttribute codeAttr = new CodeAttribute(this.getCodeAttributeUtf8(), 3, 3, begin, new ExceptionTable(), new AttributeVector());
        this.augmenter.addMethod("jdoMakeDirty", methodSig, 17, codeAttr, exceptAttr);
    }

    public void addJDOPreSerializeMethod() {
        String methodName = "jdoPreSerialize";
        String methodSig = "()V";
        int accessFlags = 20;
        ExceptionsAttribute exceptAttr = null;
        InsnTarget begin = new InsnTarget();
        Insn insn = begin;
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(180, this.getjdoStateManagerFieldRef()));
        insn = insn.append(Insn.create(76));
        InsnTarget end = new InsnTarget();
        insn = insn.append(Insn.create(43));
        insn = insn.append(Insn.create(198, end));
        insn = insn.append(Insn.create(43));
        insn = insn.append(Insn.create(42));
        insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef(JDO_ClassConstants.JDO_StateManager_Path, "preSerialize", JDO_SM_MemberConstants.JDO_SM_preSerialize_Sig), Builder.countMethodArgWords(JDO_SM_MemberConstants.JDO_SM_preSerialize_Sig)));
        insn = insn.append(end);
        insn = insn.append(Insn.create(177));
        CodeAttribute codeAttr = new CodeAttribute(this.getCodeAttributeUtf8(), 2, 2, begin, new ExceptionTable(), new AttributeVector());
        this.augmenter.addMethod("jdoPreSerialize", "()V", 20, codeAttr, exceptAttr);
    }

    public void addJDOIsPersistentMethod() {
        this.addJDOInterrogativeMethod("jdoIsPersistent", "()Z", 17, "isPersistent", JDO_SM_MemberConstants.JDO_SM_isPersistent_Sig);
    }

    public void addJDOIsTransactionalMethod() {
        this.addJDOInterrogativeMethod("jdoIsTransactional", "()Z", 17, "isTransactional", JDO_SM_MemberConstants.JDO_SM_isTransactional_Sig);
    }

    public void addJDOIsNewMethod() {
        this.addJDOInterrogativeMethod("jdoIsNew", "()Z", 17, "isNew", JDO_SM_MemberConstants.JDO_SM_isNew_Sig);
    }

    public void addJDOIsDeletedMethod() {
        this.addJDOInterrogativeMethod("jdoIsDeleted", "()Z", 17, "isDeleted", JDO_SM_MemberConstants.JDO_SM_isDeleted_Sig);
    }

    public void addJDOIsDirtyMethod() {
        this.addJDOInterrogativeMethod("jdoIsDirty", "()Z", 17, "isDirty", JDO_SM_MemberConstants.JDO_SM_isDirty_Sig);
    }

    private void addJDOInterrogativeMethod(String methodName, String methodSig, int accessFlags, String delegateName, String delegateSig) {
        ExceptionsAttribute exceptAttr = null;
        InsnTarget begin = new InsnTarget();
        Insn insn = begin;
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(180, this.getjdoStateManagerFieldRef()));
        insn = insn.append(Insn.create(76));
        InsnTarget noncall = new InsnTarget();
        insn = insn.append(Insn.create(43));
        insn = insn.append(Insn.create(198, noncall));
        insn = insn.append(Insn.create(43));
        insn = insn.append(Insn.create(42));
        insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef(JDO_ClassConstants.JDO_StateManager_Path, delegateName, delegateSig), Builder.countMethodArgWords(delegateSig)));
        insn = insn.append(Insn.create(172));
        insn = insn.append(noncall);
        insn = insn.append(Insn.create(3));
        insn = insn.append(Insn.create(172));
        CodeAttribute codeAttr = new CodeAttribute(this.getCodeAttributeUtf8(), 2, 2, begin, new ExceptionTable(), new AttributeVector());
        this.augmenter.addMethod(methodName, methodSig, accessFlags, codeAttr, exceptAttr);
    }

    public void addJDOGetPersistenceManagerMethod() {
        this.addJDOObjectQueryMethod("jdoGetPersistenceManager", JDO_PC_MemberConstants.JDO_PC_jdoGetPersistenceManager_Sig, 17, "getPersistenceManager", JDO_SM_MemberConstants.JDO_SM_getPersistenceManager_Sig);
    }

    public void addJDOGetObjectIdMethod() {
        this.addJDOObjectQueryMethod("jdoGetObjectId", JDO_PC_MemberConstants.JDO_PC_jdoGetObjectId_Sig, 17, "getObjectId", JDO_SM_MemberConstants.JDO_SM_getObjectId_Sig);
    }

    public void addJDOGetTransactionalObjectIdMethod() {
        this.addJDOObjectQueryMethod("jdoGetTransactionalObjectId", JDO_PC_MemberConstants.JDO_PC_jdoGetTransactionalObjectId_Sig, 17, "getTransactionalObjectId", JDO_SM_MemberConstants.JDO_SM_getTransactionalObjectId_Sig);
    }

    private void addJDOObjectQueryMethod(String methodName, String methodSig, int accessFlags, String delegateName, String delegateSig) {
        ExceptionsAttribute exceptAttr = null;
        InsnTarget begin = new InsnTarget();
        Insn insn = begin;
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(180, this.getjdoStateManagerFieldRef()));
        insn = insn.append(Insn.create(76));
        InsnTarget noncall = new InsnTarget();
        insn = insn.append(Insn.create(43));
        insn = insn.append(Insn.create(198, noncall));
        insn = insn.append(Insn.create(43));
        insn = insn.append(Insn.create(42));
        insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef(JDO_ClassConstants.JDO_StateManager_Path, delegateName, delegateSig), Builder.countMethodArgWords(delegateSig)));
        insn = insn.append(Insn.create(176));
        insn = insn.append(noncall);
        insn = insn.append(Insn.create(1));
        insn = insn.append(Insn.create(176));
        CodeAttribute codeAttr = new CodeAttribute(this.getCodeAttributeUtf8(), 2, 2, begin, new ExceptionTable(), new AttributeVector());
        this.augmenter.addMethod(methodName, methodSig, accessFlags, codeAttr, exceptAttr);
    }

    public void addJDOProvideFieldsMethod() {
        this.addJDOArrayArgumentIterationMethod("jdoProvideFields", "([I)V", 17, "jdoProvideField", "(I)V");
    }

    public void addJDOReplaceFieldsMethod() {
        this.addJDOArrayArgumentIterationMethod("jdoReplaceFields", "([I)V", 17, "jdoReplaceField", "(I)V");
    }

    public void addJDOArrayArgumentIterationMethod(String methodName, String methodSig, int accessFlags, String delegateName, String delegateSig) {
        ExceptionsAttribute exceptAttr = null;
        InsnTarget begin = new InsnTarget();
        Insn insn = begin;
        insn = this.appendCheckVarNonNull(insn, 1, JAVA_ClassConstants.JAVA_IllegalArgumentException_Path, "arg1");
        insn = insn.append(Insn.create(43));
        insn = insn.append(Insn.create(190));
        insn = insn.append(Insn.create(61));
        InsnTarget loopcheck = new InsnTarget();
        insn = insn.append(Insn.create(3));
        insn = insn.append(Insn.create(62));
        insn = insn.append(Insn.create(167, loopcheck));
        InsnTarget loopbody = new InsnTarget();
        insn = insn.append(loopbody);
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(43));
        insn = insn.append(Insn.create(29));
        insn = insn.append(Insn.create(46));
        insn = insn.append(Insn.create(182, this.pool.addMethodRef(this.className, delegateName, delegateSig)));
        insn = insn.append(new InsnIInc(3, 1));
        insn = insn.append(loopcheck);
        insn = insn.append(Insn.create(29));
        insn = insn.append(Insn.create(28));
        insn = insn.append(Insn.create(161, loopbody));
        insn = insn.append(Insn.create(177));
        CodeAttribute codeAttr = new CodeAttribute(this.getCodeAttributeUtf8(), 3, 4, begin, new ExceptionTable(), new AttributeVector());
        this.augmenter.addMethod(methodName, methodSig, accessFlags, codeAttr, exceptAttr);
    }

    public void addSunJDOClassForNameMethod() {
        InsnTarget end;
        String methodName = "sunjdo$classForName$";
        String methodSig = EnhancerConstants.SUNJDO_PC_sunjdoClassForName_Sig;
        int accessFlags = 28;
        ExceptionsAttribute exceptAttr = null;
        InsnTarget begin = new InsnTarget();
        Insn insn = begin;
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(184, this.pool.addMethodRef(JAVA_ClassConstants.JAVA_Class_Path, "forName", JAVA_ClassConstants.JAVA_Class_forName_Sig)));
        insn = insn.append(Insn.create(176));
        InsnTarget beginHandler = end = new InsnTarget();
        insn = insn.append(beginHandler);
        insn = insn.append(Insn.create(76));
        insn = insn.append(Insn.create(187, this.pool.addClass(JAVA_ClassConstants.JAVA_NoClassDefFoundError_Path)));
        insn = insn.append(Insn.create(89));
        insn = insn.append(Insn.create(43));
        insn = insn.append(Insn.create(182, this.pool.addMethodRef(JAVA_ClassConstants.JAVA_Throwable_Path, "getMessage", JAVA_ClassConstants.JAVA_Throwable_getMessage_Sig)));
        insn = insn.append(Insn.create(183, this.pool.addMethodRef(JAVA_ClassConstants.JAVA_NoClassDefFoundError_Path, JAVA_ClassConstants.JAVA_NoClassDefFoundError_NoClassDefFoundError_Name, JAVA_ClassConstants.JAVA_NoClassDefFoundError_NoClassDefFoundError_Sig)));
        insn = insn.append(Insn.create(191));
        ConstClass catchType = this.pool.addClass(JAVA_ClassConstants.JAVA_ClassNotFoundException_Path);
        ExceptionRange exceptionRange = new ExceptionRange(begin, end, beginHandler, catchType);
        ExceptionTable exceptionTable = new ExceptionTable();
        exceptionTable.addElement(exceptionRange);
        CodeAttribute codeAttr = new CodeAttribute(this.getCodeAttributeUtf8(), 3, 3, begin, exceptionTable, new AttributeVector());
        this.augmenter.addMethod("sunjdo$classForName$", methodSig, 28, codeAttr, exceptAttr);
    }

    public void addJDOGetManagedFieldCountMethod() {
        String methodName = "jdoGetManagedFieldCount";
        String methodSig = "()I";
        int accessFlags = 12;
        ExceptionsAttribute exceptAttr = null;
        int managedFieldCount = this.analyzer.getManagedFieldCount();
        Assertion.affirm(managedFieldCount >= 0);
        InsnTarget begin = new InsnTarget();
        Insn insn = begin;
        insn = insn.append(Insn.create(178, this.pool.addFieldRef(this.className, "jdoInheritedFieldCount", "I")));
        insn = insn.append(InsnUtils.integerConstant(managedFieldCount, this.pool));
        insn = insn.append(Insn.create(96));
        insn = insn.append(Insn.create(172));
        CodeAttribute codeAttr = new CodeAttribute(this.getCodeAttributeUtf8(), 2, 0, begin, new ExceptionTable(), new AttributeVector());
        this.augmenter.addMethod("jdoGetManagedFieldCount", "()I", 12, codeAttr, exceptAttr);
    }

    private Insn initJdoInheritedFieldCount(Insn insn) {
        Assertion.affirm(insn != null);
        boolean isPCRoot = this.analyzer.isAugmentableAsRoot();
        if (isPCRoot) {
            insn = insn.append(Insn.create(3));
        } else {
            ConstClass superConstClass = this.classFile.superName();
            Assertion.affirm(superConstClass != null);
            String superClassName = superConstClass.asString();
            Assertion.affirm(superClassName != null);
            insn = insn.append(Insn.create(184, this.pool.addMethodRef(superClassName, "jdoGetManagedFieldCount", "()I")));
        }
        insn = insn.append(Insn.create(179, this.pool.addFieldRef(this.className, "jdoInheritedFieldCount", "I")));
        Assertion.affirm(insn != null);
        return insn;
    }

    private Insn initJdoFieldNames(Insn insn) {
        Assertion.affirm(insn != null);
        int managedFieldCount = this.analyzer.getManagedFieldCount();
        String[] managedFieldNames = this.analyzer.getAnnotatedFieldNames();
        Assertion.affirm(managedFieldNames.length >= managedFieldCount);
        Assertion.affirm(NameHelper.elementPathForSig(JDO_PC_MemberConstants.JDO_PC_jdoFieldNames_Sig).equals(JAVA_ClassConstants.JAVA_String_Path));
        insn = insn.append(InsnUtils.integerConstant(managedFieldCount, this.pool));
        insn = insn.append(Insn.create(189, this.pool.addClass(JAVA_ClassConstants.JAVA_String_Path)));
        int i = 0;
        while (i < managedFieldCount) {
            insn = insn.append(Insn.create(89));
            insn = insn.append(InsnUtils.integerConstant(i, this.pool));
            String name = managedFieldNames[i];
            Assertion.affirm(name != null);
            insn = insn.append(InsnUtils.stringConstant(name, this.pool));
            insn = insn.append(Insn.create(83));
            ++i;
        }
        Assertion.affirm((insn = insn.append(Insn.create(179, this.getjdoFieldNamesFieldRef()))) != null);
        return insn;
    }

    private Insn initJdoFieldTypes(Insn insn) {
        Assertion.affirm(insn != null);
        int managedFieldCount = this.analyzer.getManagedFieldCount();
        String[] managedFieldSigs = this.analyzer.getAnnotatedFieldSigs();
        Assertion.affirm(managedFieldSigs.length >= managedFieldCount);
        Assertion.affirm(NameHelper.elementPathForSig(JDO_PC_MemberConstants.JDO_PC_jdoFieldTypes_Sig).equals(JAVA_ClassConstants.JAVA_Class_Path));
        insn = insn.append(InsnUtils.integerConstant(managedFieldCount, this.pool));
        insn = insn.append(Insn.create(189, this.pool.addClass(JAVA_ClassConstants.JAVA_Class_Path)));
        int i = 0;
        while (i < managedFieldCount) {
            insn = insn.append(Insn.create(89));
            insn = insn.append(InsnUtils.integerConstant(i, this.pool));
            String sig = managedFieldSigs[i];
            Assertion.affirm(sig != null && sig.length() > 0);
            switch (sig.charAt(0)) {
                case 'Z': {
                    insn = insn.append(Insn.create(178, this.pool.addFieldRef(JAVA_ClassConstants.JAVA_Boolean_Path, "TYPE", JAVA_ClassConstants.JAVA_Boolean_TYPE_Sig)));
                    break;
                }
                case 'C': {
                    insn = insn.append(Insn.create(178, this.pool.addFieldRef(JAVA_ClassConstants.JAVA_Character_Path, "TYPE", JAVA_ClassConstants.JAVA_Character_TYPE_Sig)));
                    break;
                }
                case 'B': {
                    insn = insn.append(Insn.create(178, this.pool.addFieldRef(JAVA_ClassConstants.JAVA_Byte_Path, "TYPE", JAVA_ClassConstants.JAVA_Byte_TYPE_Sig)));
                    break;
                }
                case 'S': {
                    insn = insn.append(Insn.create(178, this.pool.addFieldRef(JAVA_ClassConstants.JAVA_Short_Path, "TYPE", JAVA_ClassConstants.JAVA_Short_TYPE_Sig)));
                    break;
                }
                case 'I': {
                    insn = insn.append(Insn.create(178, this.pool.addFieldRef(JAVA_ClassConstants.JAVA_Integer_Path, "TYPE", JAVA_ClassConstants.JAVA_Integer_TYPE_Sig)));
                    break;
                }
                case 'J': {
                    insn = insn.append(Insn.create(178, this.pool.addFieldRef(JAVA_ClassConstants.JAVA_Long_Path, "TYPE", JAVA_ClassConstants.JAVA_Long_TYPE_Sig)));
                    break;
                }
                case 'F': {
                    insn = insn.append(Insn.create(178, this.pool.addFieldRef(JAVA_ClassConstants.JAVA_Float_Path, "TYPE", JAVA_ClassConstants.JAVA_Float_TYPE_Sig)));
                    break;
                }
                case 'D': {
                    insn = insn.append(Insn.create(178, this.pool.addFieldRef(JAVA_ClassConstants.JAVA_Double_Path, "TYPE", JAVA_ClassConstants.JAVA_Double_TYPE_Sig)));
                    break;
                }
                case 'L': {
                    insn = insn.append(InsnUtils.stringConstant(NameHelper.typeForSig(sig), this.pool));
                    insn = insn.append(Insn.create(184, this.pool.addMethodRef(this.className, "sunjdo$classForName$", EnhancerConstants.SUNJDO_PC_sunjdoClassForName_Sig)));
                    break;
                }
                case '[': {
                    insn = insn.append(InsnUtils.stringConstant(NameHelper.typeForPath(sig), this.pool));
                    insn = insn.append(Insn.create(184, this.pool.addMethodRef(this.className, "sunjdo$classForName$", EnhancerConstants.SUNJDO_PC_sunjdoClassForName_Sig)));
                    break;
                }
                default: {
                    Assertion.affirm(false, "Illegal field type: " + sig);
                }
            }
            insn = insn.append(Insn.create(83));
            ++i;
        }
        Assertion.affirm((insn = insn.append(Insn.create(179, this.getjdoFieldTypesFieldRef()))) != null);
        return insn;
    }

    private Insn initJdoFieldFlags(Insn insn) {
        Assertion.affirm(insn != null);
        int managedFieldCount = this.analyzer.getManagedFieldCount();
        int[] managedFieldFlags = this.analyzer.getAnnotatedFieldFlags();
        Assertion.affirm(managedFieldFlags.length >= managedFieldCount);
        Assertion.affirm(NameHelper.elementSigForSig("[B").equals("B"));
        insn = insn.append(InsnUtils.integerConstant(managedFieldCount, this.pool));
        insn = insn.append(Insn.create(188, 8));
        int i = 0;
        while (i < managedFieldCount) {
            insn = insn.append(Insn.create(89));
            insn = insn.append(InsnUtils.integerConstant(i, this.pool));
            int flags = managedFieldFlags[i];
            Assertion.affirm(-128 <= flags && flags < 128);
            insn = insn.append(InsnUtils.integerConstant(flags, this.pool));
            insn = insn.append(Insn.create(84));
            ++i;
        }
        Assertion.affirm((insn = insn.append(Insn.create(179, this.getjdoFieldFlagsFieldRef()))) != null);
        return insn;
    }

    private Insn initJdoPersistenceCapableSuperclass(Insn insn) {
        Assertion.affirm(insn != null);
        String pcSuperName = this.analyzer.getPCSuperClassName();
        String pcRootName = this.analyzer.getPCRootClassName();
        Assertion.affirm(pcSuperName == null || pcRootName != null);
        if (pcSuperName == null) {
            insn = insn.append(Insn.create(1));
        } else {
            insn = insn.append(InsnUtils.stringConstant(NameHelper.typeForPath(pcSuperName), this.pool));
            insn = insn.append(Insn.create(184, this.pool.addMethodRef(pcRootName, "sunjdo$classForName$", EnhancerConstants.SUNJDO_PC_sunjdoClassForName_Sig)));
        }
        insn = insn.append(Insn.create(179, this.getjdoPersistenceCapableSuperclassFieldRef()));
        Assertion.affirm(insn != null);
        return insn;
    }

    private Insn registerClass(Insn insn) {
        Assertion.affirm(insn != null);
        String pcRootName = this.analyzer.getPCRootClassName();
        insn = insn.append(InsnUtils.stringConstant(NameHelper.typeForPath(this.className), this.pool));
        insn = insn.append(Insn.create(184, this.pool.addMethodRef(pcRootName, "sunjdo$classForName$", EnhancerConstants.SUNJDO_PC_sunjdoClassForName_Sig)));
        insn = insn.append(Insn.create(178, this.getjdoFieldNamesFieldRef()));
        insn = insn.append(Insn.create(178, this.getjdoFieldTypesFieldRef()));
        insn = insn.append(Insn.create(178, this.getjdoFieldFlagsFieldRef()));
        insn = insn.append(Insn.create(178, this.getjdoPersistenceCapableSuperclassFieldRef()));
        if (this.classFile.isAbstract()) {
            insn = insn.append(Insn.create(1));
        } else {
            ConstClass thisConstClass = this.classFile.className();
            Assertion.affirm(thisConstClass != null);
            insn = insn.append(Insn.create(187, thisConstClass));
            insn = insn.append(Insn.create(89));
            insn = insn.append(Insn.create(183, this.pool.addMethodRef(this.className, NameHelper.constructorName(), NameHelper.constructorSig())));
        }
        insn = insn.append(Insn.create(184, this.pool.addMethodRef(JDO_ClassConstants.JDO_JDOImplHelper_Path, "registerClass", JDO_IH_MemberConstants.JDO_JDOImplHelper_registerClass_Sig)));
        Assertion.affirm(insn != null);
        return insn;
    }

    public void addStaticInitialization() {
        String methodName = "<clinit>";
        String methodSig = "()V";
        int accessFlags = 8;
        ExceptionsAttribute exceptAttr = null;
        InsnTarget begin = new InsnTarget();
        Insn insn = begin;
        insn = this.initJdoInheritedFieldCount(insn);
        insn = this.initJdoFieldNames(insn);
        insn = this.initJdoFieldTypes(insn);
        insn = this.initJdoFieldFlags(insn);
        insn = this.initJdoPersistenceCapableSuperclass(insn);
        insn = this.registerClass(insn);
        CodeAttribute codeAttr = new CodeAttribute(this.getCodeAttributeUtf8(), 7, 0, begin, new ExceptionTable(), new AttributeVector());
        if (this.analyzer.hasStaticInitializer()) {
            this.augmenter.prependMethod("<clinit>", "()V", 8, codeAttr, exceptAttr);
        } else {
            insn = insn.append(Insn.create(177));
            this.augmenter.addMethod("<clinit>", "()V", 8, codeAttr, exceptAttr);
        }
    }

    public void addJDONewInstanceMethod() {
        String methodName = "jdoNewInstance";
        String methodSig = JDO_PC_MemberConstants.JDO_PC_jdoNewInstance_Sig;
        boolean accessFlags = true;
        ExceptionsAttribute exceptAttr = null;
        InsnTarget begin = new InsnTarget();
        Insn insn = begin;
        ConstClass thisConstClass = this.classFile.className();
        Assertion.affirm(thisConstClass != null);
        insn = insn.append(Insn.create(187, thisConstClass));
        insn = insn.append(Insn.create(89));
        insn = insn.append(Insn.create(183, this.pool.addMethodRef(this.className, NameHelper.constructorName(), NameHelper.constructorSig())));
        insn = insn.append(Insn.create(77));
        insn = insn.append(Insn.create(44));
        insn = insn.append(Insn.create(4));
        insn = insn.append(Insn.create(181, this.getjdoFlagsFieldRef()));
        insn = insn.append(Insn.create(44));
        insn = insn.append(Insn.create(43));
        insn = insn.append(Insn.create(181, this.getjdoStateManagerFieldRef()));
        insn = insn.append(Insn.create(44));
        insn = insn.append(Insn.create(176));
        CodeAttribute codeAttr = new CodeAttribute(this.getCodeAttributeUtf8(), 2, 3, begin, new ExceptionTable(), new AttributeVector());
        this.augmenter.addMethod("jdoNewInstance", methodSig, 1, codeAttr, exceptAttr);
    }

    public void addJDONewInstanceOidMethod() {
        String methodName = "jdoNewInstance";
        String methodSig = JDO_PC_MemberConstants.JDO_PC_jdoNewInstance_Object_Sig;
        boolean accessFlags = true;
        ExceptionsAttribute exceptAttr = null;
        InsnTarget begin = new InsnTarget();
        Insn insn = begin;
        ConstClass thisConstClass = this.classFile.className();
        Assertion.affirm(thisConstClass != null);
        insn = insn.append(Insn.create(187, thisConstClass));
        insn = insn.append(Insn.create(89));
        insn = insn.append(Insn.create(183, this.pool.addMethodRef(this.className, NameHelper.constructorName(), NameHelper.constructorSig())));
        insn = insn.append(Insn.create(78));
        String pcKeyOwnerClassName = this.analyzer.getPCKeyOwnerClassName();
        Assertion.affirm(pcKeyOwnerClassName != null);
        insn = insn.append(Insn.create(45));
        insn = insn.append(Insn.create(44));
        insn = insn.append(Insn.create(182, this.pool.addMethodRef(pcKeyOwnerClassName, "jdoCopyKeyFieldsFromObjectId", JDO_PC_MemberConstants.JDO_PC_jdoCopyKeyFieldsFromObjectId_Sig)));
        insn = insn.append(Insn.create(45));
        insn = insn.append(Insn.create(4));
        insn = insn.append(Insn.create(181, this.getjdoFlagsFieldRef()));
        insn = insn.append(Insn.create(45));
        insn = insn.append(Insn.create(43));
        insn = insn.append(Insn.create(181, this.getjdoStateManagerFieldRef()));
        insn = insn.append(Insn.create(45));
        insn = insn.append(Insn.create(176));
        CodeAttribute codeAttr = new CodeAttribute(this.getCodeAttributeUtf8(), 2, 4, begin, new ExceptionTable(), new AttributeVector());
        this.augmenter.addMethod("jdoNewInstance", methodSig, 1, codeAttr, exceptAttr);
    }

    private Insn appendBeginProvideReplaceField(Insn insn) {
        Assertion.affirm(insn != null);
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(180, this.getjdoStateManagerFieldRef()));
        insn = insn.append(Insn.create(77));
        insn = insn.append(Insn.create(27));
        insn = insn.append(Insn.create(178, this.pool.addFieldRef(this.className, "jdoInheritedFieldCount", "I")));
        insn = insn.append(Insn.create(100));
        Assertion.affirm(insn != null);
        return insn;
    }

    private Insn appendEndProvideReplaceField(Insn insn, String provideReplaceField_Name, String provideReplaceField_Sig) {
        Assertion.affirm(insn != null);
        Assertion.affirm(provideReplaceField_Name);
        Assertion.affirm(provideReplaceField_Sig);
        boolean isPCRoot = this.analyzer.isAugmentableAsRoot();
        if (isPCRoot) {
            insn = this.appendThrowJavaException(insn, JAVA_ClassConstants.JAVA_IllegalArgumentException_Path, "arg1");
        } else {
            ConstClass superConstClass = this.classFile.superName();
            Assertion.affirm(superConstClass != null);
            String superClassName = superConstClass.asString();
            Assertion.affirm(superClassName != null);
            insn = insn.append(Insn.create(42));
            insn = insn.append(Insn.create(27));
            insn = insn.append(Insn.create(183, this.pool.addMethodRef(superClassName, provideReplaceField_Name, provideReplaceField_Sig)));
            insn = insn.append(Insn.create(177));
        }
        Assertion.affirm(insn != null);
        return insn;
    }

    private Insn appendCaseBranchForProvideField(Insn insn, String providedXXXField_Name, String providedXXXField_Sig, ConstFieldRef managedFieldRef) {
        Assertion.affirm(insn != null);
        Assertion.affirm(providedXXXField_Name != null);
        Assertion.affirm(providedXXXField_Sig != null);
        Assertion.affirm(managedFieldRef != null);
        insn = this.appendCheckVarNonNull(insn, 2, JAVA_ClassConstants.JAVA_IllegalStateException_Path, "arg0.jdoStateManager");
        insn = insn.append(Insn.create(44));
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(27));
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(180, managedFieldRef));
        insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef(JDO_ClassConstants.JDO_StateManager_Path, providedXXXField_Name, providedXXXField_Sig), Builder.countMethodArgWords(providedXXXField_Sig)));
        insn = insn.append(Insn.create(177));
        Assertion.affirm(insn != null);
        return insn;
    }

    private Insn appendSwitchForProvideField(Insn insn, SizeHolder sizeHolder) {
        Assertion.affirm(insn != null);
        Assertion.affirm(sizeHolder != null);
        int managedFieldCount = this.analyzer.getManagedFieldCount();
        String[] managedFieldSigs = this.analyzer.getAnnotatedFieldSigs();
        ConstFieldRef[] managedFieldRefs = this.getAnnotatedFieldRefs();
        Assertion.affirm(managedFieldSigs.length >= managedFieldCount);
        Assertion.affirm(managedFieldRefs.length >= managedFieldCount);
        boolean lowOp = false;
        InsnTarget defaultOp = new InsnTarget();
        InsnTarget[] targetsOp = new InsnTarget[managedFieldCount];
        int i = 0;
        while (i < managedFieldCount) {
            targetsOp[i] = new InsnTarget();
            ++i;
        }
        if (managedFieldCount <= 1) {
            int[] nArray;
            if (managedFieldCount == 0) {
                nArray = new int[]{};
            } else {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            }
            int[] matchesOp = nArray;
            insn = insn.append(new InsnLookupSwitch(defaultOp, matchesOp, targetsOp));
        } else {
            insn = insn.append(new InsnTableSwitch(0, defaultOp, targetsOp));
        }
        int i2 = 0;
        while (i2 < managedFieldCount) {
            insn = insn.append(targetsOp[i2]);
            String sig = managedFieldSigs[i2];
            ConstFieldRef ref = managedFieldRefs[i2];
            Assertion.affirm(sig != null && sig.length() > 0);
            Assertion.affirm(ref != null);
            sizeHolder.size = Builder.max(sizeHolder.size, Descriptor.countFieldWords(sig));
            switch (sig.charAt(0)) {
                case 'Z': {
                    insn = this.appendCaseBranchForProvideField(insn, "providedBooleanField", JDO_SM_MemberConstants.JDO_SM_providedBooleanField_Sig, ref);
                    break;
                }
                case 'C': {
                    insn = this.appendCaseBranchForProvideField(insn, "providedCharField", JDO_SM_MemberConstants.JDO_SM_providedCharField_Sig, ref);
                    break;
                }
                case 'B': {
                    insn = this.appendCaseBranchForProvideField(insn, "providedByteField", JDO_SM_MemberConstants.JDO_SM_providedByteField_Sig, ref);
                    break;
                }
                case 'S': {
                    insn = this.appendCaseBranchForProvideField(insn, "providedShortField", JDO_SM_MemberConstants.JDO_SM_providedShortField_Sig, ref);
                    break;
                }
                case 'I': {
                    insn = this.appendCaseBranchForProvideField(insn, "providedIntField", JDO_SM_MemberConstants.JDO_SM_providedIntField_Sig, ref);
                    break;
                }
                case 'J': {
                    insn = this.appendCaseBranchForProvideField(insn, "providedLongField", JDO_SM_MemberConstants.JDO_SM_providedLongField_Sig, ref);
                    break;
                }
                case 'F': {
                    insn = this.appendCaseBranchForProvideField(insn, "providedFloatField", JDO_SM_MemberConstants.JDO_SM_providedFloatField_Sig, ref);
                    break;
                }
                case 'D': {
                    insn = this.appendCaseBranchForProvideField(insn, "providedDoubleField", JDO_SM_MemberConstants.JDO_SM_providedDoubleField_Sig, ref);
                    break;
                }
                case 'L': 
                case '[': {
                    if (sig.equals(JAVA_ClassConstants.JAVA_String_Sig)) {
                        insn = this.appendCaseBranchForProvideField(insn, "providedStringField", JDO_SM_MemberConstants.JDO_SM_providedStringField_Sig, ref);
                        break;
                    }
                    insn = this.appendCaseBranchForProvideField(insn, "providedObjectField", JDO_SM_MemberConstants.JDO_SM_providedObjectField_Sig, ref);
                    break;
                }
                default: {
                    Assertion.affirm(false, "Illegal field type: " + sig);
                }
            }
            ++i2;
        }
        Assertion.affirm((insn = insn.append(defaultOp)) != null);
        return insn;
    }

    public void addJDOProvideFieldMethod() {
        String methodName = "jdoProvideField";
        String methodSig = "(I)V";
        boolean accessFlags = true;
        ExceptionsAttribute exceptAttr = null;
        InsnTarget begin = new InsnTarget();
        Insn insn = begin;
        insn = this.appendBeginProvideReplaceField(insn);
        SizeHolder sizeHolder = new SizeHolder();
        insn = this.appendSwitchForProvideField(insn, sizeHolder);
        Assertion.affirm((insn = this.appendEndProvideReplaceField(insn, "jdoProvideField", "(I)V")).opcode() == 191 || insn.opcode() == 177);
        Assertion.affirm(0 <= sizeHolder.size && sizeHolder.size <= 2);
        int maxStack = sizeHolder.size == 0 ? 3 : (sizeHolder.size == 1 ? 4 : 5);
        CodeAttribute codeAttr = new CodeAttribute(this.getCodeAttributeUtf8(), maxStack, 3, begin, new ExceptionTable(), new AttributeVector());
        this.augmenter.addMethod("jdoProvideField", "(I)V", 1, codeAttr, exceptAttr);
    }

    private Insn appendCaseBranchForReplaceField(Insn insn, String replacingXXXField_Name, String replacingXXXField_Sig, ConstFieldRef managedFieldRef, String managedFieldSig) {
        Assertion.affirm(insn != null);
        Assertion.affirm(replacingXXXField_Name != null);
        Assertion.affirm(replacingXXXField_Sig != null);
        Assertion.affirm(managedFieldRef != null);
        Assertion.affirm(managedFieldSig != null);
        insn = this.appendCheckVarNonNull(insn, 2, JAVA_ClassConstants.JAVA_IllegalStateException_Path, "arg0.jdoStateManager");
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(44));
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(27));
        insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef(JDO_ClassConstants.JDO_StateManager_Path, replacingXXXField_Name, replacingXXXField_Sig), Builder.countMethodArgWords(replacingXXXField_Sig)));
        if (replacingXXXField_Name.equals("replacingObjectField")) {
            String fieldType = NameHelper.pathForSig(managedFieldSig);
            insn = insn.append(Insn.create(192, this.pool.addClass(fieldType)));
        }
        insn = insn.append(Insn.create(181, managedFieldRef));
        Assertion.affirm((insn = insn.append(Insn.create(177))) != null);
        return insn;
    }

    private Insn appendSwitchForReplaceField(Insn insn, SizeHolder sizeHolder) {
        Assertion.affirm(insn != null);
        Assertion.affirm(sizeHolder != null);
        int managedFieldCount = this.analyzer.getManagedFieldCount();
        String[] managedFieldSigs = this.analyzer.getAnnotatedFieldSigs();
        ConstFieldRef[] managedFieldRefs = this.getAnnotatedFieldRefs();
        Assertion.affirm(managedFieldSigs.length >= managedFieldCount);
        Assertion.affirm(managedFieldRefs.length >= managedFieldCount);
        boolean lowOp = false;
        InsnTarget defaultOp = new InsnTarget();
        InsnTarget[] targetsOp = new InsnTarget[managedFieldCount];
        int i = 0;
        while (i < managedFieldCount) {
            targetsOp[i] = new InsnTarget();
            ++i;
        }
        if (managedFieldCount <= 1) {
            int[] nArray;
            if (managedFieldCount == 0) {
                nArray = new int[]{};
            } else {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            }
            int[] matchesOp = nArray;
            insn = insn.append(new InsnLookupSwitch(defaultOp, matchesOp, targetsOp));
        } else {
            insn = insn.append(new InsnTableSwitch(0, defaultOp, targetsOp));
        }
        int i2 = 0;
        while (i2 < managedFieldCount) {
            insn = insn.append(targetsOp[i2]);
            String sig = managedFieldSigs[i2];
            ConstFieldRef ref = managedFieldRefs[i2];
            Assertion.affirm(sig != null && sig.length() > 0);
            Assertion.affirm(ref != null);
            sizeHolder.size = Builder.max(sizeHolder.size, Descriptor.countFieldWords(sig));
            switch (sig.charAt(0)) {
                case 'Z': {
                    insn = this.appendCaseBranchForReplaceField(insn, "replacingBooleanField", JDO_SM_MemberConstants.JDO_SM_replacingBooleanField_Sig, ref, sig);
                    break;
                }
                case 'C': {
                    insn = this.appendCaseBranchForReplaceField(insn, "replacingCharField", JDO_SM_MemberConstants.JDO_SM_replacingCharField_Sig, ref, sig);
                    break;
                }
                case 'B': {
                    insn = this.appendCaseBranchForReplaceField(insn, "replacingByteField", JDO_SM_MemberConstants.JDO_SM_replacingByteField_Sig, ref, sig);
                    break;
                }
                case 'S': {
                    insn = this.appendCaseBranchForReplaceField(insn, "replacingShortField", JDO_SM_MemberConstants.JDO_SM_replacingShortField_Sig, ref, sig);
                    break;
                }
                case 'I': {
                    insn = this.appendCaseBranchForReplaceField(insn, "replacingIntField", JDO_SM_MemberConstants.JDO_SM_replacingIntField_Sig, ref, sig);
                    break;
                }
                case 'J': {
                    insn = this.appendCaseBranchForReplaceField(insn, "replacingLongField", JDO_SM_MemberConstants.JDO_SM_replacingLongField_Sig, ref, sig);
                    break;
                }
                case 'F': {
                    insn = this.appendCaseBranchForReplaceField(insn, "replacingFloatField", JDO_SM_MemberConstants.JDO_SM_replacingFloatField_Sig, ref, sig);
                    break;
                }
                case 'D': {
                    insn = this.appendCaseBranchForReplaceField(insn, "replacingDoubleField", JDO_SM_MemberConstants.JDO_SM_replacingDoubleField_Sig, ref, sig);
                    break;
                }
                case 'L': 
                case '[': {
                    if (sig.equals(JAVA_ClassConstants.JAVA_String_Sig)) {
                        insn = this.appendCaseBranchForReplaceField(insn, "replacingStringField", JDO_SM_MemberConstants.JDO_SM_replacingStringField_Sig, ref, sig);
                        break;
                    }
                    insn = this.appendCaseBranchForReplaceField(insn, "replacingObjectField", JDO_SM_MemberConstants.JDO_SM_replacingObjectField_Sig, ref, sig);
                    break;
                }
                default: {
                    Assertion.affirm(false, "Illegal field type: " + sig);
                }
            }
            ++i2;
        }
        Assertion.affirm((insn = insn.append(defaultOp)) != null);
        return insn;
    }

    public void addJDOReplaceFieldMethod() {
        String methodName = "jdoReplaceField";
        String methodSig = "(I)V";
        boolean accessFlags = true;
        ExceptionsAttribute exceptAttr = null;
        InsnTarget begin = new InsnTarget();
        Insn insn = begin;
        insn = this.appendBeginProvideReplaceField(insn);
        SizeHolder sizeHolder = new SizeHolder();
        insn = this.appendSwitchForReplaceField(insn, sizeHolder);
        Assertion.affirm((insn = this.appendEndProvideReplaceField(insn, "jdoReplaceField", "(I)V")).opcode() == 191 || insn.opcode() == 177);
        Assertion.affirm(0 <= sizeHolder.size && sizeHolder.size <= 2);
        int maxStack = sizeHolder.size == 0 ? 3 : 4;
        CodeAttribute codeAttr = new CodeAttribute(this.getCodeAttributeUtf8(), maxStack, 3, begin, new ExceptionTable(), new AttributeVector());
        this.augmenter.addMethod("jdoReplaceField", "(I)V", 1, codeAttr, exceptAttr);
    }

    private Insn appendBeginCopyField(Insn insn) {
        Assertion.affirm(insn != null);
        insn = insn.append(Insn.create(28));
        insn = insn.append(Insn.create(178, this.pool.addFieldRef(this.className, "jdoInheritedFieldCount", "I")));
        insn = insn.append(Insn.create(100));
        Assertion.affirm(insn != null);
        return insn;
    }

    private Insn appendEndCopyField(Insn insn) {
        Assertion.affirm(insn != null);
        boolean isPCRoot = this.analyzer.isAugmentableAsRoot();
        if (isPCRoot) {
            insn = this.appendThrowJavaException(insn, JAVA_ClassConstants.JAVA_IllegalArgumentException_Path, "arg2");
        } else {
            String superClassName = this.analyzer.getPCSuperClassName();
            Assertion.affirm(superClassName != null);
            String jdo_PC_jdoCopyField_Sig = JDONameHelper.getJDO_PC_jdoCopyField_Sig(superClassName);
            insn = insn.append(Insn.create(42));
            insn = insn.append(Insn.create(43));
            insn = insn.append(Insn.create(28));
            insn = insn.append(Insn.create(183, this.pool.addMethodRef(superClassName, "jdoCopyField", jdo_PC_jdoCopyField_Sig)));
            insn = insn.append(Insn.create(177));
        }
        Assertion.affirm(insn != null);
        return insn;
    }

    private Insn appendCaseBranchForCopyField(Insn insn, ConstFieldRef managedFieldRef) {
        Assertion.affirm(insn != null);
        Assertion.affirm(managedFieldRef != null);
        insn = this.appendCheckVarNonNull(insn, 1, JAVA_ClassConstants.JAVA_IllegalArgumentException_Path, "arg1");
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(43));
        insn = insn.append(Insn.create(180, managedFieldRef));
        insn = insn.append(Insn.create(181, managedFieldRef));
        insn = insn.append(Insn.create(177));
        Assertion.affirm(insn != null);
        return insn;
    }

    private Insn appendSwitchForCopyField(Insn insn) {
        Assertion.affirm(insn != null);
        int managedFieldCount = this.analyzer.getManagedFieldCount();
        String[] managedFieldSigs = this.analyzer.getAnnotatedFieldSigs();
        ConstFieldRef[] managedFieldRefs = this.getAnnotatedFieldRefs();
        Assertion.affirm(managedFieldSigs.length >= managedFieldCount);
        Assertion.affirm(managedFieldRefs.length >= managedFieldCount);
        boolean lowOp = false;
        InsnTarget defaultOp = new InsnTarget();
        InsnTarget[] targetsOp = new InsnTarget[managedFieldCount];
        int i = 0;
        while (i < managedFieldCount) {
            targetsOp[i] = new InsnTarget();
            ++i;
        }
        if (managedFieldCount <= 1) {
            int[] nArray;
            if (managedFieldCount == 0) {
                nArray = new int[]{};
            } else {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            }
            int[] matchesOp = nArray;
            insn = insn.append(new InsnLookupSwitch(defaultOp, matchesOp, targetsOp));
        } else {
            insn = insn.append(new InsnTableSwitch(0, defaultOp, targetsOp));
        }
        int i2 = 0;
        while (i2 < managedFieldCount) {
            insn = insn.append(targetsOp[i2]);
            String sig = managedFieldSigs[i2];
            ConstFieldRef ref = managedFieldRefs[i2];
            Assertion.affirm(sig != null && sig.length() > 0);
            Assertion.affirm(ref != null);
            switch (sig.charAt(0)) {
                case 'Z': {
                    insn = this.appendCaseBranchForCopyField(insn, ref);
                    break;
                }
                case 'C': {
                    insn = this.appendCaseBranchForCopyField(insn, ref);
                    break;
                }
                case 'B': {
                    insn = this.appendCaseBranchForCopyField(insn, ref);
                    break;
                }
                case 'S': {
                    insn = this.appendCaseBranchForCopyField(insn, ref);
                    break;
                }
                case 'I': {
                    insn = this.appendCaseBranchForCopyField(insn, ref);
                    break;
                }
                case 'J': {
                    insn = this.appendCaseBranchForCopyField(insn, ref);
                    break;
                }
                case 'F': {
                    insn = this.appendCaseBranchForCopyField(insn, ref);
                    break;
                }
                case 'D': {
                    insn = this.appendCaseBranchForCopyField(insn, ref);
                    break;
                }
                case 'L': 
                case '[': {
                    insn = this.appendCaseBranchForCopyField(insn, ref);
                    break;
                }
                default: {
                    Assertion.affirm(false, "Illegal field type: " + sig);
                }
            }
            ++i2;
        }
        Assertion.affirm((insn = insn.append(defaultOp)) != null);
        return insn;
    }

    public void addJDOCopyFieldMethod() {
        String methodName = "jdoCopyField";
        String methodSig = JDONameHelper.getJDO_PC_jdoCopyField_Sig(this.className);
        int accessFlags = 20;
        ExceptionsAttribute exceptAttr = null;
        InsnTarget begin = new InsnTarget();
        Insn insn = begin;
        insn = this.appendBeginCopyField(insn);
        insn = this.appendSwitchForCopyField(insn);
        Assertion.affirm((insn = this.appendEndCopyField(insn)).opcode() == 191 || insn.opcode() == 177);
        CodeAttribute codeAttr = new CodeAttribute(this.getCodeAttributeUtf8(), 3, 3, begin, new ExceptionTable(), new AttributeVector());
        this.augmenter.addMethod("jdoCopyField", methodSig, 20, codeAttr, exceptAttr);
    }

    public void addJDOCopyFieldsMethod() {
        String methodName = "jdoCopyFields";
        String methodSig = JDO_PC_MemberConstants.JDO_PC_jdoCopyFields_Sig;
        boolean accessFlags = true;
        ExceptionsAttribute exceptAttr = null;
        InsnTarget begin = new InsnTarget();
        Insn insn = begin;
        insn = this.appendCheckStateManager(insn, 0, JAVA_ClassConstants.JAVA_IllegalStateException_Path, "arg0.jdoStateManager");
        ConstClass thisConstClass = this.classFile.className();
        Assertion.affirm(thisConstClass != null);
        insn = this.appendCheckVarInstanceOf(insn, 1, thisConstClass, JAVA_ClassConstants.JAVA_IllegalArgumentException_Path, "arg1");
        insn = this.appendCheckVarNonNull(insn, 2, JAVA_ClassConstants.JAVA_IllegalArgumentException_Path, "arg2");
        insn = insn.append(Insn.create(43));
        insn = insn.append(Insn.create(192, thisConstClass));
        insn = insn.append(Insn.create(78));
        InsnTarget endcheck = new InsnTarget();
        insn = insn.append(Insn.create(45));
        insn = insn.append(Insn.create(180, this.getjdoStateManagerFieldRef()));
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(180, this.getjdoStateManagerFieldRef()));
        insn = insn.append(Insn.create(165, endcheck));
        insn = this.appendThrowJavaException(insn, JAVA_ClassConstants.JAVA_IllegalArgumentException_Path, "arg1.jdoStateManager");
        insn = insn.append(endcheck);
        insn = insn.append(Insn.create(44));
        insn = insn.append(Insn.create(190));
        insn = insn.append(Insn.create(54, 4));
        InsnTarget loopcheck = new InsnTarget();
        insn = insn.append(Insn.create(3));
        insn = insn.append(Insn.create(54, 5));
        insn = insn.append(Insn.create(167, loopcheck));
        InsnTarget loopbody = new InsnTarget();
        insn = insn.append(loopbody);
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(45));
        insn = insn.append(Insn.create(44));
        insn = insn.append(Insn.create(21, 5));
        insn = insn.append(Insn.create(46));
        String delegateName = "jdoCopyField";
        String delegateSig = JDONameHelper.getJDO_PC_jdoCopyField_Sig(this.className);
        insn = insn.append(Insn.create(182, this.pool.addMethodRef(this.className, "jdoCopyField", delegateSig)));
        insn = insn.append(new InsnIInc(5, 1));
        insn = insn.append(loopcheck);
        insn = insn.append(Insn.create(21, 5));
        insn = insn.append(Insn.create(21, 4));
        insn = insn.append(Insn.create(161, loopbody));
        insn = insn.append(Insn.create(177));
        CodeAttribute codeAttr = new CodeAttribute(this.getCodeAttributeUtf8(), 4, 6, begin, new ExceptionTable(), new AttributeVector());
        this.augmenter.addMethod("jdoCopyFields", methodSig, 1, codeAttr, exceptAttr);
    }

    public void addJDONewObjectIdInstanceMethod() {
        String methodName = "jdoNewObjectIdInstance";
        String methodSig = JDO_PC_MemberConstants.JDO_PC_jdoNewObjectIdInstance_Sig;
        boolean accessFlags = true;
        ExceptionsAttribute exceptAttr = null;
        InsnTarget begin = new InsnTarget();
        Insn insn = begin;
        String keyClassName = this.analyzer.getKeyClassName();
        if (keyClassName == null) {
            insn = insn.append(Insn.create(1));
            insn = insn.append(Insn.create(176));
            CodeAttribute codeAttr = new CodeAttribute(this.getCodeAttributeUtf8(), 1, 1, begin, new ExceptionTable(), new AttributeVector());
            this.augmenter.addMethod("jdoNewObjectIdInstance", methodSig, 1, codeAttr, exceptAttr);
            return;
        }
        Assertion.affirm(keyClassName != null);
        insn = insn.append(Insn.create(187, this.pool.addClass(keyClassName)));
        insn = insn.append(Insn.create(89));
        insn = insn.append(Insn.create(183, this.pool.addMethodRef(keyClassName, NameHelper.constructorName(), NameHelper.constructorSig())));
        insn = insn.append(Insn.create(176));
        CodeAttribute codeAttr = new CodeAttribute(this.getCodeAttributeUtf8(), 2, 1, begin, new ExceptionTable(), new AttributeVector());
        this.augmenter.addMethod("jdoNewObjectIdInstance", methodSig, 1, codeAttr, exceptAttr);
    }

    public void addJDONewObjectIdInstanceStringMethod() {
        String methodName = "jdoNewObjectIdInstance";
        String methodSig = JDO_PC_MemberConstants.JDO_PC_jdoNewObjectIdInstance_String_Sig;
        boolean accessFlags = true;
        ExceptionsAttribute exceptAttr = null;
        InsnTarget begin = new InsnTarget();
        Insn insn = begin;
        String keyClassName = this.analyzer.getKeyClassName();
        if (keyClassName == null) {
            insn = insn.append(Insn.create(1));
            insn = insn.append(Insn.create(176));
            CodeAttribute codeAttr = new CodeAttribute(this.getCodeAttributeUtf8(), 1, 2, begin, new ExceptionTable(), new AttributeVector());
            this.augmenter.addMethod("jdoNewObjectIdInstance", methodSig, 1, codeAttr, exceptAttr);
            return;
        }
        Assertion.affirm(keyClassName != null);
        insn = insn.append(Insn.create(187, this.pool.addClass(keyClassName)));
        insn = insn.append(Insn.create(89));
        insn = insn.append(Insn.create(43));
        insn = insn.append(Insn.create(183, this.pool.addMethodRef(keyClassName, NameHelper.constructorName(), NameHelper.constructorSig(JAVA_ClassConstants.JAVA_String_Sig))));
        insn = insn.append(Insn.create(176));
        CodeAttribute codeAttr = new CodeAttribute(this.getCodeAttributeUtf8(), 3, 2, begin, new ExceptionTable(), new AttributeVector());
        this.augmenter.addMethod("jdoNewObjectIdInstance", methodSig, 1, codeAttr, exceptAttr);
    }

    public void addJDOCopyKeyFieldsToObjectIdMethod() {
        this.addJDOCopyKeyFieldsToFromObjectIdMethod(true);
    }

    public void addJDOCopyKeyFieldsFromObjectIdMethod() {
        this.addJDOCopyKeyFieldsToFromObjectIdMethod(false);
    }

    private void addJDOCopyKeyFieldsToFromObjectIdMethod(boolean isToOid) {
        int accessFlags;
        String methodSig;
        String methodName;
        if (isToOid) {
            methodName = "jdoCopyKeyFieldsToObjectId";
            methodSig = JDO_PC_MemberConstants.JDO_PC_jdoCopyKeyFieldsToObjectId_Sig;
            accessFlags = 1;
        } else {
            methodName = "jdoCopyKeyFieldsFromObjectId";
            methodSig = JDO_PC_MemberConstants.JDO_PC_jdoCopyKeyFieldsFromObjectId_Sig;
            accessFlags = 4;
        }
        ExceptionsAttribute exceptAttr = null;
        InsnTarget begin = new InsnTarget();
        Insn insn = begin;
        String keyClassName = this.analyzer.getKeyClassName();
        if (keyClassName == null) {
            insn = insn.append(Insn.create(177));
            CodeAttribute codeAttr = new CodeAttribute(this.getCodeAttributeUtf8(), 0, 2, begin, new ExceptionTable(), new AttributeVector());
            this.augmenter.addMethod(methodName, methodSig, accessFlags, codeAttr, exceptAttr);
            return;
        }
        Assertion.affirm(keyClassName != null);
        ConstClass keyConstClass = this.pool.addClass(keyClassName);
        Assertion.affirm(keyConstClass != null);
        insn = this.appendCheckVarInstanceOf(insn, 1, keyConstClass, JAVA_ClassConstants.JAVA_IllegalArgumentException_Path, "arg1");
        insn = insn.append(Insn.create(43));
        insn = insn.append(Insn.create(192, keyConstClass));
        insn = insn.append(Insn.create(77));
        boolean isPCRoot = this.analyzer.isAugmentableAsRoot();
        if (!isPCRoot) {
            String superClassName = this.analyzer.getPCSuperKeyOwnerClassName();
            Assertion.affirm(superClassName != null);
            insn = insn.append(Insn.create(42));
            insn = insn.append(Insn.create(44));
            insn = insn.append(Insn.create(183, this.pool.addMethodRef(superClassName, methodName, methodSig)));
        }
        int keyFieldCount = this.analyzer.getKeyFieldCount();
        ConstFieldRef[] keyFieldRefs = this.getKeyFieldRefs();
        ConstFieldRef[] keyClassKeyFieldRefs = this.getKeyClassKeyFieldRefs();
        Assertion.affirm(keyFieldRefs.length == keyFieldCount);
        Assertion.affirm(keyClassKeyFieldRefs.length == keyFieldCount);
        int maxFieldSize = 0;
        int i = 0;
        while (i < keyFieldCount) {
            ConstFieldRef thisClassKeyRef = keyFieldRefs[i];
            ConstFieldRef keyClassKeyRef = keyClassKeyFieldRefs[i];
            Assertion.affirm(thisClassKeyRef != null);
            Assertion.affirm(keyClassKeyRef != null);
            if (isToOid) {
                insn = insn.append(Insn.create(44));
                insn = insn.append(Insn.create(42));
                insn = insn.append(Insn.create(180, thisClassKeyRef));
                insn = insn.append(Insn.create(181, keyClassKeyRef));
            } else {
                insn = insn.append(Insn.create(42));
                insn = insn.append(Insn.create(44));
                insn = insn.append(Insn.create(180, keyClassKeyRef));
                insn = insn.append(Insn.create(181, thisClassKeyRef));
            }
            String sig = thisClassKeyRef.nameAndType().signature().asString();
            Assertion.affirm(sig != null && sig.length() > 0);
            maxFieldSize = Builder.max(maxFieldSize, Descriptor.countFieldWords(sig));
            ++i;
        }
        insn = insn.append(Insn.create(177));
        CodeAttribute codeAttr = new CodeAttribute(this.getCodeAttributeUtf8(), Builder.max(maxFieldSize + 1, 3), 3, begin, new ExceptionTable(), new AttributeVector());
        this.augmenter.addMethod(methodName, methodSig, accessFlags, codeAttr, exceptAttr);
    }

    private Insn appendCopyKeyFieldToOid(Insn insn, String fetchXXXField_Name, String fetchXXXField_Sig, int keyFieldNo, ConstFieldRef keyFieldRef, String keyFieldSig) {
        Assertion.affirm(insn != null);
        Assertion.affirm(fetchXXXField_Name != null);
        Assertion.affirm(fetchXXXField_Sig != null);
        Assertion.affirm(keyFieldNo >= 0);
        Assertion.affirm(keyFieldRef != null);
        insn = insn.append(Insn.create(45));
        insn = insn.append(Insn.create(43));
        insn = insn.append(Insn.create(178, this.pool.addFieldRef(this.className, "jdoInheritedFieldCount", "I")));
        insn = insn.append(InsnUtils.integerConstant(keyFieldNo, this.pool));
        insn = insn.append(Insn.create(96));
        insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef(JDO_ClassConstants.JDO_ObjectIdFieldSupplier_Path, fetchXXXField_Name, fetchXXXField_Sig), Builder.countMethodArgWords(fetchXXXField_Sig)));
        if (fetchXXXField_Name.equals("fetchObjectField") && !keyFieldSig.equals(JAVA_ClassConstants.JAVA_Object_Sig)) {
            String fieldType = NameHelper.pathForSig(keyFieldSig);
            insn = insn.append(Insn.create(192, this.pool.addClass(fieldType)));
        }
        Assertion.affirm((insn = insn.append(Insn.create(181, keyFieldRef))) != null);
        return insn;
    }

    private Insn appendStatementsForCopyKeyFieldsToOid(Insn insn, SizeHolder sizeHolder) {
        Assertion.affirm(insn != null);
        Assertion.affirm(sizeHolder != null);
        int keyFieldCount = this.analyzer.getKeyFieldCount();
        ConstFieldRef[] keyFieldRefs = this.getKeyClassKeyFieldRefs();
        int[] keyFieldIndexes = this.analyzer.getKeyFieldIndexes();
        Assertion.affirm(keyFieldRefs.length == keyFieldCount);
        Assertion.affirm(keyFieldIndexes.length == keyFieldCount);
        int i = 0;
        while (i < keyFieldCount) {
            int no = keyFieldIndexes[i];
            ConstFieldRef ref = keyFieldRefs[i];
            Assertion.affirm(ref != null);
            String sig = ref.nameAndType().signature().asString();
            Assertion.affirm(sig != null && sig.length() > 0);
            sizeHolder.size = Builder.max(sizeHolder.size, Descriptor.countFieldWords(sig));
            switch (sig.charAt(0)) {
                case 'Z': {
                    insn = this.appendCopyKeyFieldToOid(insn, "fetchBooleanField", "(I)Z", no, ref, sig);
                    break;
                }
                case 'C': {
                    insn = this.appendCopyKeyFieldToOid(insn, "fetchCharField", "(I)C", no, ref, sig);
                    break;
                }
                case 'B': {
                    insn = this.appendCopyKeyFieldToOid(insn, "fetchByteField", "(I)B", no, ref, sig);
                    break;
                }
                case 'S': {
                    insn = this.appendCopyKeyFieldToOid(insn, "fetchShortField", "(I)S", no, ref, sig);
                    break;
                }
                case 'I': {
                    insn = this.appendCopyKeyFieldToOid(insn, "fetchIntField", "(I)I", no, ref, sig);
                    break;
                }
                case 'J': {
                    insn = this.appendCopyKeyFieldToOid(insn, "fetchLongField", "(I)J", no, ref, sig);
                    break;
                }
                case 'F': {
                    insn = this.appendCopyKeyFieldToOid(insn, "fetchFloatField", "(I)F", no, ref, sig);
                    break;
                }
                case 'D': {
                    insn = this.appendCopyKeyFieldToOid(insn, "fetchDoubleField", "(I)D", no, ref, sig);
                    break;
                }
                case 'L': 
                case '[': {
                    if (sig.equals(JAVA_ClassConstants.JAVA_String_Sig)) {
                        insn = this.appendCopyKeyFieldToOid(insn, "fetchStringField", JDO_OIFS_MemberConstants.JDO_OIFS_fetchStringField_Sig, no, ref, sig);
                        break;
                    }
                    insn = this.appendCopyKeyFieldToOid(insn, "fetchObjectField", JDO_OIFS_MemberConstants.JDO_OIFS_fetchObjectField_Sig, no, ref, sig);
                    break;
                }
                default: {
                    Assertion.affirm(false, "Illegal field type: " + sig);
                }
            }
            ++i;
        }
        Assertion.affirm(insn != null);
        return insn;
    }

    private Insn appendCopyKeyFieldFromOid(Insn insn, String storeXXXField_Name, String storeXXXField_Sig, int keyFieldNo, ConstFieldRef keyFieldRef) {
        Assertion.affirm(insn != null);
        Assertion.affirm(storeXXXField_Name != null);
        Assertion.affirm(storeXXXField_Sig != null);
        Assertion.affirm(keyFieldNo >= 0);
        Assertion.affirm(keyFieldRef != null);
        insn = insn.append(Insn.create(43));
        insn = insn.append(Insn.create(178, this.pool.addFieldRef(this.className, "jdoInheritedFieldCount", "I")));
        insn = insn.append(InsnUtils.integerConstant(keyFieldNo, this.pool));
        insn = insn.append(Insn.create(96));
        insn = insn.append(Insn.create(45));
        insn = insn.append(Insn.create(180, keyFieldRef));
        insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef(JDO_ClassConstants.JDO_ObjectIdFieldConsumer_Path, storeXXXField_Name, storeXXXField_Sig), Builder.countMethodArgWords(storeXXXField_Sig)));
        Assertion.affirm(insn != null);
        return insn;
    }

    private Insn appendStatementsForCopyKeyFieldsFromOid(Insn insn, SizeHolder sizeHolder) {
        Assertion.affirm(insn != null);
        Assertion.affirm(sizeHolder != null);
        int keyFieldCount = this.analyzer.getKeyFieldCount();
        ConstFieldRef[] keyFieldRefs = this.getKeyClassKeyFieldRefs();
        int[] keyFieldIndexes = this.analyzer.getKeyFieldIndexes();
        Assertion.affirm(keyFieldRefs.length == keyFieldCount);
        Assertion.affirm(keyFieldIndexes.length == keyFieldCount);
        int i = 0;
        while (i < keyFieldCount) {
            int no = keyFieldIndexes[i];
            ConstFieldRef ref = keyFieldRefs[i];
            Assertion.affirm(ref != null);
            String sig = ref.nameAndType().signature().asString();
            Assertion.affirm(sig != null && sig.length() > 0);
            sizeHolder.size = Builder.max(sizeHolder.size, Descriptor.countFieldWords(sig));
            switch (sig.charAt(0)) {
                case 'Z': {
                    insn = this.appendCopyKeyFieldFromOid(insn, "storeBooleanField", "(IZ)V", no, ref);
                    break;
                }
                case 'C': {
                    insn = this.appendCopyKeyFieldFromOid(insn, "storeCharField", "(IC)V", no, ref);
                    break;
                }
                case 'B': {
                    insn = this.appendCopyKeyFieldFromOid(insn, "storeByteField", "(IB)V", no, ref);
                    break;
                }
                case 'S': {
                    insn = this.appendCopyKeyFieldFromOid(insn, "storeShortField", "(IS)V", no, ref);
                    break;
                }
                case 'I': {
                    insn = this.appendCopyKeyFieldFromOid(insn, "storeIntField", "(II)V", no, ref);
                    break;
                }
                case 'J': {
                    insn = this.appendCopyKeyFieldFromOid(insn, "storeLongField", "(IJ)V", no, ref);
                    break;
                }
                case 'F': {
                    insn = this.appendCopyKeyFieldFromOid(insn, "storeFloatField", "(IF)V", no, ref);
                    break;
                }
                case 'D': {
                    insn = this.appendCopyKeyFieldFromOid(insn, "storeDoubleField", "(ID)V", no, ref);
                    break;
                }
                case 'L': 
                case '[': {
                    if (sig.equals(JAVA_ClassConstants.JAVA_String_Sig)) {
                        insn = this.appendCopyKeyFieldFromOid(insn, "storeStringField", JDO_OIFC_MemberConstants.JDO_OIFC_storeStringField_Sig, no, ref);
                        break;
                    }
                    insn = this.appendCopyKeyFieldFromOid(insn, "storeObjectField", JDO_OIFC_MemberConstants.JDO_OIFC_storeObjectField_Sig, no, ref);
                    break;
                }
                default: {
                    Assertion.affirm(false, "Illegal field type: " + sig);
                }
            }
            ++i;
        }
        Assertion.affirm(insn != null);
        return insn;
    }

    public void addJDOCopyKeyFieldsToObjectIdOIFSMethod() {
        this.addJDOCopyKeyFieldsToFromObjectIdOIFSMethod(true);
    }

    public void addJDOCopyKeyFieldsFromObjectIdOIFCMethod() {
        this.addJDOCopyKeyFieldsToFromObjectIdOIFSMethod(false);
    }

    private void addJDOCopyKeyFieldsToFromObjectIdOIFSMethod(boolean isToOid) {
        int accessFlags;
        String methodSig;
        String methodName;
        if (isToOid) {
            methodName = "jdoCopyKeyFieldsToObjectId";
            methodSig = JDO_PC_MemberConstants.JDO_PC_jdoCopyKeyFieldsToObjectId_OIFS_Sig;
            accessFlags = 1;
        } else {
            methodName = "jdoCopyKeyFieldsFromObjectId";
            methodSig = JDO_PC_MemberConstants.JDO_PC_jdoCopyKeyFieldsFromObjectId_OIFC_Sig;
            accessFlags = 1;
        }
        ExceptionsAttribute exceptAttr = null;
        InsnTarget begin = new InsnTarget();
        Insn insn = begin;
        String keyClassName = this.analyzer.getKeyClassName();
        if (keyClassName == null) {
            insn = insn.append(Insn.create(177));
            CodeAttribute codeAttr = new CodeAttribute(this.getCodeAttributeUtf8(), 0, 3, begin, new ExceptionTable(), new AttributeVector());
            this.augmenter.addMethod(methodName, methodSig, accessFlags, codeAttr, exceptAttr);
            return;
        }
        Assertion.affirm(keyClassName != null);
        insn = this.appendCheckVarNonNull(insn, 1, JAVA_ClassConstants.JAVA_IllegalArgumentException_Path, "arg1");
        ConstClass keyConstClass = this.pool.addClass(keyClassName);
        Assertion.affirm(keyConstClass != null);
        insn = this.appendCheckVarInstanceOf(insn, 2, keyConstClass, JAVA_ClassConstants.JAVA_IllegalArgumentException_Path, "arg2");
        insn = insn.append(Insn.create(44));
        insn = insn.append(Insn.create(192, keyConstClass));
        insn = insn.append(Insn.create(78));
        boolean isPCRoot = this.analyzer.isAugmentableAsRoot();
        if (!isPCRoot) {
            String superClassName = this.analyzer.getPCSuperKeyOwnerClassName();
            insn = insn.append(Insn.create(42));
            insn = insn.append(Insn.create(43));
            insn = insn.append(Insn.create(45));
            insn = insn.append(Insn.create(183, this.pool.addMethodRef(superClassName, methodName, methodSig)));
        }
        int keyFieldCount = this.analyzer.getKeyFieldCount();
        ConstFieldRef[] keyFieldRefs = this.getKeyFieldRefs();
        ConstFieldRef[] keyClassKeyFieldRefs = this.getKeyClassKeyFieldRefs();
        Assertion.affirm(keyFieldRefs.length == keyFieldCount);
        Assertion.affirm(keyClassKeyFieldRefs.length == keyFieldCount);
        SizeHolder sizeHolder = new SizeHolder();
        insn = isToOid ? this.appendStatementsForCopyKeyFieldsToOid(insn, sizeHolder) : this.appendStatementsForCopyKeyFieldsFromOid(insn, sizeHolder);
        insn = insn.append(Insn.create(177));
        CodeAttribute codeAttr = new CodeAttribute(this.getCodeAttributeUtf8(), Builder.max(sizeHolder.size + (isToOid ? 3 : 2), 3), 4, begin, new ExceptionTable(), new AttributeVector());
        this.augmenter.addMethod(methodName, methodSig, accessFlags, codeAttr, exceptAttr);
    }

    private Insn appendDirectReadReturn(Insn insn, ConstFieldRef fieldRef) {
        Assertion.affirm(insn != null);
        Assertion.affirm(fieldRef != null);
        String sig = fieldRef.nameAndType().signature().asString();
        Assertion.affirm(sig != null && sig.length() > 0);
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(180, fieldRef));
        switch (sig.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                insn = insn.append(Insn.create(172));
                break;
            }
            case 'J': {
                insn = insn.append(Insn.create(173));
                break;
            }
            case 'F': {
                insn = insn.append(Insn.create(174));
                break;
            }
            case 'D': {
                insn = insn.append(Insn.create(175));
                break;
            }
            case 'L': 
            case '[': {
                insn = insn.append(Insn.create(176));
                break;
            }
            default: {
                Assertion.affirm(false, "Illegal field type: " + sig);
            }
        }
        Assertion.affirm(insn != null);
        return insn;
    }

    public void addJDODirectReadAccessMethod(String methodName, String methodSig, int accessFlags, int fieldIndex) {
        InsnTarget begin;
        Assertion.affirm(methodName != null);
        Assertion.affirm(methodSig != null);
        ExceptionsAttribute exceptAttr = null;
        Insn insn = begin = new InsnTarget();
        ConstFieldRef fieldRef = this.getAnnotatedFieldRefs()[fieldIndex];
        Assertion.affirm(fieldRef != null);
        String sig = fieldRef.nameAndType().signature().asString();
        Assertion.affirm(sig != null && sig.length() > 0);
        int fieldSize = sig.equals("J") || sig.equals("D") ? 2 : 1;
        insn = this.appendDirectReadReturn(insn, fieldRef);
        CodeAttribute codeAttr = new CodeAttribute(this.getCodeAttributeUtf8(), fieldSize, 1, begin, new ExceptionTable(), new AttributeVector());
        this.augmenter.addMethod(methodName, methodSig, accessFlags, codeAttr, exceptAttr);
    }

    public Insn appendMediatedReadAccess(Insn insn, int fieldIndex, ConstFieldRef fieldRef, int varStart) {
        Assertion.affirm(insn != null);
        Assertion.affirm(fieldRef != null);
        String sig = fieldRef.nameAndType().signature().asString();
        Assertion.affirm(sig != null && sig.length() > 0);
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(180, this.getjdoStateManagerFieldRef()));
        insn = insn.append(InsnUtils.aStore(varStart, this.pool));
        InsnTarget callIsLoaded = new InsnTarget();
        insn = insn.append(InsnUtils.aLoad(varStart, this.pool));
        insn = insn.append(Insn.create(199, callIsLoaded));
        insn = this.appendDirectReadReturn(insn, fieldRef);
        insn = insn.append(callIsLoaded);
        insn = insn.append(InsnUtils.aLoad(varStart, this.pool));
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(178, this.pool.addFieldRef(this.className, "jdoInheritedFieldCount", "I")));
        insn = insn.append(InsnUtils.integerConstant(fieldIndex, this.pool));
        insn = insn.append(Insn.create(96));
        InsnTarget mediate = new InsnTarget();
        insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef(JDO_ClassConstants.JDO_StateManager_Path, "isLoaded", JDO_SM_MemberConstants.JDO_SM_isLoaded_Sig), Builder.countMethodArgWords(JDO_SM_MemberConstants.JDO_SM_isLoaded_Sig)));
        insn = insn.append(Insn.create(153, mediate));
        insn = this.appendDirectReadReturn(insn, fieldRef);
        insn = insn.append(mediate);
        insn = insn.append(InsnUtils.aLoad(varStart, this.pool));
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(178, this.pool.addFieldRef(this.className, "jdoInheritedFieldCount", "I")));
        insn = insn.append(InsnUtils.integerConstant(fieldIndex, this.pool));
        insn = insn.append(Insn.create(96));
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(180, fieldRef));
        switch (sig.charAt(0)) {
            case 'Z': {
                insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef(JDO_ClassConstants.JDO_StateManager_Path, "getBooleanField", JDO_SM_MemberConstants.JDO_SM_getBooleanField_Sig), Builder.countMethodArgWords(JDO_SM_MemberConstants.JDO_SM_getBooleanField_Sig)));
                insn = insn.append(Insn.create(172));
                break;
            }
            case 'C': {
                insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef(JDO_ClassConstants.JDO_StateManager_Path, "getCharField", JDO_SM_MemberConstants.JDO_SM_getCharField_Sig), Builder.countMethodArgWords(JDO_SM_MemberConstants.JDO_SM_getCharField_Sig)));
                insn = insn.append(Insn.create(172));
                break;
            }
            case 'B': {
                insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef(JDO_ClassConstants.JDO_StateManager_Path, "getByteField", JDO_SM_MemberConstants.JDO_SM_getByteField_Sig), Builder.countMethodArgWords(JDO_SM_MemberConstants.JDO_SM_getByteField_Sig)));
                insn = insn.append(Insn.create(172));
                break;
            }
            case 'S': {
                insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef(JDO_ClassConstants.JDO_StateManager_Path, "getShortField", JDO_SM_MemberConstants.JDO_SM_getShortField_Sig), Builder.countMethodArgWords(JDO_SM_MemberConstants.JDO_SM_getShortField_Sig)));
                insn = insn.append(Insn.create(172));
                break;
            }
            case 'I': {
                insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef(JDO_ClassConstants.JDO_StateManager_Path, "getIntField", JDO_SM_MemberConstants.JDO_SM_getIntField_Sig), Builder.countMethodArgWords(JDO_SM_MemberConstants.JDO_SM_getIntField_Sig)));
                insn = insn.append(Insn.create(172));
                break;
            }
            case 'J': {
                insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef(JDO_ClassConstants.JDO_StateManager_Path, "getLongField", JDO_SM_MemberConstants.JDO_SM_getLongField_Sig), Builder.countMethodArgWords(JDO_SM_MemberConstants.JDO_SM_getLongField_Sig)));
                insn = insn.append(Insn.create(173));
                break;
            }
            case 'F': {
                insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef(JDO_ClassConstants.JDO_StateManager_Path, "getFloatField", JDO_SM_MemberConstants.JDO_SM_getFloatField_Sig), Builder.countMethodArgWords(JDO_SM_MemberConstants.JDO_SM_getFloatField_Sig)));
                insn = insn.append(Insn.create(174));
                break;
            }
            case 'D': {
                insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef(JDO_ClassConstants.JDO_StateManager_Path, "getDoubleField", JDO_SM_MemberConstants.JDO_SM_getDoubleField_Sig), Builder.countMethodArgWords(JDO_SM_MemberConstants.JDO_SM_getDoubleField_Sig)));
                insn = insn.append(Insn.create(175));
                break;
            }
            case 'L': 
            case '[': {
                if (sig.equals(JAVA_ClassConstants.JAVA_String_Sig)) {
                    insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef(JDO_ClassConstants.JDO_StateManager_Path, "getStringField", JDO_SM_MemberConstants.JDO_SM_getStringField_Sig), Builder.countMethodArgWords(JDO_SM_MemberConstants.JDO_SM_getStringField_Sig)));
                    insn = insn.append(Insn.create(176));
                    break;
                }
                insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef(JDO_ClassConstants.JDO_StateManager_Path, "getObjectField", JDO_SM_MemberConstants.JDO_SM_getObjectField_Sig), Builder.countMethodArgWords(JDO_SM_MemberConstants.JDO_SM_getObjectField_Sig)));
                if (!sig.equals(JAVA_ClassConstants.JAVA_Object_Sig)) {
                    String fieldType = NameHelper.pathForSig(sig);
                    insn = insn.append(Insn.create(192, this.pool.addClass(fieldType)));
                }
                insn = insn.append(Insn.create(176));
                break;
            }
            default: {
                Assertion.affirm(false, "Illegal field type: " + sig);
            }
        }
        Assertion.affirm(insn != null);
        return insn;
    }

    public void addJDOMediatedReadAccessMethod(String methodName, String methodSig, int accessFlags, int fieldIndex) {
        InsnTarget begin;
        Assertion.affirm(methodName != null);
        Assertion.affirm(methodSig != null);
        ExceptionsAttribute exceptAttr = null;
        Insn insn = begin = new InsnTarget();
        ConstFieldRef fieldRef = this.getAnnotatedFieldRefs()[fieldIndex];
        Assertion.affirm(fieldRef != null);
        String sig = fieldRef.nameAndType().signature().asString();
        Assertion.affirm(sig != null && sig.length() > 0);
        int fieldSize = sig.equals("J") || sig.equals("D") ? 2 : 1;
        boolean varStart = true;
        insn = this.appendMediatedReadAccess(insn, fieldIndex, fieldRef, 1);
        CodeAttribute codeAttr = new CodeAttribute(this.getCodeAttributeUtf8(), fieldSize + 3, 2, begin, new ExceptionTable(), new AttributeVector());
        this.augmenter.addMethod(methodName, methodSig, accessFlags, codeAttr, exceptAttr);
    }

    public void addJDOCheckedReadAccessMethod(String methodName, String methodSig, int accessFlags, int fieldIndex) {
        Assertion.affirm(methodName != null);
        Assertion.affirm(methodSig != null);
        ExceptionsAttribute exceptAttr = null;
        InsnTarget begin = new InsnTarget();
        Insn insn = begin;
        ConstFieldRef fieldRef = this.getAnnotatedFieldRefs()[fieldIndex];
        Assertion.affirm(fieldRef != null);
        String sig = fieldRef.nameAndType().signature().asString();
        Assertion.affirm(sig != null && sig.length() > 0);
        int fieldSize = sig.equals("J") || sig.equals("D") ? 2 : 1;
        boolean varStart = true;
        InsnTarget mediate = new InsnTarget();
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(180, this.getjdoFlagsFieldRef()));
        insn = insn.append(Insn.create(157, mediate));
        insn = this.appendDirectReadReturn(insn, fieldRef);
        insn = insn.append(mediate);
        insn = this.appendMediatedReadAccess(insn, fieldIndex, fieldRef, 1);
        CodeAttribute codeAttr = new CodeAttribute(this.getCodeAttributeUtf8(), fieldSize + 3, 2, begin, new ExceptionTable(), new AttributeVector());
        this.augmenter.addMethod(methodName, methodSig, accessFlags, codeAttr, exceptAttr);
    }

    private Insn appendDirectWriteReturn(Insn insn, ConstFieldRef fieldRef) {
        Assertion.affirm(insn != null);
        Assertion.affirm(fieldRef != null);
        String sig = fieldRef.nameAndType().signature().asString();
        Assertion.affirm(sig != null && sig.length() > 0);
        insn = insn.append(Insn.create(42));
        switch (sig.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                insn = insn.append(Insn.create(27));
                break;
            }
            case 'J': {
                insn = insn.append(Insn.create(31));
                break;
            }
            case 'F': {
                insn = insn.append(Insn.create(35));
                break;
            }
            case 'D': {
                insn = insn.append(Insn.create(39));
                break;
            }
            case 'L': 
            case '[': {
                insn = insn.append(Insn.create(43));
                break;
            }
            default: {
                Assertion.affirm(false, "Illegal field type: " + sig);
            }
        }
        insn = insn.append(Insn.create(181, fieldRef));
        insn = insn.append(Insn.create(177));
        Assertion.affirm(insn != null);
        return insn;
    }

    public void addJDODirectWriteAccessMethod(String methodName, String methodSig, int accessFlags, int fieldIndex) {
        InsnTarget begin;
        Assertion.affirm(methodName != null);
        Assertion.affirm(methodSig != null);
        ExceptionsAttribute exceptAttr = null;
        Insn insn = begin = new InsnTarget();
        ConstFieldRef fieldRef = this.getAnnotatedFieldRefs()[fieldIndex];
        Assertion.affirm(fieldRef != null);
        insn = this.appendDirectWriteReturn(insn, fieldRef);
        CodeAttribute codeAttr = new CodeAttribute(this.getCodeAttributeUtf8(), 3, 3, begin, new ExceptionTable(), new AttributeVector());
        this.augmenter.addMethod(methodName, methodSig, accessFlags, codeAttr, exceptAttr);
    }

    private Insn appendMediatedWriteAccess(Insn insn, int fieldIndex, ConstFieldRef fieldRef, int varStart) {
        Assertion.affirm(insn != null);
        Assertion.affirm(fieldRef != null);
        String sig = fieldRef.nameAndType().signature().asString();
        Assertion.affirm(sig != null && sig.length() > 0);
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(180, this.getjdoStateManagerFieldRef()));
        insn = insn.append(InsnUtils.aStore(varStart, this.pool));
        InsnTarget mediate = new InsnTarget();
        insn = insn.append(InsnUtils.aLoad(varStart, this.pool));
        insn = insn.append(Insn.create(199, mediate));
        insn = this.appendDirectWriteReturn(insn, fieldRef);
        insn = insn.append(mediate);
        insn = insn.append(InsnUtils.aLoad(varStart, this.pool));
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(178, this.pool.addFieldRef(this.className, "jdoInheritedFieldCount", "I")));
        insn = insn.append(InsnUtils.integerConstant(fieldIndex, this.pool));
        insn = insn.append(Insn.create(96));
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(180, fieldRef));
        switch (sig.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                insn = insn.append(Insn.create(27));
                break;
            }
            case 'J': {
                insn = insn.append(Insn.create(31));
                break;
            }
            case 'F': {
                insn = insn.append(Insn.create(35));
                break;
            }
            case 'D': {
                insn = insn.append(Insn.create(39));
                break;
            }
            case 'L': 
            case '[': {
                insn = insn.append(Insn.create(43));
                break;
            }
            default: {
                Assertion.affirm(false, "Illegal field type: " + sig);
            }
        }
        switch (sig.charAt(0)) {
            case 'Z': {
                insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef(JDO_ClassConstants.JDO_StateManager_Path, "setBooleanField", JDO_SM_MemberConstants.JDO_SM_setBooleanField_Sig), Builder.countMethodArgWords(JDO_SM_MemberConstants.JDO_SM_setBooleanField_Sig)));
                break;
            }
            case 'C': {
                insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef(JDO_ClassConstants.JDO_StateManager_Path, "setCharField", JDO_SM_MemberConstants.JDO_SM_setCharField_Sig), Builder.countMethodArgWords(JDO_SM_MemberConstants.JDO_SM_setCharField_Sig)));
                break;
            }
            case 'B': {
                insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef(JDO_ClassConstants.JDO_StateManager_Path, "setByteField", JDO_SM_MemberConstants.JDO_SM_setByteField_Sig), Builder.countMethodArgWords(JDO_SM_MemberConstants.JDO_SM_setByteField_Sig)));
                break;
            }
            case 'S': {
                insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef(JDO_ClassConstants.JDO_StateManager_Path, "setShortField", JDO_SM_MemberConstants.JDO_SM_setShortField_Sig), Builder.countMethodArgWords(JDO_SM_MemberConstants.JDO_SM_setShortField_Sig)));
                break;
            }
            case 'I': {
                insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef(JDO_ClassConstants.JDO_StateManager_Path, "setIntField", JDO_SM_MemberConstants.JDO_SM_setIntField_Sig), Builder.countMethodArgWords(JDO_SM_MemberConstants.JDO_SM_setIntField_Sig)));
                break;
            }
            case 'J': {
                insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef(JDO_ClassConstants.JDO_StateManager_Path, "setLongField", JDO_SM_MemberConstants.JDO_SM_setLongField_Sig), Builder.countMethodArgWords(JDO_SM_MemberConstants.JDO_SM_setLongField_Sig)));
                break;
            }
            case 'F': {
                insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef(JDO_ClassConstants.JDO_StateManager_Path, "setFloatField", JDO_SM_MemberConstants.JDO_SM_setFloatField_Sig), Builder.countMethodArgWords(JDO_SM_MemberConstants.JDO_SM_setFloatField_Sig)));
                break;
            }
            case 'D': {
                insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef(JDO_ClassConstants.JDO_StateManager_Path, "setDoubleField", JDO_SM_MemberConstants.JDO_SM_setDoubleField_Sig), Builder.countMethodArgWords(JDO_SM_MemberConstants.JDO_SM_setDoubleField_Sig)));
                break;
            }
            case 'L': 
            case '[': {
                if (sig.equals(JAVA_ClassConstants.JAVA_String_Sig)) {
                    insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef(JDO_ClassConstants.JDO_StateManager_Path, "setStringField", JDO_SM_MemberConstants.JDO_SM_setStringField_Sig), Builder.countMethodArgWords(JDO_SM_MemberConstants.JDO_SM_setStringField_Sig)));
                    break;
                }
                insn = insn.append(new InsnInterfaceInvoke(this.pool.addInterfaceMethodRef(JDO_ClassConstants.JDO_StateManager_Path, "setObjectField", JDO_SM_MemberConstants.JDO_SM_setObjectField_Sig), Builder.countMethodArgWords(JDO_SM_MemberConstants.JDO_SM_setObjectField_Sig)));
                break;
            }
            default: {
                Assertion.affirm(false, "Illegal field type: " + sig);
            }
        }
        insn = insn.append(Insn.create(177));
        Assertion.affirm(insn != null);
        return insn;
    }

    public void addJDOMediatedWriteAccessMethod(String methodName, String methodSig, int accessFlags, int fieldIndex) {
        InsnTarget begin;
        Assertion.affirm(methodName != null);
        Assertion.affirm(methodSig != null);
        ExceptionsAttribute exceptAttr = null;
        Insn insn = begin = new InsnTarget();
        ConstFieldRef fieldRef = this.getAnnotatedFieldRefs()[fieldIndex];
        Assertion.affirm(fieldRef != null);
        String sig = fieldRef.nameAndType().signature().asString();
        Assertion.affirm(sig != null && sig.length() > 0);
        int fieldSize = sig.equals("J") || sig.equals("D") ? 2 : 1;
        int varStart = fieldSize + 1;
        insn = this.appendMediatedWriteAccess(insn, fieldIndex, fieldRef, varStart);
        CodeAttribute codeAttr = new CodeAttribute(this.getCodeAttributeUtf8(), 2 * fieldSize + 3, fieldSize + 2, begin, new ExceptionTable(), new AttributeVector());
        this.augmenter.addMethod(methodName, methodSig, accessFlags, codeAttr, exceptAttr);
    }

    public void addJDOCheckedWriteAccessMethod(String methodName, String methodSig, int accessFlags, int fieldIndex) {
        Assertion.affirm(methodName != null);
        Assertion.affirm(methodSig != null);
        ExceptionsAttribute exceptAttr = null;
        InsnTarget begin = new InsnTarget();
        Insn insn = begin;
        ConstFieldRef fieldRef = this.getAnnotatedFieldRefs()[fieldIndex];
        Assertion.affirm(fieldRef != null);
        String sig = fieldRef.nameAndType().signature().asString();
        Assertion.affirm(sig != null && sig.length() > 0);
        int fieldSize = sig.equals("J") || sig.equals("D") ? 2 : 1;
        int varStart = fieldSize + 1;
        InsnTarget mediate = new InsnTarget();
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(180, this.getjdoFlagsFieldRef()));
        insn = insn.append(Insn.create(154, mediate));
        insn = this.appendDirectWriteReturn(insn, fieldRef);
        insn = insn.append(mediate);
        insn = this.appendMediatedWriteAccess(insn, fieldIndex, fieldRef, varStart);
        CodeAttribute codeAttr = new CodeAttribute(this.getCodeAttributeUtf8(), 2 * fieldSize + 3, fieldSize + 2, begin, new ExceptionTable(), new AttributeVector());
        this.augmenter.addMethod(methodName, methodSig, accessFlags, codeAttr, exceptAttr);
    }

    public void addJDOClearMethod() {
        String methodName = "";
        String methodSig = "()V";
        boolean accessFlags = false;
        ExceptionsAttribute exceptAttr = null;
        InsnTarget begin = new InsnTarget();
        Insn insn = begin;
        Object managedFields = null;
        int managedFieldCount = (managedFields).length;
        int i = 0;
        while (i < managedFieldCount) {
            void field = managedFields[i];
            String fieldName = field.name().asString();
            String fieldSig = field.signature().asString();
            insn = insn.append(Insn.create(42));
            switch (fieldSig.charAt(0)) {
                case 'D': {
                    insn = insn.append(Insn.create(14));
                    break;
                }
                case 'F': {
                    insn = insn.append(Insn.create(11));
                    break;
                }
                case 'J': {
                    insn = insn.append(Insn.create(9));
                    break;
                }
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    insn = insn.append(Insn.create(3));
                    break;
                }
                case 'L': 
                case '[': {
                    insn = insn.append(Insn.create(1));
                    break;
                }
                default: {
                    throw new InternalError("Illegal field type: " + fieldSig);
                }
            }
            insn = insn.append(Insn.create(181, this.pool.addFieldRef(this.className, fieldName, fieldSig)));
            ++i;
        }
        insn = insn.append(Insn.create(177));
        CodeAttribute codeAttr = new CodeAttribute(this.getCodeAttributeUtf8(), 3, 1, begin, new ExceptionTable(), new AttributeVector());
        this.augmenter.addMethod("", "()V", 0, codeAttr, exceptAttr);
    }

    public void addJDOClone() {
        String methodName = "";
        String methodSig = "()Ljava/lang/Object;";
        boolean accessFlags = false;
        ExceptionsAttribute exceptAttr = new ExceptionsAttribute(this.pool.addUtf8("Exceptions"), this.pool.addClass("java/lang/CloneNotSupportedException"));
        InsnTarget begin = new InsnTarget();
        Insn insn = begin;
        ConstClass superConstClass = this.classFile.superName();
        ConstClass thisConstClass = this.classFile.className();
        Assertion.affirm(thisConstClass != null);
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(183, this.pool.addMethodRef(superConstClass.asString(), "", "()Ljava/lang/Object;")));
        insn = insn.append(Insn.create(192, thisConstClass));
        insn = insn.append(Insn.create(176));
        CodeAttribute codeAttr = new CodeAttribute(this.getCodeAttributeUtf8(), 1, 1, begin, new ExceptionTable(), new AttributeVector());
        this.augmenter.addMethod("", "()Ljava/lang/Object;", 0, codeAttr, exceptAttr);
    }

    private static class SizeHolder {
        int size;

        private SizeHolder() {
        }
    }
}

