/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.core;

import com.sap.jdo.enhancer.classfile.AttributeVector;
import com.sap.jdo.enhancer.classfile.ClassField;
import com.sap.jdo.enhancer.classfile.ClassFile;
import com.sap.jdo.enhancer.classfile.ClassMethod;
import com.sap.jdo.enhancer.classfile.CodeAttribute;
import com.sap.jdo.enhancer.classfile.ConstClass;
import com.sap.jdo.enhancer.classfile.ConstantPool;
import com.sap.jdo.enhancer.classfile.Descriptor;
import com.sap.jdo.enhancer.classfile.ExceptionsAttribute;
import com.sap.jdo.enhancer.classfile.Insn;
import com.sap.jdo.enhancer.classfile.InsnTarget;
import com.sap.jdo.enhancer.classfile.LineNumberTableAttribute;
import com.sap.jdo.enhancer.classfile.SyntheticAttribute;
import com.sap.jdo.enhancer.core.Analyzer;
import com.sap.jdo.enhancer.core.Builder;
import com.sap.jdo.enhancer.core.Controller;
import com.sap.jdo.enhancer.core.Environment;
import com.sap.jdo.enhancer.core.JDOConstants;
import com.sap.jdo.enhancer.core.JDONameHelper;
import com.sap.jdo.enhancer.core.JDO_ClassConstants;
import com.sap.jdo.enhancer.core.JDO_PC_MemberConstants;
import com.sap.jdo.enhancer.util.Assertion;
import com.sap.jdo.enhancer.util.Support;
import java.util.HashSet;
import java.util.Vector;

final class Augmenter
extends Support
implements JDOConstants {
    private static final boolean addSyntheticAttr = false;
    private static final boolean addLineNumberTableAttr = true;
    private final Controller control;
    private final Analyzer analyzer;
    private final ClassFile classFile;
    private final String className;
    private final String userClassName;
    private final ConstantPool pool;
    private final Environment env;
    private final Builder builder;

    public Augmenter(Controller control, Analyzer analyzer, Environment env) {
        Assertion.affirm(control != null);
        Assertion.affirm(analyzer != null);
        Assertion.affirm(env != null);
        this.control = control;
        this.analyzer = analyzer;
        this.env = env;
        this.classFile = control.getClassFile();
        this.className = this.classFile.classNameString();
        this.userClassName = this.classFile.userClassName();
        this.pool = this.classFile.pool();
        this.builder = new Builder(analyzer, this, env);
        Assertion.affirm(this.classFile != null);
        Assertion.affirm(this.className != null);
        Assertion.affirm(this.userClassName != null);
        Assertion.affirm(this.pool != null);
        Assertion.affirm(this.builder != null);
    }

    public void augment() {
        Assertion.affirm(this.analyzer.isAugmentable() && !this.env.noAugment());
        this.env.message("augmenting class " + this.userClassName);
        if (this.analyzer.isAugmentableAsRoot()) {
            this.augmentClassInterface(JDO_ClassConstants.JDO_PersistenceCapable_Path);
            this.augmentGenericJDOFields();
            this.augmentGenericJDOMethods();
        }
        this.augmentSpecificJDOFields();
        this.augmentSpecificJDOMethods();
        this.augmentJDOAccessorMutatorMethods();
    }

    private void augmentClassInterface(String interfaceName) {
        this.env.message("adding: implements " + ClassFile.userClassFromVMClass(interfaceName));
        ConstClass iface = this.pool.addClass(interfaceName);
        this.classFile.addInterface(iface);
        this.control.noteUpdate();
    }

    public void augmentGenericJDOFields() {
        this.addField("jdoStateManager", JDO_PC_MemberConstants.JDO_PC_jdoStateManager_Sig, 132);
        this.addField("jdoFlags", "B", 132);
    }

    public void augmentSpecificJDOFields() {
        this.addField("jdoInheritedFieldCount", "I", 26);
        this.addField("jdoFieldNames", JDO_PC_MemberConstants.JDO_PC_jdoFieldNames_Sig, 26);
        this.addField("jdoFieldTypes", JDO_PC_MemberConstants.JDO_PC_jdoFieldTypes_Sig, 26);
        this.addField("jdoFieldFlags", "[B", 26);
        this.addField("jdoPersistenceCapableSuperclass", JDO_PC_MemberConstants.JDO_PC_jdoPersistenceCapableSuperclass_Sig, 26);
    }

    private void addField(String fieldName, String fieldSig, int accessFlags) {
        Assertion.affirm(fieldName != null);
        Assertion.affirm(fieldSig != null);
        this.env.message("adding: " + Descriptor.userFieldSig(fieldSig) + " " + fieldName);
        AttributeVector fieldAttrs = new AttributeVector();
        fieldAttrs.addElement(new SyntheticAttribute(this.pool.addUtf8("Synthetic")));
        ClassField field = new ClassField(accessFlags, this.pool.addUtf8(fieldName), this.pool.addUtf8(fieldSig), fieldAttrs);
        Assertion.affirm(this.classFile.findField(fieldName) == null, "Attempt to add a repeated field.");
        this.classFile.addField(field);
        this.control.noteUpdate();
    }

    public void augmentGenericJDOMethods() {
        this.builder.addJDOReplaceFlags();
        this.builder.addJDOIsPersistentMethod();
        this.builder.addJDOIsTransactionalMethod();
        this.builder.addJDOIsNewMethod();
        this.builder.addJDOIsDeletedMethod();
        this.builder.addJDOIsDirtyMethod();
        this.builder.addJDOMakeDirtyMethod();
        this.builder.addJDOPreSerializeMethod();
        this.builder.addJDOGetPersistenceManagerMethod();
        this.builder.addJDOGetObjectIdMethod();
        this.builder.addJDOGetTransactionalObjectIdMethod();
        this.builder.addJDOReplaceStateManager();
        this.builder.addJDOProvideFieldsMethod();
        this.builder.addJDOReplaceFieldsMethod();
        this.builder.addSunJDOClassForNameMethod();
    }

    public void augmentSpecificJDOMethods() {
        this.builder.addJDOGetManagedFieldCountMethod();
        this.builder.addStaticInitialization();
        this.builder.addJDONewInstanceMethod();
        this.builder.addJDONewInstanceOidMethod();
        this.builder.addJDOProvideFieldMethod();
        this.builder.addJDOReplaceFieldMethod();
        this.builder.addJDOCopyFieldMethod();
        this.builder.addJDOCopyFieldsMethod();
        if (this.analyzer.isAugmentableAsRoot() || this.analyzer.getKeyClassName() != null) {
            this.builder.addJDONewObjectIdInstanceMethod();
            this.builder.addJDONewObjectIdInstanceStringMethod();
            this.builder.addJDOCopyKeyFieldsToObjectIdMethod();
            this.builder.addJDOCopyKeyFieldsFromObjectIdMethod();
            this.builder.addJDOCopyKeyFieldsToObjectIdOIFSMethod();
            this.builder.addJDOCopyKeyFieldsFromObjectIdOIFCMethod();
        }
    }

    public void augmentJDOAccessorMutatorMethod(String fieldName, String fieldSig, int fieldMods, int fieldFlags, int index) {
        Assertion.affirm(fieldName != null);
        Assertion.affirm(fieldSig != null);
        Assertion.affirm((fieldMods & 8) == 0);
        Assertion.affirm((fieldFlags & 1) == 0 | (fieldFlags & 2) == 0);
        Assertion.affirm((fieldFlags & 4) == 0 | (fieldFlags & 8) == 0);
        Assertion.affirm((fieldFlags & 1) == 0 | (fieldFlags & 8) == 0);
        Assertion.affirm((fieldFlags & 4) == 0 | (fieldFlags & 2) == 0);
        String aName = JDONameHelper.getJDO_PC_jdoAccessor_Name(fieldName);
        String aSig = JDONameHelper.getJDO_PC_jdoAccessor_Sig(this.className, fieldSig);
        int aMods = JDONameHelper.getJDO_PC_jdoAccessor_Mods(fieldMods);
        if ((fieldFlags & 1) != 0) {
            this.builder.addJDOCheckedReadAccessMethod(aName, aSig, aMods, index);
        } else if ((fieldFlags & 2) != 0) {
            this.builder.addJDOMediatedReadAccessMethod(aName, aSig, aMods, index);
        } else {
            this.builder.addJDODirectReadAccessMethod(aName, aSig, aMods, index);
        }
        String mName = JDONameHelper.getJDO_PC_jdoMutator_Name(fieldName);
        String mSig = JDONameHelper.getJDO_PC_jdoMutator_Sig(this.className, fieldSig);
        int mMods = JDONameHelper.getJDO_PC_jdoMutator_Mods(fieldMods);
        if ((fieldFlags & 4) != 0) {
            this.builder.addJDOCheckedWriteAccessMethod(mName, mSig, mMods, index);
        } else if ((fieldFlags & 8) != 0) {
            this.builder.addJDOMediatedWriteAccessMethod(mName, mSig, mMods, index);
        } else {
            this.builder.addJDODirectWriteAccessMethod(mName, mSig, mMods, index);
        }
    }

    public void augmentJDOAccessorMutatorMethods() {
        int annotatedFieldCount = this.analyzer.getAnnotatedFieldCount();
        String[] annotatedFieldNames = this.analyzer.getAnnotatedFieldNames();
        String[] annotatedFieldSigs = this.analyzer.getAnnotatedFieldSigs();
        int[] annotatedFieldMods = this.analyzer.getAnnotatedFieldMods();
        int[] annotatedFieldFlags = this.analyzer.getAnnotatedFieldFlags();
        Assertion.affirm(annotatedFieldNames.length == annotatedFieldCount);
        Assertion.affirm(annotatedFieldSigs.length == annotatedFieldCount);
        Assertion.affirm(annotatedFieldMods.length == annotatedFieldCount);
        Assertion.affirm(annotatedFieldFlags.length == annotatedFieldCount);
        int i = 0;
        while (i < annotatedFieldCount) {
            this.augmentJDOAccessorMutatorMethod(annotatedFieldNames[i], annotatedFieldSigs[i], annotatedFieldMods[i], annotatedFieldFlags[i], i);
            ++i;
        }
    }

    void addMethod(String methodName, String methodSig, int accessFlags, CodeAttribute codeAttr, ExceptionsAttribute exceptAttr) {
        Assertion.affirm(methodName != null);
        Assertion.affirm(methodSig != null);
        Assertion.affirm(codeAttr != null);
        this.env.message("adding: " + Descriptor.userMethodResult(methodSig) + " " + methodName + Descriptor.userMethodArgs(methodSig));
        Assertion.affirm(codeAttr.theCode().opcode() == -1);
        InsnTarget begin = (InsnTarget)codeAttr.theCode();
        AttributeVector codeSpecificAttrs = codeAttr.attributes();
        Assertion.affirm(codeSpecificAttrs != null);
        codeSpecificAttrs.addElement(new LineNumberTableAttribute(this.pool.addUtf8("LineNumberTable"), new short[]{0}, new InsnTarget[]{begin}));
        AttributeVector methodAttrs = new AttributeVector();
        methodAttrs.addElement(codeAttr);
        if (exceptAttr != null) {
            methodAttrs.addElement(exceptAttr);
        }
        ClassMethod method = new ClassMethod(accessFlags, this.pool.addUtf8(methodName), this.pool.addUtf8(methodSig), methodAttrs);
        Assertion.affirm(this.classFile.findMethod(methodName, methodSig) == null, "Attempt to add a repeated method.");
        this.classFile.addMethod(method);
        this.control.noteUpdate();
    }

    void prependMethod(String methodName, String methodSig, int accessFlags, CodeAttribute codeAttr, ExceptionsAttribute exceptAttr) {
        Assertion.affirm(methodName != null);
        Assertion.affirm(methodSig != null);
        Assertion.affirm(codeAttr != null);
        this.env.message("extending: " + Descriptor.userMethodResult(methodSig) + " " + methodName + Descriptor.userMethodArgs(methodSig));
        ClassMethod method = this.classFile.findMethod(methodName, methodSig);
        Assertion.affirm(method != null, "Attempt to add code to a non-existing method.");
        Assertion.affirm(method.access() == accessFlags, "Attempt to add code to an abstract method.");
        Assertion.affirm(!method.isAbstract(), "Attempt to add code to an abstract method.");
        Assertion.affirm(!method.isNative(), "Attempt to add code to a native method.");
        CodeAttribute foundCodeAttr = method.codeAttribute();
        Assertion.affirm(foundCodeAttr != null);
        Insn firstInsn = codeAttr.theCode();
        Assertion.affirm(firstInsn != null);
        Insn foundFirstInsn = foundCodeAttr.theCode();
        Assertion.affirm(foundFirstInsn != null);
        Insn lastInsn = firstInsn.append(foundFirstInsn);
        Assertion.affirm(lastInsn != null);
        foundCodeAttr.setTheCode(firstInsn);
        foundCodeAttr.setStackUsed(Augmenter.max(foundCodeAttr.stackUsed(), codeAttr.stackUsed()));
        foundCodeAttr.setLocalsUsed(Augmenter.max(foundCodeAttr.localsUsed(), codeAttr.localsUsed()));
        if (exceptAttr != null) {
            Assertion.affirm(exceptAttr.getExceptions().size() == new HashSet(exceptAttr.getExceptions()).size(), "Exception attribute contains duplicate exceptions.");
            ExceptionsAttribute foundExceptAttr = method.exceptionsAttribute();
            if (foundExceptAttr == null) {
                AttributeVector methodAttrs = method.attributes();
                Assertion.affirm(methodAttrs != null);
                methodAttrs.addElement(exceptAttr);
            } else {
                Vector foundEx = foundExceptAttr.getExceptions();
                Vector newEx = exceptAttr.getExceptions();
                newEx.removeAll(foundEx);
                foundEx.addAll(newEx);
            }
        }
        this.control.noteUpdate();
    }

    private static int max(int i, int j) {
        return i < j ? j : i;
    }
}

