/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.core;

import com.sap.jdo.enhancer.classfile.ClassFile;
import com.sap.jdo.enhancer.classfile.ClassMethod;
import com.sap.jdo.enhancer.classfile.CodeAttribute;
import com.sap.jdo.enhancer.classfile.ConstClass;
import com.sap.jdo.enhancer.classfile.ConstFieldRef;
import com.sap.jdo.enhancer.classfile.ConstMethodRef;
import com.sap.jdo.enhancer.classfile.ConstNameAndType;
import com.sap.jdo.enhancer.classfile.ConstantPool;
import com.sap.jdo.enhancer.classfile.Descriptor;
import com.sap.jdo.enhancer.classfile.Insn;
import com.sap.jdo.enhancer.classfile.InsnConstOp;
import com.sap.jdo.enhancer.classfile.VMConstants;
import com.sap.jdo.enhancer.core.Analyzer;
import com.sap.jdo.enhancer.core.Controller;
import com.sap.jdo.enhancer.core.Environment;
import com.sap.jdo.enhancer.core.JDO_PC_MemberConstants;
import com.sap.jdo.enhancer.meta.EnhancerMetaData;
import com.sap.jdo.enhancer.util.Assertion;
import com.sap.jdo.enhancer.util.Support;
import java.util.Iterator;

class Annotater
extends Support
implements VMConstants {
    private final Controller control;
    private final Analyzer analyzer;
    private final ClassFile classFile;
    private final String userClassName;
    private final ConstantPool pool;
    private final Environment env;
    private final EnhancerMetaData meta;

    public Annotater(Controller control, Analyzer analyzer, Environment env) {
        Assertion.affirm(control != null);
        Assertion.affirm(analyzer != null);
        Assertion.affirm(env != null);
        this.control = control;
        this.analyzer = analyzer;
        this.env = env;
        this.meta = env.getEnhancerMetaData();
        this.classFile = control.getClassFile();
        this.userClassName = this.classFile.userClassName();
        this.pool = this.classFile.pool();
        Assertion.affirm(this.classFile != null);
        Assertion.affirm(this.userClassName != null);
        Assertion.affirm(this.meta != null);
        Assertion.affirm(this.pool != null);
    }

    public void annotate() {
        Assertion.affirm(this.analyzer.isAnnotateable() && !this.env.noAnnotate());
        this.env.message("annotating class " + this.userClassName);
        boolean annotated = false;
        Iterator i = this.analyzer.getAnnotatableMethods().iterator();
        while (i.hasNext()) {
            ClassMethod method = (ClassMethod)i.next();
            annotated |= this.annotated(method);
        }
        if (annotated) {
            this.control.noteUpdate();
        }
    }

    private boolean annotated(ClassMethod method) {
        boolean annotated = false;
        CodeAttribute codeAttr = method.codeAttribute();
        if (codeAttr == null) {
            return annotated;
        }
        this.env.message("annotating: " + this.userClassName + "." + method.name().asString() + Descriptor.userMethodArgs(method.signature().asString()));
        Insn firstInsn = codeAttr.theCode();
        Assertion.affirm(firstInsn.opcode() == -1);
        Insn insn = firstInsn.next();
        while (insn != null) {
            switch (insn.opcode()) {
                case 180: 
                case 181: {
                    Insn newInsn = this.insnAnnotation(insn);
                    if (insn != newInsn) {
                        annotated = true;
                    }
                    insn = newInsn;
                    break;
                }
            }
            insn = insn.next();
        }
        return annotated;
    }

    private Insn insnAnnotation(Insn insn) {
        String methodSig;
        String methodName;
        Assertion.affirm(insn.opcode() == 180 || insn.opcode() == 181);
        boolean isGet = insn.opcode() == 180;
        InsnConstOp fieldInsn = (InsnConstOp)insn;
        ConstFieldRef fieldRef = (ConstFieldRef)fieldInsn.value();
        ConstClass declClass = fieldRef.className();
        String declClassName = declClass.asString();
        ConstNameAndType fieldNameAndType = fieldRef.nameAndType();
        String fieldName = fieldNameAndType.name().asString();
        String fieldType = fieldNameAndType.signature().asString();
        if (this.meta.isKnownNonManagedField(declClassName, fieldName, fieldType)) {
            return insn;
        }
        if (isGet) {
            methodName = "jdoGet" + fieldName;
            methodSig = "(L" + declClassName + ";)" + fieldType;
        } else {
            methodName = "jdoSet" + fieldName;
            methodSig = "(L" + declClassName + ";" + fieldType + ")V";
        }
        Insn frag = Insn.create(184, this.pool.addMethodRef(declClassName, methodName, methodSig));
        Insn prev = insn.prev();
        insn.remove();
        Insn last = prev.insert(frag);
        return last;
    }

    private void annotateClone(ClassMethod method, String superName) {
        CodeAttribute codeAttr = method.codeAttribute();
        Insn insn = codeAttr.theCode();
        while (insn != null) {
            if (insn.opcode() == 183) {
                InsnConstOp invoke = (InsnConstOp)insn;
                ConstMethodRef methodRef = (ConstMethodRef)invoke.value();
                ConstNameAndType methodNT = methodRef.nameAndType();
                String methodName = methodNT.name().asString();
                String methodSig = methodNT.signature().asString();
                if (methodName.equals("clone") && methodSig.equals("()Ljava/lang/Object;")) {
                    boolean needCheckcast;
                    String thisClass = this.classFile.classNameString();
                    Insn checkCastInsn = insn.next();
                    if (checkCastInsn.opcode() != 192) {
                        needCheckcast = true;
                    } else {
                        ConstClass target = (ConstClass)((InsnConstOp)checkCastInsn).value();
                        if (target.asString().equals(thisClass)) {
                            insn = checkCastInsn;
                            needCheckcast = false;
                        } else {
                            needCheckcast = true;
                        }
                    }
                    Insn newInsn = Insn.create(89);
                    if (needCheckcast) {
                        newInsn.append(Insn.create(192, this.pool.addClass(thisClass)));
                    }
                    newInsn.append(Insn.create(89));
                    newInsn.append(Insn.create(1));
                    newInsn.append(Insn.create(181, this.pool.addFieldRef(thisClass, "jdoStateManager", JDO_PC_MemberConstants.JDO_PC_jdoStateManager_Sig)));
                    newInsn.append(Insn.create(3));
                    newInsn.append(Insn.create(181, this.pool.addFieldRef(thisClass, "jdoFlags", "B")));
                    insn.insert(newInsn);
                    int annotationStack = 3;
                    codeAttr.setStackUsed(codeAttr.stackUsed() + 3);
                }
            }
            insn = insn.next();
        }
    }
}

