/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.core;

import com.sap.jdo.enhancer.classfile.ClassAttribute;
import com.sap.jdo.enhancer.classfile.ClassField;
import com.sap.jdo.enhancer.classfile.ClassFile;
import com.sap.jdo.enhancer.classfile.ClassMethod;
import com.sap.jdo.enhancer.classfile.ConstClass;
import com.sap.jdo.enhancer.classfile.ConstantPool;
import com.sap.jdo.enhancer.core.Controller;
import com.sap.jdo.enhancer.core.EnhancerConstants;
import com.sap.jdo.enhancer.core.Environment;
import com.sap.jdo.enhancer.core.JAVA_ClassConstants;
import com.sap.jdo.enhancer.core.JDOConstants;
import com.sap.jdo.enhancer.core.JDONameHelper;
import com.sap.jdo.enhancer.core.JDO_ClassConstants;
import com.sap.jdo.enhancer.core.JDO_PC_MemberConstants;
import com.sap.jdo.enhancer.core.NameHelper;
import com.sap.jdo.enhancer.meta.EnhancerMetaData;
import com.sap.jdo.enhancer.util.Assertion;
import com.sap.jdo.enhancer.util.Support;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

final class Analyzer
extends Support
implements JDOConstants,
EnhancerConstants {
    public static final int CC_Unenhancable = -2;
    public static final int CC_PreviouslyEnhanced = -1;
    public static final int CC_PersistenceUnknown = 0;
    public static final int CC_PersistenceAware = 1;
    public static final int CC_PersistenceCapable = 2;
    public static final int CC_PersistenceCapableRoot = 3;
    private static final Set jdoFieldNames = new HashSet();
    private final Controller control;
    private final ClassFile classFile;
    private final String className;
    private final String userClassName;
    private final ConstantPool pool;
    private final Environment env;
    private final EnhancerMetaData meta;
    private int persistenceType = 0;
    private String pcSuperClassName;
    private String pcRootClassName;
    private String pcKeyOwnerClassName;
    private String pcSuperKeyOwnerClassName;
    private String keyClassName;
    private String superKeyClassName;
    private int keyFieldCount;
    private int[] keyFieldIndexes;
    private int managedFieldCount;
    private int annotatedFieldCount;
    private String[] annotatedFieldNames;
    private String[] annotatedFieldSigs;
    private int[] annotatedFieldMods;
    private int[] annotatedFieldFlags;
    private final Map jdoLikeFields = new HashMap(20);
    private final Map jdoLikeMethods = new HashMap(50);
    private final Map annotatableMethods = new HashMap(100);
    private boolean hasImplementsPC = false;
    private boolean hasGenericJDOFields = false;
    private boolean hasGenericJDOMethods = false;
    private boolean hasGenericJDOMembers = false;
    private boolean hasSpecificJDOFields = false;
    private boolean hasSpecificJDOMethods = false;
    private boolean hasSpecificJDOMembers = false;
    private boolean hasCallbackJDOMethods = false;
    private boolean hasJDOMembers = false;
    private boolean hasDefaultConstructor = false;
    private boolean hasStaticInitializer = false;
    private boolean hasCloneMethod = false;
    private boolean hasWriteObjectMethod = false;
    private boolean hasReadObjectMethod = false;

    public Analyzer(Controller control, Environment env) {
        Assertion.affirm(control != null);
        Assertion.affirm(env != null);
        this.control = control;
        this.classFile = control.getClassFile();
        this.className = this.classFile.classNameString();
        this.userClassName = this.classFile.userClassName();
        this.pool = this.classFile.pool();
        this.env = env;
        this.meta = env.getEnhancerMetaData();
        Assertion.affirm(this.classFile != null);
        Assertion.affirm(this.className != null);
        Assertion.affirm(this.userClassName != null);
        Assertion.affirm(this.pool != null);
        Assertion.affirm(this.meta != null);
    }

    public ClassFile getClassFile() {
        return this.classFile;
    }

    public int getPersistenceType() {
        return this.persistenceType;
    }

    public boolean isAnalyzed() {
        return this.persistenceType != 0;
    }

    public boolean isAnnotateable() {
        return this.persistenceType >= 0;
    }

    public boolean isAugmentable() {
        return this.persistenceType >= 2;
    }

    public boolean isAugmentableAsRoot() {
        return this.persistenceType >= 3;
    }

    public Collection getAnnotatableMethods() {
        return this.annotatableMethods.values();
    }

    public String getPCSuperClassName() {
        return this.pcSuperClassName;
    }

    public String getPCRootClassName() {
        return this.pcRootClassName;
    }

    public String getPCKeyOwnerClassName() {
        return this.pcKeyOwnerClassName;
    }

    public String getPCSuperKeyOwnerClassName() {
        return this.pcSuperKeyOwnerClassName;
    }

    public String getKeyClassName() {
        return this.keyClassName;
    }

    public String getSuperKeyClassName() {
        return this.superKeyClassName;
    }

    public int getKeyFieldCount() {
        return this.keyFieldCount;
    }

    public int[] getKeyFieldIndexes() {
        return this.keyFieldIndexes;
    }

    public int getManagedFieldCount() {
        return this.managedFieldCount;
    }

    public int getAnnotatedFieldCount() {
        return this.annotatedFieldCount;
    }

    public String[] getAnnotatedFieldNames() {
        return this.annotatedFieldNames;
    }

    public String[] getAnnotatedFieldSigs() {
        return this.annotatedFieldSigs;
    }

    public int[] getAnnotatedFieldMods() {
        return this.annotatedFieldMods;
    }

    public int[] getAnnotatedFieldFlags() {
        return this.annotatedFieldFlags;
    }

    public boolean hasDefaultConstructor() {
        return this.hasDefaultConstructor;
    }

    public boolean hasStaticInitializer() {
        return this.hasStaticInitializer;
    }

    public boolean hasCloneMethod() {
        return this.hasCloneMethod;
    }

    public boolean hasWriteObjectMethod() {
        return this.hasWriteObjectMethod;
    }

    public boolean hasReadObjectMethod() {
        return this.hasReadObjectMethod;
    }

    public boolean hasJDOAugmentation() {
        return this.hasJDOMembers;
    }

    public void scan() {
        this.env.message("scanning class " + this.userClassName);
        this.checkForEnhancedAttribute();
        if (!this.isAnnotateable()) {
            return;
        }
        this.initPersistenceType();
        if (!this.isAnnotateable()) {
            return;
        }
        Assertion.affirm(this.persistenceType > -2);
        this.scanFields();
        this.scanMethods();
        if (this.isAugmentable()) {
            this.checkPCFeasibility();
            this.checkSpecificAugmentation();
            this.checkCallbackAugmentation();
            if (this.isAugmentableAsRoot()) {
                this.checkGenericAugmentation();
            }
        }
    }

    private void checkForEnhancedAttribute() {
        Enumeration e = this.classFile.attributes().elements();
        while (e.hasMoreElements()) {
            ClassAttribute attr = (ClassAttribute)e.nextElement();
            String attrName = attr.attrName().asString();
            if (!"com.sap.jdo.enhancer.enhanced".equals(attrName)) continue;
            this.persistenceType = -1;
            this.env.message("ignoring previously enhanced class " + this.userClassName);
            return;
        }
    }

    private void initPersistenceType() {
        Assertion.affirm(this.persistenceType == 0);
        EnhancerMetaData meta = this.env.getEnhancerMetaData();
        if (meta.isKnownUnenhancableClass(this.className)) {
            this.persistenceType = -2;
            return;
        }
        if (meta.isPersistenceCapableClass(this.className)) {
            String pcSuperClassName;
            this.pcSuperClassName = meta.getPersistenceCapableSuperClass(this.className);
            this.pcRootClassName = meta.getPersistenceCapableRootClass(this.className);
            Assertion.affirm(this.pcSuperClassName == null || this.pcRootClassName != null);
            this.persistenceType = this.pcSuperClassName == null ? 3 : 2;
            Assertion.affirm(!this.classFile.isInterface());
            ConstClass superConstClass = this.classFile.superName();
            Assertion.affirm(superConstClass != null);
            Assertion.affirm(this.pcSuperClassName == null || !superConstClass.asString().equals("java/lang/Object"));
            this.pcKeyOwnerClassName = this.className;
            while (meta.getKeyClass(this.pcKeyOwnerClassName) == null) {
                pcSuperClassName = meta.getPersistenceCapableSuperClass(this.pcKeyOwnerClassName);
                if (pcSuperClassName == null) break;
                this.pcKeyOwnerClassName = pcSuperClassName;
            }
            Assertion.affirm(this.pcKeyOwnerClassName != null);
            this.pcSuperKeyOwnerClassName = this.pcSuperClassName;
            if (this.pcSuperKeyOwnerClassName != null) {
                while (meta.getKeyClass(this.pcSuperKeyOwnerClassName) == null) {
                    pcSuperClassName = meta.getPersistenceCapableSuperClass(this.pcSuperKeyOwnerClassName);
                    if (pcSuperClassName == null) break;
                    this.pcSuperKeyOwnerClassName = pcSuperClassName;
                }
                Assertion.affirm(this.pcKeyOwnerClassName != null);
            }
            this.keyClassName = meta.getKeyClass(this.className);
            this.superKeyClassName = meta.getSuperKeyClass(this.className);
            Assertion.affirm(this.superKeyClassName == null || this.pcSuperClassName != null);
        }
    }

    private void scanFields() {
        HashMap<String, ClassField> annotatedFieldMap = new HashMap<String, ClassField>();
        if (this.isAugmentable()) {
            Enumeration e = this.classFile.fields().elements();
            while (e.hasMoreElements()) {
                ClassField field = (ClassField)e.nextElement();
                String name = field.name().asString();
                String sig = field.signature().asString();
                if (jdoFieldNames.contains(name) || field.isStatic() || this.meta.isKnownNonManagedField(this.className, name, sig)) continue;
                ClassField obj = annotatedFieldMap.put(name, field);
                Assertion.affirm(obj == null, "Error in classfile: repeated declaration of field: " + this.userClassName + "." + name);
                if (field.isFinal()) continue;
                if (field.isTransient()) {
                    this.meta.passTypeInformation(this.className, name, sig);
                    continue;
                }
                this.meta.declareField(this.className, name, sig);
            }
        }
        this.annotatedFieldCount = annotatedFieldMap.size();
        String[] managedFieldNames = this.meta.getManagedFields(this.className);
        Assertion.affirm(managedFieldNames != null);
        this.managedFieldCount = managedFieldNames.length;
        HashSet<String> managedFieldNamesSet = new HashSet<String>(Arrays.asList(managedFieldNames));
        Assertion.affirm(managedFieldNamesSet.size() == this.managedFieldCount, "JDO metadata: returned duplicate managed fields.");
        Assertion.affirm(this.managedFieldCount <= this.annotatedFieldCount, "JDO metadata: managed fields exceed annotated fields.");
        String[] keyFieldNames = this.meta.getKeyFields(this.className);
        Assertion.affirm(keyFieldNames != null);
        this.keyFieldCount = keyFieldNames.length;
        Assertion.affirm(this.keyFieldCount == 0 || this.keyClassName != null, "JDO metadata: returned key fields but no key class.");
        HashSet<String> keyFieldNamesSet = new HashSet<String>(Arrays.asList(keyFieldNames));
        Assertion.affirm(keyFieldNamesSet.size() == this.keyFieldCount, "JDO metadata: returned duplicate key fields.");
        Assertion.affirm(this.keyFieldCount <= this.managedFieldCount, "JDO metadata: key fields exceed managed fields.");
        Enumeration e = this.classFile.fields().elements();
        while (e.hasMoreElements()) {
            ClassField field = (ClassField)e.nextElement();
            String name = field.name().asString();
            String sig = field.signature().asString();
            String userFieldName = this.userClassName + "." + name;
            if (name.startsWith("jdo")) {
                ClassField f = this.jdoLikeFields.put(name, field);
                Assertion.affirm(f == null);
            }
            if (!managedFieldNamesSet.contains(name)) {
                Assertion.affirm(!this.meta.isManagedField(this.className, name));
                Assertion.affirm(!keyFieldNamesSet.contains(name), "JDO metadata: reported the field " + userFieldName + " to be non-managed but key.");
                continue;
            }
            Assertion.affirm(this.meta.isManagedField(this.className, name));
            Assertion.affirm(!field.isStatic(), "JDO metadata: reported the field " + userFieldName + " to be managed though it's static.");
            Assertion.affirm(!field.isFinal(), "JDO metadata: reported the field " + userFieldName + " to be managed though it's final.");
        }
        int j = 0;
        this.keyFieldIndexes = new int[this.keyFieldCount];
        String[] managedFieldSigs = new String[this.managedFieldCount];
        int[] managedFieldMods = new int[this.managedFieldCount];
        int i = 0;
        while (i < this.managedFieldCount) {
            String name = managedFieldNames[i];
            Assertion.affirm(name != null);
            ClassField field = (ClassField)annotatedFieldMap.get(name);
            Assertion.affirm(field != null, "The managed field " + this.userClassName + "." + name + " is not declared by the class.");
            Assertion.affirm(!field.isStatic(), "The managed field " + this.userClassName + "." + name + " is static.");
            Assertion.affirm(!field.isFinal(), "The managed field " + this.userClassName + "." + name + " is final.");
            annotatedFieldMap.remove(name);
            if (keyFieldNamesSet.contains(name)) {
                Assertion.affirm(this.meta.isKeyField(this.className, name));
                this.keyFieldIndexes[j++] = i;
            }
            managedFieldSigs[i] = field.signature().asString();
            managedFieldMods[i] = field.access();
            ++i;
        }
        int[] managedFieldFlags = this.meta.getFieldFlags(this.className, managedFieldNames);
        Assertion.affirm(this.keyFieldIndexes.length == this.keyFieldCount);
        Assertion.affirm(this.keyFieldCount <= this.managedFieldCount);
        Assertion.affirm(managedFieldNames.length == this.managedFieldCount);
        Assertion.affirm(managedFieldSigs.length == this.managedFieldCount);
        Assertion.affirm(managedFieldMods.length == this.managedFieldCount);
        Assertion.affirm(managedFieldFlags.length == this.managedFieldCount);
        Assertion.affirm(this.managedFieldCount <= this.annotatedFieldCount);
        if (this.managedFieldCount == this.annotatedFieldCount) {
            this.annotatedFieldNames = managedFieldNames;
            this.annotatedFieldSigs = managedFieldSigs;
            this.annotatedFieldMods = managedFieldMods;
            this.annotatedFieldFlags = managedFieldFlags;
        } else {
            this.annotatedFieldNames = new String[this.annotatedFieldCount];
            this.annotatedFieldSigs = new String[this.annotatedFieldCount];
            this.annotatedFieldMods = new int[this.annotatedFieldCount];
            this.annotatedFieldFlags = new int[this.annotatedFieldCount];
            int i2 = this.managedFieldCount;
            System.arraycopy(managedFieldNames, 0, this.annotatedFieldNames, 0, i2);
            System.arraycopy(managedFieldSigs, 0, this.annotatedFieldSigs, 0, i2);
            System.arraycopy(managedFieldMods, 0, this.annotatedFieldMods, 0, i2);
            System.arraycopy(managedFieldFlags, 0, this.annotatedFieldFlags, 0, i2);
            Iterator k = annotatedFieldMap.entrySet().iterator();
            while (k.hasNext()) {
                Map.Entry entry = k.next();
                String name = (String)entry.getKey();
                ClassField field = (ClassField)entry.getValue();
                Assertion.affirm(name.equals(field.name().asString()));
                Assertion.affirm(!field.isStatic(), "The managed field " + this.userClassName + "." + name + " is static.");
                this.annotatedFieldNames[i2] = name;
                this.annotatedFieldSigs[i2] = field.signature().asString();
                this.annotatedFieldMods[i2] = field.access();
                this.annotatedFieldFlags[i2] = 0;
                ++i2;
            }
            Assertion.affirm(i2 == this.annotatedFieldCount);
        }
        Assertion.affirm(this.keyFieldIndexes.length == this.keyFieldCount);
        Assertion.affirm(this.keyFieldCount <= this.managedFieldCount);
        Assertion.affirm(this.annotatedFieldNames.length == this.annotatedFieldCount);
        Assertion.affirm(this.annotatedFieldSigs.length == this.annotatedFieldCount);
        Assertion.affirm(this.annotatedFieldMods.length == this.annotatedFieldCount);
        Assertion.affirm(this.annotatedFieldFlags.length == this.annotatedFieldCount);
        Assertion.affirm(this.managedFieldCount <= this.annotatedFieldCount);
    }

    private void scanMethods() {
        Enumeration e = this.classFile.methods().elements();
        while (e.hasMoreElements()) {
            ClassMethod m;
            ClassMethod method = (ClassMethod)e.nextElement();
            String name = method.name().asString();
            String sig = method.signature().asString();
            Assertion.affirm(name != null);
            Assertion.affirm(sig != null);
            String key = Analyzer.methodKey(name, sig);
            Assertion.affirm(key != null);
            if (!method.isAbstract() && !method.isNative()) {
                m = this.annotatableMethods.put(key, method);
                Assertion.affirm(m == null);
            }
            if (name.startsWith("jdo")) {
                m = this.jdoLikeMethods.put(key, method);
                Assertion.affirm(m == null);
                continue;
            }
            if (name.equals(NameHelper.constructorName()) && sig.equals(NameHelper.constructorSig())) {
                this.hasDefaultConstructor = true;
                continue;
            }
            if (name.equals("<clinit>") && sig.equals("()V")) {
                this.hasStaticInitializer = true;
                continue;
            }
            if (name.equals("clone") && sig.equals(JAVA_ClassConstants.JAVA_Object_clone_Sig)) {
                this.hasCloneMethod = true;
                continue;
            }
            if (name.equals("writeObject") && sig.equals(JAVA_ClassConstants.JAVA_Object_writeObject_Sig)) {
                this.hasWriteObjectMethod = true;
                continue;
            }
            if (!name.equals("readObject") || !sig.equals(JAVA_ClassConstants.JAVA_Object_readObject_Sig)) continue;
            this.hasReadObjectMethod = true;
            m = this.annotatableMethods.remove(key);
            Assertion.affirm(m != null);
        }
        if (this.hasDefaultConstructor) {
            this.env.message(Support.getI18N("enhancer.class_has_default_constructor"));
        } else {
            this.env.message(Support.getI18N("enhancer.class_has_not_default_constructor"));
        }
        if (this.hasStaticInitializer) {
            this.env.message(Support.getI18N("enhancer.class_has_static_initializer"));
        } else {
            this.env.message(Support.getI18N("enhancer.class_has_not_static_initializer"));
        }
        if (this.hasCloneMethod) {
            this.env.message(Support.getI18N("enhancer.class_has_clone_method"));
        } else {
            this.env.message(Support.getI18N("enhancer.class_has_not_clone_method"));
        }
        if (this.hasWriteObjectMethod) {
            this.env.message(Support.getI18N("enhancer.class_has_writeObject_method"));
        } else {
            this.env.message(Support.getI18N("enhancer.class_has_not_writeObject_method"));
        }
        if (this.hasReadObjectMethod) {
            this.env.message(Support.getI18N("enhancer.class_has_readObject_method"));
        } else {
            this.env.message(Support.getI18N("enhancer.class_has_not_readObject_method"));
        }
    }

    private void checkGenericAugmentation() {
        boolean none;
        this.scanForImplementsPC();
        this.scanForGenericJDOFields();
        this.scanForGenericJDOMethods();
        boolean all = this.hasImplementsPC && this.hasGenericJDOFields && this.hasGenericJDOMethods;
        boolean bl = none = !this.hasImplementsPC && !this.hasGenericJDOFields && !this.hasGenericJDOMethods;
        if (all ^ none) {
            this.hasGenericJDOMembers = this.hasImplementsPC;
            this.env.message(Support.getI18N("enhancer.class_has_generic_jdo_members", String.valueOf(this.hasGenericJDOMembers)));
            return;
        }
        String key = "enhancer.class_has_inconsistently_declared_jdo_members";
        if (this.hasGenericJDOFields && !this.hasGenericJDOMethods) {
            this.env.error(Support.getI18N("enhancer.class_has_inconsistently_declared_jdo_members", this.userClassName, "<generic jdo fields>", "<generic jdo methods>"));
        } else if (!this.hasGenericJDOFields && this.hasGenericJDOMethods) {
            this.env.error(Support.getI18N("enhancer.class_has_inconsistently_declared_jdo_members", this.userClassName, "<generic jdo methods>", "<generic jdo fields>"));
        } else if (!this.hasGenericJDOFields && !this.hasGenericJDOMethods) {
            this.env.error(Support.getI18N("enhancer.class_has_inconsistently_declared_jdo_members", this.userClassName, "<implements PersistenceCapable>", "<generic jdo members>"));
        } else {
            this.env.error(Support.getI18N("enhancer.class_has_inconsistently_declared_jdo_members", this.userClassName, "<generic jdo members>", "<implements PersistenceCapable>"));
        }
    }

    private void checkSpecificAugmentation() {
        boolean none;
        this.scanForSpecificJDOFields();
        this.scanForSpecificJDOMethods();
        boolean all = this.hasSpecificJDOFields && this.hasSpecificJDOMethods;
        boolean bl = none = !this.hasSpecificJDOFields && !this.hasSpecificJDOMethods;
        if (all ^ none) {
            this.hasSpecificJDOMembers = this.hasSpecificJDOFields;
            this.env.message(Support.getI18N("enhancer.class_has_specific_jdo_members", String.valueOf(this.hasSpecificJDOMembers)));
            return;
        }
        String key = "enhancer.class_has_inconsistently_declared_jdo_members";
        if (this.hasSpecificJDOFields && !this.hasSpecificJDOMethods) {
            this.env.error(Support.getI18N("enhancer.class_has_inconsistently_declared_jdo_members", this.userClassName, "<specific jdo fields>", "<specific jdo methods>"));
        } else {
            this.env.error(Support.getI18N("enhancer.class_has_inconsistently_declared_jdo_members", this.userClassName, "<specific jdo methods>", "<specific jdo fields>"));
        }
    }

    private void checkCallbackAugmentation() {
        this.scanForCallbackJDOMethods();
        this.env.message(Support.getI18N("enhancer.class_has_callback_jdo_methods", String.valueOf(this.hasCallbackJDOMethods)));
    }

    private void checkPCFeasibility() {
        if (!this.hasDefaultConstructor) {
            this.env.error(Support.getI18N("enhancer.class_missing_default_constructor", this.userClassName));
        }
    }

    private void scanForImplementsPC() {
        this.hasImplementsPC = false;
        Iterator ifc = ((AbstractList)this.classFile.interfaces()).iterator();
        while (ifc.hasNext()) {
            ConstClass i = (ConstClass)ifc.next();
            if (!i.asString().equals(JDO_ClassConstants.JDO_PersistenceCapable_Path)) continue;
            this.hasImplementsPC = true;
            break;
        }
        this.env.message(Support.getI18N("enhancer.class_implements_jdo_pc", String.valueOf(this.hasImplementsPC)));
    }

    private void scanForGenericJDOFields() {
        if (this.jdoLikeFields.isEmpty()) {
            this.hasGenericJDOFields = false;
            this.env.message(Support.getI18N("enhancer.class_has_generic_jdo_fields", String.valueOf(this.hasGenericJDOFields)));
            return;
        }
        HashSet found = new HashSet(10);
        HashSet missing = new HashSet(10);
        this.scanJDOField("jdoStateManager", JDO_PC_MemberConstants.JDO_PC_jdoStateManager_Sig, 132, found, missing);
        this.scanJDOField("jdoFlags", "B", 132, found, missing);
        if (found.isEmpty() ^ missing.isEmpty()) {
            this.hasGenericJDOFields = missing.isEmpty();
            this.env.message(Support.getI18N("enhancer.class_has_generic_jdo_fields", String.valueOf(this.hasGenericJDOFields)));
            return;
        }
        this.reportInconsistentJDOMembers(found, missing);
    }

    private void scanForGenericJDOMethods() {
        if (this.jdoLikeMethods.isEmpty()) {
            this.hasGenericJDOMethods = false;
            this.env.message(Support.getI18N("enhancer.class_has_generic_jdo_methods", String.valueOf(this.hasGenericJDOMethods)));
            return;
        }
        HashSet found = new HashSet(30);
        HashSet missing = new HashSet(30);
        this.scanJDOMethod("jdoReplaceStateManager", JDO_PC_MemberConstants.JDO_PC_jdoReplaceStateManager_Sig, 49, found, missing);
        this.scanJDOMethod("jdoReplaceFlags", "()V", 17, found, missing);
        this.scanJDOMethod("jdoGetPersistenceManager", JDO_PC_MemberConstants.JDO_PC_jdoGetPersistenceManager_Sig, 17, found, missing);
        this.scanJDOMethod("jdoGetObjectId", JDO_PC_MemberConstants.JDO_PC_jdoGetObjectId_Sig, 17, found, missing);
        this.scanJDOMethod("jdoGetTransactionalObjectId", JDO_PC_MemberConstants.JDO_PC_jdoGetTransactionalObjectId_Sig, 17, found, missing);
        this.scanJDOMethod("jdoIsPersistent", "()Z", 17, found, missing);
        this.scanJDOMethod("jdoIsTransactional", "()Z", 17, found, missing);
        this.scanJDOMethod("jdoIsNew", "()Z", 17, found, missing);
        this.scanJDOMethod("jdoIsDeleted", "()Z", 17, found, missing);
        this.scanJDOMethod("jdoIsDirty", "()Z", 17, found, missing);
        this.scanJDOMethod("jdoMakeDirty", JDO_PC_MemberConstants.JDO_PC_jdoMakeDirty_Sig, 17, found, missing);
        this.scanJDOMethod("jdoPreSerialize", "()V", 20, found, missing);
        this.scanJDOMethod("jdoReplaceFields", "([I)V", 17, found, missing);
        this.scanJDOMethod("jdoProvideFields", "([I)V", 17, found, missing);
        if (found.isEmpty() ^ missing.isEmpty()) {
            this.hasGenericJDOMethods = missing.isEmpty();
            this.env.message(Support.getI18N("enhancer.class_has_generic_jdo_methods", String.valueOf(this.hasGenericJDOMethods)));
            return;
        }
        this.reportInconsistentJDOMembers(found, missing);
    }

    private void scanForSpecificJDOFields() {
        if (this.jdoLikeFields.isEmpty()) {
            this.hasSpecificJDOFields = false;
            this.env.message(Support.getI18N("enhancer.class_has_specific_jdo_fields", String.valueOf(this.hasSpecificJDOFields)));
            return;
        }
        HashSet found = new HashSet(10);
        HashSet missing = new HashSet(10);
        this.scanJDOField("jdoInheritedFieldCount", "I", 26, found, missing);
        this.scanJDOField("jdoFieldNames", JDO_PC_MemberConstants.JDO_PC_jdoFieldNames_Sig, 26, found, missing);
        this.scanJDOField("jdoFieldTypes", JDO_PC_MemberConstants.JDO_PC_jdoFieldTypes_Sig, 26, found, missing);
        this.scanJDOField("jdoFieldFlags", "[B", 26, found, missing);
        this.scanJDOField("jdoPersistenceCapableSuperclass", JDO_PC_MemberConstants.JDO_PC_jdoPersistenceCapableSuperclass_Sig, 26, found, missing);
        if (found.isEmpty() ^ missing.isEmpty()) {
            this.hasSpecificJDOFields = missing.isEmpty();
            this.env.message(Support.getI18N("enhancer.class_has_specific_jdo_fields", String.valueOf(this.hasSpecificJDOFields)));
            return;
        }
        this.reportInconsistentJDOMembers(found, missing);
    }

    private void scanForSpecificJDOMethods() {
        if (this.jdoLikeMethods.isEmpty()) {
            this.hasSpecificJDOMethods = false;
            this.env.message(Support.getI18N("enhancer.class_has_specific_jdo_methods", String.valueOf(this.hasSpecificJDOMethods)));
            return;
        }
        HashSet found = new HashSet(30);
        HashSet missing = new HashSet(30);
        this.scanJDOMethod("jdoGetManagedFieldCount", "()I", 12, found, missing);
        this.scanJDOMethod("jdoNewInstance", JDO_PC_MemberConstants.JDO_PC_jdoNewInstance_Sig, 1, found, missing);
        this.scanJDOMethod("jdoNewInstance", JDO_PC_MemberConstants.JDO_PC_jdoNewInstance_Sig, 1, found, missing);
        this.scanJDOMethod("jdoNewObjectIdInstance", JDO_PC_MemberConstants.JDO_PC_jdoNewObjectIdInstance_Sig, 1, found, missing);
        this.scanJDOMethod("jdoNewObjectIdInstance", JDO_PC_MemberConstants.JDO_PC_jdoNewObjectIdInstance_Sig, 1, found, missing);
        this.scanJDOMethod("jdoCopyKeyFieldsToObjectId", JDO_PC_MemberConstants.JDO_PC_jdoCopyKeyFieldsToObjectId_Sig, 1, found, missing);
        this.scanJDOMethod("jdoCopyKeyFieldsToObjectId", JDO_PC_MemberConstants.JDO_PC_jdoCopyKeyFieldsToObjectId_OIFS_Sig, 1, found, missing);
        this.scanJDOMethod("jdoCopyKeyFieldsFromObjectId", JDO_PC_MemberConstants.JDO_PC_jdoCopyKeyFieldsFromObjectId_OIFC_Sig, 1, found, missing);
        this.scanJDOMethod("jdoReplaceField", "(I)V", 1, found, missing);
        this.scanJDOMethod("jdoProvideField", "(I)V", 1, found, missing);
        this.scanJDOMethod("jdoCopyFields", JDO_PC_MemberConstants.JDO_PC_jdoCopyFields_Sig, 1, found, missing);
        this.scanJDOMethod("jdoCopyField", JDONameHelper.getJDO_PC_jdoCopyField_Sig(this.className), 20, found, missing);
        if (found.isEmpty() ^ missing.isEmpty()) {
            this.hasSpecificJDOMethods = missing.isEmpty();
            this.env.message(Support.getI18N("enhancer.class_has_specific_jdo_methods", String.valueOf(this.hasSpecificJDOMethods)));
            return;
        }
        this.reportInconsistentJDOMembers(found, missing);
    }

    private void scanForCallbackJDOMethods() {
        if (this.jdoLikeMethods.isEmpty()) {
            this.hasCallbackJDOMethods = false;
            this.env.message(Support.getI18N("enhancer.class_has_callback_jdo_methods", String.valueOf(this.hasCallbackJDOMethods)));
            return;
        }
        HashSet found = new HashSet(30);
        HashSet missing = new HashSet(30);
        boolean annotatable = true;
        this.scanJDOMethod("jdoPostLoad", "()V", 1, found, missing, false);
        this.scanJDOMethod("jdoPreStore", "()V", 1, found, missing, true);
        this.scanJDOMethod("jdoPreClear", "()V", 1, found, missing, false);
        this.scanJDOMethod("jdoPreDelete", "()V", 1, found, missing, true);
        if (!found.isEmpty()) {
            this.hasCallbackJDOMethods = true;
            this.env.message(Support.getI18N("enhancer.class_has_callback_jdo_methods", String.valueOf(this.hasCallbackJDOMethods)));
        }
    }

    private void scanJDOField(String fieldName, String expectedSig, int expectedMods, Set found, Set missing) {
        ClassField field = (ClassField)this.jdoLikeFields.get(fieldName);
        if (field == null) {
            missing.add(fieldName);
            return;
        }
        found.add(fieldName);
        String foundSig = field.signature().asString();
        int foundMods = field.access();
        if (!expectedSig.equals(foundSig) || expectedMods != foundMods) {
            this.env.error(Support.getI18N("enhancer.class_has_illegally_declared_jdo_member", new Object[]{this.userClassName, fieldName, expectedSig, foundSig, new Integer(expectedMods), new Integer(foundMods)}));
        }
    }

    private void scanJDOMethod(String methodName, String expectedSig, int expectedMods, Set found, Set missing) {
        this.scanJDOMethod(methodName, expectedSig, expectedMods, found, missing, true);
    }

    private void scanJDOMethod(String methodName, String expectedSig, int expectedMods, Set found, Set missing, boolean annotatable) {
        String key = Analyzer.methodKey(methodName, expectedSig);
        ClassMethod method = (ClassMethod)this.jdoLikeMethods.get(key);
        if (method == null) {
            missing.add(key);
            return;
        }
        found.add(key);
        String foundSig = method.signature().asString();
        int foundMods = method.access();
        if (!expectedSig.equals(foundSig) || expectedMods != foundMods) {
            this.env.error(Support.getI18N("enhancer.class_has_illegally_declared_jdo_member", new Object[]{this.userClassName, methodName, expectedSig, foundSig, new Integer(expectedMods), new Integer(foundMods)}));
        }
        if (!annotatable) {
            Object m = this.annotatableMethods.remove(key);
            Assertion.affirm(m != null);
        }
    }

    private void reportInconsistentJDOMembers(Set found, Set missing) {
        Iterator fi = found.iterator();
        StringBuffer f = new StringBuffer((String)fi.next());
        while (fi.hasNext()) {
            f.append(", " + fi.next());
        }
        Iterator mi = found.iterator();
        StringBuffer m = new StringBuffer((String)mi.next());
        while (mi.hasNext()) {
            m.append(", " + mi.next());
        }
        this.env.error(Support.getI18N("enhancer.class_has_inconsistently_declared_jdo_members", this.userClassName, f.toString(), m.toString()));
    }

    private static String methodKey(String name, String sig) {
        Assertion.affirm(name != null);
        Assertion.affirm(sig != null && sig.charAt(0) == '(' && sig.indexOf(41) > 0);
        String parms = sig.substring(0, sig.indexOf(41) + 1);
        return name + parms;
    }

    static {
        jdoFieldNames.add("jdoStateManager");
        jdoFieldNames.add("jdoFlags");
        jdoFieldNames.add("jdoInheritedFieldCount");
        jdoFieldNames.add("jdoFieldNames");
        jdoFieldNames.add("jdoFieldTypes");
        jdoFieldNames.add("jdoFieldFlags");
        jdoFieldNames.add("jdoPersistenceCapableSuperclass");
    }
}

