/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.classfile;

import com.sap.jdo.enhancer.classfile.ClassAttribute;
import com.sap.jdo.enhancer.classfile.ClassPrint;
import com.sap.jdo.enhancer.classfile.CodeEnv;
import com.sap.jdo.enhancer.classfile.ConstUtf8;
import com.sap.jdo.enhancer.classfile.LocalVariable;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;

public class LocalVariableTableAttribute
extends ClassAttribute {
    public static final String expectedAttrName = "LocalVariableTable";
    private Vector localTable;

    Enumeration variables() {
        return this.localTable.elements();
    }

    public LocalVariableTableAttribute(ConstUtf8 nameAttr, Vector lvarTable) {
        super(nameAttr);
        this.localTable = lvarTable;
    }

    static LocalVariableTableAttribute read(ConstUtf8 attrName, DataInputStream data, CodeEnv env) throws IOException {
        int nVars = data.readUnsignedShort();
        Vector<LocalVariable> lvarTable = new Vector<LocalVariable>();
        while (nVars-- > 0) {
            lvarTable.addElement(LocalVariable.read(data, env));
        }
        return new LocalVariableTableAttribute(attrName, lvarTable);
    }

    void write(DataOutputStream out) throws IOException {
        out.writeShort(this.attrName().getIndex());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream tmp_out = new DataOutputStream(baos);
        tmp_out.writeShort(this.localTable.size());
        int i = 0;
        while (i < this.localTable.size()) {
            ((LocalVariable)this.localTable.elementAt(i)).write(tmp_out);
            ++i;
        }
        tmp_out.flush();
        byte[] tmp_bytes = baos.toByteArray();
        out.writeInt(tmp_bytes.length);
        out.write(tmp_bytes, 0, tmp_bytes.length);
    }

    void print(PrintStream out, int indent) {
        ClassPrint.spaces(out, indent);
        out.println("LocalVariables: ");
        int i = 0;
        while (i < this.localTable.size()) {
            ((LocalVariable)this.localTable.elementAt(i)).print(out, indent + 2);
            ++i;
        }
    }
}

