/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.classfile;

import com.sap.jdo.enhancer.classfile.ConstValue;
import com.sap.jdo.enhancer.classfile.ConstantPool;
import com.sap.jdo.enhancer.classfile.Insn;
import com.sap.jdo.enhancer.classfile.InsnError;
import com.sap.jdo.enhancer.classfile.VMConstants;

public class InsnUtils
implements VMConstants {
    public static Insn constantValue(ConstValue value) {
        int tag = value.tag();
        switch (tag) {
            case 3: 
            case 4: 
            case 8: {
                int opcode = value.getIndex() <= 255 ? 18 : 19;
                return Insn.create(opcode, value);
            }
            case 5: 
            case 6: {
                return Insn.create(20, value);
            }
        }
        throw new InsnError("bad constant tag");
    }

    public static Insn stringConstant(String s, ConstantPool pool) {
        return InsnUtils.constantValue(pool.addString(s));
    }

    public static Insn integerConstant(int i, ConstantPool pool) {
        if (i == -1) {
            return Insn.create(2);
        }
        if (i == 0) {
            return Insn.create(3);
        }
        if (i == 1) {
            return Insn.create(4);
        }
        if (i == 2) {
            return Insn.create(5);
        }
        if (i == 3) {
            return Insn.create(6);
        }
        if (i == 4) {
            return Insn.create(7);
        }
        if (i == 5) {
            return Insn.create(8);
        }
        if (i >= -128 && i < 128) {
            return Insn.create(16, i);
        }
        if (i >= Short.MIN_VALUE && i < 32768) {
            return Insn.create(17, i);
        }
        return InsnUtils.constantValue(pool.addInteger(i));
    }

    public static Insn longConstant(long l, ConstantPool pool) {
        if (l == 0L) {
            return Insn.create(9);
        }
        if (l == 1L) {
            return Insn.create(10);
        }
        return InsnUtils.constantValue(pool.addLong(l));
    }

    public static Insn floatConstant(float f, ConstantPool pool) {
        if (f == 0.0f) {
            return Insn.create(11);
        }
        if (f == 1.0f) {
            return Insn.create(12);
        }
        if (f == 2.0f) {
            return Insn.create(13);
        }
        return InsnUtils.constantValue(pool.addFloat(f));
    }

    public static Insn doubleConstant(double d, ConstantPool pool) {
        if (d == 0.0) {
            return Insn.create(14);
        }
        if (d == 1.0) {
            return Insn.create(15);
        }
        return InsnUtils.constantValue(pool.addDouble(d));
    }

    public static Insn aStore(int i, ConstantPool pool) {
        if (i == 0) {
            return Insn.create(75);
        }
        if (i == 1) {
            return Insn.create(76);
        }
        if (i == 2) {
            return Insn.create(77);
        }
        if (i == 3) {
            return Insn.create(78);
        }
        return Insn.create(58, i);
    }

    public static Insn iStore(int i, ConstantPool pool) {
        if (i == 0) {
            return Insn.create(59);
        }
        if (i == 1) {
            return Insn.create(60);
        }
        if (i == 2) {
            return Insn.create(61);
        }
        if (i == 3) {
            return Insn.create(62);
        }
        return Insn.create(54, i);
    }

    public static Insn fStore(int i, ConstantPool pool) {
        if (i == 0) {
            return Insn.create(67);
        }
        if (i == 1) {
            return Insn.create(68);
        }
        if (i == 2) {
            return Insn.create(69);
        }
        if (i == 3) {
            return Insn.create(70);
        }
        return Insn.create(56, i);
    }

    public static Insn lStore(int i, ConstantPool pool) {
        if (i == 0) {
            return Insn.create(63);
        }
        if (i == 1) {
            return Insn.create(64);
        }
        if (i == 2) {
            return Insn.create(65);
        }
        if (i == 3) {
            return Insn.create(66);
        }
        return Insn.create(55, i);
    }

    public static Insn dStore(int i, ConstantPool pool) {
        if (i == 0) {
            return Insn.create(71);
        }
        if (i == 1) {
            return Insn.create(72);
        }
        if (i == 2) {
            return Insn.create(73);
        }
        if (i == 3) {
            return Insn.create(74);
        }
        return Insn.create(57, i);
    }

    public static Insn aLoad(int i, ConstantPool pool) {
        if (i == 0) {
            return Insn.create(42);
        }
        if (i == 1) {
            return Insn.create(43);
        }
        if (i == 2) {
            return Insn.create(44);
        }
        if (i == 3) {
            return Insn.create(45);
        }
        return Insn.create(25, i);
    }

    public static Insn iLoad(int i, ConstantPool pool) {
        if (i == 0) {
            return Insn.create(26);
        }
        if (i == 1) {
            return Insn.create(27);
        }
        if (i == 2) {
            return Insn.create(28);
        }
        if (i == 3) {
            return Insn.create(29);
        }
        return Insn.create(21, i);
    }

    public static Insn fLoad(int i, ConstantPool pool) {
        if (i == 0) {
            return Insn.create(34);
        }
        if (i == 1) {
            return Insn.create(35);
        }
        if (i == 2) {
            return Insn.create(36);
        }
        if (i == 3) {
            return Insn.create(37);
        }
        return Insn.create(23, i);
    }

    public static Insn lLoad(int i, ConstantPool pool) {
        if (i == 0) {
            return Insn.create(30);
        }
        if (i == 1) {
            return Insn.create(31);
        }
        if (i == 2) {
            return Insn.create(32);
        }
        if (i == 3) {
            return Insn.create(33);
        }
        return Insn.create(22, i);
    }

    public static Insn dLoad(int i, ConstantPool pool) {
        if (i == 0) {
            return Insn.create(38);
        }
        if (i == 1) {
            return Insn.create(39);
        }
        if (i == 2) {
            return Insn.create(40);
        }
        if (i == 3) {
            return Insn.create(41);
        }
        return Insn.create(24, i);
    }

    public static Insn load(int tp, int i, ConstantPool pool) {
        switch (tp) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return InsnUtils.iLoad(i, pool);
            }
            case 6: {
                return InsnUtils.fLoad(i, pool);
            }
            case 7: {
                return InsnUtils.dLoad(i, pool);
            }
            case 11: {
                return InsnUtils.lLoad(i, pool);
            }
            case 12: {
                return InsnUtils.aLoad(i, pool);
            }
        }
        throw new InsnError("bad load type");
    }

    public static Insn store(int tp, int i, ConstantPool pool) {
        switch (tp) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return InsnUtils.iStore(i, pool);
            }
            case 6: {
                return InsnUtils.fStore(i, pool);
            }
            case 7: {
                return InsnUtils.dStore(i, pool);
            }
            case 11: {
                return InsnUtils.lStore(i, pool);
            }
            case 12: {
                return InsnUtils.aStore(i, pool);
            }
        }
        throw new InsnError("bad store type");
    }
}

