/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.classfile;

import com.sap.jdo.enhancer.classfile.ClassPrint;
import com.sap.jdo.enhancer.classfile.ConstClass;
import com.sap.jdo.enhancer.classfile.Insn;
import com.sap.jdo.enhancer.classfile.InsnError;
import com.sap.jdo.enhancer.classfile.InsnReadEnv;
import java.io.PrintStream;
import java.util.Stack;

public class InsnMultiDimArrayNew
extends Insn {
    private ConstClass classOp;
    private int nDimsOp;

    public boolean isSimpleLoad() {
        return false;
    }

    public int nStackArgs() {
        return this.nDimsOp;
    }

    public int nStackResults() {
        return 1;
    }

    public String argTypes() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.nDimsOp) {
            buf.append("I");
            ++i;
        }
        return buf.toString();
    }

    public String resultTypes() {
        return "A";
    }

    public boolean branches() {
        return false;
    }

    public ConstClass arrayClass() {
        return this.classOp;
    }

    public void setArrayClass(ConstClass classOp) {
        this.classOp = classOp;
    }

    public int nDims() {
        return this.nDimsOp;
    }

    public InsnMultiDimArrayNew(ConstClass classOp, int nDimsOp) {
        this(classOp, nDimsOp, -1);
    }

    public boolean isEqual(Stack msg, Object obj) {
        if (!(obj instanceof InsnMultiDimArrayNew)) {
            msg.push("obj/obj.getClass() = " + (obj == null ? null : obj.getClass()));
            msg.push("this.getClass() = " + this.getClass());
            return false;
        }
        InsnMultiDimArrayNew other = (InsnMultiDimArrayNew)obj;
        if (!super.isEqual(msg, other)) {
            return false;
        }
        if (!this.classOp.isEqual(msg, other.classOp)) {
            msg.push(String.valueOf("classOp = " + other.classOp));
            msg.push(String.valueOf("classOp = " + this.classOp));
            return false;
        }
        if (this.nDimsOp != other.nDimsOp) {
            msg.push(String.valueOf("nDimsOp = " + other.nDimsOp));
            msg.push(String.valueOf("nDimsOp = " + this.nDimsOp));
            return false;
        }
        return true;
    }

    InsnMultiDimArrayNew(ConstClass classOp, int nDimsOp, int offset) {
        super(197, offset);
        this.classOp = classOp;
        this.nDimsOp = nDimsOp;
        if (classOp == null || nDimsOp < 1) {
            throw new InsnError("attempt to create an opc_multianewarray with invalid operands");
        }
    }

    void print(PrintStream out, int indent) {
        ClassPrint.spaces(out, indent);
        out.println(this.offset() + "  opc_multianewarray  pool(" + this.classOp.getIndex() + ")," + this.nDimsOp);
    }

    int store(byte[] buf, int index) {
        buf[index++] = (byte)this.opcode();
        index = Insn.storeShort(buf, index, (short)this.classOp.getIndex());
        buf[index++] = (byte)this.nDimsOp;
        return index;
    }

    int size() {
        return 4;
    }

    static InsnMultiDimArrayNew read(InsnReadEnv insnEnv, int myPC) {
        ConstClass classOp = (ConstClass)insnEnv.pool().constantAt(insnEnv.getUShort());
        int nDims = insnEnv.getUByte();
        return new InsnMultiDimArrayNew(classOp, nDims, myPC);
    }
}

