/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.classfile;

import com.sap.jdo.enhancer.classfile.ClassPrint;
import com.sap.jdo.enhancer.classfile.Insn;
import com.sap.jdo.enhancer.classfile.InsnError;
import com.sap.jdo.enhancer.classfile.InsnReadEnv;
import com.sap.jdo.enhancer.classfile.InsnTarget;
import java.io.PrintStream;
import java.util.Stack;

public class InsnLookupSwitch
extends Insn {
    private InsnTarget defaultOp;
    private int[] matchesOp;
    private InsnTarget[] targetsOp;

    public int nStackArgs() {
        return 1;
    }

    public int nStackResults() {
        return 0;
    }

    public String argTypes() {
        return "I";
    }

    public String resultTypes() {
        return "";
    }

    public boolean branches() {
        return true;
    }

    public void markTargets() {
        this.defaultOp.setBranchTarget();
        int i = 0;
        while (i < this.targetsOp.length) {
            this.targetsOp[i].setBranchTarget();
            ++i;
        }
    }

    public InsnTarget defaultTarget() {
        return this.defaultOp;
    }

    public int[] switchCases() {
        return this.matchesOp;
    }

    public InsnTarget[] switchTargets() {
        return this.targetsOp;
    }

    public InsnLookupSwitch(InsnTarget defaultOp, int[] matchesOp, InsnTarget[] targetsOp) {
        this(defaultOp, matchesOp, targetsOp, -1);
    }

    public boolean isEqual(Stack msg, Object obj) {
        if (!(obj instanceof InsnLookupSwitch)) {
            msg.push("obj/obj.getClass() = " + (obj == null ? null : obj.getClass()));
            msg.push("this.getClass() = " + this.getClass());
            return false;
        }
        InsnLookupSwitch other = (InsnLookupSwitch)obj;
        if (!super.isEqual(msg, other)) {
            return false;
        }
        if (!this.defaultOp.isEqual(msg, other.defaultOp)) {
            msg.push(String.valueOf("defaultOp = " + other.defaultOp));
            msg.push(String.valueOf("defaultOp = " + this.defaultOp));
            return false;
        }
        if (this.matchesOp.length != other.matchesOp.length) {
            msg.push("matchesOp.length " + String.valueOf(other.matchesOp.length));
            msg.push("matchesOp.length " + String.valueOf(this.matchesOp.length));
            return false;
        }
        int i = 0;
        while (i < this.matchesOp.length) {
            int m1 = this.matchesOp[i];
            int m2 = other.matchesOp[i];
            if (m1 != m2) {
                msg.push("matchesOp[" + i + "] = " + String.valueOf(m2));
                msg.push("matchesOp[" + i + "] = " + String.valueOf(m1));
                return false;
            }
            ++i;
        }
        if (this.targetsOp.length != other.targetsOp.length) {
            msg.push("targetsOp.length " + String.valueOf(other.targetsOp.length));
            msg.push("targetsOp.length " + String.valueOf(this.targetsOp.length));
            return false;
        }
        int i2 = 0;
        while (i2 < this.targetsOp.length) {
            InsnTarget t1 = this.targetsOp[i2];
            InsnTarget t2 = other.targetsOp[i2];
            if (!t1.isEqual(msg, t2)) {
                msg.push("targetsOp[" + i2 + "] = " + String.valueOf(t2));
                msg.push("targetsOp[" + i2 + "] = " + String.valueOf(t1));
                return false;
            }
            ++i2;
        }
        return true;
    }

    InsnLookupSwitch(InsnTarget defaultOp, int[] matchesOp, InsnTarget[] targetsOp, int offset) {
        super(171, offset);
        this.defaultOp = defaultOp;
        this.matchesOp = matchesOp;
        this.targetsOp = targetsOp;
        if (defaultOp == null || targetsOp == null || matchesOp == null || targetsOp.length != matchesOp.length) {
            throw new InsnError("attempt to create an opc_lookupswitch with invalid operands");
        }
    }

    void print(PrintStream out, int indent) {
        ClassPrint.spaces(out, indent);
        out.println(this.offset() + "  opc_lookupswitch  ");
        int i = 0;
        while (i < this.matchesOp.length) {
            ClassPrint.spaces(out, indent + 2);
            out.println(this.matchesOp[i] + " -> " + this.targetsOp[i].offset());
            ++i;
        }
        ClassPrint.spaces(out, indent + 2);
        out.println("default -> " + this.defaultOp.offset());
    }

    int store(byte[] buf, int index) {
        buf[index++] = (byte)this.opcode();
        index = index + 3 & 0xFFFFFFFC;
        index = Insn.storeInt(buf, index, this.defaultOp.offset() - this.offset());
        index = Insn.storeInt(buf, index, this.targetsOp.length);
        int i = 0;
        while (i < this.targetsOp.length) {
            index = Insn.storeInt(buf, index, this.matchesOp[i]);
            index = Insn.storeInt(buf, index, this.targetsOp[i].offset() - this.offset());
            ++i;
        }
        return index;
    }

    int size() {
        int basic = (this.offset() + 4 & 0xFFFFFFFC) - this.offset() + 8;
        return basic + this.targetsOp.length * 8;
    }

    static InsnLookupSwitch read(InsnReadEnv insnEnv, int myPC) {
        int thisPC = myPC + 1;
        int pads = (thisPC + 3 & 0xFFFFFFFC) - thisPC;
        while (pads > 0) {
            insnEnv.getByte();
            --pads;
        }
        InsnTarget defaultTarget = insnEnv.getTarget(insnEnv.getInt() + myPC);
        int npairs = insnEnv.getInt();
        int[] matches = new int[npairs];
        InsnTarget[] offsets = new InsnTarget[npairs];
        int i = 0;
        while (i < npairs) {
            matches[i] = insnEnv.getInt();
            offsets[i] = insnEnv.getTarget(insnEnv.getInt() + myPC);
            ++i;
        }
        return new InsnLookupSwitch(defaultTarget, matches, offsets, myPC);
    }
}

