/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.classfile;

import com.sap.jdo.enhancer.classfile.ClassPrint;
import com.sap.jdo.enhancer.classfile.ConstInterfaceMethodRef;
import com.sap.jdo.enhancer.classfile.Insn;
import com.sap.jdo.enhancer.classfile.InsnConstOp;
import com.sap.jdo.enhancer.classfile.InsnError;
import com.sap.jdo.enhancer.classfile.InsnReadEnv;
import java.io.PrintStream;
import java.util.Stack;

public class InsnInterfaceInvoke
extends InsnConstOp {
    private int nArgsOp;

    public int nStackArgs() {
        return super.nStackArgs();
    }

    public int nStackResults() {
        return super.nStackResults();
    }

    public String argTypes() {
        return super.argTypes();
    }

    public String resultTypes() {
        return super.resultTypes();
    }

    public boolean branches() {
        return false;
    }

    public ConstInterfaceMethodRef method() {
        return (ConstInterfaceMethodRef)this.value();
    }

    public int nArgs() {
        return this.nArgsOp;
    }

    public InsnInterfaceInvoke(ConstInterfaceMethodRef methodRefOp, int nArgsOp) {
        this(methodRefOp, nArgsOp, -1);
    }

    public boolean isEqual(Stack msg, Object obj) {
        if (!(obj instanceof InsnInterfaceInvoke)) {
            msg.push("obj/obj.getClass() = " + (obj == null ? null : obj.getClass()));
            msg.push("this.getClass() = " + this.getClass());
            return false;
        }
        InsnInterfaceInvoke other = (InsnInterfaceInvoke)obj;
        if (!super.isEqual(msg, other)) {
            return false;
        }
        if (this.nArgsOp != other.nArgsOp) {
            msg.push(String.valueOf("nArgsOp = " + other.nArgsOp));
            msg.push(String.valueOf("nArgsOp = " + this.nArgsOp));
            return false;
        }
        return true;
    }

    InsnInterfaceInvoke(ConstInterfaceMethodRef methodRefOp, int nArgsOp, int offset) {
        super(185, methodRefOp, offset);
        this.nArgsOp = nArgsOp;
        if (methodRefOp == null || nArgsOp < 0) {
            throw new InsnError("attempt to create an opc_invokeinterface with invalid operands");
        }
    }

    void print(PrintStream out, int indent) {
        ClassPrint.spaces(out, indent);
        out.println(this.offset() + "  opc_invokeinterface  " + "pool(" + this.method().getIndex() + ")," + this.nArgsOp);
    }

    int store(byte[] buf, int index) {
        buf[index++] = (byte)this.opcode();
        index = Insn.storeShort(buf, index, (short)this.method().getIndex());
        buf[index++] = (byte)this.nArgsOp;
        buf[index++] = 0;
        return index;
    }

    int size() {
        return 5;
    }

    static InsnInterfaceInvoke read(InsnReadEnv insnEnv, int myPC) {
        ConstInterfaceMethodRef iface = (ConstInterfaceMethodRef)insnEnv.pool().constantAt(insnEnv.getUShort());
        int nArgs = insnEnv.getUByte();
        insnEnv.getByte();
        return new InsnInterfaceInvoke(iface, nArgs, myPC);
    }
}

