/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.classfile;

import com.sap.jdo.enhancer.classfile.ClassPrint;
import com.sap.jdo.enhancer.classfile.CodeEnv;
import com.sap.jdo.enhancer.classfile.ConstClass;
import com.sap.jdo.enhancer.classfile.InsnTarget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Stack;

public class ExceptionRange {
    private InsnTarget excStartPC;
    private InsnTarget excEndPC;
    private InsnTarget excHandlerPC;
    private ConstClass excCatchType;

    public InsnTarget startPC() {
        return this.excStartPC;
    }

    public InsnTarget endPC() {
        return this.excEndPC;
    }

    public InsnTarget handlerPC() {
        return this.excHandlerPC;
    }

    public ConstClass catchType() {
        return this.excCatchType;
    }

    public ExceptionRange(InsnTarget startPC, InsnTarget endPC, InsnTarget handlerPC, ConstClass catchType) {
        this.excStartPC = startPC;
        this.excEndPC = endPC;
        this.excHandlerPC = handlerPC;
        this.excCatchType = catchType;
    }

    public boolean isEqual(Stack msg, Object obj) {
        if (!(obj instanceof ExceptionRange)) {
            msg.push("obj/obj.getClass() = " + (obj == null ? null : obj.getClass()));
            msg.push("this.getClass() = " + this.getClass());
            return false;
        }
        ExceptionRange other = (ExceptionRange)obj;
        if (!this.excStartPC.isEqual(msg, other.excStartPC)) {
            msg.push(String.valueOf("excStartPC = " + other.excStartPC));
            msg.push(String.valueOf("excStartPC = " + this.excStartPC));
            return false;
        }
        if (!this.excEndPC.isEqual(msg, other.excEndPC)) {
            msg.push(String.valueOf("excEndPC = " + other.excEndPC));
            msg.push(String.valueOf("excEndPC = " + this.excEndPC));
            return false;
        }
        if (!this.excHandlerPC.isEqual(msg, other.excHandlerPC)) {
            msg.push(String.valueOf("excHandlerPC = " + other.excHandlerPC));
            msg.push(String.valueOf("excHandlerPC = " + this.excHandlerPC));
            return false;
        }
        if (!this.excCatchType.isEqual(msg, other.excCatchType)) {
            msg.push(String.valueOf("excCatchType = " + other.excCatchType));
            msg.push(String.valueOf("excCatchType = " + this.excCatchType));
            return false;
        }
        return true;
    }

    static ExceptionRange read(DataInputStream data, CodeEnv env) throws IOException {
        InsnTarget startPC = env.getTarget(data.readUnsignedShort());
        InsnTarget endPC = env.getTarget(data.readUnsignedShort());
        InsnTarget handlerPC = env.getTarget(data.readUnsignedShort());
        ConstClass catchType = (ConstClass)env.pool().constantAt(data.readUnsignedShort());
        return new ExceptionRange(startPC, endPC, handlerPC, catchType);
    }

    void write(DataOutputStream out) throws IOException {
        out.writeShort(this.excStartPC.offset());
        out.writeShort(this.excEndPC.offset());
        out.writeShort(this.excHandlerPC.offset());
        out.writeShort(this.excCatchType == null ? 0 : this.excCatchType.getIndex());
    }

    void print(PrintStream out, int indent) {
        ClassPrint.spaces(out, indent);
        out.print("Exc Range:");
        if (this.excCatchType == null) {
            out.print("any");
        } else {
            out.print("'" + this.excCatchType.asString() + "'");
        }
        out.print(" start = " + Integer.toString(this.excStartPC.offset()));
        out.print(" end = " + Integer.toString(this.excEndPC.offset()));
        out.println(" handle = " + Integer.toString(this.excHandlerPC.offset()));
    }
}

