/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.classfile;

import com.sap.jdo.enhancer.classfile.ConstUtf8;
import com.sap.jdo.enhancer.classfile.ConstValue;
import com.sap.jdo.enhancer.classfile.ConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Stack;

public class ConstString
extends ConstValue {
    public static final int MyTag = 8;
    private ConstUtf8 stringValue;
    private int stringValueIndex;

    public int tag() {
        return 8;
    }

    public ConstUtf8 value() {
        return this.stringValue;
    }

    public String descriptor() {
        return "Ljava/lang/String;";
    }

    public String toString() {
        return "CONSTANTString(" + this.indexAsString() + "): " + "string(" + this.stringValue.asString() + ")";
    }

    public boolean isEqual(Stack msg, Object obj) {
        if (!(obj instanceof ConstString)) {
            msg.push("obj/obj.getClass() = " + (obj == null ? null : obj.getClass()));
            msg.push("this.getClass() = " + this.getClass());
            return false;
        }
        ConstString other = (ConstString)obj;
        if (!super.isEqual(msg, other)) {
            return false;
        }
        if (!this.stringValue.isEqual(msg, other.stringValue)) {
            msg.push(String.valueOf("stringValue = " + other.stringValue));
            msg.push(String.valueOf("stringValue = " + this.stringValue));
            return false;
        }
        return true;
    }

    ConstString(ConstUtf8 s) {
        this.stringValue = s;
    }

    ConstString(int sIndex) {
        this.stringValueIndex = sIndex;
    }

    void formatData(DataOutputStream b) throws IOException {
        b.writeShort(this.stringValue.getIndex());
    }

    static ConstString read(DataInputStream input) throws IOException {
        return new ConstString(input.readUnsignedShort());
    }

    void resolve(ConstantPool p) {
        this.stringValue = (ConstUtf8)p.constantAt(this.stringValueIndex);
    }
}

