/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.classfile;

import com.sap.jdo.enhancer.classfile.ConstBasic;
import com.sap.jdo.enhancer.classfile.ConstUtf8;
import com.sap.jdo.enhancer.classfile.ConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Stack;

public class ConstNameAndType
extends ConstBasic {
    public static final int MyTag = 12;
    private ConstUtf8 theName;
    private int theNameIndex;
    private ConstUtf8 typeSignature;
    private int typeSignatureIndex;

    public int tag() {
        return 12;
    }

    public ConstUtf8 name() {
        return this.theName;
    }

    public ConstUtf8 signature() {
        return this.typeSignature;
    }

    public void changeSignature(ConstUtf8 newSig) {
        this.typeSignature = newSig;
    }

    public String toString() {
        return "CONSTANTNameAndType(" + this.indexAsString() + "): " + "name(" + this.theName.toString() + ") " + " type(" + this.typeSignature.toString() + ")";
    }

    public boolean isEqual(Stack msg, Object obj) {
        if (!(obj instanceof ConstNameAndType)) {
            msg.push("obj/obj.getClass() = " + (obj == null ? null : obj.getClass()));
            msg.push("this.getClass() = " + this.getClass());
            return false;
        }
        ConstNameAndType other = (ConstNameAndType)obj;
        if (!super.isEqual(msg, other)) {
            return false;
        }
        if (!this.theName.isEqual(msg, other.theName)) {
            msg.push(String.valueOf("theName = " + other.theName));
            msg.push(String.valueOf("theName = " + this.theName));
            return false;
        }
        if (!this.typeSignature.isEqual(msg, other.typeSignature)) {
            msg.push(String.valueOf("typeSignature = " + other.typeSignature));
            msg.push(String.valueOf("typeSignature = " + this.typeSignature));
            return false;
        }
        return true;
    }

    ConstNameAndType(ConstUtf8 n, ConstUtf8 sig) {
        this.theName = n;
        this.typeSignature = sig;
    }

    ConstNameAndType(int n, int sig) {
        this.theNameIndex = n;
        this.typeSignatureIndex = sig;
    }

    void formatData(DataOutputStream b) throws IOException {
        b.writeShort(this.theName.getIndex());
        b.writeShort(this.typeSignature.getIndex());
    }

    static ConstNameAndType read(DataInputStream input) throws IOException {
        int cname = input.readUnsignedShort();
        int sig = input.readUnsignedShort();
        return new ConstNameAndType(cname, sig);
    }

    void resolve(ConstantPool p) {
        this.theName = (ConstUtf8)p.constantAt(this.theNameIndex);
        this.typeSignature = (ConstUtf8)p.constantAt(this.typeSignatureIndex);
    }
}

