/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.classfile;

import com.sap.jdo.enhancer.classfile.ConstBasic;
import com.sap.jdo.enhancer.classfile.ConstUtf8;
import com.sap.jdo.enhancer.classfile.ConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Stack;

public class ConstClass
extends ConstBasic {
    public static final int MyTag = 7;
    private ConstUtf8 theClassName;
    private int theClassNameIndex;

    public int tag() {
        return 7;
    }

    public ConstUtf8 className() {
        return this.theClassName;
    }

    public String asString() {
        return this.theClassName.asString();
    }

    public String toString() {
        return "CONSTANTClass(" + this.indexAsString() + "): " + "className(" + this.theClassName.toString() + ")";
    }

    public void changeClass(ConstUtf8 newName) {
        this.theClassName = newName;
        this.theClassNameIndex = newName.getIndex();
    }

    public ConstClass(ConstUtf8 cname) {
        this.theClassName = cname;
    }

    public boolean isEqual(Stack msg, Object obj) {
        if (!(obj instanceof ConstClass)) {
            msg.push("obj/obj.getClass() = " + (obj == null ? null : obj.getClass()));
            msg.push("this.getClass() = " + this.getClass());
            return false;
        }
        ConstClass other = (ConstClass)obj;
        if (!super.isEqual(msg, other)) {
            return false;
        }
        if (!this.theClassName.isEqual(msg, other.theClassName)) {
            msg.push(String.valueOf("theClassName = " + other.theClassName));
            msg.push(String.valueOf("theClassName = " + this.theClassName));
            return false;
        }
        return true;
    }

    ConstClass(int cname) {
        this.theClassNameIndex = cname;
    }

    void formatData(DataOutputStream b) throws IOException {
        b.writeShort(this.theClassName.getIndex());
    }

    static ConstClass read(DataInputStream input) throws IOException {
        return new ConstClass(input.readUnsignedShort());
    }

    void resolve(ConstantPool p) {
        this.theClassName = (ConstUtf8)p.constantAt(this.theClassNameIndex);
    }
}

