/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.classfile;

import com.sap.jdo.enhancer.classfile.AttributeVector;
import com.sap.jdo.enhancer.classfile.ClassAttribute;
import com.sap.jdo.enhancer.classfile.ClassPrint;
import com.sap.jdo.enhancer.classfile.CodeEnv;
import com.sap.jdo.enhancer.classfile.ConstUtf8;
import com.sap.jdo.enhancer.classfile.ConstantPool;
import com.sap.jdo.enhancer.classfile.ExceptionTable;
import com.sap.jdo.enhancer.classfile.Insn;
import com.sap.jdo.enhancer.classfile.InsnError;
import com.sap.jdo.enhancer.classfile.InsnReadEnv;
import com.sap.jdo.enhancer.classfile.InsnTarget;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Stack;

public class CodeAttribute
extends ClassAttribute {
    public static final String expectedAttrName = "Code";
    private byte[] theDataBytes;
    private int maxStack;
    private int maxLocals;
    private byte[] theCodeBytes;
    private Insn theCode;
    private ExceptionTable exceptionTable;
    private AttributeVector codeAttributes;
    CodeEnv codeEnv;

    public int stackUsed() {
        this.makeValid();
        return this.maxStack;
    }

    public void setStackUsed(int used) {
        this.makeValid();
        this.maxStack = used;
    }

    public int localsUsed() {
        this.makeValid();
        return this.maxLocals;
    }

    public void setLocalsUsed(int used) {
        this.makeValid();
        this.maxLocals = used;
    }

    public byte[] byteCodes() {
        this.makeValid();
        return this.theCodeBytes;
    }

    public Insn theCode() {
        this.makeValid();
        if (this.theCode == null && this.codeEnv != null) {
            this.buildInstructions(this.codeEnv);
        }
        return this.theCode;
    }

    public void setTheCode(Insn insn) {
        this.makeValid();
        if (insn != null && insn.opcode() != -1) {
            throw new InsnError("The initial instruction in all methods must be a target");
        }
        this.theCode = insn;
    }

    public ExceptionTable exceptionHandlers() {
        this.makeValid();
        return this.exceptionTable;
    }

    public AttributeVector attributes() {
        this.makeValid();
        return this.codeAttributes;
    }

    public CodeAttribute(ConstUtf8 attrName, int maxStack, int maxLocals, Insn code, ExceptionTable excTable, AttributeVector codeAttrs) {
        this(attrName, maxStack, maxLocals, code, null, excTable, codeAttrs, null);
    }

    public CodeAttribute(ConstUtf8 attrName, int maxStack, int maxLocals, Insn code, byte[] codeBytes, ExceptionTable excTable, AttributeVector codeAttrs, CodeEnv codeEnv) {
        super(attrName);
        this.maxStack = maxStack;
        this.maxLocals = maxLocals;
        this.theCode = code;
        this.theCodeBytes = codeBytes;
        this.exceptionTable = excTable;
        this.codeAttributes = codeAttrs;
        this.codeEnv = codeEnv;
    }

    public CodeAttribute(ConstUtf8 attrName, byte[] dataBytes, CodeEnv codeEnv) {
        super(attrName);
        this.theDataBytes = dataBytes;
        this.codeEnv = codeEnv;
    }

    public boolean isEqual(Stack msg, Object obj) {
        if (!(obj instanceof CodeAttribute)) {
            msg.push("obj/obj.getClass() = " + (obj == null ? null : obj.getClass()));
            msg.push("this.getClass() = " + this.getClass());
            return false;
        }
        CodeAttribute other = (CodeAttribute)obj;
        if (!super.isEqual(msg, other)) {
            return false;
        }
        if (this.stackUsed() != other.stackUsed()) {
            msg.push(String.valueOf("stackUsed() = " + other.stackUsed()));
            msg.push(String.valueOf("stackUsed() = " + this.stackUsed()));
            return false;
        }
        if (this.localsUsed() != other.localsUsed()) {
            msg.push(String.valueOf("localsUsed() = " + other.localsUsed()));
            msg.push(String.valueOf("localsUsed() = " + this.localsUsed()));
            return false;
        }
        Insn theCode1 = this.theCode();
        Insn theCode2 = other.theCode();
        while (theCode1 != null && theCode2 != null) {
            if (theCode1.opcode() == -1) {
                theCode1 = theCode1.next();
                continue;
            }
            if (theCode2.opcode() == -1) {
                theCode2 = theCode2.next();
                continue;
            }
            if (!theCode1.isEqual(msg, theCode2)) {
                msg.push("theCode()[i] = " + String.valueOf(theCode2));
                msg.push("theCode()[i] = " + String.valueOf(theCode1));
                return false;
            }
            theCode1 = theCode1.next();
            theCode2 = theCode2.next();
        }
        if (theCode1 == null ^ theCode2 == null) {
            msg.push("theCode()[i] = " + String.valueOf(theCode2));
            msg.push("theCode()[i] = " + String.valueOf(theCode1));
            return false;
        }
        if (!this.exceptionHandlers().isEqual(msg, other.exceptionHandlers())) {
            msg.push(String.valueOf("exceptionHandlers() = " + other.exceptionHandlers()));
            msg.push(String.valueOf("exceptionHandlers() = " + this.exceptionHandlers()));
            return false;
        }
        if (!this.attributes().isEqual(msg, other.attributes())) {
            msg.push(String.valueOf("attributes() = " + other.attributes()));
            msg.push(String.valueOf("attributes() = " + this.attributes()));
            return false;
        }
        return true;
    }

    static CodeAttribute read(ConstUtf8 attrName, DataInputStream data, ConstantPool pool) throws IOException {
        int maxStack = data.readUnsignedShort();
        int maxLocals = data.readUnsignedShort();
        int codeLength = data.readInt();
        byte[] codeBytes = new byte[codeLength];
        data.readFully(codeBytes);
        Insn code = null;
        CodeEnv codeEnv = new CodeEnv(pool);
        ExceptionTable excTable = ExceptionTable.read(data, codeEnv);
        AttributeVector codeAttrs = AttributeVector.readAttributes(data, codeEnv);
        return new CodeAttribute(attrName, maxStack, maxLocals, code, codeBytes, excTable, codeAttrs, codeEnv);
    }

    static CodeAttribute read(ConstUtf8 attrName, int attrLength, DataInputStream data, ConstantPool pool) throws IOException {
        byte[] dataBytes = new byte[attrLength];
        data.readFully(dataBytes);
        return new CodeAttribute(attrName, dataBytes, new CodeEnv(pool));
    }

    void write(DataOutputStream out) throws IOException {
        out.writeShort(this.attrName().getIndex());
        if (this.theDataBytes == null) {
            this.buildInstructionBytes();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream tmpOut = new DataOutputStream(baos);
            tmpOut.writeShort(this.maxStack);
            tmpOut.writeShort(this.maxLocals);
            tmpOut.writeInt(this.theCodeBytes.length);
            tmpOut.write(this.theCodeBytes, 0, this.theCodeBytes.length);
            this.exceptionTable.write(tmpOut);
            this.codeAttributes.write(tmpOut);
            tmpOut.flush();
            byte[] tmpBytes = baos.toByteArray();
            out.writeInt(tmpBytes.length);
            out.write(tmpBytes, 0, tmpBytes.length);
        } else {
            out.writeInt(this.theDataBytes.length);
            out.write(this.theDataBytes, 0, this.theDataBytes.length);
        }
    }

    void print(PrintStream out, int indent) {
        this.makeValid();
        ClassPrint.spaces(out, indent);
        out.print("Code:");
        out.print(" max_stack = " + Integer.toString(this.maxStack));
        out.print(" max_locals = " + Integer.toString(this.maxLocals));
        out.println(" Exceptions:");
        this.exceptionTable.print(out, indent + 2);
        ClassPrint.spaces(out, indent);
        out.println("Code Attributes:");
        this.codeAttributes.print(out, indent + 2);
        Insn insn = this.theCode();
        if (insn != null) {
            ClassPrint.spaces(out, indent);
            out.println("Instructions:");
            while (insn != null) {
                insn.print(out, indent + 2);
                insn = insn.next();
            }
        }
    }

    private int resolveOffsets() {
        Insn insn = this.theCode;
        int currPC = 0;
        while (insn != null) {
            currPC = insn.resolveOffset(currPC);
            insn = insn.next();
        }
        return currPC;
    }

    int codeSize() {
        this.makeValid();
        return this.theCodeBytes.length;
    }

    private void buildInstructions(CodeEnv codeEnv) {
        if (this.theCodeBytes != null) {
            InsnTarget targ;
            InsnReadEnv insnEnv = new InsnReadEnv(this.theCodeBytes, codeEnv);
            Insn currInsn = this.theCode = insnEnv.getTarget(0);
            while (insnEnv.more()) {
                Insn newInsn = Insn.read(insnEnv);
                currInsn.setNext(newInsn);
                currInsn = newInsn;
            }
            currInsn = this.theCode;
            Insn prevInsn = null;
            while (currInsn != null) {
                int off = currInsn.offset();
                if (off > 0 && (targ = codeEnv.findTarget(off)) != null) {
                    prevInsn.setNext(targ);
                }
                prevInsn = currInsn;
                currInsn = currInsn.next();
            }
            targ = codeEnv.findTarget(insnEnv.currentPC());
            if (targ != null) {
                prevInsn.setNext(targ);
            }
        }
    }

    private void buildInstructionBytes() {
        if (this.theCode != null) {
            int size = this.resolveOffsets();
            this.theCodeBytes = new byte[size];
            Insn insn = this.theCode;
            int index = 0;
            while (insn != null) {
                index = insn.store(this.theCodeBytes, index);
                insn = insn.next();
            }
        }
    }

    private void makeValid() {
        if (this.theDataBytes != null) {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(this.theDataBytes));
            try {
                this.maxStack = dis.readUnsignedShort();
                this.maxLocals = dis.readUnsignedShort();
                int codeLength = dis.readInt();
                this.theCodeBytes = new byte[codeLength];
                dis.readFully(this.theCodeBytes);
                this.exceptionTable = ExceptionTable.read(dis, this.codeEnv);
                this.codeAttributes = AttributeVector.readAttributes(dis, this.codeEnv);
            }
            catch (IOException ioe) {
                throw new ClassFormatError("IOException while reading code attribute");
            }
            this.theDataBytes = null;
        }
    }
}

