/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.classfile;

import com.sap.jdo.enhancer.classfile.AttributeVector;
import com.sap.jdo.enhancer.classfile.ClassField;
import com.sap.jdo.enhancer.classfile.ClassMethod;
import com.sap.jdo.enhancer.classfile.ClassPrint;
import com.sap.jdo.enhancer.classfile.ConstClass;
import com.sap.jdo.enhancer.classfile.ConstantPool;
import com.sap.jdo.enhancer.classfile.VMConstants;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public final class ClassFile
implements VMConstants,
Serializable {
    public static final int magic = -889275714;
    public static final int jdk11MinorVersion = 3;
    public static final int jdk11MajorVersion = 45;
    public static final int jdk12MinorVersion = 0;
    public static final int jdk12MajorVersion = 46;
    private int majorVersion = 45;
    private int minorVersion = 3;
    private ConstantPool constantPool = new ConstantPool();
    private int accessFlags = 0;
    private ConstClass thisClassName;
    private ConstClass superClassName;
    private Vector classInterfaces = new Vector();
    private Vector classFields = new Vector();
    private Vector classMethods = new Vector();
    private AttributeVector classAttributes = new AttributeVector();

    public ConstantPool pool() {
        return this.constantPool;
    }

    public int access() {
        return this.accessFlags;
    }

    public final boolean isFinal() {
        return (this.accessFlags & 0x10) != 0;
    }

    public final boolean isInterface() {
        return (this.accessFlags & 0x200) != 0;
    }

    public final boolean isPublic() {
        return (this.accessFlags & 1) != 0;
    }

    public final boolean isAbstract() {
        return (this.accessFlags & 0x400) != 0;
    }

    public void setAccessFlags(int flags) {
        this.accessFlags = flags;
    }

    public ConstClass className() {
        return this.thisClassName;
    }

    public String classNameString() {
        return this.thisClassName == null ? null : this.thisClassName.asString();
    }

    public ConstClass superName() {
        return this.superClassName;
    }

    public String superNameString() {
        return this.superClassName == null ? null : this.superClassName.asString();
    }

    public void setSuperName(ConstClass superCl) {
        this.superClassName = superCl;
    }

    public Vector interfaces() {
        return this.classInterfaces;
    }

    public void addInterface(ConstClass iface) {
        this.classInterfaces.addElement(iface);
    }

    public Vector fields() {
        return this.classFields;
    }

    public void addField(ClassField field) {
        this.classFields.addElement(field);
    }

    public void addField(ClassField field, int index) {
        this.classFields.insertElementAt(field, index);
    }

    public Vector methods() {
        return this.classMethods;
    }

    public ClassMethod findMethod(String methodName, String methodSig) {
        Enumeration e = this.methods().elements();
        while (e.hasMoreElements()) {
            ClassMethod method = (ClassMethod)e.nextElement();
            if (!method.name().asString().equals(methodName) || !method.signature().asString().equals(methodSig)) continue;
            return method;
        }
        return null;
    }

    public void addMethod(ClassMethod method) {
        this.classMethods.addElement(method);
    }

    public ClassField findField(String fieldName) {
        Enumeration e = this.fields().elements();
        while (e.hasMoreElements()) {
            ClassField field = (ClassField)e.nextElement();
            if (!field.name().asString().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    public AttributeVector attributes() {
        return this.classAttributes;
    }

    public String userClassName() {
        return ClassFile.userClassFromVMClass(this.classNameString());
    }

    public static String userClassFromVMClass(String vmName) {
        return vmName.replace('/', '.');
    }

    public static String vmClassFromUserClass(String userName) {
        return userName.replace('.', '/');
    }

    public String pkg() {
        return ClassFile.packageOf(this.classNameString());
    }

    public static String packageOf(String vmName) {
        int last = vmName.lastIndexOf(47);
        if (last < 0) {
            return "";
        }
        return vmName.substring(0, last);
    }

    public ClassFile(DataInputStream data) throws ClassFormatError {
        this(data, true);
    }

    public ClassFile(DataInputStream data, boolean allowJDK12ClassFiles) throws ClassFormatError {
        try {
            int thisMagic = data.readInt();
            if (thisMagic != -889275714) {
                throw new ClassFormatError("Bad magic value for input");
            }
            int thisMinorVersion = data.readUnsignedShort();
            int thisMajorVersion = data.readUnsignedShort();
            if (!(thisMinorVersion == 3 && thisMajorVersion == 45 || allowJDK12ClassFiles && thisMinorVersion == 0 && thisMajorVersion == 46)) {
                throw new ClassFormatError("Bad version number: " + thisMajorVersion + "." + thisMinorVersion + " expected: " + this.majorVersion + "." + this.minorVersion);
            }
            this.minorVersion = thisMinorVersion;
            this.majorVersion = thisMajorVersion;
            this.readConstants(data);
            this.accessFlags = data.readUnsignedShort();
            this.thisClassName = (ConstClass)this.constantPool.constantAt(data.readUnsignedShort());
            this.superClassName = (ConstClass)this.constantPool.constantAt(data.readUnsignedShort());
            this.readInterfaces(data);
            this.readFields(data);
            this.readMethods(data);
            this.classAttributes = AttributeVector.readAttributes(data, this.constantPool);
        }
        catch (IOException e) {
            throw new ClassFormatError("IOException during reading");
        }
    }

    public ClassFile(String cname, String supername) {
        this.thisClassName = this.constantPool.addClass(cname);
        this.superClassName = this.constantPool.addClass(supername);
    }

    public void write(DataOutputStream buff) throws IOException {
        buff.writeInt(-889275714);
        buff.writeShort(this.minorVersion);
        buff.writeShort(this.majorVersion);
        this.constantPool.write(buff);
        buff.writeShort(this.accessFlags);
        buff.writeShort(this.thisClassName.getIndex());
        buff.writeShort(this.superClassName == null ? 0 : this.superClassName.getIndex());
        this.writeInterfaces(buff);
        this.writeFields(buff);
        this.writeMethods(buff);
        this.classAttributes.write(buff);
    }

    public byte[] getBytes() throws IOException {
        String writeClassToDirectory = System.getProperty("filter.writeClassToDirectory");
        if (writeClassToDirectory != null) {
            String filename = writeClassToDirectory + File.separator + this.thisClassName.asString() + ".class";
            System.err.println("Writing class to file " + filename);
            DataOutputStream stream = new DataOutputStream(new FileOutputStream(filename));
            this.write(stream);
            stream.close();
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        this.write(new DataOutputStream(byteStream));
        return byteStream.toByteArray();
    }

    public void print(PrintStream out) {
        this.print(out, 0);
    }

    public void print(PrintStream out, int indent) {
        this.constantPool.print(out, indent);
        out.println();
        ClassPrint.spaces(out, indent);
        out.println("majorVersion = " + Integer.toString(this.majorVersion));
        ClassPrint.spaces(out, indent);
        out.println("minorVersion = " + Integer.toString(this.minorVersion));
        ClassPrint.spaces(out, indent);
        out.println("accessFlags = " + Integer.toString(this.accessFlags));
        ClassPrint.spaces(out, indent);
        out.println("className = " + this.thisClassName.asString());
        ClassPrint.spaces(out, indent);
        out.println("superClassName = " + this.superClassName.asString());
        ClassPrint.spaces(out, indent);
        out.print("Interfaces =");
        int i = 0;
        while (i < this.classInterfaces.size()) {
            out.print(" " + ((ConstClass)this.classInterfaces.elementAt(i)).asString());
            ++i;
        }
        out.println();
        ClassPrint.spaces(out, indent);
        out.println("fields =");
        int i2 = 0;
        while (i2 < this.classFields.size()) {
            ((ClassField)this.classFields.elementAt(i2)).print(out, indent + 3);
            ++i2;
        }
        ClassPrint.spaces(out, indent);
        out.println("methods =");
        int i3 = 0;
        while (i3 < this.classMethods.size()) {
            ((ClassMethod)this.classMethods.elementAt(i3)).print(out, indent + 3);
            ++i3;
        }
        ClassPrint.spaces(out, indent);
        out.println("attributes =");
        this.classAttributes.print(out, indent + 3);
    }

    public void summarize(PrintStream out, int indent) {
        this.constantPool.summarize(out, indent);
        int codeSize = 0;
        int i = 0;
        while (i < this.classMethods.size()) {
            codeSize += ((ClassMethod)this.classMethods.elementAt(i)).codeSize();
            ++i;
        }
        ClassPrint.spaces(out, indent);
        out.println(this.classMethods.size() + " methods in " + codeSize + " bytes");
        ClassPrint.spaces(out, indent);
        out.println(this.classFields.size() + " fields");
    }

    private void readConstants(DataInputStream data) throws IOException {
        this.constantPool = new ConstantPool(data);
    }

    private void readInterfaces(DataInputStream data) throws IOException {
        int nInterfaces = data.readUnsignedShort();
        while (nInterfaces-- > 0) {
            int interfaceIndex = data.readUnsignedShort();
            ConstClass ci = null;
            if (interfaceIndex != 0) {
                ci = (ConstClass)this.constantPool.constantAt(interfaceIndex);
            }
            this.classInterfaces.addElement(ci);
        }
    }

    private void writeInterfaces(DataOutputStream data) throws IOException {
        data.writeShort(this.classInterfaces.size());
        int i = 0;
        while (i < this.classInterfaces.size()) {
            ConstClass ci = (ConstClass)this.classInterfaces.elementAt(i);
            int interfaceIndex = 0;
            if (ci != null) {
                interfaceIndex = ci.getIndex();
            }
            data.writeShort(interfaceIndex);
            ++i;
        }
    }

    private void readFields(DataInputStream data) throws IOException {
        int nFields = data.readUnsignedShort();
        while (nFields-- > 0) {
            this.classFields.addElement(ClassField.read(data, this.constantPool));
        }
    }

    private void writeFields(DataOutputStream data) throws IOException {
        data.writeShort(this.classFields.size());
        int i = 0;
        while (i < this.classFields.size()) {
            ((ClassField)this.classFields.elementAt(i)).write(data);
            ++i;
        }
    }

    private void readMethods(DataInputStream data) throws IOException {
        int nMethods = data.readUnsignedShort();
        while (nMethods-- > 0) {
            this.classMethods.addElement(ClassMethod.read(data, this.constantPool));
        }
    }

    private void writeMethods(DataOutputStream data) throws IOException {
        data.writeShort(this.classMethods.size());
        int i = 0;
        while (i < this.classMethods.size()) {
            ((ClassMethod)this.classMethods.elementAt(i)).write(data);
            ++i;
        }
    }
}

