/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.classfile;

import com.sap.jdo.enhancer.classfile.AttributeVector;
import com.sap.jdo.enhancer.classfile.ClassMember;
import com.sap.jdo.enhancer.classfile.ClassPrint;
import com.sap.jdo.enhancer.classfile.ConstUtf8;
import com.sap.jdo.enhancer.classfile.ConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class ClassField
extends ClassMember {
    private int accessFlags;
    private ConstUtf8 fieldName;
    private ConstUtf8 fieldSignature;
    private AttributeVector fieldAttributes;

    public boolean isTransient() {
        return (this.accessFlags & 0x80) != 0;
    }

    public int access() {
        return this.accessFlags;
    }

    public void setAccess(int newFlags) {
        this.accessFlags = newFlags;
    }

    public ConstUtf8 name() {
        return this.fieldName;
    }

    public void changeName(ConstUtf8 name) {
        this.fieldName = name;
    }

    public ConstUtf8 signature() {
        return this.fieldSignature;
    }

    public void changeSignature(ConstUtf8 newSig) {
        this.fieldSignature = newSig;
    }

    public AttributeVector attributes() {
        return this.fieldAttributes;
    }

    public ClassField(int accFlags, ConstUtf8 name, ConstUtf8 sig, AttributeVector field_attrs) {
        this.accessFlags = accFlags;
        this.fieldName = name;
        this.fieldSignature = sig;
        this.fieldAttributes = field_attrs;
    }

    static ClassField read(DataInputStream data, ConstantPool pool) throws IOException {
        ClassField f = null;
        int accessFlags = data.readUnsignedShort();
        int name_index = data.readUnsignedShort();
        int sig_index = data.readUnsignedShort();
        AttributeVector fieldAttribs = AttributeVector.readAttributes(data, pool);
        f = new ClassField(accessFlags, (ConstUtf8)pool.constantAt(name_index), (ConstUtf8)pool.constantAt(sig_index), fieldAttribs);
        return f;
    }

    void write(DataOutputStream data) throws IOException {
        data.writeShort(this.accessFlags);
        data.writeShort(this.fieldName.getIndex());
        data.writeShort(this.fieldSignature.getIndex());
        this.fieldAttributes.write(data);
    }

    void print(PrintStream out, int indent) {
        ClassPrint.spaces(out, indent);
        out.print("'" + this.fieldName.asString() + "'");
        out.print(" sig = " + this.fieldSignature.asString());
        out.print(" access_flags = " + Integer.toString(this.accessFlags));
        out.println(" attributes:");
        this.fieldAttributes.print(out, indent + 2);
    }
}

