/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer.classfile;

import com.sap.jdo.enhancer.classfile.AttributeVector;
import com.sap.jdo.enhancer.classfile.ClassAttribute;
import com.sap.jdo.enhancer.classfile.ClassPrint;
import com.sap.jdo.enhancer.classfile.CodeEnv;
import com.sap.jdo.enhancer.classfile.ConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Stack;

public class AttributeVector {
    private ClassAttribute[] attributes = null;

    private ClassAttribute attrAt(int i) {
        return this.attributes[i];
    }

    public void addElement(ClassAttribute attr) {
        if (this.attributes == null) {
            this.attributes = new ClassAttribute[1];
        } else {
            ClassAttribute[] newAttributes = new ClassAttribute[this.attributes.length + 1];
            System.arraycopy(this.attributes, 0, newAttributes, 0, this.attributes.length);
            this.attributes = newAttributes;
        }
        this.attributes[this.attributes.length - 1] = attr;
    }

    public Enumeration elements() {
        class AttributeVectorEnumeration
        implements Enumeration {
            private ClassAttribute[] attributes;
            private int current;
            private final /* synthetic */ AttributeVector this$0;

            AttributeVectorEnumeration(AttributeVector this$0, ClassAttribute[] attrs) {
                this.this$0 = this$0;
                this.current = 0;
                this.attributes = attrs;
            }

            public boolean hasMoreElements() {
                return this.attributes != null && this.current < this.attributes.length;
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                return this.attributes[this.current++];
            }
        }
        return new AttributeVectorEnumeration(this, this.attributes);
    }

    public ClassAttribute findAttribute(String attrName) {
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            ClassAttribute attr = (ClassAttribute)e.nextElement();
            if (!attr.attrName().asString().equals(attrName)) continue;
            return attr;
        }
        return null;
    }

    public boolean isEqual(Stack msg, Object obj) {
        if (!(obj instanceof AttributeVector)) {
            msg.push("obj/obj.getClass() = " + (obj == null ? null : obj.getClass()));
            msg.push("this.getClass() = " + this.getClass());
            return false;
        }
        AttributeVector other = (AttributeVector)obj;
        if (this.attributes.length != other.attributes.length) {
            msg.push("attributes.length " + String.valueOf(other.attributes.length));
            msg.push("attributes.length " + String.valueOf(this.attributes.length));
            return false;
        }
        class ClassAttributeComparator
        implements Comparator {
            private final /* synthetic */ AttributeVector this$0;

            ClassAttributeComparator(AttributeVector this$0) {
                this.this$0 = this$0;
            }

            public int compare(Object o1, Object o2) {
                ClassAttribute a1 = (ClassAttribute)o1;
                ClassAttribute a2 = (ClassAttribute)o2;
                String s1 = a1.attrName().asString();
                String s2 = a2.attrName().asString();
                return s1.compareTo(s2);
            }
        }
        ClassAttributeComparator comparator = new ClassAttributeComparator(this);
        ClassAttribute[] thisAttributes = (ClassAttribute[])this.attributes.clone();
        ClassAttribute[] otherAttributes = (ClassAttribute[])other.attributes.clone();
        Arrays.sort(thisAttributes, comparator);
        Arrays.sort(otherAttributes, comparator);
        int i = 0;
        while (i < this.attributes.length) {
            ClassAttribute a1 = thisAttributes[i];
            ClassAttribute a2 = otherAttributes[i];
            if (!a1.isEqual(msg, a2)) {
                msg.push("attributes[i] = " + String.valueOf(a2));
                msg.push("attributes[i] = " + String.valueOf(a1));
                return false;
            }
            ++i;
        }
        return true;
    }

    static AttributeVector readAttributes(DataInputStream data, ConstantPool constantPool) throws IOException {
        AttributeVector attribs = new AttributeVector();
        int n_attrs = data.readUnsignedShort();
        while (n_attrs-- > 0) {
            attribs.addElement(ClassAttribute.read(data, constantPool));
        }
        return attribs;
    }

    static AttributeVector readAttributes(DataInputStream data, CodeEnv codeEnv) throws IOException {
        AttributeVector attribs = new AttributeVector();
        int n_attrs = data.readUnsignedShort();
        while (n_attrs-- > 0) {
            attribs.addElement(ClassAttribute.read(data, codeEnv));
        }
        return attribs;
    }

    void write(DataOutputStream out) throws IOException {
        if (this.attributes == null) {
            out.writeShort(0);
        } else {
            out.writeShort(this.attributes.length);
            int i = 0;
            while (i < this.attributes.length) {
                this.attributes[i].write(out);
                ++i;
            }
        }
    }

    void print(PrintStream out, int indent) {
        if (this.attributes != null) {
            int i = 0;
            while (i < this.attributes.length) {
                this.attributes[i].print(out, indent);
                ++i;
            }
        }
    }

    void summarize(PrintStream out, int indent) {
        ClassPrint.spaces(out, indent);
        out.println((this.attributes == null ? 0 : this.attributes.length) + " attributes");
    }
}

