/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer;

import com.sap.jdo.enhancer.MainBase;
import com.sap.jdo.enhancer.util.Assertion;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OptionSet
extends MainBase {
    public static final String prefix = "-";
    public static final String lprefix = "--";
    protected final List options = new ArrayList();
    protected final Map names = new HashMap();
    protected final Map abbrevs = new HashMap();
    protected final List arguments = new ArrayList();
    public String usageHeader = "Usage: <options> <arguments>..";
    public String optionsHeader = "Options:";
    public String argumentsHeader = "Arguments:";
    public String returnHeader = "Return: A non-zero value in case of errors.";
    public String indent = "    ";

    public OptionSet(PrintWriter out, PrintWriter err) {
        super(out, err);
    }

    public OptionSet(PrintWriter out, PrintWriter err, String usageHeader, String optionsHeader, String argumentsHeader, String returnHeader, String indent) {
        this(out, err);
        this.usageHeader = usageHeader;
        this.optionsHeader = optionsHeader;
        this.argumentsHeader = argumentsHeader;
        this.returnHeader = returnHeader;
        this.indent = indent;
    }

    public void register(Option option) {
        Assertion.affirm(option != null);
        option.set = this;
        this.options.add(option);
        Assertion.affirm(option.name != null);
        Option obj = this.names.put(lprefix + option.name, option);
        Assertion.affirm(obj == null, "Option already registered: " + option.name);
        if (option.abbrev != null) {
            obj = this.abbrevs.put(prefix + option.abbrev, option);
            Assertion.affirm(obj == null, "Option already registered: " + option.name);
        }
    }

    public UsageOption createUsageOption(String name, String abbrev, String descr) {
        UsageOption opt = new UsageOption(name, abbrev, descr);
        this.register(opt);
        return opt;
    }

    public BooleanOption createBooleanOption(String name, String abbrev, String descr) {
        BooleanOption opt = new BooleanOption(name, abbrev, descr);
        this.register(opt);
        return opt;
    }

    public BooleanOption createBooleanOption(String name, String abbrev, String descr, boolean defaultVal) {
        BooleanOption opt = new BooleanOption(name, abbrev, descr, defaultVal);
        this.register(opt);
        return opt;
    }

    public StringOption createStringOption(String name, String abbrev, String descr) {
        StringOption opt = new StringOption(name, abbrev, descr);
        this.register(opt);
        return opt;
    }

    public StringOption createStringOption(String name, String abbrev, String descr, String defaultVal) {
        StringOption opt = new StringOption(name, abbrev, descr, defaultVal);
        this.register(opt);
        return opt;
    }

    public int parse(String[] argv) {
        Assertion.affirm(argv != null);
        Iterator<String> i = Arrays.asList(argv).iterator();
        while (i.hasNext()) {
            String arg = i.next();
            if (arg == null || arg.length() == 0) {
                this.println("Ignoring empty command line argument.");
                continue;
            }
            if (!arg.startsWith(prefix)) {
                this.arguments.add(arg);
                continue;
            }
            Option option = (Option)this.abbrevs.get(arg);
            if (option == null) {
                option = (Option)this.names.get(arg);
            }
            if (option == null) {
                this.printlnErr("Unrecognized option: " + arg);
                this.printUsage();
                return -1;
            }
            int res = option.parse(i);
            if (res >= 0) continue;
            this.printUsage();
            return res;
        }
        return this.check();
    }

    public int check() {
        return 0;
    }

    public void printUsage() {
        this.println();
        this.printUsageHeader();
        this.printOptionHeader();
        this.printOptionUsage();
        this.printArgumentHeader();
        this.printArgumentUsage();
        this.printReturnHeader();
        this.printReturnUsage();
    }

    public void printUsageHeader() {
        this.printlnErr(this.usageHeader);
    }

    public void printOptionHeader() {
        this.printlnErr();
        this.printlnErr(this.optionsHeader);
    }

    public void printOptionUsage() {
        Iterator i = this.options.iterator();
        while (i.hasNext()) {
            this.printlnErr(this.indent + ((Option)i.next()).asUsage());
        }
    }

    public void printArgumentHeader() {
        this.printlnErr();
        this.printlnErr(this.argumentsHeader);
    }

    public void printArgumentUsage() {
    }

    public void printReturnHeader() {
        this.printlnErr();
        this.printlnErr(this.returnHeader);
    }

    public void printReturnUsage() {
    }

    public void printAll() {
        this.printOptions();
        this.printArguments();
    }

    public void printOptions() {
        this.println();
        this.println(this.optionsHeader);
        Iterator i = this.options.iterator();
        while (i.hasNext()) {
            this.println(this.indent + ((Option)i.next()).asValue());
        }
    }

    public void printArguments() {
        this.println();
        this.println(this.argumentsHeader);
        this.print(this.indent);
        Iterator i = this.arguments.iterator();
        while (i.hasNext()) {
            this.print(" " + i.next());
        }
    }

    public static void main(String[] args) {
        PrintWriter out = new PrintWriter(System.out, true);
        OptionSet options = new OptionSet(out, out);
        options.parse(args);
    }

    static /* synthetic */ void access$001(boolean x0) {
        Assertion.affirm(x0);
    }

    public static class StringOption
    extends Option {
        public final String defaultVal;
        public String value;

        public StringOption(String name, String abbrev, String descr) {
            this(name, abbrev, descr, null);
        }

        public StringOption(String name, String abbrev, String descr, String defaultVal) {
            super(name, abbrev, descr);
            this.defaultVal = defaultVal;
            this.value = defaultVal;
        }

        public int parse(Iterator i) {
            if (this.value != this.defaultVal) {
                this.set.printlnErr("Repeated option: -" + this.abbrev + "/" + OptionSet.lprefix + this.name);
                return -1;
            }
            if (!i.hasNext()) {
                this.set.printlnErr("Missing argument to option: -" + this.abbrev + "/" + OptionSet.lprefix + this.name);
                return -1;
            }
            this.value = (String)i.next();
            if (this.value.startsWith(OptionSet.prefix)) {
                this.set.printlnErr("Missing argument to option: -" + this.abbrev + "/" + OptionSet.lprefix + this.name);
                return -1;
            }
            return 0;
        }

        public String asValue() {
            return this.name + " = " + String.valueOf(this.value);
        }
    }

    public static class BooleanOption
    extends Option {
        public final boolean defaultVal;
        public boolean value;

        public BooleanOption(String name, String abbrev, String descr) {
            this(name, abbrev, descr, false);
        }

        public BooleanOption(String name, String abbrev, String descr, boolean defaultVal) {
            super(name, abbrev, descr);
            this.defaultVal = defaultVal;
            this.value = defaultVal;
        }

        public int parse(Iterator i) {
            if (this.value != this.defaultVal) {
                this.set.printlnErr("Repeated option: -" + this.abbrev + "/" + OptionSet.lprefix + this.name);
                return -1;
            }
            this.value = true;
            return 0;
        }

        public String asValue() {
            return this.name + " = " + String.valueOf(this.value);
        }
    }

    public static class UsageOption
    extends Option {
        public boolean value;

        public UsageOption(String name, String abbrev, String descr) {
            super(name, abbrev, descr);
        }

        public int parse(Iterator i) {
            this.value = true;
            return -1;
        }

        public String asValue() {
            return this.name + " = " + String.valueOf(this.value);
        }
    }

    public static abstract class Option {
        protected OptionSet set;
        public final String name;
        public final String abbrev;
        public final String descr;

        public Option(String name, String abbrev, String descr) {
            OptionSet.access$001(name != null);
            this.name = name;
            this.abbrev = abbrev;
            this.descr = descr;
        }

        public abstract int parse(Iterator var1);

        public String asUsage() {
            String abbr = this.abbrev == null ? "    " : OptionSet.prefix + this.abbrev + ", ";
            return abbr + OptionSet.lprefix + this.name + " " + this.descr;
        }

        public abstract String asValue();
    }
}

