/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer;

import com.sap.jdo.enhancer.MainBase;
import com.sap.jdo.enhancer.MetaDataOptions;
import com.sap.jdo.enhancer.meta.EnhancerMetaData;
import com.sap.jdo.enhancer.meta.EnhancerMetaDataFatalError;
import com.sap.jdo.enhancer.meta.model.EnhancerMetaDataJDOModelImpl;
import com.sap.jdo.enhancer.meta.prop.EnhancerMetaDataPropertyImpl;
import com.sap.jdo.enhancer.meta.util.EnhancerMetaDataTimer;
import com.sap.jdo.enhancer.util.Assertion;
import com.sap.jdo.enhancer.util.CombinedResourceLocator;
import com.sap.jdo.enhancer.util.ListResourceLocator;
import com.sap.jdo.enhancer.util.PathResourceLocator;
import com.sap.jdo.enhancer.util.ResourceLocator;
import com.sap.jdo.enhancer.util.ResourceLocatorBase;
import com.sap.jdo.enhancer.util.ResourceLocatorTimer;
import com.sap.jdo.enhancer.util.Support;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MetaDataMain
extends MainBase {
    protected MetaDataOptions options;
    protected ResourceLocator classLocator;
    protected EnhancerMetaData meta;

    public MetaDataMain(PrintWriter out, PrintWriter err) {
        super(out, err);
        this.options = new MetaDataOptions(out, err);
    }

    public void printWarning(String msg) {
        this.out.println(Support.getI18N("enhancer.warning", msg));
    }

    public void printMessage(String msg) {
        if (this.options.verbose.value) {
            this.out.println(Support.getI18N("enhancer.message", msg));
        }
    }

    protected int initMetaData() {
        try {
            this.meta = this.options.propFileName.value != null ? new EnhancerMetaDataPropertyImpl(this.out, this.options.verbose.value, this.options.propFileName.value) : new EnhancerMetaDataJDOModelImpl(this.out, this.options.verbose.value, this.options.jdoFileNames, this.options.zipFileNames, this.options.sourcePath.value);
            if (this.options.doTiming.value) {
                this.meta = new EnhancerMetaDataTimer(this.meta);
            }
        }
        catch (EnhancerMetaDataFatalError ex) {
            this.printlnErr("Cannot initialize JDO meta-data source", ex);
            return -3;
        }
        return 0;
    }

    protected int initClassLocator() {
        boolean verbose = this.options.verbose.value;
        List classFileNames = this.options.classFileNames;
        List zipFileNames = this.options.zipFileNames;
        String sourcePath = this.options.sourcePath.value;
        try {
            ArrayList<ResourceLocatorBase> locators = new ArrayList<ResourceLocatorBase>();
            if (classFileNames != null && !classFileNames.isEmpty()) {
                ListResourceLocator classes = new ListResourceLocator(this.out, verbose, classFileNames);
                this.printMessage(Support.getI18N("enhancer.using_class_files", MetaDataOptions.asString(classFileNames)));
                locators.add(classes);
            }
            if (zipFileNames != null && !zipFileNames.isEmpty()) {
                StringBuffer s = new StringBuffer();
                Iterator i = zipFileNames.iterator();
                s.append(i.next());
                while (i.hasNext()) {
                    s.append(File.pathSeparator + i.next());
                }
                PathResourceLocator zips = new PathResourceLocator(this.out, verbose, s.toString());
                this.printMessage(Support.getI18N("enhancer.using_zip_files", s.toString()));
                locators.add(zips);
            }
            if (sourcePath != null && sourcePath.length() > 0) {
                PathResourceLocator path = new PathResourceLocator(this.out, verbose, sourcePath);
                this.printMessage(Support.getI18N("enhancer.using_source_path", sourcePath));
                locators.add(path);
            }
            Assertion.affirm(!locators.isEmpty());
            this.classLocator = new CombinedResourceLocator(this.out, verbose, locators);
            if (this.options.doTiming.value) {
                this.classLocator = new ResourceLocatorTimer(this.classLocator);
            }
        }
        catch (IOException ex) {
            this.printlnErr("Cannot initialize resource locator for classes", ex);
            return -2;
        }
        return 0;
    }

    private static InputStream openFileInputStream(String fileName) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(fileName));
    }

    private static String createClassFileName(String className) {
        return className.replace('.', '/') + ".class";
    }

    private InputStream openClassInputStream(String className) throws IOException {
        String resourceName = MetaDataMain.createClassFileName(className);
        URL url = ClassLoader.getSystemResource(resourceName);
        if (url == null) {
            throw new FileNotFoundException(className);
        }
        return url.openStream();
    }

    private void closeInputStream(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException ex) {
                this.printlnErr("", ex);
            }
        }
    }

    public static void main(String[] args) {
        PrintWriter out = new PrintWriter(System.out, true);
        MetaDataMain main = new MetaDataMain(out, out);
        main.options.parse(args);
        main.initMetaData();
    }
}

