/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer;

import com.sap.jdo.enhancer.ClassFileEnhancer;
import com.sap.jdo.enhancer.ClassFileEnhancerHelper;
import com.sap.jdo.enhancer.ClassFileEnhancerTimer;
import com.sap.jdo.enhancer.EnhancerFatalError;
import com.sap.jdo.enhancer.EnhancerUserException;
import com.sap.jdo.enhancer.OutputStreamWrapper;
import com.sap.jdo.enhancer.filter.Enhancer;
import com.sap.jdo.enhancer.meta.EnhancerMetaData;
import com.sap.jdo.enhancer.meta.EnhancerMetaDataFatalError;
import com.sap.jdo.enhancer.meta.model.EnhancerMetaDataJDOModelImpl;
import com.sap.jdo.enhancer.meta.prop.EnhancerMetaDataPropertyImpl;
import com.sap.jdo.enhancer.meta.util.EnhancerMetaDataTimer;
import com.sap.jdo.enhancer.util.Assertion;
import com.sap.jdo.enhancer.util.Support;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Main
extends Support {
    public static final int OK = 0;
    public static final int USAGE_ERROR = -1;
    public static final int METADATA_ERROR = -2;
    public static final int INTERNAL_ERROR = -3;
    private final PrintWriter out = new PrintWriter(System.out, true);
    private final PrintWriter err = new PrintWriter(System.err, true);
    private final CmdLineOptions opts = new CmdLineOptions();
    private ClassFileEnhancer enhancer;
    private EnhancerMetaData jdoMetaData;

    public static void enhanceIDE(String path, String[] classFileNames) throws EnhancerUserException {
        Main main = new Main();
        main.opts.setOptionsIDE(path, classFileNames);
        if (main.createEnhancer() != 0) {
            throw new EnhancerUserException("");
        }
        if (main.enhanceInputFiles(main.opts.classNames, main.opts.classFileNames, main.opts.zipFileNames, main.opts.jdoFileNames) != 0) {
            throw new EnhancerUserException("");
        }
    }

    public static void main(String[] argv) {
        int res;
        Main main = new Main();
        try {
            try {
                res = main.process(argv);
            }
            catch (RuntimeException ex) {
                main.out.flush();
                main.err.println("Internal error while postprocessing: " + ex.getMessage());
                ex.printStackTrace(main.err);
                main.err.flush();
                res = -3;
                Object var5_4 = null;
                if (main.opts.doTiming) {
                    Support.timer.print();
                }
            }
            Object var5_3 = null;
            if (main.opts.doTiming) {
                Support.timer.print();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (main.opts.doTiming) {
                Support.timer.print();
            }
            throw throwable;
        }
        System.exit(res);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int process(String[] argv) {
        int n;
        block7: {
            int n2;
            block6: {
                int res = this.opts.processArgs(argv);
                if (res != 0) {
                    this.printMessage("aborted with errors.");
                    return res;
                }
                try {
                    if (this.opts.doTiming) {
                        Support.timer.push("Main.process(String[])");
                    }
                    if ((res = this.createEnhancer()) != 0) {
                        this.printMessage("aborted with errors.");
                        int n3 = res;
                        Object var5_6 = null;
                        if (!this.opts.doTiming) return n3;
                        Support.timer.pop();
                        return n3;
                    }
                    res = this.enhanceInputFiles(this.opts.classNames, this.opts.classFileNames, this.opts.zipFileNames, this.opts.jdoFileNames);
                    if (res != 0) {
                        this.printMessage("aborted with errors.");
                        n2 = res;
                        break block6;
                    }
                    this.printMessage("done.");
                    n = 0;
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    if (!this.opts.doTiming) throw throwable;
                    Support.timer.pop();
                    throw throwable;
                }
            }
            Object var5_7 = null;
            if (!this.opts.doTiming) return n2;
            Support.timer.pop();
            return n2;
        }
        Object var5_8 = null;
        if (!this.opts.doTiming) return n;
        Support.timer.pop();
        return n;
    }

    private int initEnhancerMetaData() {
        String propertiesFileName = this.opts.propertiesFileName;
        List jdoFileNames = this.opts.jdoFileNames;
        List zipFileNames = this.opts.zipFileNames;
        String sourcePath = this.opts.sourcePath;
        try {
            this.jdoMetaData = propertiesFileName != null ? new EnhancerMetaDataPropertyImpl(this.out, this.opts.verbose, propertiesFileName) : new EnhancerMetaDataJDOModelImpl(this.out, this.opts.verbose, jdoFileNames, zipFileNames, sourcePath);
        }
        catch (EnhancerMetaDataFatalError ex) {
            this.printError("Cannot initialize JDO meta-data source", ex);
            return -2;
        }
        return 0;
    }

    private int createEnhancer() {
        int res = this.initEnhancerMetaData();
        if (res < 0) {
            return res;
        }
        Assertion.affirm(this.jdoMetaData != null);
        Properties props = new Properties();
        if (this.opts.verbose) {
            ((Hashtable)props).put("Enhancer.verboseLevel", "verbose");
        }
        if (this.opts.doTiming) {
            this.jdoMetaData = new EnhancerMetaDataTimer(this.jdoMetaData);
            ((Hashtable)props).put("Enhancer.doTimingStatistics", Boolean.TRUE.toString());
        }
        if (this.opts.dumpClass) {
            ((Hashtable)props).put("Enhancer.dumpClass", Boolean.TRUE.toString());
        }
        if (this.opts.noAugment) {
            ((Hashtable)props).put("Enhancer.noAugment", Boolean.TRUE.toString());
        }
        if (this.opts.noAnnotate) {
            ((Hashtable)props).put("Enhancer.noAnnotate", Boolean.TRUE.toString());
        }
        try {
            this.enhancer = new Enhancer(this.jdoMetaData, props, this.out, this.err);
            if (this.opts.doTiming) {
                this.enhancer = new ClassFileEnhancerTimer(this.enhancer);
            }
            return 0;
        }
        catch (EnhancerUserException ex) {
            this.printError("Error while creating the enhancer", ex);
            return -1;
        }
        catch (EnhancerFatalError ex) {
            this.printError("Fatal error while creating the enhancer", ex);
            this.enhancer = null;
            return -1;
        }
    }

    private int enhanceInputFiles(List classNames, List classFileNames, List zipFileNames, List jdoFileNames) {
        int res = 0;
        try {
            Iterator i = zipFileNames.iterator();
            while (i.hasNext()) {
                try {
                    this.enhanceZipFile((String)i.next());
                }
                catch (EnhancerUserException ex) {
                    this.printError("Error while enhancing", ex);
                    ++res;
                }
            }
            Iterator i2 = classFileNames.iterator();
            while (i2.hasNext()) {
                try {
                    this.enhanceClassFile(Main.openFileInputStream((String)i2.next()));
                }
                catch (EnhancerUserException ex) {
                    this.printError("Error while enhancing", ex);
                    ++res;
                }
            }
            Iterator i3 = classNames.iterator();
            while (i3.hasNext()) {
                try {
                    this.enhanceClassFile(this.openClassInputStream((String)i3.next()));
                }
                catch (EnhancerUserException ex) {
                    this.printError("Error while enhancing", ex);
                    ++res;
                }
            }
        }
        catch (IOException ex) {
            this.printError("IO Error while enhancing", ex);
            return ++res;
        }
        catch (EnhancerFatalError ex) {
            this.printError("Fatal error while enhancing", ex);
            this.enhancer = null;
            return ++res;
        }
        return res;
    }

    private void enhanceClassFile(InputStream in) throws IOException, EnhancerUserException, EnhancerFatalError {
        BufferedOutputStream out = null;
        try {
            File temp = File.createTempFile("enhancer", ".class");
            out = new BufferedOutputStream(new FileOutputStream(temp));
            OutputStreamWrapper wrapper = new OutputStreamWrapper(out);
            boolean enhanced = this.enhancer.enhanceClassFile(in, wrapper);
            this.closeOutputStream(out);
            this.closeInputStream(in);
            this.createOutputFile(enhanced, Main.createClassFileName(wrapper.getClassName()), temp);
            Object var7_6 = null;
            this.closeInputStream(in);
            this.closeOutputStream(out);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.closeInputStream(in);
            this.closeOutputStream(out);
            throw throwable;
        }
    }

    private void enhanceZipFile(String filename) throws IOException, EnhancerUserException, EnhancerFatalError {
        ZipInputStream in = null;
        ZipOutputStream out = null;
        try {
            File temp = File.createTempFile("enhancer", ".zip");
            in = new ZipInputStream(new BufferedInputStream(new FileInputStream(new File(filename))));
            out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(temp)));
            boolean enhanced = ClassFileEnhancerHelper.enhanceZipFile(this.enhancer, in, out);
            this.closeOutputStream(out);
            this.closeInputStream(in);
            this.createOutputFile(enhanced, new File(filename).getName(), temp);
            Object var7_6 = null;
            this.closeOutputStream(out);
            this.closeInputStream(in);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.closeOutputStream(out);
            this.closeInputStream(in);
            throw throwable;
        }
    }

    private static InputStream openFileInputStream(String filename) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(new File(filename)));
    }

    private InputStream openClassInputStream(String classname) throws IOException {
        String resourceName = Main.createClassFileName(classname);
        URL url = ClassLoader.getSystemResource(resourceName);
        if (url == null) {
            throw new FileNotFoundException(classname);
        }
        return url.openStream();
    }

    private File createZipOutputFile(String zipfilename) {
        return new File(this.opts.destinationDirectory, new File(zipfilename).getName());
    }

    private void createOutputFile(boolean enhanced, String filename, File temp) throws IOException {
        block8: {
            FilterOutputStream dos;
            block7: {
                if (this.opts.noWrite || !enhanced && !this.opts.forceWrite) {
                    temp.deleteOnExit();
                    return;
                }
                File file = new File(this.opts.destinationDirectory, filename);
                Main.createPathOfFile(file);
                file.delete();
                boolean renamed = temp.renameTo(file);
                if (renamed) break block8;
                DataInputStream dis = null;
                dos = null;
                try {
                    dis = new DataInputStream(new FileInputStream(temp));
                    dos = new DataOutputStream(new FileOutputStream(file));
                    int PAGESIZE = 4096;
                    byte[] data = new byte[PAGESIZE];
                    while (dis.available() > 0) {
                        int numRead = dis.read(data, 0, PAGESIZE);
                        ((DataOutputStream)dos).write(data, 0, numRead);
                    }
                    Object var12_11 = null;
                    if (dis == null) break block7;
                }
                catch (Throwable throwable) {
                    Object var12_12 = null;
                    if (dis != null) {
                        dis.close();
                    }
                    if (dos != null) {
                        dos.close();
                    }
                    throw throwable;
                }
                dis.close();
            }
            if (dos != null) {
                dos.close();
            }
            temp.deleteOnExit();
        }
    }

    private void closeInputStream(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException ex) {
                this.printError(null, ex);
            }
        }
    }

    private void closeOutputStream(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException ex) {
                this.printError(null, ex);
            }
        }
    }

    private static boolean isClassFileName(String filename) {
        return filename.endsWith(".class");
    }

    private static boolean isZipFileName(String filename) {
        int n = filename.length();
        if (n < 5) {
            return false;
        }
        String ext = filename.substring(n - 4);
        return ext.equalsIgnoreCase(".zip") || ext.equalsIgnoreCase(".jar");
    }

    private static boolean isJarFileName(String filename) {
        int n = filename.length();
        if (n < 5) {
            return false;
        }
        String ext = filename.substring(n - 4);
        return ext.equalsIgnoreCase(".jar");
    }

    private static boolean isJdoFileName(String filename) {
        return filename.endsWith(".jdo");
    }

    private static String createClassFileName(String classname) {
        return classname.replace('.', '/') + ".class";
    }

    private static void createPathOfFile(File file) throws IOException {
        File dir = file.getAbsoluteFile().getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Error creating directory '" + dir.getAbsolutePath() + "'.");
        }
    }

    private void printError(String msg, Throwable ex) {
        this.out.flush();
        if (msg != null) {
            this.err.println(msg + (ex != null ? ": " + ex.getMessage() : ""));
        }
        if (ex != null) {
            ex.printStackTrace(this.err);
        }
    }

    private void printMessage(String msg) {
        this.out.println(msg);
    }

    private class CmdLineOptions {
        final List classNames = new ArrayList();
        final List classFileNames = new ArrayList();
        final List zipFileNames = new ArrayList();
        final List jdoFileNames = new ArrayList();
        String sourcePath = null;
        String destinationDirectory = null;
        String propertiesFileName = null;
        boolean doTiming = false;
        boolean verbose = false;
        boolean quiet = false;
        boolean forceWrite = false;
        boolean noWrite = false;
        boolean dumpClass = false;
        boolean noAugment = false;
        boolean noAnnotate = false;

        private CmdLineOptions() {
        }

        protected void setOptionsIDE(String path, String[] classFileNames) throws EnhancerUserException {
            if (path == null || classFileNames == null || classFileNames.length == 0) {
                throw new EnhancerUserException("path or class file(s) not given");
            }
            int i = 0;
            while (i < classFileNames.length) {
                String relativeClassFileName = classFileNames[i];
                if (!relativeClassFileName.endsWith(".class")) {
                    throw new EnhancerUserException("no class file: " + relativeClassFileName);
                }
                String absoluteClassFileName = path + "/" + relativeClassFileName;
                String absoluteJDOFileName = absoluteClassFileName.substring(0, absoluteClassFileName.length() - ".class".length()) + ".jdo";
                this.classFileNames.add(absoluteClassFileName);
                this.jdoFileNames.add(absoluteJDOFileName);
                ++i;
            }
            this.destinationDirectory = path;
            this.forceWrite = true;
        }

        public void usage() {
            Main.this.err.println("Usage: main <options> <arguments>...");
            Main.this.err.println("Options:");
            Main.this.err.println("  -h, --help               print usage message and exit gently");
            Main.this.err.println("  -v, --verbose            print verbose messages");
            Main.this.err.println("  -q, --quiet              supress warnings");
            Main.this.err.println("  -s, --sourcepath <path>  source path for jdo and classfiles");
            Main.this.err.println("  -d, --destdir <dir>      destination directory for output files");
            Main.this.err.println("  -f, --force              overwrite output files");
            Main.this.err.println("  -n, --nowrite            never write output files");
            Main.this.err.println("  -t, --timing             do timing messures");
            Main.this.err.println();
            Main.this.err.println("Debugging Options:");
            Main.this.err.println("      --properties <file>  use property file for meta data");
            Main.this.err.println("      --dumpclass          print out disassembled code of classes");
            Main.this.err.println("      --noaugment          do not enhance for persistence-capability");
            Main.this.err.println("      --noannotate         do not enhance for persistence-awareness");
            Main.this.err.println();
            Main.this.err.println("Arguments:");
            Main.this.err.println("  <jdofile>    the name of a .jdo file");
            Main.this.err.println("  <classfile>  the name of a .class file");
            Main.this.err.println();
            Main.this.err.println("Returns a non-zero value in case of errors.");
        }

        protected int processArgs(String[] argv) {
            ArrayList<String> inputNames = new ArrayList<String>();
            int i = 0;
            while (i < argv.length) {
                String arg = argv[i];
                if (arg.equals("-h") || arg.equals("--help")) {
                    this.usage();
                    return 0;
                }
                if (arg.equals("-v") || arg.equals("--verbose")) {
                    this.verbose = true;
                    this.quiet = false;
                } else if (arg.equals("-q") || arg.equals("--quiet")) {
                    this.quiet = true;
                    this.verbose = false;
                } else if (arg.equals("-t") || arg.equals("--timing")) {
                    this.doTiming = true;
                } else if (arg.equals("-f") || arg.equals("--force")) {
                    this.forceWrite = true;
                    this.noWrite = false;
                } else if (arg.equals("-n") || arg.equals("--nowrite")) {
                    this.noWrite = true;
                    this.forceWrite = false;
                } else if (arg.equals("--dumpclass")) {
                    this.dumpClass = true;
                } else if (arg.equals("--noaugment")) {
                    this.noAugment = true;
                } else if (arg.equals("--noannotate")) {
                    this.noAnnotate = true;
                } else if (arg.equals("-s") || arg.equals("--sourcepath")) {
                    if (argv.length - i < 2) {
                        Main.this.printError("Missing argument to the -s/--sourcepath option", null);
                        this.usage();
                        return -1;
                    }
                    this.sourcePath = argv[++i];
                } else if (arg.equals("-d") || arg.equals("--destdir")) {
                    if (argv.length - i < 2) {
                        Main.this.printError("Missing argument to the -d/-destdir option", null);
                        this.usage();
                        return -1;
                    }
                    this.destinationDirectory = argv[++i];
                } else if (arg.equals("--properties")) {
                    if (argv.length - i < 2) {
                        Main.this.printError("Missing argument to the --properties option", null);
                        this.usage();
                        return -1;
                    }
                    this.propertiesFileName = argv[++i];
                } else {
                    if (arg.length() > 0 && arg.charAt(0) == '-') {
                        Main.this.printError("Unrecognized option:" + arg, null);
                        this.usage();
                        return -1;
                    }
                    if (arg.length() == 0) {
                        Main.this.printMessage("Ignoring empty command line argument.");
                    } else {
                        inputNames.add(arg);
                    }
                }
                ++i;
            }
            Iterator names = inputNames.iterator();
            while (names.hasNext()) {
                String name = (String)names.next();
                if (Main.isJdoFileName(name)) {
                    this.jdoFileNames.add(name);
                    continue;
                }
                if (Main.isClassFileName(name)) {
                    this.classFileNames.add(name);
                    continue;
                }
                if (Main.isZipFileName(name)) {
                    this.zipFileNames.add(name);
                    continue;
                }
                this.classNames.add(name);
            }
            if (this.verbose) {
                this.printArgs();
            }
            return this.checkArgs();
        }

        protected int checkArgs() {
            if (this.classFileNames.size() > 0 && this.jdoFileNames.isEmpty() && this.propertiesFileName == null && this.sourcePath == null) {
                String msg = "No JDO meta-data source specified for class files";
                Main.this.printError("No JDO meta-data source specified for class files", null);
                this.usage();
                return -1;
            }
            if (!this.jdoFileNames.isEmpty() && this.propertiesFileName != null) {
                String msg = "Cannot have both jdo files and properties specified";
                Main.this.printError("Cannot have both jdo files and properties specified", null);
                this.usage();
                return -1;
            }
            return 0;
        }

        protected void printArgs() {
            Main.this.out.println("Enhancer: options:");
            Main.this.out.println("    verbose = " + this.verbose);
            Main.this.out.println("    quiet = " + this.quiet);
            Main.this.out.println("    forceWrite = " + this.forceWrite);
            Main.this.out.println("    noWrite = " + this.noWrite);
            Main.this.out.println("    sourcePath = " + this.sourcePath);
            Main.this.out.println("    destinationDirectory = " + this.destinationDirectory);
            Main.this.out.println("    propertiesFileName = " + this.propertiesFileName);
            Main.this.out.println("    doTiming = " + this.doTiming);
            Main.this.out.println("    classNames = {");
            Iterator i = this.classNames.iterator();
            while (i.hasNext()) {
                Main.this.out.println("        " + i.next());
            }
            Main.this.out.println("    }");
            Main.this.out.println("    jdoFileNames = {");
            Iterator i2 = this.jdoFileNames.iterator();
            while (i2.hasNext()) {
                Main.this.out.println("        " + i2.next());
            }
            Main.this.out.println("    classFileNames = {");
            Iterator i3 = this.classFileNames.iterator();
            while (i3.hasNext()) {
                Main.this.out.println("        " + i3.next());
            }
            Main.this.out.println("    }");
            Main.this.out.println("    zipFileNames = {");
            Iterator i4 = this.zipFileNames.iterator();
            while (i4.hasNext()) {
                Main.this.out.println("        " + i4.next());
            }
            Main.this.out.println("    }");
            Main.this.out.println("    dumpClass = " + this.dumpClass);
            Main.this.out.println("    noAugment = " + this.noAugment);
            Main.this.out.println("    noAnnotate = " + this.noAnnotate);
        }
    }
}

