/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.enhancer;

import com.sap.jdo.enhancer.ClassFileEnhancer;
import com.sap.jdo.enhancer.EnhancerFatalError;
import com.sap.jdo.enhancer.EnhancerUserException;
import com.sap.jdo.enhancer.OutputStreamWrapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ClassFileEnhancerHelper {
    public static boolean enhanceClassFile(ClassFileEnhancer enhancer, InputStream in, OutputStream out) throws EnhancerUserException, EnhancerFatalError {
        return enhancer.enhanceClassFile(in, new OutputStreamWrapper(out));
    }

    /*
     * WARNING - void declaration
     */
    public static boolean enhanceZipFile(ClassFileEnhancer enhancer, ZipInputStream zip_in, ZipOutputStream zip_out) throws EnhancerUserException, EnhancerFatalError {
        boolean enhanced = false;
        try {
            ZipEntry entry;
            CRC32 crc32 = new CRC32();
            while ((entry = zip_in.getNextEntry()) != null) {
                void var5_6;
                InputStream in = zip_in;
                ZipEntry out_entry = new ZipEntry((ZipEntry)var5_6);
                if (ClassFileEnhancerHelper.isClassFileEntry((ZipEntry)var5_6)) {
                    in = ClassFileEnhancerHelper.openZipEntry(zip_in);
                    in.mark(Integer.MAX_VALUE);
                    ByteArrayOutputStream tmp = new ByteArrayOutputStream();
                    if (enhancer.enhanceClassFile(in, tmp)) {
                        enhanced = true;
                        byte[] bytes = tmp.toByteArray();
                        tmp.close();
                        in.close();
                        ClassFileEnhancerHelper.modifyZipEntry(out_entry, bytes, crc32);
                        in = new ByteArrayInputStream(bytes);
                    } else {
                        in.reset();
                    }
                }
                zip_out.putNextEntry(out_entry);
                ClassFileEnhancerHelper.copyZipEntry(in, zip_out);
                zip_out.closeEntry();
                if (in == zip_in) continue;
                in.close();
            }
        }
        catch (IOException ex) {
            throw new EnhancerFatalError(ex);
        }
        return enhanced;
    }

    /*
     * WARNING - void declaration
     */
    private static void copyZipEntry(InputStream in, OutputStream out) throws IOException {
        int b;
        while (in.available() > 0 && (b = in.read()) > -1) {
            void var2_2;
            out.write((int)var2_2);
        }
    }

    private static InputStream openZipEntry(ZipInputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ClassFileEnhancerHelper.copyZipEntry(in, out);
        return new ByteArrayInputStream(out.toByteArray());
    }

    private static void modifyZipEntry(ZipEntry entry, byte[] bytes, CRC32 crc32) {
        entry.setSize(bytes.length);
        if (entry.getMethod() == 0) {
            crc32.reset();
            crc32.update(bytes);
            entry.setCrc(crc32.getValue());
            entry.setCompressedSize(bytes.length);
        }
    }

    private static boolean isClassFileEntry(ZipEntry entry) {
        return entry.getName().endsWith(".class");
    }
}

