/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.common.sco.sap;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class ArrayList
extends com.sap.jdo.common.sco.ArrayList {
    private transient Vector added = new Vector();
    private transient Vector removed = new Vector();
    private transient Object clonedInstance = null;
    private static final String _ArrayList = "ArrayList";

    public ArrayList(Class elementType, boolean allowNulls) {
        super(elementType, allowNulls);
    }

    public ArrayList(Class elementType, boolean allowNulls, int initialCapacity) {
        super(elementType, allowNulls, initialCapacity);
    }

    public Object set(int index, Object element) {
        Object o = super.set(index, element);
        if (!this.added.remove(o)) {
            this.removed.add(o);
        }
        if (!this.removed.remove(element)) {
            this.added.add(element);
        }
        return o;
    }

    public boolean add(Object o) {
        if (!this.removed.remove(o)) {
            this.added.add(o);
        }
        return super.add(o);
    }

    public boolean remove(Object o) {
        if (super.remove(o)) {
            if (!this.added.remove(o)) {
                this.removed.add(o);
            }
            return true;
        }
        return false;
    }

    public void add(int index, Object element) {
        super.add(index, element);
        if (!this.removed.remove(element)) {
            this.added.add(element);
        }
    }

    public Object remove(int index) {
        Object obj = super.remove(index);
        if (!this.added.remove(obj)) {
            this.removed.add(obj);
        }
        return obj;
    }

    public void clear() {
        Iterator iter = super.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (this.added.remove(o)) continue;
            this.removed.add(o);
        }
        this.added.clear();
        super.clear();
    }

    public boolean addAll(Collection c) {
        boolean modified = super.addAll(c);
        this.removed.removeAll(c);
        this.added.addAll(c);
        return modified;
    }

    public boolean removeAll(Collection c) {
        boolean modified = false;
        Iterator e = c.iterator();
        while (e.hasNext()) {
            Object o = e.next();
            if (!super.contains(o)) continue;
            super.removeInternal(o);
            if (!this.added.remove(o)) {
                this.removed.add(o);
            }
            modified = true;
        }
        return modified;
    }

    public boolean addAll(int index, Collection c) {
        boolean modified = super.addAll(index, c);
        this.removed.removeAll(c);
        this.added.addAll(c);
        return modified;
    }

    public boolean retainAll(Collection c) {
        Iterator iter = super.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (c.contains(o) || this.added.remove(o)) continue;
            this.removed.add(o);
        }
        return super.retainAll(c);
    }

    public void resetElements() {
        this.added.clear();
        this.removed.clear();
    }

    public Object getAddedElements(Object lastImage) {
        return this.added;
    }

    public Object getRemovedElements(Object lastImage) {
        return this.removed;
    }

    public void clearInternal() {
        super.clearInternal();
        this.reset();
    }

    public Object clone() {
        Object obj = super.clone();
        ((ArrayList)obj).setClonedInstance(this);
        return obj;
    }

    private void setClonedInstance(Object obj) {
        this.clonedInstance = obj;
    }

    private boolean isClonedFrom(Object obj) {
        return this.clonedInstance == obj;
    }
}

