/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.common.sco;

import com.sap.jdo.SCO;
import com.sap.jdo.SCOCollection;
import com.sap.jdo.StateManagerInternal;
import com.sap.jdo.common.sco.SCOHelper;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import javax.jdo.I18NHelper;

public class TreeSet
extends java.util.TreeSet
implements SCOCollection {
    private transient StateManagerInternal owner;
    private transient int fieldNumber = -1;
    private transient Class elementType;
    private transient boolean allowNulls;
    private transient HashSet added = new HashSet();
    private transient HashSet removed = new HashSet();
    private static final I18NHelper msg = I18NHelper.getInstance((String)"com.sap.jdo.common.sco.Bundle");
    private static final String _TreeSet = "TreeSet";

    public TreeSet(Class elementType, boolean allowNulls) {
        this.elementType = elementType;
        this.allowNulls = allowNulls;
    }

    public TreeSet(Class elementType, boolean allowNulls, Comparator c) {
        super(c);
        this.elementType = elementType;
        this.allowNulls = allowNulls;
    }

    public boolean add(Object o) {
        SCOHelper.debug(_TreeSet, "add");
        SCOHelper.assertNullsAllowed(o, this.allowNulls);
        SCOHelper.assertElementType(o, this.elementType);
        this.makeDirty();
        boolean modified = super.add(o);
        if (modified && !this.removed.remove(o)) {
            this.added.add(o);
        }
        this.trackUpdates(modified);
        return modified;
    }

    public boolean addAll(Collection c) {
        SCOHelper.debug(_TreeSet, "addAll");
        Throwable[] err = new Throwable[c.size()];
        int l = 0;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            try {
                SCOHelper.assertNullsAllowed(o, this.allowNulls);
                SCOHelper.assertElementType(o, this.elementType);
            }
            catch (Throwable e) {
                err[l++] = e;
            }
        }
        SCOHelper.validateResult(l, err);
        boolean modified = false;
        this.makeDirty();
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (super.contains(o)) continue;
            if (!this.removed.remove(o)) {
                this.added.add(o);
            }
            super.add(o);
            modified = true;
        }
        this.trackUpdates(modified);
        return modified;
    }

    public boolean remove(Object o) {
        SCOHelper.debug(_TreeSet, "remove");
        this.makeDirty();
        boolean modified = super.remove(o);
        if (modified && !this.added.remove(o)) {
            this.removed.add(o);
        }
        this.trackUpdates(modified);
        return modified;
    }

    public boolean removeAll(Collection c) {
        SCOHelper.debug(_TreeSet, "removeAll");
        boolean modified = false;
        this.makeDirty();
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!super.contains(o)) continue;
            this.removeInternal(o);
            modified = true;
            if (this.added.remove(o)) continue;
            this.removed.add(o);
        }
        this.trackUpdates(modified);
        return modified;
    }

    public boolean retainAll(Collection c) {
        SCOHelper.debug(_TreeSet, "retainAll");
        this.makeDirty();
        Iterator iter = super.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (c.contains(o) || this.added.remove(o)) continue;
            this.removed.add(o);
        }
        boolean modified = super.retainAll(c);
        this.trackUpdates(modified);
        return modified;
    }

    public void clear() {
        SCOHelper.debug(_TreeSet, "clear");
        this.makeDirty();
        this.removed.clear();
        this.added.clear();
        Iterator iter = super.iterator();
        while (iter.hasNext()) {
            this.removed.add(iter.next());
        }
        super.clear();
        this.trackUpdates(true);
    }

    public Object clone() {
        SCOHelper.debug(_TreeSet, "clone");
        Object obj = super.clone();
        if (obj instanceof SCO) {
            ((SCO)obj).unsetOwner(this.owner, this.fieldNumber);
        }
        return obj;
    }

    public void reset() {
        this.added.clear();
        this.removed.clear();
    }

    public void addInternal(Object o) {
        super.add(o);
    }

    public void addAllInternal(Collection c) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            super.add(iter.next());
        }
    }

    public Collection getAdded() {
        return this.added;
    }

    public Collection getRemoved() {
        return this.removed;
    }

    public void clearInternal() {
        super.clear();
        this.reset();
    }

    public void removeInternal(Object o) {
        super.remove(o);
    }

    public void unsetOwner(Object owner, int fieldNumber) {
        if (this.owner == owner && this.fieldNumber == fieldNumber) {
            this.owner = null;
            this.fieldNumber = -1;
        }
    }

    public void setOwner(Object owner, int fieldNumber) {
        if (this.owner == null && owner instanceof StateManagerInternal) {
            this.owner = (StateManagerInternal)owner;
            this.fieldNumber = fieldNumber;
        }
    }

    public Object getOwner() {
        return SCOHelper.getOwner(this.owner);
    }

    public String getFieldName() {
        return SCOHelper.getFieldName(this.owner, this.fieldNumber);
    }

    private void makeDirty() {
        if (this.owner != null) {
            this.owner.makeDirty(this.fieldNumber);
        }
    }

    private void trackUpdates(boolean modified) {
        if (modified && this.owner != null) {
            this.owner.trackUpdates(this.fieldNumber, this);
        }
    }

    public Class getElementType() {
        return this.elementType;
    }

    public boolean allowNulls() {
        return this.allowNulls;
    }
}

