/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.common.sco;

import com.sap.jdo.SCO;
import com.sap.jdo.SCODate;
import com.sap.jdo.StateManagerInternal;
import com.sap.jdo.common.sco.SCOHelper;
import java.util.Calendar;
import java.util.Date;

public class SqlDate
extends java.sql.Date
implements SCODate {
    private transient StateManagerInternal owner;
    private transient int fieldNumber;
    private static final String _SqlDate = "SqlDate";

    public SqlDate() {
        super(SqlDate.normalize(0L));
    }

    public SqlDate(long date) {
        super(SqlDate.normalize(date));
    }

    public void setTime(long time) {
        SCOHelper.debug(_SqlDate, "setTime");
        this.makeDirty();
        super.setTime(SqlDate.normalize(time));
    }

    public Object clone() {
        SCOHelper.debug(_SqlDate, "clone");
        Object obj = super.clone();
        if (obj instanceof SCO) {
            ((SCO)obj).unsetOwner(this.owner, this.fieldNumber);
        }
        return obj;
    }

    public void setYear(int year) {
        SCOHelper.debug(_SqlDate, "setYear");
        this.makeDirty();
        super.setYear(year);
    }

    public void setMonth(int month) {
        SCOHelper.debug(_SqlDate, "setMonth");
        this.makeDirty();
        super.setMonth(month);
    }

    public void setDate(int date) {
        SCOHelper.debug(_SqlDate, "setDate");
        this.makeDirty();
        super.setDate(date);
    }

    public void setTimeInternal(long time) {
        super.setTime(SqlDate.normalize(time));
    }

    public void unsetOwner(Object owner, int fieldNumber) {
        if (this.owner == owner && this.fieldNumber == fieldNumber) {
            this.owner = null;
            this.fieldNumber = -1;
        }
    }

    public void setOwner(Object owner, int fieldNumber) {
        if (this.owner == null && owner instanceof StateManagerInternal) {
            this.owner = (StateManagerInternal)owner;
            this.fieldNumber = fieldNumber;
        }
    }

    public Object getOwner() {
        return SCOHelper.getOwner(this.owner);
    }

    public String getFieldName() {
        return SCOHelper.getFieldName(this.owner, this.fieldNumber);
    }

    private void makeDirty() {
        if (this.owner != null) {
            this.owner.makeDirty(this.fieldNumber);
        }
    }

    private static long normalize(long date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(date));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime().getTime();
    }
}

