/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.common.sco;

import com.sap.jdo.SCOCollection;
import com.sap.jdo.StateManagerInternal;
import com.sap.jdo.common.model.jdo.RuntimeJDOModelFactoryImpl;
import com.sap.jdo.common.model.jdo.util.TypeSupport;
import com.sap.jdo.common.sco.SCOHelper;
import com.sap.jdo.common.sco.sap.SCOCollectionElements;
import com.sap.jdo.model.jdo.JDOModel;
import com.sap.jdo.model.jdo.JDOModelException;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jdo.JDOFatalDataStoreException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.spi.PersistenceCapable;

public class ScoCollection
extends AbstractCollection
implements SCOCollection,
Cloneable,
Serializable,
SCOCollectionElements {
    private transient StateManagerInternal owner;
    private transient int fieldNumber = -1;
    private transient Class elementType;
    private transient boolean allowNulls;
    private transient ArrayList added = new ArrayList();
    private transient ArrayList removed = new ArrayList();
    private HashMap elementsCount = null;
    private int size = 0;
    private transient int modCount = 0;
    private transient ArrayList changedElements = new ArrayList();
    private transient ArrayList addedElements = new ArrayList();
    private transient ArrayList removedElements = new ArrayList();
    private transient ArrayList nonPCObjects = null;
    private transient Object clonedInstance = null;
    private static final String _CollectionSco = "ScoCollection";
    static /* synthetic */ Class class$javax$jdo$spi$PersistenceCapable;
    static /* synthetic */ Class class$java$lang$Object;

    public ScoCollection(Class elementType, boolean allowNulls) {
        this.elementType = elementType;
        if (allowNulls) {
            throw new UnsupportedOperationException("Null values are not yet supported");
        }
        this.allowNulls = allowNulls;
        this.elementsCount = new HashMap();
        if (!(class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = ScoCollection.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(elementType)) {
            this.nonPCObjects = new ArrayList();
        }
    }

    public ScoCollection(Class elementType, boolean allowNulls, int initialCapacity) {
        this.elementType = elementType;
        if (allowNulls) {
            throw new UnsupportedOperationException("Null values are not yet supported");
        }
        this.allowNulls = allowNulls;
        this.elementsCount = new HashMap(initialCapacity);
        if (!(class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = ScoCollection.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(elementType)) {
            this.nonPCObjects = new ArrayList();
        }
    }

    public ScoCollection(Class elementType, boolean allowNulls, int initialCapacity, float loadFactor) {
        this.elementType = elementType;
        if (allowNulls) {
            throw new UnsupportedOperationException("Null values are not yet supported");
        }
        this.allowNulls = allowNulls;
        this.elementsCount = new HashMap(initialCapacity, loadFactor);
        if (!(class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = ScoCollection.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(elementType)) {
            this.nonPCObjects = new ArrayList();
        }
    }

    public boolean add(Object o) {
        SCOHelper.debug(_CollectionSco, "add");
        SCOHelper.assertNullsAllowed(o, this.allowNulls);
        SCOHelper.assertElementType(o, this.elementType);
        this.makeDirty();
        this.addHashMap(o, false);
        this.trackUpdates(true);
        return true;
    }

    public boolean remove(Object o) {
        SCOHelper.debug(_CollectionSco, "remove");
        this.makeDirty();
        if (this.delHashMap(o, false)) {
            this.trackUpdates(true);
            return true;
        }
        return false;
    }

    public void clear() {
        SCOHelper.debug(_CollectionSco, "clear");
        this.makeDirty();
        ++this.modCount;
        super.clear();
        if (this.nonPCObjects != null) {
            this.nonPCObjects.clear();
        }
        if (!this.added.isEmpty() || !this.addedElements.isEmpty()) {
            throw new JDOFatalDataStoreException("Error during deletion");
        }
        this.trackUpdates(true);
    }

    public boolean addAll(Collection c) {
        SCOHelper.debug(_CollectionSco, "addAll");
        Throwable[] err = new Throwable[c.size()];
        int l = 0;
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            try {
                SCOHelper.assertNullsAllowed(o, this.allowNulls);
                SCOHelper.assertElementType(o, this.elementType);
            }
            catch (Throwable e) {
                err[l++] = e;
            }
            SCOHelper.validateResult(l, err);
        }
        this.makeDirty();
        ++this.modCount;
        boolean modified = super.addAll(c);
        this.trackUpdates(modified);
        return modified;
    }

    public boolean removeAll(Collection c) {
        SCOHelper.debug(_CollectionSco, "removeAll");
        boolean modified = false;
        this.makeDirty();
        Iterator e = c.iterator();
        while (e.hasNext()) {
            Object o = e.next();
            if (!this.contains(o)) continue;
            modified = this.delHashMap(o, false);
        }
        if (modified) {
            ++this.modCount;
        }
        this.trackUpdates(modified);
        return modified;
    }

    public boolean retainAll(Collection c) {
        SCOHelper.debug(_CollectionSco, "retainAll");
        boolean modified = false;
        this.makeDirty();
        modified = super.retainAll(c);
        if (this.nonPCObjects != null) {
            ((AbstractCollection)this.nonPCObjects).retainAll(c);
        }
        if (modified) {
            ++this.modCount;
        }
        this.trackUpdates(modified);
        return modified;
    }

    public void addInternal(Object o) {
        if (o instanceof EntryPair) {
            EntryPair pair = (EntryPair)o;
            this.size += pair.getCount();
            Object obj = pair.getObject();
            if (obj instanceof PersistenceCapable) {
                Object oid = ((PersistenceCapable)obj).jdoGetObjectId();
                obj = oid == null ? obj : oid;
            } else if (this.nonPCObjects != null) {
                this.nonPCObjects.add(obj);
            }
            this.elementsCount.put(obj, pair);
        } else {
            if (this.nonPCObjects != null && !(o instanceof PersistenceCapable)) {
                this.nonPCObjects.add(o);
            }
            this.addHashMap(o, true);
        }
        ++this.modCount;
    }

    public void addAllInternal(Collection c) {
        if (c instanceof ScoCollection) {
            ScoCollection scoC = (ScoCollection)c;
            Iterator it = scoC.elementsCount.keySet().iterator();
            while (it.hasNext()) {
                Object obj;
                Object o = it.next();
                this.elementsCount.put(o, scoC.elementsCount.get(o));
                if (this.nonPCObjects == null || (obj = ((EntryPair)scoC.elementsCount.get(o)).getObject()) instanceof PersistenceCapable) continue;
                this.nonPCObjects.add(obj);
            }
            this.size = scoC.size;
        } else {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                this.addHashMap(it.next(), true);
            }
        }
        ++this.modCount;
    }

    public void removeInternal(Object o) {
        this.delHashMap(o, true);
        if (this.nonPCObjects != null) {
            if (!(o instanceof EntryPair) || !((o = ((EntryPair)o).getObject()) instanceof PersistenceCapable)) {
                // empty if block
            }
            ((AbstractCollection)this.nonPCObjects).remove(o);
        }
        ++this.modCount;
    }

    public void resetElements() {
        this.added.clear();
        this.removed.clear();
        this.addedElements.clear();
        this.changedElements.clear();
        this.removedElements.clear();
    }

    public HashMap getAddedColElements(Object lastImage) {
        ScoCollection last;
        if (lastImage == null && this.nonPCObjects == null) {
            return this.elementsCount;
        }
        if (this.nonPCObjects != null || this.isClonedLastImage(lastImage)) {
            HashMap result = new HashMap();
            Iterator it = ((AbstractList)this.addedElements).iterator();
            while (it.hasNext()) {
                Object o = it.next();
                result.put(o, this.elementsCount.get(o));
            }
            return result;
        }
        if (this.addedElements == null) {
            return null;
        }
        if (lastImage instanceof ScoCollection) {
            last = (ScoCollection)lastImage;
        } else {
            last = new ScoCollection(this.elementType, this.allowNulls, ((Collection)lastImage).size());
            last.addAllInternal((Collection)lastImage);
        }
        HashMap result = new HashMap();
        Iterator it = this.elementsCount.keySet().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            EntryPair lastCount = (EntryPair)last.elementsCount.get(o);
            if (lastCount != null) continue;
            result.put(o, this.elementsCount.get(o));
        }
        return result;
    }

    public HashMap getChangedColElements(Object lastImage) {
        ScoCollection last;
        if (lastImage == null) {
            return null;
        }
        if (this.isClonedLastImage(lastImage)) {
            return this.getChangedElements(this.changedElements, (ScoCollection)lastImage);
        }
        if (this.changedElements == null) {
            return null;
        }
        if (lastImage instanceof ScoCollection) {
            last = (ScoCollection)lastImage;
        } else {
            last = new ScoCollection(this.elementType, this.allowNulls, ((Collection)lastImage).size());
            last.addAllInternal((Collection)lastImage);
        }
        return this.getChangedElements(this.elementsCount.keySet(), last);
    }

    private HashMap getChangedElements(Collection c, ScoCollection last) {
        HashMap result = new HashMap();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            EntryPair pair;
            Object o = it.next();
            EntryPair lastPair = (EntryPair)last.elementsCount.get(o);
            if (lastPair == null || (pair = (EntryPair)this.elementsCount.get(o)).getCount() == lastPair.getCount()) continue;
            result.put(o, pair);
        }
        return result;
    }

    public Collection getRemovedElements(Object lastImage) {
        ScoCollection last;
        if (lastImage == null) {
            return null;
        }
        if (this.isClonedLastImage(lastImage)) {
            return this.removedElements;
        }
        ArrayList removedElementsOid = new ArrayList();
        if (lastImage instanceof ScoCollection) {
            last = (ScoCollection)lastImage;
        } else {
            last = new ScoCollection(this.elementType, this.allowNulls, ((Collection)lastImage).size());
            last.addAllInternal((Collection)lastImage);
        }
        removedElementsOid.addAll(last.getElementsOid());
        ((AbstractCollection)removedElementsOid).removeAll(this.getElementsOid());
        this.removedElements = new ArrayList();
        Iterator it = ((AbstractList)removedElementsOid).iterator();
        while (it.hasNext()) {
            this.removedElements.add(((EntryPair)last.elementsCount.get(it.next())).getObject());
        }
        return this.removedElements;
    }

    public void clearInternal() {
        this.elementsCount.clear();
        if (this.nonPCObjects != null) {
            this.nonPCObjects.clear();
        }
        this.resetElements();
    }

    public Object clone() throws CloneNotSupportedException {
        SCOHelper.debug(_CollectionSco, "clone");
        ScoCollection obj = (ScoCollection)super.clone();
        obj.elementsCount = new HashMap(this.elementsCount.size());
        Iterator it = this.elementsCount.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            obj.elementsCount.put(entry.getKey(), ((EntryPair)entry.getValue()).clone());
        }
        obj.size = this.size;
        obj.unsetOwner(this.owner, this.fieldNumber);
        obj.setClonedInstance(this);
        obj.resetElements();
        obj.modCount = 0;
        if (this.nonPCObjects != null) {
            obj.nonPCObjects = (ArrayList)this.nonPCObjects.clone();
        }
        return obj;
    }

    private void setClonedInstance(Object obj) {
        this.clonedInstance = obj;
    }

    private boolean isClonedLastImage(Object lastImage) {
        return lastImage instanceof ScoCollection && ((ScoCollection)lastImage).isClonedFrom(this);
    }

    private boolean isClonedFrom(Object obj) {
        return this.clonedInstance == obj;
    }

    private void addHashMap(Object o, boolean internal) {
        EntryPair val;
        Object oid;
        if (o == null) {
            throw new UnsupportedOperationException("Null values are not yet supported");
        }
        if (o instanceof PersistenceCapable) {
            oid = ((PersistenceCapable)o).jdoGetObjectId();
            if (oid == null) {
                oid = o;
            }
        } else {
            oid = o;
        }
        if (!internal && !((AbstractCollection)this.removed).remove(o)) {
            this.added.add(o);
        }
        if ((val = (EntryPair)this.elementsCount.get(oid)) == null) {
            if (this.nonPCObjects != null && !(o instanceof PersistenceCapable)) {
                this.nonPCObjects.add(o);
            } else if (!internal && !((AbstractCollection)this.removedElements).remove(o)) {
                this.addedElements.add(oid);
            }
            this.elementsCount.put(oid, new EntryPair(1, o));
            ++this.size;
        } else {
            if (this.nonPCObjects != null && !(o instanceof PersistenceCapable)) {
                this.nonPCObjects.add(o);
            } else if (!internal && !this.addedElements.contains(oid)) {
                this.changedElements.add(oid);
            }
            this.elementsCount.put(oid, ((EntryPair)this.elementsCount.get(oid)).incrementCount());
            ++this.size;
        }
    }

    private boolean delHashMap(Object o, boolean internal) {
        EntryPair val;
        Object oid;
        if (o == null) {
            throw new UnsupportedOperationException("Null values are not yet supported");
        }
        if (o instanceof PersistenceCapable) {
            oid = ((PersistenceCapable)o).jdoGetObjectId();
            if (oid == null) {
                oid = o;
            }
        } else {
            oid = o;
        }
        if (!((AbstractCollection)this.added).remove(o)) {
            this.removed.add(o);
        }
        if ((val = (EntryPair)this.elementsCount.get(oid)) == null) {
            return false;
        }
        if (val.count == 1) {
            this.elementsCount.remove(oid);
            --this.size;
            if (this.nonPCObjects != null && !(o instanceof PersistenceCapable)) {
                ((AbstractCollection)this.nonPCObjects).remove(o);
            } else if (!(internal || ((AbstractCollection)this.addedElements).remove(oid) && !((AbstractCollection)this.changedElements).remove(oid))) {
                this.removedElements.add(o);
            }
        } else {
            if (this.nonPCObjects != null && !(o instanceof PersistenceCapable)) {
                ((AbstractCollection)this.nonPCObjects).remove(o);
            } else if (!internal) {
                this.changedElements.add(oid);
            }
            this.elementsCount.put(oid, ((EntryPair)this.elementsCount.get(oid)).decrementCount());
            --this.size;
        }
        return true;
    }

    public void unsetOwner(Object owner, int fieldNumber) {
        if (this.owner == owner && this.fieldNumber == fieldNumber) {
            this.owner = null;
            this.fieldNumber = -1;
        }
    }

    private void makeDirty() {
        if (this.owner != null) {
            this.owner.makeDirty(this.fieldNumber);
        }
    }

    private void trackUpdates(boolean modified) {
        if (modified && this.owner != null) {
            this.owner.trackUpdates(this.fieldNumber, this);
        }
    }

    public void setOwner(Object owner, int fieldNumber) {
        if (this.owner == null && owner instanceof StateManagerInternal) {
            this.owner = (StateManagerInternal)owner;
            this.fieldNumber = fieldNumber;
            try {
                JDOModel jdoModel = RuntimeJDOModelFactoryImpl.getInstance().getJDOModel(((StateManagerInternal)owner).getPCClass().getClassLoader());
                if (TypeSupport.isValueType(jdoModel, this.elementType)) {
                    this.nonPCObjects = null;
                }
            }
            catch (JDOModelException e) {
                throw new JDOFatalInternalException("Error during JDOModel access.", (Throwable)e);
            }
        }
    }

    public Object getOwner() {
        return SCOHelper.getOwner(this.owner);
    }

    public String getFieldName() {
        return SCOHelper.getFieldName(this.owner, this.fieldNumber);
    }

    public Class getElementType() {
        return this.elementType;
    }

    public boolean allowNulls() {
        return this.allowNulls;
    }

    public Collection getAdded() {
        return this.added;
    }

    public Collection getRemoved() {
        return this.removed;
    }

    public void reset() {
        this.added.clear();
        this.removed.clear();
    }

    public Iterator iterator() {
        return new CollectionScoIterator(this, this.modCount);
    }

    public int size() {
        return this.size;
    }

    private Collection getElementsOid() {
        ArrayList result = new ArrayList();
        Iterator it = this.elementsCount.keySet().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            EntryPair pair = (EntryPair)this.elementsCount.get(o);
            if (!(pair.getObject() instanceof PersistenceCapable)) continue;
            result.add(o);
        }
        return result;
    }

    public boolean equals(Object obj) {
        ScoCollection col;
        if (obj == null || !(obj instanceof Collection) || this.size != ((Collection)obj).size() && ((Collection)obj).size() != Integer.MAX_VALUE) {
            return false;
        }
        if (obj instanceof ScoCollection) {
            col = (ScoCollection)obj;
        } else {
            col = new ScoCollection(class$java$lang$Object == null ? (class$java$lang$Object = ScoCollection.class$("java.lang.Object")) : class$java$lang$Object, false, ((Collection)obj).size());
            col.addAllInternal((Collection)obj);
        }
        Iterator it = this.elementsCount.keySet().iterator();
        while (it.hasNext()) {
            Object oid = it.next();
            EntryPair colPair = (EntryPair)col.elementsCount.get(oid);
            if (colPair != null && ((EntryPair)this.elementsCount.get(oid)).getCount() == colPair.getCount()) continue;
            return false;
        }
        return true;
    }

    public Collection getAddedSetElements(Object lastImage) {
        throw new JDOFatalInternalException("ScoCollection is not a set!");
    }

    public Collection getNonPCObjects() {
        return this.nonPCObjects;
    }

    public byte getNonPCObjectsChanges(Object lastImage) {
        ArrayList lastCol = null;
        if (lastImage != null) {
            lastCol = ((ScoCollection)lastImage).nonPCObjects;
        }
        if (this.nonPCObjects != null && this.nonPCObjects.size() != 0 && lastCol != null) {
            if (((AbstractList)this.nonPCObjects).equals(lastCol)) {
                return 0;
            }
            return 2;
        }
        if ((this.nonPCObjects == null || this.nonPCObjects.size() == 0) && lastCol != null) {
            return 3;
        }
        if (this.nonPCObjects != null && lastCol == null) {
            return 1;
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class EntryPair
    implements Serializable,
    Cloneable {
        private int count;
        private Object obj;

        public EntryPair(int count, Object obj) {
            this.count = count;
            this.obj = obj;
        }

        private EntryPair incrementCount() {
            ++this.count;
            return this;
        }

        private EntryPair decrementCount() {
            --this.count;
            return this;
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public int getCount() {
            return this.count;
        }

        public Object getObject() {
            return this.obj;
        }
    }

    class CollectionScoIterator
    implements Iterator {
        private ScoCollection collection;
        private Iterator it;
        private Object actual;
        private Object returnObj;
        private int index;
        private int size;
        private int expectedModCount;

        private CollectionScoIterator(ScoCollection collection, int expectedModCount) {
            this.collection = collection;
            this.it = collection.elementsCount.keySet().iterator();
            this.expectedModCount = expectedModCount;
            this.index = 0;
            this.size = 0;
        }

        public boolean hasNext() {
            return this.it.hasNext() || this.index + 1 < this.size;
        }

        public Object next() {
            if (this.expectedModCount != ScoCollection.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (++this.index < this.size) {
                return this.returnObj;
            }
            this.actual = this.it.next();
            EntryPair pair = (EntryPair)this.collection.elementsCount.get(this.actual);
            this.size = pair.count;
            this.returnObj = pair.getObject();
            this.index = 0;
            return this.returnObj;
        }

        public void remove() {
            if (this.expectedModCount != ScoCollection.this.modCount) {
                throw new ConcurrentModificationException();
            }
            this.collection.delHashMap(this.actual, false);
            --this.size;
        }
    }
}

