/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.common.sco;

import com.sap.jdo.SCO;
import com.sap.jdo.SCOMap;
import com.sap.jdo.StateManagerInternal;
import com.sap.jdo.common.sco.SCOHelper;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.jdo.I18NHelper;

public class Hashtable
extends java.util.Hashtable
implements SCOMap {
    private transient StateManagerInternal owner;
    private transient int fieldNumber = -1;
    private transient Class keyType;
    private transient Class valueType;
    private transient boolean allowNulls;
    private transient ArrayList addedKeys = new ArrayList();
    private transient ArrayList addedValues = new ArrayList();
    private transient ArrayList removedKeys = new ArrayList();
    private transient ArrayList removedValues = new ArrayList();
    private static final I18NHelper msg = I18NHelper.getInstance((String)"com.sap.jdo.common.sco.Bundle");
    private static final String _Hashtable = "Hashtable";

    public Hashtable(Class keyType, Class valueType, boolean allowNulls) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.allowNulls = allowNulls;
    }

    public Hashtable(Class keyType, Class valueType, boolean allowNulls, int initialCapacity) {
        super(initialCapacity);
        this.keyType = keyType;
        this.valueType = valueType;
        this.allowNulls = allowNulls;
    }

    public Hashtable(Class keyType, Class valueType, boolean allowNulls, int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.keyType = keyType;
        this.valueType = valueType;
        this.allowNulls = allowNulls;
    }

    public Object put(Object key, Object value) {
        SCOHelper.debug(_Hashtable, "put");
        Throwable[] err = new Throwable[2];
        int l = 0;
        try {
            SCOHelper.assertNullKeysAllowed(key, this.allowNulls);
            SCOHelper.assertKeyType(key, this.keyType);
        }
        catch (Throwable ex) {
            err[l++] = ex;
        }
        try {
            SCOHelper.assertNullValuesAllowed(value, this.allowNulls);
            SCOHelper.assertValueType(value, this.valueType);
        }
        catch (Throwable ex) {
            err[l++] = ex;
        }
        SCOHelper.validateResult(l, err);
        this.makeDirty();
        Object o = this.process(key, value);
        this.trackUpdates(true);
        return o;
    }

    public void putAll(Map t) {
        SCOHelper.debug(_Hashtable, "putAll");
        Throwable[] err = new Throwable[2 * t.size()];
        int l = 0;
        Iterator i = t.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            Object k = e.getKey();
            Object v = e.getValue();
            try {
                SCOHelper.assertNullKeysAllowed(k, this.allowNulls);
                SCOHelper.assertKeyType(k, this.keyType);
            }
            catch (Throwable ex) {
                err[l++] = ex;
            }
            try {
                SCOHelper.assertNullValuesAllowed(v, this.allowNulls);
                SCOHelper.assertValueType(v, this.valueType);
            }
            catch (Throwable ex) {
                err[l++] = ex;
            }
        }
        SCOHelper.validateResult(l, err);
        boolean modified = false;
        this.makeDirty();
        i = t.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            this.process(e.getKey(), e.getValue());
        }
        this.trackUpdates(true);
    }

    public Object remove(Object key) {
        SCOHelper.debug(_Hashtable, "remove");
        this.makeDirty();
        boolean removed = false;
        if (super.containsKey(key)) {
            if (!((AbstractCollection)this.addedKeys).remove(key)) {
                this.removedKeys.add(key);
            }
            removed = true;
        }
        Object o = super.remove(key);
        if (removed && !((AbstractCollection)this.addedValues).remove(o)) {
            this.removedValues.add(o);
        }
        this.trackUpdates(removed);
        return o;
    }

    public void clear() {
        SCOHelper.debug(_Hashtable, "clear");
        this.makeDirty();
        Iterator i = super.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            this.removedKeys.add(e.getKey());
            this.removedValues.add(e.getValue());
        }
        super.clear();
        this.addedKeys.clear();
        this.addedValues.clear();
        this.trackUpdates(true);
    }

    public Object clone() {
        SCOHelper.debug(_Hashtable, "clone");
        Object obj = super.clone();
        if (obj instanceof SCO) {
            ((SCO)obj).unsetOwner(this.owner, this.fieldNumber);
        }
        return obj;
    }

    public void reset() {
        this.addedKeys.clear();
        this.addedValues.clear();
        this.removedKeys.clear();
        this.removedValues.clear();
    }

    public void putInternal(Object key, Object value) {
        super.put(key, value);
    }

    public void putAllInternal(Map t) {
        Iterator i = t.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            super.put(e.getKey(), e.getValue());
        }
    }

    public Collection getAddedKeys() {
        return this.addedKeys;
    }

    public Collection getAddedValues() {
        return this.addedValues;
    }

    public Collection getRemovedKeys() {
        return this.removedKeys;
    }

    public Collection getRemovedValues() {
        return this.removedValues;
    }

    public void clearInternal() {
        super.clear();
        this.reset();
    }

    public void removeInternal(Object key) {
        super.remove(key);
    }

    public void unsetOwner(Object owner, int fieldNumber) {
        if (this.owner == owner && this.fieldNumber == fieldNumber) {
            this.owner = null;
            this.fieldNumber = -1;
        }
    }

    public void setOwner(Object owner, int fieldNumber) {
        if (this.owner == null && owner instanceof StateManagerInternal) {
            this.owner = (StateManagerInternal)owner;
            this.fieldNumber = fieldNumber;
        }
    }

    public Object getOwner() {
        return SCOHelper.getOwner(this.owner);
    }

    public String getFieldName() {
        return SCOHelper.getFieldName(this.owner, this.fieldNumber);
    }

    private void makeDirty() {
        if (this.owner != null) {
            this.owner.makeDirty(this.fieldNumber);
        }
    }

    private void trackUpdates(boolean modified) {
        if (modified && this.owner != null) {
            this.owner.trackUpdates(this.fieldNumber, this);
        }
    }

    public Class getKeyType() {
        return this.keyType;
    }

    public Class getValueType() {
        return this.valueType;
    }

    public boolean allowNulls() {
        return this.allowNulls;
    }

    private Object process(Object key, Object value) {
        Object o;
        if (!super.containsKey(key) && !((AbstractCollection)this.removedKeys).remove(key)) {
            this.addedKeys.add(key);
        }
        if (!((AbstractCollection)this.addedValues).remove(o = super.put(key, value))) {
            this.removedValues.add(o);
        }
        if (!((AbstractCollection)this.removedValues).remove(value)) {
            this.addedValues.add(value);
        }
        return o;
    }
}

