/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.common.model.jdo.xml;

import com.sap.jdo.common.model.jdo.JDOModelFactoryImpl;
import com.sap.jdo.common.model.jdo.RuntimeJavaModel;
import com.sap.jdo.common.model.jdo.util.PrintSupport;
import com.sap.jdo.model.jdo.JDOClass;
import com.sap.jdo.model.jdo.JDOModel;
import com.sap.jdo.model.jdo.JDOModelFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class XMLExists {
    private boolean xmlExpected;
    public static final int VERBOSE = 1;
    public static final int NORMAL = 0;
    public static final int QUITE = -1;
    private int outputLevel = 0;

    public static void main(String[] args) {
        XMLExists test = new XMLExists();
        List classNames = test.processArgs(args);
        if (!test.run(classNames)) {
            System.exit(1);
        }
    }

    public XMLExists() {
        this(true, 0);
    }

    public XMLExists(boolean xmlExpected, int outputLevel) {
        this.xmlExpected = xmlExpected;
        this.outputLevel = outputLevel;
    }

    public boolean run(List classNames) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        boolean ok = true;
        Iterator i = classNames.iterator();
        while (i.hasNext()) {
            String className = (String)i.next();
            try {
                this.checkClass(className, classLoader, this.xmlExpected);
                if (this.outputLevel == 0 && this.xmlExpected) {
                    System.out.println("Found XML metadata for class " + className);
                    continue;
                }
                if (this.outputLevel != 0 || this.xmlExpected) continue;
                System.out.println("No MXL metadata for class " + className);
            }
            catch (Exception ex) {
                if (this.outputLevel > -1) {
                    System.err.println(ex);
                }
                ok = false;
            }
        }
        return ok;
    }

    public void checkClass(String className, ClassLoader classLoader, boolean xmlExpected) throws Exception {
        JDOModelFactory factory;
        JDOModel jdoModel;
        Class<?> clazz = Class.forName(className, true, classLoader);
        if (this.outputLevel == 1) {
            System.out.println("Found " + clazz);
        }
        if ((jdoModel = (factory = JDOModelFactoryImpl.getInstance()).getJDOModel(classLoader)).getJavaModel() == null) {
            jdoModel.setJavaModel(new RuntimeJavaModel(classLoader));
        }
        JDOClass jdoClass = jdoModel.getJDOClass(className);
        if (xmlExpected && jdoClass == null) {
            throw new Exception("Missing JDO XML metadata for class " + className);
        }
        if (!xmlExpected && jdoClass != null) {
            throw new Exception("Found JDO XML metadata for class " + className);
        }
        if (this.outputLevel == 1 && jdoClass != null) {
            PrintSupport.printJDOClass(jdoClass);
        }
    }

    protected List processArgs(String[] args) {
        ArrayList<String> classNames = new ArrayList<String>();
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.equals("-h")) {
                this.usage();
            } else if (arg.equals("-v")) {
                this.outputLevel = 1;
            } else if (arg.equals("-q")) {
                this.outputLevel = -1;
            } else if (arg.equals("-xml")) {
                this.xmlExpected = true;
            } else if (arg.equals("-noxmlc")) {
                this.xmlExpected = false;
            } else if (arg.length() > 0 && arg.charAt(0) == '-') {
                System.err.println("Unrecognized option:" + arg);
                this.usage();
            } else if (arg.length() == 0) {
                System.err.println("Ignoring empty command line argument.");
            } else {
                classNames.add(arg);
            }
            ++i;
        }
        return classNames;
    }

    public void usage() {
        System.err.println("Usage: main <options> <arguments>...");
        System.err.println("Options:");
        System.err.println("  -h      print usage message");
        System.err.println("  -v      print verbose messages and JDO metadata");
        System.err.println("  -q      do not print any messages; just set the exit code");
        System.err.println("  -xml    expected to find JDO XML metadata for the specified class(es)");
        System.err.println("  -noxml  expected to find no JDO XML metadata for the specified class(es)");
        System.err.println("Arguments:");
        System.err.println("  <classname>   the fully qualified name of a class to be checked");
    }
}

