/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.common.model.jdo.xml;

import com.sap.jdo.common.model.jdo.xml.JDOHandler;
import com.sap.jdo.model.jdo.JDOArray;
import com.sap.jdo.model.jdo.JDOClass;
import com.sap.jdo.model.jdo.JDOCollection;
import com.sap.jdo.model.jdo.JDOElement;
import com.sap.jdo.model.jdo.JDOExtension;
import com.sap.jdo.model.jdo.JDOField;
import com.sap.jdo.model.jdo.JDOIdentityType;
import com.sap.jdo.model.jdo.JDOMap;
import com.sap.jdo.model.jdo.JDOModel;
import com.sap.jdo.model.jdo.JDOModelException;
import com.sap.jdo.model.jdo.JDOPackage;
import com.sap.jdo.model.jdo.NullValueTreatment;
import com.sap.jdo.model.jdo.PersistenceModifier;
import com.sap.tc.logging.Location;
import java.util.Collection;
import java.util.HashSet;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class JDOHandlerImpl
implements JDOHandler {
    private final JDOModel model;
    private final Stack context = new Stack();
    private Collection handledJDOClasses = new HashSet();
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$jdo$common$model$jdo$xml$JDOHandlerImpl == null ? (class$com$sap$jdo$common$model$jdo$xml$JDOHandlerImpl = JDOHandlerImpl.class$("com.sap.jdo.common.model.jdo.xml.JDOHandlerImpl")) : class$com$sap$jdo$common$model$jdo$xml$JDOHandlerImpl));
    private final boolean bePath;
    static /* synthetic */ Class class$com$sap$jdo$common$model$jdo$xml$JDOHandlerImpl;

    public JDOHandlerImpl(JDOModel aModel) {
        this.model = aModel;
        this.bePath = LOCATION.beDebug();
    }

    public void start_jdo(Attributes meta) {
        if (this.bePath) {
            LOCATION.pathT("start_jdo");
        }
        this.context.push(this.model);
    }

    public void end_jdo() {
        if (this.bePath) {
            LOCATION.pathT("end_jdo");
        }
        this.context.pop();
    }

    public void start_package(Attributes meta) throws SAXException {
        if (this.bePath) {
            LOCATION.pathT("start_package");
        }
        JDOPackage jdoPackage = null;
        try {
            JDOModel model = (JDOModel)this.context.peek();
            String packageName = meta.getValue("", "name");
            if (packageName == null || packageName.length() == 0) {
                throw new JDOModelException("Invalid empty package specification");
            }
            jdoPackage = model.createJDOPackage(packageName);
        }
        catch (JDOModelException ex) {
            LOCATION.traceThrowableT(500, "model exception in start_package", (Throwable)ex);
            SAXException e = new SAXException("model exception", ex);
            LOCATION.throwing((Throwable)e);
            throw e;
        }
        this.context.push(jdoPackage);
    }

    public void end_package() {
        if (this.bePath) {
            LOCATION.pathT("end_package");
        }
        this.context.pop();
    }

    public void start_class(Attributes meta) throws SAXException {
        if (this.bePath) {
            LOCATION.pathT("start_class");
        }
        JDOClass jdoClass = null;
        try {
            JDOPackage jdoPackage = (JDOPackage)this.context.peek();
            String packageName = jdoPackage.getName();
            String className = meta.getValue("", "name");
            className = packageName + '.' + className;
            jdoClass = this.model.createJDOClass(className, false);
            int i = 0;
            while (i < meta.getLength()) {
                String name = meta.getLocalName(i);
                String value = meta.getValue(i);
                LOCATION.debugT("  " + name + " = " + value);
                if (!"name".equals(name)) {
                    if ("identity-type".equals(name)) {
                        jdoClass.setIdentityType(JDOIdentityType.toJDOIdentityType(value));
                    } else if ("objectid-class".equals(name)) {
                        jdoClass.setObjectIdClassName(value);
                    } else if ("requires-extent".equals(name)) {
                        jdoClass.setRequiresExtent(new Boolean(value));
                    } else if ("persistence-capable-superclass".equals(name)) {
                        if (jdoClass.getPersistenceCapableSuperclassName() == null) {
                            jdoClass.setPersistenceCapableSuperclassName(value);
                        }
                    } else {
                        SAXException e = new SAXException("unknown class attribute " + name + "=" + value);
                        LOCATION.throwing((Throwable)e);
                        throw e;
                    }
                }
                ++i;
            }
        }
        catch (JDOModelException ex) {
            LOCATION.traceThrowableT(500, "model exception in start_class", (Throwable)ex);
            SAXException e = new SAXException("model exception", ex);
            LOCATION.throwing((Throwable)e);
            throw e;
        }
        this.handledJDOClasses.add(jdoClass);
        this.context.push(jdoClass);
    }

    public void end_class() {
        if (this.bePath) {
            LOCATION.pathT("end_class");
        }
        this.context.pop();
    }

    public void start_field(Attributes meta) throws SAXException {
        if (this.bePath) {
            LOCATION.pathT("start_field");
        }
        JDOField jdoField = null;
        try {
            JDOClass jdoClass = (JDOClass)this.context.peek();
            String fieldName = meta.getValue("", "name");
            jdoField = jdoClass.createJDOField(fieldName);
            int i = 0;
            while (i < meta.getLength()) {
                String name = meta.getLocalName(i);
                String value = meta.getValue(i);
                LOCATION.debugT("  " + name + " = " + value);
                if (!"name".equals(name)) {
                    if ("persistence-modifier".equals(name)) {
                        int modifier = PersistenceModifier.toPersistenceModifier(value);
                        jdoField.setPersistenceModifier(modifier);
                    } else if ("primary-key".equals(name)) {
                        jdoField.setPrimaryKey(new Boolean(value));
                    } else if ("null-value".equals(name)) {
                        jdoField.setNullValueTreatment(NullValueTreatment.toNullValueTreatment(value));
                    } else if ("default-fetch-group".equals(name)) {
                        jdoField.setDefaultFetchGroup(new Boolean(value));
                    } else if ("embedded".equals(name)) {
                        jdoField.setEmbedded(new Boolean(value));
                    } else {
                        SAXException e = new SAXException("unknown field attribute " + name + "=" + value);
                        LOCATION.throwing((Throwable)e);
                        throw e;
                    }
                }
                ++i;
            }
        }
        catch (JDOModelException ex) {
            LOCATION.traceThrowableT(500, "model exception in start_field", (Throwable)ex);
            SAXException e = new SAXException("model exception", ex);
            LOCATION.throwing((Throwable)e);
            throw e;
        }
        this.context.push(jdoField);
    }

    public void end_field() {
        if (this.bePath) {
            LOCATION.pathT("end_field");
        }
        this.context.pop();
    }

    public void start_collection(Attributes meta) throws SAXException {
        if (this.bePath) {
            LOCATION.pathT("start_collection");
        }
        JDOCollection jdoCollection = null;
        try {
            JDOField jdoField = (JDOField)this.context.peek();
            jdoCollection = jdoField.createJDOCollection();
            int i = 0;
            while (i < meta.getLength()) {
                String name = meta.getLocalName(i);
                String value = meta.getValue(i);
                LOCATION.debugT("  " + name + " = " + value);
                if ("element-type".equals(name)) {
                    jdoCollection.setElementTypeName(value);
                } else if ("embedded-element".equals(name)) {
                    jdoCollection.setEmbeddedElement(new Boolean(value));
                } else {
                    SAXException e = new SAXException("unknown collection attribute " + name + "=" + value);
                    LOCATION.throwing((Throwable)e);
                    throw e;
                }
                ++i;
            }
        }
        catch (JDOModelException ex) {
            LOCATION.traceThrowableT(500, "model exception in start_collection", (Throwable)ex);
            SAXException e = new SAXException("model exception", ex);
            LOCATION.throwing((Throwable)e);
            throw e;
        }
        this.context.push(jdoCollection);
    }

    public void end_collection() {
        if (this.bePath) {
            LOCATION.pathT("end_collection");
        }
        this.context.pop();
    }

    public void start_array(Attributes meta) throws SAXException {
        if (this.bePath) {
            LOCATION.pathT("start_array");
        }
        JDOArray jdoArray = null;
        try {
            JDOField jdoField = (JDOField)this.context.peek();
            jdoArray = jdoField.createJDOArray();
            int i = 0;
            while (i < meta.getLength()) {
                String name = meta.getLocalName(i);
                String value = meta.getValue(i);
                LOCATION.debugT("  " + name + " = " + value);
                if (!"embedded-element".equals(name)) {
                    SAXException e = new SAXException("unknown array attribute " + name + "=" + value);
                    LOCATION.throwing((Throwable)e);
                    throw e;
                }
                jdoArray.setEmbeddedElement(new Boolean(value));
                ++i;
            }
        }
        catch (JDOModelException ex) {
            LOCATION.traceThrowableT(500, "model exception in start_array", (Throwable)ex);
            SAXException e = new SAXException("model exception", ex);
            LOCATION.throwing((Throwable)e);
            throw e;
        }
        this.context.push(jdoArray);
    }

    public void end_array() {
        if (this.bePath) {
            LOCATION.pathT("end_array");
        }
        this.context.pop();
    }

    public void start_map(Attributes meta) throws SAXException {
        if (this.bePath) {
            LOCATION.pathT("start_map");
        }
        JDOMap jdoMap = null;
        try {
            JDOField jdoField = (JDOField)this.context.peek();
            jdoMap = jdoField.createJDOMap();
            int i = 0;
            while (i < meta.getLength()) {
                String name = meta.getLocalName(i);
                String value = meta.getValue(i);
                LOCATION.debugT("  " + name + " = " + value);
                if ("key-type".equals(name)) {
                    jdoMap.setKeyTypeName(value);
                } else if ("embedded-key".equals(name)) {
                    jdoMap.setEmbeddedKey(new Boolean(value));
                } else if ("value-type".equals(name)) {
                    jdoMap.setValueTypeName(value);
                } else if ("embedded-value".equals(name)) {
                    jdoMap.setEmbeddedValue(new Boolean(value));
                } else {
                    SAXException e = new SAXException("unknown map attribute " + name + "=" + value);
                    LOCATION.throwing((Throwable)e);
                    throw e;
                }
                ++i;
            }
        }
        catch (JDOModelException ex) {
            LOCATION.traceThrowableT(500, "model exception in start_map", (Throwable)ex);
            SAXException e = new SAXException("model exception", ex);
            LOCATION.throwing((Throwable)e);
            throw e;
        }
        this.context.push(jdoMap);
    }

    public void end_map() {
        if (this.bePath) {
            LOCATION.pathT("end_map");
        }
        this.context.pop();
    }

    public void start_extension(Attributes meta) throws SAXException {
        if (this.bePath) {
            LOCATION.pathT("start_extension");
        }
        JDOExtension jdoExtension = null;
        try {
            JDOElement jdoElement = (JDOElement)this.context.peek();
            jdoExtension = jdoElement.createJDOExtension();
            int i = 0;
            while (i < meta.getLength()) {
                String name = meta.getLocalName(i);
                String value = meta.getValue(i);
                LOCATION.debugT("  " + name + " = " + value);
                if ("vendor-name".equals(name)) {
                    jdoExtension.setVendorName(value);
                } else if ("key".equals(name)) {
                    jdoExtension.setKey(value);
                } else if ("value".equals(name)) {
                    jdoExtension.setValue(value);
                } else {
                    SAXException e = new SAXException("unknown extension attribute " + name + "=" + value);
                    LOCATION.throwing((Throwable)e);
                    throw e;
                }
                ++i;
            }
        }
        catch (JDOModelException ex) {
            LOCATION.traceThrowableT(500, "model exception in start_extension", (Throwable)ex);
            SAXException e = new SAXException("model exception", ex);
            LOCATION.throwing((Throwable)e);
            throw e;
        }
    }

    public void end_extension() {
        if (this.bePath) {
            LOCATION.pathT("end_extension");
        }
    }

    public Collection handledJDOClasses() {
        return this.handledJDOClasses;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

