/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.common.model.jdo;

import com.sap.jdo.common.model.jdo.JDOModelFactoryImpl;
import com.sap.jdo.common.model.jdo.RegisterClassListener;
import com.sap.jdo.common.model.jdo.RuntimeJavaModel;
import com.sap.jdo.model.jdo.JDOModel;
import com.sap.jdo.model.jdo.JDOModelException;
import com.sap.jdo.model.jdo.JDOModelFactory;
import javax.jdo.I18NHelper;
import javax.jdo.spi.JDOImplHelper;

public class RuntimeJDOModelFactoryImpl
extends JDOModelFactoryImpl {
    private static JDOModelFactory jdoModelFactory;
    private static final I18NHelper msg;

    public static synchronized JDOModelFactory getInstance() throws JDOModelException {
        if (jdoModelFactory == null) {
            jdoModelFactory = new RuntimeJDOModelFactoryImpl();
            try {
                JDOImplHelper helper = JDOImplHelper.getInstance();
                RegisterClassListener crl = new RegisterClassListener(helper, jdoModelFactory);
                helper.addRegisterClassListener((javax.jdo.spi.RegisterClassListener)crl);
            }
            catch (SecurityException ex) {
                throw new JDOModelException(msg.msg("EXC_NoJDOImplHelper"), ex);
            }
        }
        return jdoModelFactory;
    }

    public JDOModel getJDOModel(Object key) throws JDOModelException {
        if (!(key instanceof ClassLoader)) {
            throw new JDOModelException(msg.msg("EXC_InvalidJDOModelKey", (Object)key.getClass().getName()));
        }
        return super.getJDOModel(key);
    }

    protected void updateCache(Object key, JDOModel jdoModel) throws JDOModelException {
        ClassLoader classLoader = (ClassLoader)key;
        jdoModel.setJavaModel(new RuntimeJavaModel(classLoader));
        if (classLoader != ClassLoader.getSystemClassLoader()) {
            try {
                ClassLoader parentClassLoader = classLoader.getParent();
                if (parentClassLoader != null) {
                    jdoModel.setParent(this.getJDOModel(parentClassLoader));
                }
            }
            catch (SecurityException ex) {
                jdoModel.setParent(null);
            }
        }
        super.updateCache(key, jdoModel);
    }

    static {
        msg = I18NHelper.getInstance((String)"com.sap.jdo.common.model.jdo.Bundle");
    }
}

