/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.common.model.jdo;

import com.sap.jdo.common.model.jdo.JDOArrayImpl;
import com.sap.jdo.common.model.jdo.JDOClassImpl;
import com.sap.jdo.common.model.jdo.JDOCollectionImpl;
import com.sap.jdo.common.model.jdo.JDOMapImpl;
import com.sap.jdo.common.model.jdo.JDOMemberImpl;
import com.sap.jdo.common.model.jdo.JDOReferenceImpl;
import com.sap.jdo.common.model.jdo.JDORelationshipImpl;
import com.sap.jdo.common.model.jdo.util.TypeSupport;
import com.sap.jdo.model.jdo.JDOArray;
import com.sap.jdo.model.jdo.JDOCollection;
import com.sap.jdo.model.jdo.JDOField;
import com.sap.jdo.model.jdo.JDOMap;
import com.sap.jdo.model.jdo.JDOModel;
import com.sap.jdo.model.jdo.JDOModelException;
import com.sap.jdo.model.jdo.JDOReference;
import com.sap.jdo.model.jdo.JDORelationship;
import com.sap.jdo.model.jdo.JavaModel;
import java.lang.reflect.Modifier;
import javax.jdo.I18NHelper;

public class JDOFieldImpl
extends JDOMemberImpl
implements JDOField {
    private int persistenceModifier = 0;
    private boolean primaryKey = false;
    private int nullValueTreatment = 0;
    private Boolean defaultFetchGroup;
    private Boolean embedded;
    private transient Object type;
    private String typeName;
    private transient Object javaField;
    private boolean serializable = false;
    private Integer javaModifier;
    private JDORelationship relationship;
    private int relativeFieldNumber = -1;
    private boolean checkedRelationship = false;
    private static final I18NHelper msg = I18NHelper.getInstance((String)"com.sap.jdo.common.model.jdo.Bundle");

    public int getPersistenceModifier() {
        if (this.persistenceModifier == 0 && this.type != null) {
            this.persistenceModifier = TypeSupport.isPersistenceFieldType(this.getDeclaringClass().getDeclaringModel(), this.type) ? 8 : 1;
        }
        return this.persistenceModifier;
    }

    public void setPersistenceModifier(int persistenceModifier) {
        this.persistenceModifier = persistenceModifier;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    public int getNullValueTreatment() {
        return this.nullValueTreatment;
    }

    public void setNullValueTreatment(int nullValueTreatment) {
        this.nullValueTreatment = nullValueTreatment;
    }

    public boolean isDefaultFetchGroup() {
        if (this.defaultFetchGroup == null) {
            if (this.isPrimaryKey()) {
                this.defaultFetchGroup = Boolean.FALSE;
            } else if (this.type != null) {
                this.defaultFetchGroup = TypeSupport.isValueType(this.getDeclaringClass().getDeclaringModel(), this.type) ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return this.defaultFetchGroup == null ? false : this.defaultFetchGroup;
    }

    public void setDefaultFetchGroup(boolean defaultFetchGroup) {
        this.defaultFetchGroup = defaultFetchGroup ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isEmbedded() {
        if (this.embedded == null && this.type != null) {
            this.embedded = TypeSupport.isEmbeddedFieldType(this.getDeclaringClass().getDeclaringModel(), this.type) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.embedded == null ? false : this.embedded;
    }

    public void setEmbedded(boolean embedded) {
        this.embedded = embedded ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object getType() {
        return this.type;
    }

    public void setType(Object type) {
        if (type != null) {
            JDOModel declaringModel = this.getDeclaringClass().getDeclaringModel();
            JavaModel javaModel = declaringModel.getJavaModel();
            if (javaModel != null) {
                this.setTypeName(javaModel.getTypeName(type));
            }
            if (this.relationship == null) {
                this.checkedRelationship = false;
            }
        }
        this.type = type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public Object getJavaField() {
        return this.javaField;
    }

    public void setJavaField(Object javaField) {
        this.javaField = javaField;
    }

    public boolean isSerializable() {
        return this.serializable;
    }

    public void setSerializable(boolean serializable) throws JDOModelException {
        this.serializable = serializable;
    }

    public int getJavaModifier() {
        return this.javaModifier == null ? 0 : this.javaModifier;
    }

    public void setJavaModifier(int javaModifier) {
        this.javaModifier = new Integer(javaModifier);
    }

    public JDORelationship getRelationship() {
        if (!this.checkedRelationship) {
            if (this.relationship == null && this.type != null) {
                JDOModel declaringModel = this.getDeclaringClass().getDeclaringModel();
                if (this.getPersistenceModifier() != 1 && !TypeSupport.isValueType(declaringModel, this.type) && !TypeSupport.isValueArrayType(declaringModel, this.type)) {
                    if (TypeSupport.isCollectionType(declaringModel, this.type)) {
                        this.createJDOCollectionInternal();
                    } else if (TypeSupport.isMapType(declaringModel, this.type)) {
                        this.createJDOMapInternal();
                    } else if (TypeSupport.isArrayType(declaringModel, this.type)) {
                        this.createJDOArrayInternal();
                    } else {
                        this.createJDOReferenceInternal();
                    }
                }
            }
            this.checkedRelationship = true;
            if (this.relationship != null) {
                ((JDORelationshipImpl)this.relationship).checkRelationship();
            }
        }
        return this.relationship;
    }

    public void setRelationship(JDORelationship relationship) {
        this.relationship = relationship;
        this.checkedRelationship = false;
    }

    public JDOReference createJDOReference() throws JDOModelException {
        if (this.relationship != null) {
            throw new JDOModelException(msg.msg("EXC_RelationshipAlreadyDefined", (Object)this.getName(), (Object)this.relationship));
        }
        return this.createJDOReferenceInternal();
    }

    public JDOCollection createJDOCollection() throws JDOModelException {
        if (this.relationship != null) {
            throw new JDOModelException(msg.msg("EXC_RelationshipAlreadyDefined", (Object)this.getName(), (Object)this.relationship));
        }
        return this.createJDOCollectionInternal();
    }

    public JDOArray createJDOArray() throws JDOModelException {
        if (this.relationship != null) {
            throw new JDOModelException(msg.msg("EXC_RelationshipAlreadyDefined", (Object)this.getName(), (Object)this.relationship));
        }
        return this.createJDOArrayInternal();
    }

    public JDOMap createJDOMap() throws JDOModelException {
        if (this.relationship != null) {
            throw new JDOModelException(msg.msg("EXC_RelationshipAlreadyDefined", (Object)this.getName(), (Object)this.relationship));
        }
        return this.createJDOMapInternal();
    }

    public boolean isPersistent() {
        switch (this.getPersistenceModifier()) {
            case 4: {
                return true;
            }
            case 8: {
                int mod = this.getJavaModifier();
                return !Modifier.isStatic(mod) && !Modifier.isFinal(mod) && !Modifier.isTransient(mod);
            }
        }
        return false;
    }

    public boolean isTransactional() {
        return this.getPersistenceModifier() == 2;
    }

    public boolean isManaged() {
        int persistenceModifier = this.getPersistenceModifier();
        return persistenceModifier == 4 || persistenceModifier == 8 || persistenceModifier == 2;
    }

    public boolean isRelationship() {
        return this.getRelationship() != null;
    }

    public int getFieldNumber() {
        int fieldNumber = this.getRelativeFieldNumber();
        if (fieldNumber > -1) {
            fieldNumber += this.getDeclaringClass().getInheritedManagedFieldCount();
        }
        return fieldNumber;
    }

    public int getRelativeFieldNumber() {
        ((JDOClassImpl)this.getDeclaringClass()).sortDeclaredManagedFields();
        return this.relativeFieldNumber;
    }

    protected void setRelativeFieldNumber(int number) {
        this.relativeFieldNumber = number;
    }

    public JDOReferenceImpl createJDOReferenceInternal() {
        JDOReferenceImpl ref = new JDOReferenceImpl();
        this.setRelationship(ref);
        ref.setDeclaringField(this);
        return ref;
    }

    public JDOCollectionImpl createJDOCollectionInternal() {
        JDOCollectionImpl collection = new JDOCollectionImpl();
        this.setRelationship(collection);
        collection.setDeclaringField(this);
        return collection;
    }

    public JDOArrayImpl createJDOArrayInternal() {
        JDOArrayImpl array = new JDOArrayImpl();
        this.setRelationship(array);
        array.setDeclaringField(this);
        return array;
    }

    public JDOMapImpl createJDOMapInternal() {
        JDOMapImpl map = new JDOMapImpl();
        this.setRelationship(map);
        map.setDeclaringField(this);
        return map;
    }
}

