/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.common;

import com.sap.jdo.ClassDescriptor;
import com.sap.jdo.EJBImplHelper;
import com.sap.jdo.PersistenceManagerFactoryInternal;
import com.sap.jdo.StoreManager;
import com.sap.jdo.TranscriberFactory;
import com.sap.jdo.common.Accessor;
import com.sap.jdo.common.JDORIVersion;
import com.sap.jdo.common.PersistenceManagerImpl;
import com.sap.jdo.common.PersistenceManagerWrapper;
import com.sap.jdo.common.TransactionImpl;
import com.sap.jdo.common.descriptor.ClassDescriptorImpl;
import com.sap.jdo.common.model.jdo.RuntimeJDOModelFactoryImpl;
import com.sap.jdo.common.query.tree.Tree;
import com.sap.jdo.model.jdo.JDOClass;
import com.sap.jdo.model.jdo.JDOModel;
import com.sap.jdo.model.jdo.JDOModelException;
import com.sap.jdo.query.QueryTree;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jdo.I18NHelper;
import javax.jdo.JDOException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.transaction.Transaction;

public abstract class PersistenceManagerFactoryImpl
implements PersistenceManagerFactoryInternal {
    private String URL = null;
    private String userName = null;
    protected String password = null;
    private String driverName = null;
    private Object connectionFactory = null;
    private String connectionFactoryName = null;
    private Object connectionFactory2 = null;
    private String connectionFactory2Name = null;
    private boolean multithreaded = false;
    private boolean optimistic = true;
    private boolean retainValues = true;
    private boolean restoreValues = true;
    private boolean nontransactionalRead = true;
    private boolean nontransactionalWrite = false;
    private boolean ignoreCache = true;
    private int queryTimeout = 0;
    private int updateTimeout = 0;
    private int minPool = 1;
    private int maxPool = 1;
    private int msWait = 0;
    protected boolean configurable = true;
    private static final int PERSIST_CF = 1;
    private static final int PERSIST_CF_NAME = 2;
    private static final int PERSIST_PROPS = 3;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$jdo$common$PersistenceManagerFactoryImpl == null ? (class$com$sap$jdo$common$PersistenceManagerFactoryImpl = PersistenceManagerFactoryImpl.class$("com.sap.jdo.common.PersistenceManagerFactoryImpl")) : class$com$sap$jdo$common$PersistenceManagerFactoryImpl));
    private static final String commonBundle = "com.sap.jdo.common.Bundle";
    private static final I18NHelper msg = I18NHelper.getInstance((String)"com.sap.jdo.common.Bundle");
    private Hashtable pmCash = new Hashtable();
    private Hashtable classDescriptors = new Hashtable();
    protected static HashMap pmfAccessors = new HashMap(4);
    protected static HashMap propsAccessors = new HashMap(10);
    static /* synthetic */ Class class$com$sap$jdo$common$PersistenceManagerFactoryImpl;

    public PersistenceManagerFactoryImpl() {
    }

    public PersistenceManagerFactoryImpl(String URL2, String userName, String password, String driverName) {
        this.URL = URL2;
        this.userName = userName;
        this.password = password;
        this.driverName = driverName;
    }

    public void setConnectionUserName(String userName) {
        this.assertConfigurable();
        this.userName = userName;
    }

    public String getConnectionUserName() {
        return this.userName;
    }

    public void setConnectionPassword(String password) {
        this.assertConfigurable();
        this.password = password;
    }

    protected String getConnectionPassword() {
        return this.password;
    }

    public void setConnectionURL(String URL2) {
        this.assertConfigurable();
        this.URL = URL2;
    }

    public String getConnectionURL() {
        return this.URL;
    }

    public void setConnectionDriverName(String driverName) {
        this.assertConfigurable();
        this.driverName = driverName;
    }

    public String getConnectionDriverName() {
        return this.driverName;
    }

    public void setConnectionFactoryName(String connectionFactoryName) {
        this.assertConfigurable();
        this.connectionFactoryName = connectionFactoryName;
    }

    public String getConnectionFactoryName() {
        return this.connectionFactoryName;
    }

    public void setConnectionFactory(Object connectionFactory) {
        this.assertConfigurable();
        this.connectionFactory = connectionFactory;
    }

    public Object getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory2Name(String cfn2) {
        this.assertConfigurable();
        this.connectionFactory2Name = cfn2;
    }

    public String getConnectionFactory2Name() {
        return this.connectionFactory2Name;
    }

    public void setConnectionFactory2(Object _connectionFactory) {
        this.assertConfigurable();
        this.connectionFactory2 = _connectionFactory;
    }

    public Object getConnectionFactory2() {
        return this.connectionFactory2;
    }

    public void setMultithreaded(boolean flag) {
        this.assertConfigurable();
        this.multithreaded = flag;
    }

    public boolean getMultithreaded() {
        return this.multithreaded;
    }

    public void setOptimistic(boolean flag) {
        this.assertConfigurable();
        this.optimistic = flag;
    }

    public boolean getOptimistic() {
        return this.optimistic;
    }

    public void setRetainValues(boolean flag) {
        this.assertConfigurable();
        this.retainValues = flag;
    }

    public boolean getRetainValues() {
        return this.retainValues;
    }

    public void setRestoreValues(boolean flag) {
        this.assertConfigurable();
        this.restoreValues = flag;
    }

    public boolean getRestoreValues() {
        return this.restoreValues;
    }

    public void setNontransactionalRead(boolean flag) {
        this.assertConfigurable();
        this.nontransactionalRead = flag;
    }

    public boolean getNontransactionalRead() {
        return this.nontransactionalRead;
    }

    public void setNontransactionalWrite(boolean flag) {
        this.assertConfigurable();
        this.nontransactionalWrite = flag;
    }

    public boolean getNontransactionalWrite() {
        return this.nontransactionalWrite;
    }

    public void setIgnoreCache(boolean flag) {
        this.assertConfigurable();
        this.ignoreCache = flag;
    }

    public boolean getIgnoreCache() {
        return this.ignoreCache;
    }

    public void setMsWait(int msWait) {
        this.assertConfigurable();
        this.msWait = msWait;
    }

    public int getMsWait() {
        return this.msWait;
    }

    public void setMinPool(int minPool) {
        this.assertConfigurable();
        this.minPool = minPool;
    }

    public int getMinPool() {
        return this.minPool;
    }

    public void setMaxPool(int maxPool) {
        this.assertConfigurable();
        this.maxPool = maxPool;
    }

    public int getMaxPool() {
        return this.maxPool;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.assertConfigurable();
        this.queryTimeout = queryTimeout;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setUpdateTimeout(int updateTimeout) {
        this.assertConfigurable();
        this.updateTimeout = updateTimeout;
    }

    public int getUpdateTimeout() {
        return this.updateTimeout;
    }

    public Properties getProperties() {
        return JDORIVersion.getVendorProperties();
    }

    public Collection supportedOptions() {
        return Collections.unmodifiableList(Arrays.asList(this.getOptionArray()));
    }

    protected abstract String[] getOptionArray();

    protected abstract PersistenceManager createPersistenceManager(String var1, String var2);

    public PersistenceManager getPersistenceManager() {
        return this.getPersistenceManager(null, null);
    }

    public PersistenceManager getPersistenceManager(String userid, String password) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("getPersistenceManager");
        }
        if (this.configurable) {
            this.verifyConfiguration();
        }
        boolean wasConfigurable = this.configurable;
        this.setConfigured();
        try {
            return this.getPersistenceManagerInternal(userid, password);
        }
        catch (JDOException e) {
            if (wasConfigurable) {
                this.setNonconfigured();
            }
            throw e;
        }
    }

    private PersistenceManager getPersistenceManagerInternal(String userid, String password) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("getPersistenceManagerInternal");
        }
        PersistenceManagerImpl pm = null;
        Transaction t = null;
        if (t != null) {
            pm = this.getFromPool(userid, password);
            javax.jdo.Transaction tx = pm.currentTransaction();
            if (!tx.isActive()) {
                ((TransactionImpl)tx).begin(t);
            }
            if (!pm.verify(userid, password)) {
                throw new JDOUserException(msg.msg("EXC_WrongUsernamePassword"));
            }
        } else {
            pm = this.getFromPool(userid, password);
        }
        if (!EJBImplHelper.isManaged()) {
            return new PersistenceManagerWrapper(pm);
        }
        return pm;
    }

    protected void registerPersistenceManager(PersistenceManagerImpl pm, Object t) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("registerPersistenceManager");
        }
    }

    protected void releasePersistenceManager(PersistenceManagerImpl pm, Object t) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("releasePersistenceManager");
        }
        this.releaseStoreManager(pm);
        this.returnToPool(pm);
    }

    private synchronized PersistenceManagerImpl getFromPool(String userid, String password) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("getFromPool");
        }
        return (PersistenceManagerImpl)this.createPersistenceManager(userid, password);
    }

    private void returnToPool(PersistenceManagerImpl pm) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("returnToPool");
        }
    }

    protected void assertConfigurable() {
        if (!this.configurable) {
            throw new JDOUserException(msg.msg("EXC_NotConfigurable"));
        }
    }

    private int getSerializedForm() {
        int rc = 0;
        rc = null != this.connectionFactory ? 1 : (null != this.connectionFactoryName ? 2 : 3);
        return rc;
    }

    private int getSerializedForm(Properties props) {
        int rc = 0;
        rc = null == ((Hashtable)props).get("javax.jdo.option.ConnectionURL") ? 1 : (null != ((Hashtable)props).get("javax.jdo.option.ConnectionFactoryName") ? 2 : 3);
        return rc;
    }

    protected void doWriteObject(ObjectOutputStream oos) throws IOException {
        this.writeObject(oos);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        int kind = this.getSerializedForm();
        oos.writeInt(kind);
        switch (kind) {
            case 1: {
                oos.writeObject(this.connectionFactory);
                break;
            }
            case 2: {
                oos.writeUTF(this.connectionFactoryName);
                oos.writeUTF(this.connectionFactory2Name);
                break;
            }
            case 3: {
                oos.writeObject(this.URL);
                oos.writeObject(this.userName);
                oos.writeObject(this.encrypt(this.password));
                oos.writeObject(this.driverName);
            }
        }
        oos.writeBoolean(this.multithreaded);
        oos.writeBoolean(this.optimistic);
        oos.writeBoolean(this.retainValues);
        oos.writeBoolean(this.restoreValues);
        oos.writeBoolean(this.nontransactionalRead);
        oos.writeBoolean(this.nontransactionalWrite);
        oos.writeBoolean(this.ignoreCache);
        oos.writeInt(this.queryTimeout);
        oos.writeInt(this.updateTimeout);
    }

    protected void doReadObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.readObject(ois);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        if (LOCATION.bePath()) {
            LOCATION.pathT("readObject");
        }
        if (this.pmCash == null) {
            this.pmCash = new Hashtable();
        }
        int kind = ois.readInt();
        switch (kind) {
            case 1: {
                this.connectionFactory = ois.readObject();
                break;
            }
            case 2: {
                this.connectionFactoryName = ois.readUTF();
                this.connectionFactory2Name = ois.readUTF();
                break;
            }
            case 3: {
                this.URL = (String)ois.readObject();
                this.userName = (String)ois.readObject();
                this.password = this.decrypt((String)ois.readObject());
                this.driverName = (String)ois.readObject();
            }
        }
        this.multithreaded = ois.readBoolean();
        this.optimistic = ois.readBoolean();
        this.retainValues = ois.readBoolean();
        this.restoreValues = ois.readBoolean();
        this.nontransactionalRead = ois.readBoolean();
        this.nontransactionalWrite = ois.readBoolean();
        this.ignoreCache = ois.readBoolean();
        this.queryTimeout = ois.readInt();
        this.updateTimeout = ois.readInt();
    }

    protected HashMap getLocalAccessors() {
        return new HashMap();
    }

    public static void initPropsAccessors() {
        if (pmfAccessors.size() != 0) {
            return;
        }
        HashMap hashMap = pmfAccessors;
        synchronized (hashMap) {
            if (pmfAccessors.size() != 0) {
                return;
            }
            pmfAccessors.put("javax.jdo.option.ConnectionURL", new PMFAccessor(){

                public String get(PersistenceManagerFactoryImpl pmf) {
                    return pmf.getConnectionURL();
                }

                public String getNonDefault(PersistenceManagerFactoryImpl pmf) {
                    return pmf.getConnectionURL();
                }

                public String getDefault() {
                    return null;
                }

                public void set(PersistenceManagerFactoryImpl pmf, String s) {
                    pmf.setConnectionURL(s);
                }
            });
            pmfAccessors.put("javax.jdo.option.ConnectionUserName", new PMFAccessor(){

                public String get(PersistenceManagerFactoryImpl pmf) {
                    return pmf.getConnectionUserName();
                }

                public String getNonDefault(PersistenceManagerFactoryImpl pmf) {
                    return pmf.getConnectionUserName();
                }

                public String getDefault() {
                    return null;
                }

                public void set(PersistenceManagerFactoryImpl pmf, String s) {
                    pmf.setConnectionUserName(s);
                }
            });
            pmfAccessors.put("javax.jdo.option.ConnectionPassword", new PMFAccessor(){

                public String get(PersistenceManagerFactoryImpl pmf) {
                    return pmf.encrypt(pmf.getConnectionPassword());
                }

                public String getNonDefault(PersistenceManagerFactoryImpl pmf) {
                    return pmf.encrypt(pmf.getConnectionPassword());
                }

                public String getDefault() {
                    return null;
                }

                public void set(PersistenceManagerFactoryImpl pmf, String s) {
                    pmf.setConnectionPassword(pmf.decrypt(s));
                }
            });
            pmfAccessors.put("javax.jdo.option.ConnectionDriverName", new PMFAccessor(){

                public String get(PersistenceManagerFactoryImpl pmf) {
                    return pmf.getConnectionDriverName();
                }

                public String getNonDefault(PersistenceManagerFactoryImpl pmf) {
                    return pmf.getConnectionDriverName();
                }

                public String getDefault() {
                    return null;
                }

                public void set(PersistenceManagerFactoryImpl pmf, String s) {
                    pmf.setConnectionDriverName(s);
                }
            });
            propsAccessors.put("javax.jdo.option.Multithreaded", new PMFAccessor(){

                public String get(PersistenceManagerFactoryImpl pmf) {
                    return new Boolean(pmf.getMultithreaded()).toString();
                }

                public String getNonDefault(PersistenceManagerFactoryImpl pmf) {
                    return !pmf.getMultithreaded() ? null : "true";
                }

                public String getDefault() {
                    return "false";
                }

                public void set(PersistenceManagerFactoryImpl pmf, String s) {
                    pmf.setMultithreaded(Boolean.valueOf(s));
                }
            });
            propsAccessors.put("javax.jdo.option.Optimistic", new PMFAccessor(){

                public String get(PersistenceManagerFactoryImpl pmf) {
                    return new Boolean(pmf.getOptimistic()).toString();
                }

                public String getNonDefault(PersistenceManagerFactoryImpl pmf) {
                    return pmf.getOptimistic() ? null : "false";
                }

                public String getDefault() {
                    return "true";
                }

                public void set(PersistenceManagerFactoryImpl pmf, String s) {
                    pmf.setOptimistic(Boolean.valueOf(s));
                }
            });
            propsAccessors.put("javax.jdo.option.RetainValues", new PMFAccessor(){

                public String get(PersistenceManagerFactoryImpl pmf) {
                    return new Boolean(pmf.getRetainValues()).toString();
                }

                public String getNonDefault(PersistenceManagerFactoryImpl pmf) {
                    return pmf.getRetainValues() ? null : "false";
                }

                public String getDefault() {
                    return "true";
                }

                public void set(PersistenceManagerFactoryImpl pmf, String s) {
                    pmf.setRetainValues(Boolean.valueOf(s));
                }
            });
            propsAccessors.put("javax.jdo.option.RestoreValues", new PMFAccessor(){

                public String get(PersistenceManagerFactoryImpl pmf) {
                    return new Boolean(pmf.getRestoreValues()).toString();
                }

                public String getNonDefault(PersistenceManagerFactoryImpl pmf) {
                    return pmf.getRestoreValues() ? null : "false";
                }

                public String getDefault() {
                    return "true";
                }

                public void set(PersistenceManagerFactoryImpl pmf, String s) {
                    pmf.setRestoreValues(Boolean.valueOf(s));
                }
            });
            propsAccessors.put("javax.jdo.option.NontransactionalRead", new PMFAccessor(){

                public String get(PersistenceManagerFactoryImpl pmf) {
                    return new Boolean(pmf.getNontransactionalRead()).toString();
                }

                public String getNonDefault(PersistenceManagerFactoryImpl pmf) {
                    return pmf.getNontransactionalRead() ? null : "false";
                }

                public String getDefault() {
                    return "true";
                }

                public void set(PersistenceManagerFactoryImpl pmf, String s) {
                    pmf.setNontransactionalRead(Boolean.valueOf(s));
                }
            });
            propsAccessors.put("javax.jdo.option.NontransactionalWrite", new PMFAccessor(){

                public String get(PersistenceManagerFactoryImpl pmf) {
                    return new Boolean(pmf.getNontransactionalWrite()).toString();
                }

                public String getNonDefault(PersistenceManagerFactoryImpl pmf) {
                    return !pmf.getNontransactionalWrite() ? null : "true";
                }

                public String getDefault() {
                    return "false";
                }

                public void set(PersistenceManagerFactoryImpl pmf, String s) {
                    pmf.setNontransactionalWrite(Boolean.valueOf(s));
                }
            });
            propsAccessors.put("javax.jdo.option.IgnoreCache", new PMFAccessor(){

                public String get(PersistenceManagerFactoryImpl pmf) {
                    return new Boolean(pmf.getIgnoreCache()).toString();
                }

                public String getNonDefault(PersistenceManagerFactoryImpl pmf) {
                    return pmf.getIgnoreCache() ? null : "false";
                }

                public String getDefault() {
                    return "true";
                }

                public void set(PersistenceManagerFactoryImpl pmf, String s) {
                    pmf.setIgnoreCache(Boolean.valueOf(s));
                }
            });
            propsAccessors.put("javax.jdo.option.ConnectionFactoryName", new PMFAccessor(){

                public String get(PersistenceManagerFactoryImpl pmf) {
                    return pmf.getConnectionFactoryName();
                }

                public String getNonDefault(PersistenceManagerFactoryImpl pmf) {
                    return pmf.getConnectionFactoryName() == null ? null : pmf.getConnectionFactoryName();
                }

                public String getDefault() {
                    return null;
                }

                public void set(PersistenceManagerFactoryImpl pmf, String s) {
                    pmf.setConnectionFactoryName(s);
                }
            });
            propsAccessors.put("javax.jdo.option.ConnectionFactory2Name", new PMFAccessor(){

                public String get(PersistenceManagerFactoryImpl pmf) {
                    return pmf.getConnectionFactory2Name();
                }

                public String getNonDefault(PersistenceManagerFactoryImpl pmf) {
                    return pmf.getConnectionFactory2Name() == null ? null : pmf.getConnectionFactory2Name();
                }

                public String getDefault() {
                    return null;
                }

                public void set(PersistenceManagerFactoryImpl pmf, String s) {
                    pmf.setConnectionFactory2Name(s);
                }
            });
        }
    }

    protected static int toInt(String s) {
        int rc = 0;
        try {
            rc = Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            throw new JDOFatalInternalException(msg.msg("EXC_IntegerInInvalidFormat"));
        }
        return rc;
    }

    public Properties getAsProperties() {
        this.assertConfigurable();
        return this.getAsPropertiesInternal();
    }

    protected Properties getAsPropertiesInternal() {
        PersistenceManagerFactoryImpl.initPropsAccessors();
        Properties p = new Properties();
        int kind = this.getSerializedForm();
        switch (kind) {
            case 1: {
                this.setCFProperties(p);
                break;
            }
            case 2: {
                p.setProperty("javax.jdo.option.ConnectionFactoryName", this.connectionFactoryName);
                if (this.connectionFactory2Name == null) break;
                p.setProperty("javax.jdo.option.ConnectionFactory2Name", this.connectionFactory2Name);
                break;
            }
            case 3: {
                this.setProps(p, pmfAccessors);
            }
        }
        this.setProps(p, propsAccessors);
        this.setPMFClassProperty(p);
        this.setProps(p, this.getLocalAccessors());
        return p;
    }

    protected abstract void setPMFClassProperty(Properties var1);

    void setProps(Properties p, HashMap accessors) {
        Set s = accessors.entrySet();
        Iterator i = s.iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            String key = (String)e.getKey();
            PMFAccessor a = (PMFAccessor)e.getValue();
            String value = a.getNonDefault(this);
            if (null == value) continue;
            p.setProperty(key, value);
        }
    }

    public void setFromProperties(Properties p) {
        PersistenceManagerFactoryImpl.initPropsAccessors();
        this.assertConfigurable();
        int kind = this.getSerializedForm(p);
        switch (kind) {
            case 1: {
                this.getCFFromProperties(p);
                break;
            }
            case 2: {
                this.connectionFactoryName = p.getProperty("javax.jdo.option.ConnectionFactoryName");
                this.connectionFactory2Name = p.getProperty("javax.jdo.option.ConnectionFactory2Name");
                break;
            }
            case 3: {
                this.getProps(p, pmfAccessors);
            }
        }
        this.getProps(p, propsAccessors);
        this.getProps(p, this.getLocalAccessors());
    }

    private void getProps(Properties p, HashMap accessors) {
        Set s = accessors.entrySet();
        Iterator i = s.iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            String key = (String)e.getKey();
            String value = p.getProperty(key);
            if (null == value) continue;
            PMFAccessor a = (PMFAccessor)e.getValue();
            a.set(this, value);
        }
    }

    protected abstract String encrypt(String var1);

    protected abstract String decrypt(String var1);

    protected abstract void setCFProperties(Properties var1);

    protected abstract void getCFFromProperties(Properties var1);

    protected abstract boolean isConnectionFactoryConfigured();

    public String toString() {
        return "URL: " + this.URL + "\n" + "userName: " + this.userName + "\n" + "password: " + this.password + "\n" + "driverName: " + this.driverName + "\n" + "connectionFactory: " + this.connectionFactory + "\n" + "connectionFactoryName: " + this.connectionFactoryName + "\n" + "connectionFactory2: " + this.connectionFactory2 + "\n" + "connectionFactory2Name: " + this.connectionFactory2Name + "\n" + "multithreaded: " + this.multithreaded + "\n" + "optimistic: " + this.optimistic + "\n" + "retainValues: " + this.retainValues + "\n" + "restoreValues: " + this.restoreValues + "\n" + "nontransactionalRead: " + this.nontransactionalRead + "\n" + "nontransactionalWrite: " + this.nontransactionalWrite + "\n" + "ignoreCache: " + this.ignoreCache + "\n" + "queryTimeout: " + this.queryTimeout + "\n" + "updateTimeout: " + this.updateTimeout + "\n";
    }

    protected void verifyConfiguration() {
        if (!this.isConnectionFactoryConfigured() && this.connectionFactoryName == null && this.URL == null) {
            throw new JDOFatalUserException(msg.msg("EXC_IncompleteConfiguration"));
        }
    }

    protected void setConfigured() {
        this.configurable = false;
    }

    protected void setNonconfigured() {
        this.configurable = true;
    }

    public static void filterProperties(Properties props, Properties filtered, Map accessors) {
        Set s = accessors.entrySet();
        Iterator i = s.iterator();
        while (i.hasNext()) {
            Accessor a;
            Map.Entry e = i.next();
            String key = (String)e.getKey();
            String value = props.getProperty(key);
            if (null == value || (a = (Accessor)e.getValue()).getDefault() == value) continue;
            filtered.setProperty(key, value);
        }
    }

    public QueryTree newQueryTree() {
        return new Tree();
    }

    public ClassDescriptor getClassDescriptor(Class type) {
        ClassDescriptor classDesc = (ClassDescriptor)this.classDescriptors.get(type);
        if (classDesc == null) {
            try {
                classDesc = this.createClassDescriptor(type);
            }
            catch (JDOModelException e) {
                throw new JDOFatalInternalException("Internal ERROR: Unable to create class description of " + type.getName() + ".", (Throwable)e);
            }
        }
        return classDesc;
    }

    protected ClassDescriptor createClassDescriptor(Class type) throws JDOModelException {
        ClassLoader cl = type.getClassLoader();
        if (cl == null) {
            return null;
        }
        JDOModel jdoModel = RuntimeJDOModelFactoryImpl.getInstance().getJDOModel(cl);
        JDOClass jdoClass = jdoModel.getJDOClass(type.getName());
        if (jdoClass == null) {
            return null;
        }
        ClassDescriptorImpl classDesc = new ClassDescriptorImpl(type.getName(), type, jdoClass, (PersistenceManagerFactoryInternal)this);
        this.classDescriptors.put(type, classDesc);
        return classDesc;
    }

    public synchronized boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PersistenceManagerFactoryImpl)) {
            return false;
        }
        return ((Hashtable)this.getAsPropertiesInternal()).equals(((PersistenceManagerFactoryImpl)o).getAsPropertiesInternal());
    }

    public synchronized int hashCode() {
        return ((Hashtable)this.getAsPropertiesInternal()).hashCode();
    }

    public abstract Class getTrackedClass(Class var1);

    public abstract void releaseStoreManager(PersistenceManager var1);

    public abstract StoreManager getStoreManager(PersistenceManager var1);

    public abstract Class getObjectIdClass(Class var1);

    public abstract TranscriberFactory getTranscriberFactory();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface PMFAccessor
    extends Accessor {
        public String get(PersistenceManagerFactoryImpl var1);

        public String getNonDefault(PersistenceManagerFactoryImpl var1);

        public void set(PersistenceManagerFactoryImpl var1, String var2);
    }
}

