/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo.common;

import com.sap.jdo.PersistenceManagerInternal;
import com.sap.jdo.StateManagerInternal;
import com.sap.jdo.StoreManager;
import com.sap.jdo.common.PersistenceManagerImpl;
import com.sap.jdo.common.state.StateManagerFactory;
import com.sap.tc.logging.Location;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.jdo.I18NHelper;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOUserException;
import javax.jdo.spi.PersistenceCapable;

class CacheManagerImpl {
    PersistenceManagerImpl pm = null;
    private Collection _txCache = Collections.synchronizedSet(new HashSet());
    private Collection _transientCache = new Vector();
    private ArrayList _flushedCache = new ArrayList();
    private ArrayList _newInstances = new ArrayList();
    private WeakHashMap _weakCache = new WeakHashMap();
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$jdo$common$CacheManagerImpl == null ? (class$com$sap$jdo$common$CacheManagerImpl = CacheManagerImpl.class$("com.sap.jdo.common.CacheManagerImpl")) : class$com$sap$jdo$common$CacheManagerImpl));
    private static final String commonBundle = "com.sap.jdo.common.Bundle";
    private static final I18NHelper msg = I18NHelper.getInstance((String)"com.sap.jdo.common.Bundle");
    static /* synthetic */ Class class$com$sap$jdo$common$CacheManagerImpl;

    CacheManagerImpl(PersistenceManagerImpl pm) {
        this.pm = pm;
    }

    protected void close() {
        this._weakCache.clear();
        this._txCache.clear();
        this._flushedCache.clear();
        this._transientCache.clear();
    }

    protected Object getObjectById(Object oid, boolean validate) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("getObjectById");
        }
        StateManagerInternal sm = this.getStateManager(oid, validate);
        return sm.getObject();
    }

    protected StateManagerInternal getStateManager(Object oid, Class pcClass) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("getStatemanager " + oid + " for: " + pcClass.getName());
        }
        StateManagerInternal sm = null;
        sm = (StateManagerInternal)this._weakCache.get(oid);
        if (sm == null) {
            WeakHashMap weakHashMap = this._weakCache;
            synchronized (weakHashMap) {
                sm = (StateManagerInternal)this._weakCache.get(oid);
            }
        }
        if (sm == null) {
            sm = this.createNewSM(null, oid, pcClass);
        } else {
            sm.setPCClass(pcClass);
        }
        if (LOCATION.bePath()) {
            LOCATION.pathT("return from getStateManager: " + sm);
        }
        return sm;
    }

    protected Object getExternalObjectId(PersistenceCapable pc, boolean transactional) {
        StateManagerInternal sm = this.pm.findStateManager(pc);
        Object oid = null;
        if (((AbstractMap)this._weakCache).containsValue(sm)) {
            oid = transactional ? sm.getTransactionalObjectId(pc) : sm.getExternalObjectId();
        }
        return oid;
    }

    protected void makePersistent(PersistenceCapable pc) {
        StateManagerInternal sm = this.pm.findStateManager(pc);
        if (sm == null) {
            sm = StateManagerFactory.newInstance((PersistenceCapable)pc, (PersistenceManagerInternal)this.pm);
        }
        sm.makePersistent();
    }

    protected void makeTransactional(PersistenceCapable pc) {
        StateManagerInternal sm = this.pm.findStateManager(pc);
        if (sm == null) {
            sm = StateManagerFactory.newInstance((PersistenceCapable)pc, (PersistenceManagerInternal)this.pm);
        }
        sm.makeTransactional();
    }

    protected void makeNontransactional(PersistenceCapable pc) {
        StateManagerInternal sm = this.pm.findStateManager(pc);
        if (sm == null) {
            throw new JDOUserException(msg.msg("EXC_NonTransactional"));
        }
        sm.makeNontransactional();
    }

    protected void makeTransient(PersistenceCapable pc) {
        StateManagerInternal sm = this.pm.findStateManager(pc);
        if (sm != null) {
            sm.makeTransient();
        }
    }

    protected void evict(PersistenceCapable pc) {
        StateManagerInternal sm = this.pm.findStateManager(pc);
        if (sm != null) {
            sm.evictInstance();
        }
    }

    protected void evictAll() {
        StateManagerInternal sm = null;
        Iterator it = this._weakCache.entrySet().iterator();
        while (it.hasNext()) {
            sm = (StateManagerInternal)it.next().getValue();
            sm.evictInstance();
        }
    }

    protected void retrieve(PersistenceCapable pc) {
        StateManagerInternal sm = this.pm.findStateManager(pc);
        if (sm != null) {
            sm.retrieve();
        }
    }

    protected void refresh(PersistenceCapable pc) {
        StateManagerInternal sm = this.pm.findStateManager(pc);
        if (sm != null) {
            sm.refreshInstance();
        }
    }

    protected void refreshAllTransactional() {
        StateManagerInternal sm = null;
        Iterator it = this._txCache.iterator();
        while (it.hasNext()) {
            sm = (StateManagerInternal)it.next();
            sm.refreshInstance();
        }
    }

    protected void refreshAllNontransactional() {
        StateManagerInternal sm = null;
        Iterator it = this._weakCache.entrySet().iterator();
        while (it.hasNext()) {
            sm = (StateManagerInternal)it.next().getValue();
            sm.refreshInstance();
        }
    }

    protected void registerTransient(StateManagerInternal sm) {
        Iterator it = this._transientCache.iterator();
        while (it.hasNext()) {
            Object o = ((WeakReference)it.next()).get();
            if ((StateManagerInternal)o != sm) continue;
            return;
        }
        this._transientCache.add(new WeakReference<StateManagerInternal>(sm));
    }

    protected void register(StateManagerInternal sm, Object oid, boolean transactional, boolean throwDuplicateException) {
        if (oid == null) {
            oid = sm.getInternalObjectId();
        }
        if (!this._weakCache.containsKey(oid)) {
            this.deregisterTransient(sm);
            this._weakCache.put(oid, sm);
        } else if (throwDuplicateException) {
            throw new JDOUserException(msg.msg("EXC_ObjectExistsInCache"));
        }
        if (this.pm.currentTransaction().isActive() && transactional) {
            if (!this._flushedCache.contains(sm)) {
                this._flushedCache.add(sm);
            }
            if (!this._txCache.contains(sm)) {
                this._txCache.add(sm);
                if (sm.isNew()) {
                    this._newInstances.add(sm.getObject());
                }
            }
        }
        if (!transactional) {
            this._txCache.remove(sm);
            ((AbstractCollection)this._flushedCache).remove(sm);
        }
    }

    protected void deregisterTransient(Object sm) {
        Iterator it = this._transientCache.iterator();
        while (it.hasNext()) {
            WeakReference wr = (WeakReference)it.next();
            if ((StateManagerInternal)wr.get() != sm) continue;
            this._transientCache.remove(wr);
            break;
        }
    }

    protected void deregister(Object oid) {
        if (oid != null) {
            Object o = this._weakCache.remove(oid);
            if (this.pm.currentTransaction().isActive()) {
                this._txCache.remove(o);
                ((AbstractCollection)this._flushedCache).remove(o);
            }
        }
    }

    protected void replaceObjectId(Object oldId, Object newId) {
        if (LOCATION.bePath()) {
            LOCATION.pathT("replaceObjectId");
        }
        WeakHashMap weakHashMap = this._weakCache;
        synchronized (weakHashMap) {
            if (this._weakCache.containsKey(newId)) {
                throw new JDOFatalInternalException(msg.msg("EXC_ObjectIdExistsInCache", newId));
            }
            Object o = this._weakCache.remove(oldId);
            if (o == null) {
                throw new JDOFatalInternalException(msg.msg("EXC_ObjectIdNotExistsInCache", newId));
            }
            this._weakCache.put(newId, o);
        }
    }

    protected void markAsFlushed(StateManagerInternal sm) {
        this._txCache.remove(sm);
    }

    protected void flushInstances() {
        StateManagerInternal sm = null;
        Object[] e = this._txCache.toArray();
        boolean commit = this.pm.insideCommit();
        int i = 0;
        while (i < e.length) {
            sm = (StateManagerInternal)e[i];
            sm.handleReachability(commit);
            ++i;
        }
        StoreManager srm = this.pm.getStoreManager();
        Iterator it = this._txCache.iterator();
        srm.flush(it, this.pm);
        if (commit) {
            this._txCache.clear();
        }
    }

    protected void afterCompletion(boolean abort) {
        boolean retainValues = this.pm.currentTransaction().getRetainValues();
        boolean restoreValues = this.pm.currentTransaction().getRestoreValues();
        Iterator it = this._transientCache.iterator();
        while (it.hasNext()) {
            Object o = ((WeakReference)it.next()).get();
            if (o == null) {
                it.remove();
                continue;
            }
            this._flushedCache.add(o);
        }
        int len = this._flushedCache.size();
        int i = 0;
        while (i < len) {
            StateManagerInternal sm = (StateManagerInternal)this._flushedCache.get(i);
            sm.afterCompletion(abort, retainValues, restoreValues);
            ++i;
        }
        this._flushedCache.clear();
        this._newInstances.clear();
        this._txCache.clear();
    }

    protected Collection getInsertedInstances() {
        if (LOCATION.bePath()) {
            LOCATION.pathT("getInsertedInstances");
        }
        return this._newInstances;
    }

    private StateManagerInternal getStateManager(Object oid, boolean validate) {
        Object o = null;
        StoreManager srm = this.pm.getStoreManager();
        Class candidateClassType = srm.getPCClassForOid(oid, this.pm);
        if (candidateClassType == null) {
            throw new JDOUserException(msg.msg("EXC_NotOID"), oid);
        }
        Object internalOid = srm.getInternalObjectId(oid, this.pm);
        if (LOCATION.beDebug()) {
            LOCATION.debugT("getStateManager internal oid: " + internalOid);
        }
        StateManagerInternal sm = null;
        Object v = this._weakCache.get(internalOid);
        o = v;
        if (v == null) {
            WeakHashMap weakHashMap = this._weakCache;
            synchronized (weakHashMap) {
                Object v2 = this._weakCache.get(internalOid);
                o = v2;
                if (v2 == null) {
                    if (LOCATION.beDebug()) {
                        LOCATION.debugT("getStateManager oid not found.");
                    }
                    sm = this.createNewSM(oid, internalOid, candidateClassType);
                    sm.reload();
                    StateManagerInternal stateManagerInternal = sm;
                    return stateManagerInternal;
                }
                if (validate && !this._flushedCache.contains(o)) {
                    if (LOCATION.beDebug()) {
                        LOCATION.debugT("getStateManager oid found - reload.");
                    }
                    sm = o;
                    sm.reload();
                    StateManagerInternal stateManagerInternal = sm;
                    return stateManagerInternal;
                }
            }
        } else if (validate && !this._flushedCache.contains(o)) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("getStateManager oid found - reload.");
            }
            sm = o;
            sm.reload();
            return sm;
        }
        return o;
    }

    private StateManagerInternal createNewSM(Object UserOid, Object internalOid, Class candidateClassType) {
        try {
            return StateManagerFactory.newInstance((Object)UserOid, (Object)internalOid, (PersistenceManagerInternal)this.pm, (Class)candidateClassType);
        }
        catch (JDOUserException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JDOUserException(msg.msg("EXC_NotOID"), (Throwable)e, UserOid);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

