/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.workspaceMonitor;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.DAVTeamProvider;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItemListener;
import com.tssap.dtr.client.lib.vfs.IVfsGenericFolder;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsVersionListener;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

class WorkspaceUpdater
implements IVfsFolderItemListener,
IVfsVersionListener {
    private boolean _refreshingTriggeredByVfs;
    private IWorkspace fWorkspace = ResourcesPlugin.getWorkspace();
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$workspaceMonitor$WorkspaceUpdater == null ? (class$com$tssap$dtr$client$eclipse$workspaceMonitor$WorkspaceUpdater = WorkspaceUpdater.class$("com.tssap.dtr.client.eclipse.workspaceMonitor.WorkspaceUpdater")) : class$com$tssap$dtr$client$eclipse$workspaceMonitor$WorkspaceUpdater));
    private List fMonitoredManagers = new ArrayList();
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$workspaceMonitor$WorkspaceUpdater;

    WorkspaceUpdater() {
    }

    public void updateListeners() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = root.getProjects();
        ArrayList<IVersionedFileSystemManager> currentManagers = new ArrayList<IVersionedFileSystemManager>();
        int i = 0;
        while (i < projects.length) {
            DAVTeamProvider provider = BluebirdPlugin.getDAVTeamProvider((IResource)projects[i]);
            if (provider != null) {
                IVersionedFileSystemManager manager = provider.getVFSManager();
                if (manager != null && !this.fMonitoredManagers.contains(manager)) {
                    this.addListeners(manager);
                    this.fMonitoredManagers.add(manager);
                }
                if (!currentManagers.contains(manager)) {
                    currentManagers.add(manager);
                }
            }
            ++i;
        }
        if (currentManagers.size() != this.fMonitoredManagers.size()) {
            IVersionedFileSystemManager manager;
            ArrayList<IVersionedFileSystemManager> toRemove = new ArrayList<IVersionedFileSystemManager>();
            Iterator iter = this.fMonitoredManagers.iterator();
            while (iter.hasNext()) {
                manager = (IVersionedFileSystemManager)iter.next();
                if (currentManagers.contains(manager)) continue;
                toRemove.add(manager);
            }
            iter = toRemove.iterator();
            while (iter.hasNext()) {
                manager = (IVersionedFileSystemManager)iter.next();
                this.removeListeners(manager);
                this.fMonitoredManagers.remove(manager);
            }
        }
    }

    public void shutdownUpdater() {
        Iterator iter = this.fMonitoredManagers.iterator();
        while (iter.hasNext()) {
            IVersionedFileSystemManager manager = (IVersionedFileSystemManager)iter.next();
            this.removeListeners(manager);
        }
        this.fMonitoredManagers.clear();
    }

    private void addListeners(IVersionedFileSystemManager manager) {
        manager.addFolderItemListener((IVfsFolderItemListener)this);
        manager.addVersionListener((IVfsVersionListener)this);
    }

    private void removeListeners(IVersionedFileSystemManager manager) {
        manager.removeFolderItemListener((IVfsFolderItemListener)this);
        manager.removeVersionListener((IVfsVersionListener)this);
    }

    public void locationStateChanged(IVfsFolderItem folderItem, VfsFolderItemLocationState oldState) {
        this.refreshResource(folderItem);
    }

    public void activityStateChanged(IVfsActivityRecordedFolderItem folderItem, VfsFolderItemActivityState oldState) {
        IVfsActivityRecordedFolderItem itemToRefresh = folderItem;
        if (folderItem.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE) {
            try {
                itemToRefresh = folderItem.getParent();
            }
            catch (VfsException e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
                return;
            }
        }
        this.refreshResource((IVfsFolderItem)itemToRefresh);
    }

    public void versionOnFolderItemChanged(IVfsActivityRecordedFolderItem folderItem, IVfsVersion oldVersion) {
        this.refreshResource((IVfsFolderItem)folderItem);
    }

    public void itemsAddedOrRemoved(IVfsGenericFolder folder) {
        this.refreshResource((IVfsFolderItem)folder);
    }

    private void refreshResource(IVfsFolderItem item) {
        IResource res = this.getWorkspaceMember(item);
        if (res != null) {
            this.refreshResource(res);
        }
    }

    private void refreshResource(IResource resource) {
        this._refreshingTriggeredByVfs = true;
        try {
            block4: {
                try {
                    if (resource.getWorkspace().isTreeLocked()) break block4;
                    resource.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    LogUtil.logException((Location)LOCATION, (Throwable)e);
                    Object var4_3 = null;
                    this._refreshingTriggeredByVfs = false;
                }
            }
            Object var4_2 = null;
            this._refreshingTriggeredByVfs = false;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._refreshingTriggeredByVfs = false;
            throw throwable;
        }
    }

    public boolean isRefreshingTriggeredByVfs() {
        return this._refreshingTriggeredByVfs;
    }

    private IResource getWorkspaceMember(IVfsFolderItem item) {
        String localPath = item.getLocalPath();
        Object resource = null;
        if (localPath != null) {
            Path absolutePath = new Path(localPath);
            resource = item.asFile() != null ? this.fWorkspace.getRoot().getFileForLocation((IPath)absolutePath) : this.fWorkspace.getRoot().getContainerForLocation((IPath)absolutePath);
        }
        return resource;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

