/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.workspaceMonitor;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.preference.DtrPreferenceManager;
import com.tssap.dtr.client.eclipse.workspaceMonitor.MonitorType;
import com.tssap.dtr.client.eclipse.workspaceMonitor.ResourceChangeListener;
import com.tssap.dtr.client.eclipse.workspaceMonitor.WorkspaceUpdater;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class WorkspaceMonitor {
    private static WorkspaceMonitor fMonitor;
    private final DtrPreferenceManager fManger = BluebirdPlugin.getDefault().getPreferenceManager();
    private final WorkspaceUpdater fUpdater = new WorkspaceUpdater();
    private ResourceChangeListener fResourceChangeListener;
    private IResourceChangeListener fUpdaterListener;
    private final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$workspaceMonitor$WorkspaceMonitor == null ? (class$com$tssap$dtr$client$eclipse$workspaceMonitor$WorkspaceMonitor = WorkspaceMonitor.class$("com.tssap.dtr.client.eclipse.workspaceMonitor.WorkspaceMonitor")) : class$com$tssap$dtr$client$eclipse$workspaceMonitor$WorkspaceMonitor));
    public static final int DEPTH_INFINITE = -1;
    public static final int DIFFERENT_WORKSPACES = 1;
    public static final int EXCLUDED_FROM_MONITOR = 2;
    public static final int NOT_LOGGED_IN = 3;
    public static final int CANT_CONVERT_TO_VFS_OBJECTS = 4;
    public static final int SOME_FILES_ARENT_CHECKOUT_FOR_EDIT = 5;
    public static final int ALL_FILES_ARENT_CHECKOUT_FOR_EDIT = 6;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$workspaceMonitor$WorkspaceMonitor;

    private WorkspaceMonitor() {
    }

    public static WorkspaceMonitor getInstance() {
        if (fMonitor == null) {
            fMonitor = new WorkspaceMonitor();
        }
        return fMonitor;
    }

    public WorkspaceUpdater getWorkspaceUpdater() {
        return this.fUpdater;
    }

    public boolean setMonitorResource(IResource resource, boolean monitor, int depth) {
        boolean out = true;
        MonitorType[] allTypes = MonitorType.getAllTypes();
        int i = 0;
        while (i < allTypes.length) {
            if (!this.setMonitorResource(resource, monitor, allTypes[i], depth)) {
                out = false;
            }
            ++i;
        }
        return out;
    }

    public boolean setMonitorResource(IResource resource, boolean monitor, MonitorType type, int depth) {
        if (type == null) {
            return false;
        }
        try {
            resource.setPersistentProperty(type.getTypeQualifiedName(), new Boolean(monitor).toString());
            resource.setPersistentProperty(type.getDepthQualifiedName(), String.valueOf(depth));
        }
        catch (CoreException e) {
            LogUtil.logException((Location)this.LOCATION, (Throwable)e);
            return false;
        }
        return true;
    }

    public IResource[] getMonitoredResources(IProject project, MonitorType type) {
        ArrayList monitoredResources = new ArrayList(10);
        try {
            this.getResourcesWithMonitoredProperty((IResource)project, monitoredResources, type, true);
        }
        catch (CoreException e) {
            LogUtil.logException((Location)this.LOCATION, (Throwable)e);
        }
        if (monitoredResources.size() == 0) {
            return new IResource[0];
        }
        return monitoredResources.toArray(new IResource[monitoredResources.size()]);
    }

    public IResource[] getExcludedResources(IProject project, MonitorType type) {
        ArrayList excludedResources = new ArrayList();
        try {
            this.getResourcesWithMonitoredProperty((IResource)project, excludedResources, type, false);
        }
        catch (CoreException e) {
            LogUtil.logException((Location)this.LOCATION, (Throwable)e);
        }
        if (excludedResources.size() == 0) {
            return new IResource[0];
        }
        return excludedResources.toArray(new IResource[excludedResources.size()]);
    }

    public IResource[] getMonitoredResources(IProject project) {
        ArrayList monitoredResources = new ArrayList(10);
        try {
            MonitorType[] allTypes = MonitorType.getAllTypes();
            int i = 0;
            while (i < allTypes.length) {
                this.getResourcesWithMonitoredProperty((IResource)project, monitoredResources, allTypes[i], true);
                ++i;
            }
        }
        catch (CoreException e) {
            LogUtil.logException((Location)this.LOCATION, (Throwable)e);
        }
        if (monitoredResources.size() == 0) {
            return new IResource[0];
        }
        return monitoredResources.toArray(new IResource[monitoredResources.size()]);
    }

    private void getResourcesWithMonitoredProperty(IResource resource, List list, MonitorType type, boolean value) throws CoreException {
        if (resource.isAccessible()) {
            String propertyValue = resource.getPersistentProperty(type.getTypeQualifiedName());
            if (propertyValue != null) {
                Integer depth;
                Boolean propValue = new Boolean(propertyValue);
                if (propValue == value) {
                    list.add(resource);
                }
                if ((depth = new Integer(resource.getPersistentProperty(type.getDepthQualifiedName()))) == -1) {
                    return;
                }
            }
            if (resource instanceof IContainer) {
                IResource[] members = ((IContainer)resource).members();
                int i = 0;
                while (i < members.length) {
                    this.getResourcesWithMonitoredProperty(members[i], list, type, value);
                    ++i;
                }
            }
        }
    }

    public boolean hasWorkspaceMonitorProperty(IResource resource) {
        try {
            MonitorType[] types = MonitorType.getAllTypes();
            int i = 0;
            while (i < types.length) {
                if (resource.getPersistentProperty(types[i].getTypeQualifiedName()) != null) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            LogUtil.logCaughtException((Location)this.LOCATION, (Throwable)e);
        }
        return false;
    }

    public boolean hasWorkspaceMonitorProperty(IResource resource, MonitorType type) {
        try {
            if (resource.getPersistentProperty(type.getTypeQualifiedName()) != null) {
                return true;
            }
        }
        catch (CoreException e) {
            LogUtil.logCaughtException((Location)this.LOCATION, (Throwable)e);
        }
        return false;
    }

    public boolean isMonitored(IResource resource, MonitorType type) {
        Boolean monitorProperty = this.affectedByProperty(resource, type);
        if (monitorProperty == null || monitorProperty.booleanValue()) {
            return this.getDefault(type);
        }
        return false;
    }

    public boolean isMonitoredForAdding(IResource resource) {
        Boolean monitorProperty = this.affectedByProperty(resource, MonitorType.ADD);
        if (monitorProperty == null || monitorProperty.booleanValue()) {
            return this.getDefault(MonitorType.ADD);
        }
        return false;
    }

    public boolean isMonitoredForEdit(IResource resource) {
        Boolean monitorProperty = this.affectedByProperty(resource, MonitorType.EDIT);
        if (monitorProperty == null || monitorProperty.booleanValue()) {
            return this.getDefault(MonitorType.EDIT);
        }
        return false;
    }

    public boolean isMonitoredForMove(IResource resource) {
        Boolean monitorProperty = this.affectedByProperty(resource, MonitorType.MOVE);
        if (monitorProperty == null || monitorProperty.booleanValue()) {
            return this.getDefault(MonitorType.MOVE);
        }
        return false;
    }

    public boolean isMonitoredForDelete(IResource resource) {
        Boolean monitorProperty = this.affectedByProperty(resource, MonitorType.DELETE);
        if (monitorProperty == null || monitorProperty.booleanValue()) {
            return this.getDefault(MonitorType.DELETE);
        }
        return false;
    }

    private boolean getDefault(MonitorType type) {
        if (this.fManger.isWorkspaceMonitorGeneral()) {
            if (type.equals(MonitorType.ADD)) {
                return this.fManger.isWorkspaceMonitorAdd();
            }
            if (type.equals(MonitorType.DELETE)) {
                return this.fManger.isWorkspaceMonitorDelete();
            }
            if (type.equals(MonitorType.EDIT)) {
                return this.fManger.isWorkspaceMonitorEdit();
            }
            if (type.equals(MonitorType.MOVE)) {
                return this.fManger.isWorkspaceMonitorMove();
            }
        }
        return false;
    }

    public boolean isInParentScope(IResource resource, MonitorType type, boolean value) {
        IContainer parent = resource.getParent();
        Boolean affected = this.affectedByProperty((IResource)parent, type);
        if (affected == null) {
            return false;
        }
        return affected == value;
    }

    private Boolean affectedByProperty(IResource resource, MonitorType type) {
        try {
            Boolean hasProperty = this.checkForPropertyScope(resource, resource, type);
            return hasProperty;
        }
        catch (CoreException e) {
            LogUtil.logException((Location)this.LOCATION, (Throwable)e);
            return null;
        }
    }

    private Boolean checkForPropertyScope(IResource checkedResource, IResource originalResource, MonitorType type) throws CoreException {
        if (!checkedResource.isAccessible()) {
            return null;
        }
        String prop = checkedResource.getPersistentProperty(type.getTypeQualifiedName());
        if (prop != null) {
            int depth = new Integer(checkedResource.getPersistentProperty(type.getDepthQualifiedName()));
            if (depth == -1) {
                return new Boolean(prop);
            }
            IResource res = originalResource;
            while (!checkedResource.equals((Object)res)) {
                --depth;
                res = res.getParent();
            }
            if (depth >= 0) {
                return new Boolean(prop);
            }
            return null;
        }
        if (originalResource.getProject() == null || originalResource.getProject().equals((Object)checkedResource)) {
            return null;
        }
        return this.checkForPropertyScope((IResource)checkedResource.getParent(), originalResource, type);
    }

    private void registerWorkspaceUpdater() {
        this.fUpdater.updateListeners();
        this.fUpdaterListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IResourceDelta delta = event.getDelta();
                int kind = delta.getKind();
                IResourceDelta[] resourceDeltas = delta.getAffectedChildren();
                int i = 0;
                while (i < resourceDeltas.length) {
                    if (resourceDeltas[i].getResource() instanceof IProject) {
                        WorkspaceMonitor.this.fUpdater.updateListeners();
                    }
                    ++i;
                }
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.fUpdaterListener, 1);
    }

    private void unregisterWorkspaceUpdater() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.fUpdaterListener);
        this.fUpdater.shutdownUpdater();
    }

    public void startupMonitor() {
        this.fResourceChangeListener = new ResourceChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fResourceChangeListener, 1);
        this.registerWorkspaceUpdater();
    }

    public void shutdownMonitor() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fResourceChangeListener);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

